/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Attachment;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.CodeableReference;
import org.linuxforhealth.fhir.model.type.Date;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Duration;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Integer;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.MarketingStatus;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Quantity;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
@Constraint(id="packagedProductDefinition-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/publication-status", expression="status.exists() implies (status.memberOf('http://hl7.org/fhir/ValueSet/publication-status', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/PackagedProductDefinition", generated=true)
public class PackagedProductDefinition
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String name;
    @Summary
    @Binding(bindingName="PackageType", strength=BindingStrength.Value.EXAMPLE, description="A high level categorisation of a package.", valueSet="http://hl7.org/fhir/ValueSet/package-type")
    private final CodeableConcept type;
    @Summary
    @ReferenceTarget(value={"MedicinalProductDefinition"})
    private final List<Reference> packageFor;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.PREFERRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    private final CodeableConcept status;
    @Summary
    private final DateTime statusDate;
    @Summary
    private final List<Quantity> containedItemQuantity;
    @Summary
    private final Markdown description;
    @Summary
    private final List<LegalStatusOfSupply> legalStatusOfSupply;
    @Summary
    private final List<MarketingStatus> marketingStatus;
    @Summary
    @Binding(bindingName="PackageCharacteristic", strength=BindingStrength.Value.EXAMPLE, description="A characteristic of a package.", valueSet="http://hl7.org/fhir/ValueSet/package-characteristic")
    private final List<CodeableConcept> characteristic;
    @Summary
    private final Boolean copackagedIndicator;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final List<Reference> manufacturer;
    @Summary
    private final Package _package;

    private PackagedProductDefinition(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.name = builder.name;
        this.type = builder.type;
        this.packageFor = Collections.unmodifiableList(builder.packageFor);
        this.status = builder.status;
        this.statusDate = builder.statusDate;
        this.containedItemQuantity = Collections.unmodifiableList(builder.containedItemQuantity);
        this.description = builder.description;
        this.legalStatusOfSupply = Collections.unmodifiableList(builder.legalStatusOfSupply);
        this.marketingStatus = Collections.unmodifiableList(builder.marketingStatus);
        this.characteristic = Collections.unmodifiableList(builder.characteristic);
        this.copackagedIndicator = builder.copackagedIndicator;
        this.manufacturer = Collections.unmodifiableList(builder.manufacturer);
        this._package = builder._package;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public org.linuxforhealth.fhir.model.type.String getName() {
        return this.name;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public List<Reference> getPackageFor() {
        return this.packageFor;
    }

    public CodeableConcept getStatus() {
        return this.status;
    }

    public DateTime getStatusDate() {
        return this.statusDate;
    }

    public List<Quantity> getContainedItemQuantity() {
        return this.containedItemQuantity;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<LegalStatusOfSupply> getLegalStatusOfSupply() {
        return this.legalStatusOfSupply;
    }

    public List<MarketingStatus> getMarketingStatus() {
        return this.marketingStatus;
    }

    public List<CodeableConcept> getCharacteristic() {
        return this.characteristic;
    }

    public Boolean getCopackagedIndicator() {
        return this.copackagedIndicator;
    }

    public List<Reference> getManufacturer() {
        return this.manufacturer;
    }

    public Package getPackage() {
        return this._package;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.name != null || this.type != null || !this.packageFor.isEmpty() || this.status != null || this.statusDate != null || !this.containedItemQuantity.isEmpty() || this.description != null || !this.legalStatusOfSupply.isEmpty() || !this.marketingStatus.isEmpty() || !this.characteristic.isEmpty() || this.copackagedIndicator != null || !this.manufacturer.isEmpty() || this._package != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.name, "name", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.packageFor, "packageFor", visitor, Reference.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.statusDate, "statusDate", visitor);
                this.accept(this.containedItemQuantity, "containedItemQuantity", visitor, Quantity.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.legalStatusOfSupply, "legalStatusOfSupply", visitor, LegalStatusOfSupply.class);
                this.accept(this.marketingStatus, "marketingStatus", visitor, MarketingStatus.class);
                this.accept(this.characteristic, "characteristic", visitor, CodeableConcept.class);
                this.accept(this.copackagedIndicator, "copackagedIndicator", visitor);
                this.accept(this.manufacturer, "manufacturer", visitor, Reference.class);
                this.accept(this._package, "package", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PackagedProductDefinition other = (PackagedProductDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.packageFor, other.packageFor) && Objects.equals(this.status, other.status) && Objects.equals(this.statusDate, other.statusDate) && Objects.equals(this.containedItemQuantity, other.containedItemQuantity) && Objects.equals(this.description, other.description) && Objects.equals(this.legalStatusOfSupply, other.legalStatusOfSupply) && Objects.equals(this.marketingStatus, other.marketingStatus) && Objects.equals(this.characteristic, other.characteristic) && Objects.equals(this.copackagedIndicator, other.copackagedIndicator) && Objects.equals(this.manufacturer, other.manufacturer) && Objects.equals(this._package, other._package);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.name, this.type, this.packageFor, this.status, this.statusDate, this.containedItemQuantity, this.description, this.legalStatusOfSupply, this.marketingStatus, this.characteristic, this.copackagedIndicator, this.manufacturer, this._package);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Package
    extends BackboneElement {
        @Summary
        private final List<Identifier> identifier;
        @Summary
        @Binding(bindingName="PackagingType", strength=BindingStrength.Value.EXAMPLE, description="A high level categorisation of a package.", valueSet="http://hl7.org/fhir/ValueSet/packaging-type")
        private final CodeableConcept type;
        @Summary
        private final Integer quantity;
        @Summary
        @Binding(bindingName="PackageMaterial", strength=BindingStrength.Value.EXAMPLE, description="A material used in the construction of packages and their components.", valueSet="http://hl7.org/fhir/ValueSet/package-material")
        private final List<CodeableConcept> material;
        @Summary
        @Binding(bindingName="PackageMaterial", strength=BindingStrength.Value.EXAMPLE, description="A material used in the construction of packages and their components.", valueSet="http://hl7.org/fhir/ValueSet/package-material")
        private final List<CodeableConcept> alternateMaterial;
        @Summary
        private final List<ShelfLifeStorage> shelfLifeStorage;
        @Summary
        @ReferenceTarget(value={"Organization"})
        private final List<Reference> manufacturer;
        @Summary
        private final List<Property> property;
        @Summary
        private final List<ContainedItem> containedItem;
        @Summary
        private final List<Package> _package;

        private Package(Builder builder) {
            super(builder);
            this.identifier = Collections.unmodifiableList(builder.identifier);
            this.type = builder.type;
            this.quantity = builder.quantity;
            this.material = Collections.unmodifiableList(builder.material);
            this.alternateMaterial = Collections.unmodifiableList(builder.alternateMaterial);
            this.shelfLifeStorage = Collections.unmodifiableList(builder.shelfLifeStorage);
            this.manufacturer = Collections.unmodifiableList(builder.manufacturer);
            this.property = Collections.unmodifiableList(builder.property);
            this.containedItem = Collections.unmodifiableList(builder.containedItem);
            this._package = Collections.unmodifiableList(builder._package);
        }

        public List<Identifier> getIdentifier() {
            return this.identifier;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Integer getQuantity() {
            return this.quantity;
        }

        public List<CodeableConcept> getMaterial() {
            return this.material;
        }

        public List<CodeableConcept> getAlternateMaterial() {
            return this.alternateMaterial;
        }

        public List<ShelfLifeStorage> getShelfLifeStorage() {
            return this.shelfLifeStorage;
        }

        public List<Reference> getManufacturer() {
            return this.manufacturer;
        }

        public List<Property> getProperty() {
            return this.property;
        }

        public List<ContainedItem> getContainedItem() {
            return this.containedItem;
        }

        public List<Package> getPackage() {
            return this._package;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.identifier.isEmpty() || this.type != null || this.quantity != null || !this.material.isEmpty() || !this.alternateMaterial.isEmpty() || !this.shelfLifeStorage.isEmpty() || !this.manufacturer.isEmpty() || !this.property.isEmpty() || !this.containedItem.isEmpty() || !this._package.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.identifier, "identifier", visitor, Identifier.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.quantity, "quantity", visitor);
                    this.accept(this.material, "material", visitor, CodeableConcept.class);
                    this.accept(this.alternateMaterial, "alternateMaterial", visitor, CodeableConcept.class);
                    this.accept(this.shelfLifeStorage, "shelfLifeStorage", visitor, ShelfLifeStorage.class);
                    this.accept(this.manufacturer, "manufacturer", visitor, Reference.class);
                    this.accept(this.property, "property", visitor, Property.class);
                    this.accept(this.containedItem, "containedItem", visitor, ContainedItem.class);
                    this.accept(this._package, "package", visitor, Package.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Package other = (Package)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.type, other.type) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.material, other.material) && Objects.equals(this.alternateMaterial, other.alternateMaterial) && Objects.equals(this.shelfLifeStorage, other.shelfLifeStorage) && Objects.equals(this.manufacturer, other.manufacturer) && Objects.equals(this.property, other.property) && Objects.equals(this.containedItem, other.containedItem) && Objects.equals(this._package, other._package);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.type, this.quantity, this.material, this.alternateMaterial, this.shelfLifeStorage, this.manufacturer, this.property, this.containedItem, this._package);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class ContainedItem
        extends BackboneElement {
            @Summary
            @Required
            private final CodeableReference item;
            @Summary
            private final Quantity amount;

            private ContainedItem(Builder builder) {
                super(builder);
                this.item = builder.item;
                this.amount = builder.amount;
            }

            public CodeableReference getItem() {
                return this.item;
            }

            public Quantity getAmount() {
                return this.amount;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.item != null || this.amount != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.item, "item", visitor);
                        this.accept(this.amount, "amount", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ContainedItem other = (ContainedItem)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.item, other.item) && Objects.equals(this.amount, other.amount);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.item, this.amount);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableReference item;
                private Quantity amount;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder item(CodeableReference item) {
                    this.item = item;
                    return this;
                }

                public Builder amount(Quantity amount) {
                    this.amount = amount;
                    return this;
                }

                @Override
                public ContainedItem build() {
                    ContainedItem containedItem = new ContainedItem(this);
                    if (this.validating) {
                        this.validate(containedItem);
                    }
                    return containedItem;
                }

                protected void validate(ContainedItem containedItem) {
                    super.validate(containedItem);
                    ValidationSupport.requireNonNull(containedItem.item, "item");
                    ValidationSupport.requireValueOrChildren(containedItem);
                }

                protected Builder from(ContainedItem containedItem) {
                    super.from(containedItem);
                    this.item = containedItem.item;
                    this.amount = containedItem.amount;
                    return this;
                }
            }
        }

        public static class Property
        extends BackboneElement {
            @Summary
            @Binding(bindingName="ProductCharacteristic", strength=BindingStrength.Value.EXAMPLE, description="This value set includes all observable entity codes from SNOMED CT - provided as an exemplar value set.", valueSet="http://hl7.org/fhir/ValueSet/product-characteristic-codes")
            @Required
            private final CodeableConcept type;
            @Summary
            @Choice(value={CodeableConcept.class, Quantity.class, Date.class, Boolean.class, Attachment.class})
            private final Element value;

            private Property(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.value = builder.value;
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public Element getValue() {
                return this.value;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.value != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.value, "value", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Property other = (Property)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.value);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept type;
                private Element value;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder value(LocalDate value) {
                    this.value = value == null ? null : Date.of(value);
                    return this;
                }

                public Builder value(java.lang.Boolean value) {
                    this.value = value == null ? null : Boolean.of(value);
                    return this;
                }

                public Builder value(Element value) {
                    this.value = value;
                    return this;
                }

                @Override
                public Property build() {
                    Property property = new Property(this);
                    if (this.validating) {
                        this.validate(property);
                    }
                    return property;
                }

                protected void validate(Property property) {
                    super.validate(property);
                    ValidationSupport.requireNonNull(property.type, "type");
                    ValidationSupport.choiceElement(property.value, "value", CodeableConcept.class, Quantity.class, Date.class, Boolean.class, Attachment.class);
                    ValidationSupport.requireValueOrChildren(property);
                }

                protected Builder from(Property property) {
                    super.from(property);
                    this.type = property.type;
                    this.value = property.value;
                    return this;
                }
            }
        }

        public static class ShelfLifeStorage
        extends BackboneElement {
            @Summary
            private final CodeableConcept type;
            @Summary
            @Choice(value={Duration.class, org.linuxforhealth.fhir.model.type.String.class})
            private final Element period;
            @Summary
            private final List<CodeableConcept> specialPrecautionsForStorage;

            private ShelfLifeStorage(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.period = builder.period;
                this.specialPrecautionsForStorage = Collections.unmodifiableList(builder.specialPrecautionsForStorage);
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public Element getPeriod() {
                return this.period;
            }

            public List<CodeableConcept> getSpecialPrecautionsForStorage() {
                return this.specialPrecautionsForStorage;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.period != null || !this.specialPrecautionsForStorage.isEmpty();
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.period, "period", visitor);
                        this.accept(this.specialPrecautionsForStorage, "specialPrecautionsForStorage", visitor, CodeableConcept.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ShelfLifeStorage other = (ShelfLifeStorage)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.period, other.period) && Objects.equals(this.specialPrecautionsForStorage, other.specialPrecautionsForStorage);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.period, this.specialPrecautionsForStorage);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept type;
                private Element period;
                private List<CodeableConcept> specialPrecautionsForStorage = new ArrayList<CodeableConcept>();

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder period(String period) {
                    this.period = period == null ? null : org.linuxforhealth.fhir.model.type.String.of(period);
                    return this;
                }

                public Builder period(Element period) {
                    this.period = period;
                    return this;
                }

                public Builder specialPrecautionsForStorage(CodeableConcept ... specialPrecautionsForStorage) {
                    for (CodeableConcept value : specialPrecautionsForStorage) {
                        this.specialPrecautionsForStorage.add(value);
                    }
                    return this;
                }

                public Builder specialPrecautionsForStorage(Collection<CodeableConcept> specialPrecautionsForStorage) {
                    this.specialPrecautionsForStorage = new ArrayList<CodeableConcept>(specialPrecautionsForStorage);
                    return this;
                }

                @Override
                public ShelfLifeStorage build() {
                    ShelfLifeStorage shelfLifeStorage = new ShelfLifeStorage(this);
                    if (this.validating) {
                        this.validate(shelfLifeStorage);
                    }
                    return shelfLifeStorage;
                }

                protected void validate(ShelfLifeStorage shelfLifeStorage) {
                    super.validate(shelfLifeStorage);
                    ValidationSupport.choiceElement(shelfLifeStorage.period, "period", Duration.class, org.linuxforhealth.fhir.model.type.String.class);
                    ValidationSupport.checkList(shelfLifeStorage.specialPrecautionsForStorage, "specialPrecautionsForStorage", CodeableConcept.class);
                    ValidationSupport.requireValueOrChildren(shelfLifeStorage);
                }

                protected Builder from(ShelfLifeStorage shelfLifeStorage) {
                    super.from(shelfLifeStorage);
                    this.type = shelfLifeStorage.type;
                    this.period = shelfLifeStorage.period;
                    this.specialPrecautionsForStorage.addAll(shelfLifeStorage.specialPrecautionsForStorage);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Identifier> identifier = new ArrayList<Identifier>();
            private CodeableConcept type;
            private Integer quantity;
            private List<CodeableConcept> material = new ArrayList<CodeableConcept>();
            private List<CodeableConcept> alternateMaterial = new ArrayList<CodeableConcept>();
            private List<ShelfLifeStorage> shelfLifeStorage = new ArrayList<ShelfLifeStorage>();
            private List<Reference> manufacturer = new ArrayList<Reference>();
            private List<Property> property = new ArrayList<Property>();
            private List<ContainedItem> containedItem = new ArrayList<ContainedItem>();
            private List<Package> _package = new ArrayList<Package>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder identifier(Identifier ... identifier) {
                for (Identifier value : identifier) {
                    this.identifier.add(value);
                }
                return this;
            }

            public Builder identifier(Collection<Identifier> identifier) {
                this.identifier = new ArrayList<Identifier>(identifier);
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder quantity(java.lang.Integer quantity) {
                this.quantity = quantity == null ? null : Integer.of(quantity);
                return this;
            }

            public Builder quantity(Integer quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder material(CodeableConcept ... material) {
                for (CodeableConcept value : material) {
                    this.material.add(value);
                }
                return this;
            }

            public Builder material(Collection<CodeableConcept> material) {
                this.material = new ArrayList<CodeableConcept>(material);
                return this;
            }

            public Builder alternateMaterial(CodeableConcept ... alternateMaterial) {
                for (CodeableConcept value : alternateMaterial) {
                    this.alternateMaterial.add(value);
                }
                return this;
            }

            public Builder alternateMaterial(Collection<CodeableConcept> alternateMaterial) {
                this.alternateMaterial = new ArrayList<CodeableConcept>(alternateMaterial);
                return this;
            }

            public Builder shelfLifeStorage(ShelfLifeStorage ... shelfLifeStorage) {
                for (ShelfLifeStorage value : shelfLifeStorage) {
                    this.shelfLifeStorage.add(value);
                }
                return this;
            }

            public Builder shelfLifeStorage(Collection<ShelfLifeStorage> shelfLifeStorage) {
                this.shelfLifeStorage = new ArrayList<ShelfLifeStorage>(shelfLifeStorage);
                return this;
            }

            public Builder manufacturer(Reference ... manufacturer) {
                for (Reference value : manufacturer) {
                    this.manufacturer.add(value);
                }
                return this;
            }

            public Builder manufacturer(Collection<Reference> manufacturer) {
                this.manufacturer = new ArrayList<Reference>(manufacturer);
                return this;
            }

            public Builder property(Property ... property) {
                for (Property value : property) {
                    this.property.add(value);
                }
                return this;
            }

            public Builder property(Collection<Property> property) {
                this.property = new ArrayList<Property>(property);
                return this;
            }

            public Builder containedItem(ContainedItem ... containedItem) {
                for (ContainedItem value : containedItem) {
                    this.containedItem.add(value);
                }
                return this;
            }

            public Builder containedItem(Collection<ContainedItem> containedItem) {
                this.containedItem = new ArrayList<ContainedItem>(containedItem);
                return this;
            }

            public Builder _package(Package ... _package) {
                for (Package value : _package) {
                    this._package.add(value);
                }
                return this;
            }

            public Builder _package(Collection<Package> _package) {
                this._package = new ArrayList<Package>(_package);
                return this;
            }

            @Override
            public Package build() {
                Package _package = new Package(this);
                if (this.validating) {
                    this.validate(_package);
                }
                return _package;
            }

            protected void validate(Package _package) {
                super.validate(_package);
                ValidationSupport.checkList(_package.identifier, "identifier", Identifier.class);
                ValidationSupport.checkList(_package.material, "material", CodeableConcept.class);
                ValidationSupport.checkList(_package.alternateMaterial, "alternateMaterial", CodeableConcept.class);
                ValidationSupport.checkList(_package.shelfLifeStorage, "shelfLifeStorage", ShelfLifeStorage.class);
                ValidationSupport.checkList(_package.manufacturer, "manufacturer", Reference.class);
                ValidationSupport.checkList(_package.property, "property", Property.class);
                ValidationSupport.checkList(_package.containedItem, "containedItem", ContainedItem.class);
                ValidationSupport.checkList(_package._package, "package", Package.class);
                ValidationSupport.checkReferenceType(_package.manufacturer, "manufacturer", "Organization");
                ValidationSupport.requireValueOrChildren(_package);
            }

            protected Builder from(Package _package) {
                super.from(_package);
                this.identifier.addAll(_package.identifier);
                this.type = _package.type;
                this.quantity = _package.quantity;
                this.material.addAll(_package.material);
                this.alternateMaterial.addAll(_package.alternateMaterial);
                this.shelfLifeStorage.addAll(_package.shelfLifeStorage);
                this.manufacturer.addAll(_package.manufacturer);
                this.property.addAll(_package.property);
                this.containedItem.addAll(_package.containedItem);
                this._package.addAll(_package._package);
                return this;
            }
        }
    }

    public static class LegalStatusOfSupply
    extends BackboneElement {
        @Summary
        @Binding(bindingName="LegalStatusOfSupply", strength=BindingStrength.Value.EXAMPLE, description="The prescription supply types appropriate to a medicinal product", valueSet="http://hl7.org/fhir/ValueSet/legal-status-of-supply")
        private final CodeableConcept code;
        @Summary
        @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXAMPLE, description="Jurisdiction codes", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
        private final CodeableConcept jurisdiction;

        private LegalStatusOfSupply(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.jurisdiction = builder.jurisdiction;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public CodeableConcept getJurisdiction() {
            return this.jurisdiction;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.jurisdiction != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.jurisdiction, "jurisdiction", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LegalStatusOfSupply other = (LegalStatusOfSupply)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.jurisdiction, other.jurisdiction);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.jurisdiction);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;
            private CodeableConcept jurisdiction;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder jurisdiction(CodeableConcept jurisdiction) {
                this.jurisdiction = jurisdiction;
                return this;
            }

            @Override
            public LegalStatusOfSupply build() {
                LegalStatusOfSupply legalStatusOfSupply = new LegalStatusOfSupply(this);
                if (this.validating) {
                    this.validate(legalStatusOfSupply);
                }
                return legalStatusOfSupply;
            }

            protected void validate(LegalStatusOfSupply legalStatusOfSupply) {
                super.validate(legalStatusOfSupply);
                ValidationSupport.requireValueOrChildren(legalStatusOfSupply);
            }

            protected Builder from(LegalStatusOfSupply legalStatusOfSupply) {
                super.from(legalStatusOfSupply);
                this.code = legalStatusOfSupply.code;
                this.jurisdiction = legalStatusOfSupply.jurisdiction;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private org.linuxforhealth.fhir.model.type.String name;
        private CodeableConcept type;
        private List<Reference> packageFor = new ArrayList<Reference>();
        private CodeableConcept status;
        private DateTime statusDate;
        private List<Quantity> containedItemQuantity = new ArrayList<Quantity>();
        private Markdown description;
        private List<LegalStatusOfSupply> legalStatusOfSupply = new ArrayList<LegalStatusOfSupply>();
        private List<MarketingStatus> marketingStatus = new ArrayList<MarketingStatus>();
        private List<CodeableConcept> characteristic = new ArrayList<CodeableConcept>();
        private Boolean copackagedIndicator;
        private List<Reference> manufacturer = new ArrayList<Reference>();
        private Package _package;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder name(String name) {
            this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
            return this;
        }

        public Builder name(org.linuxforhealth.fhir.model.type.String name) {
            this.name = name;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder packageFor(Reference ... packageFor) {
            for (Reference value : packageFor) {
                this.packageFor.add(value);
            }
            return this;
        }

        public Builder packageFor(Collection<Reference> packageFor) {
            this.packageFor = new ArrayList<Reference>(packageFor);
            return this;
        }

        public Builder status(CodeableConcept status) {
            this.status = status;
            return this;
        }

        public Builder statusDate(DateTime statusDate) {
            this.statusDate = statusDate;
            return this;
        }

        public Builder containedItemQuantity(Quantity ... containedItemQuantity) {
            for (Quantity value : containedItemQuantity) {
                this.containedItemQuantity.add(value);
            }
            return this;
        }

        public Builder containedItemQuantity(Collection<Quantity> containedItemQuantity) {
            this.containedItemQuantity = new ArrayList<Quantity>(containedItemQuantity);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder legalStatusOfSupply(LegalStatusOfSupply ... legalStatusOfSupply) {
            for (LegalStatusOfSupply value : legalStatusOfSupply) {
                this.legalStatusOfSupply.add(value);
            }
            return this;
        }

        public Builder legalStatusOfSupply(Collection<LegalStatusOfSupply> legalStatusOfSupply) {
            this.legalStatusOfSupply = new ArrayList<LegalStatusOfSupply>(legalStatusOfSupply);
            return this;
        }

        public Builder marketingStatus(MarketingStatus ... marketingStatus) {
            for (MarketingStatus value : marketingStatus) {
                this.marketingStatus.add(value);
            }
            return this;
        }

        public Builder marketingStatus(Collection<MarketingStatus> marketingStatus) {
            this.marketingStatus = new ArrayList<MarketingStatus>(marketingStatus);
            return this;
        }

        public Builder characteristic(CodeableConcept ... characteristic) {
            for (CodeableConcept value : characteristic) {
                this.characteristic.add(value);
            }
            return this;
        }

        public Builder characteristic(Collection<CodeableConcept> characteristic) {
            this.characteristic = new ArrayList<CodeableConcept>(characteristic);
            return this;
        }

        public Builder copackagedIndicator(java.lang.Boolean copackagedIndicator) {
            this.copackagedIndicator = copackagedIndicator == null ? null : Boolean.of(copackagedIndicator);
            return this;
        }

        public Builder copackagedIndicator(Boolean copackagedIndicator) {
            this.copackagedIndicator = copackagedIndicator;
            return this;
        }

        public Builder manufacturer(Reference ... manufacturer) {
            for (Reference value : manufacturer) {
                this.manufacturer.add(value);
            }
            return this;
        }

        public Builder manufacturer(Collection<Reference> manufacturer) {
            this.manufacturer = new ArrayList<Reference>(manufacturer);
            return this;
        }

        public Builder _package(Package _package) {
            this._package = _package;
            return this;
        }

        @Override
        public PackagedProductDefinition build() {
            PackagedProductDefinition packagedProductDefinition = new PackagedProductDefinition(this);
            if (this.validating) {
                this.validate(packagedProductDefinition);
            }
            return packagedProductDefinition;
        }

        protected void validate(PackagedProductDefinition packagedProductDefinition) {
            super.validate(packagedProductDefinition);
            ValidationSupport.checkList(packagedProductDefinition.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(packagedProductDefinition.packageFor, "packageFor", Reference.class);
            ValidationSupport.checkList(packagedProductDefinition.containedItemQuantity, "containedItemQuantity", Quantity.class);
            ValidationSupport.checkList(packagedProductDefinition.legalStatusOfSupply, "legalStatusOfSupply", LegalStatusOfSupply.class);
            ValidationSupport.checkList(packagedProductDefinition.marketingStatus, "marketingStatus", MarketingStatus.class);
            ValidationSupport.checkList(packagedProductDefinition.characteristic, "characteristic", CodeableConcept.class);
            ValidationSupport.checkList(packagedProductDefinition.manufacturer, "manufacturer", Reference.class);
            ValidationSupport.checkReferenceType(packagedProductDefinition.packageFor, "packageFor", "MedicinalProductDefinition");
            ValidationSupport.checkReferenceType(packagedProductDefinition.manufacturer, "manufacturer", "Organization");
        }

        protected Builder from(PackagedProductDefinition packagedProductDefinition) {
            super.from(packagedProductDefinition);
            this.identifier.addAll(packagedProductDefinition.identifier);
            this.name = packagedProductDefinition.name;
            this.type = packagedProductDefinition.type;
            this.packageFor.addAll(packagedProductDefinition.packageFor);
            this.status = packagedProductDefinition.status;
            this.statusDate = packagedProductDefinition.statusDate;
            this.containedItemQuantity.addAll(packagedProductDefinition.containedItemQuantity);
            this.description = packagedProductDefinition.description;
            this.legalStatusOfSupply.addAll(packagedProductDefinition.legalStatusOfSupply);
            this.marketingStatus.addAll(packagedProductDefinition.marketingStatus);
            this.characteristic.addAll(packagedProductDefinition.characteristic);
            this.copackagedIndicator = packagedProductDefinition.copackagedIndicator;
            this.manufacturer.addAll(packagedProductDefinition.manufacturer);
            this._package = packagedProductDefinition._package;
            return this;
        }
    }
}

