/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Date;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Money;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.PaymentNoticeStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
public class PaymentNotice
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="PaymentNoticeStatus", strength=BindingStrength.Value.REQUIRED, description="A code specifying the state of the resource instance.", valueSet="http://hl7.org/fhir/ValueSet/fm-status|4.3.0")
    @Required
    private final PaymentNoticeStatus status;
    private final Reference request;
    private final Reference response;
    @Summary
    @Required
    private final DateTime created;
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
    private final Reference provider;
    @Summary
    @ReferenceTarget(value={"PaymentReconciliation"})
    @Required
    private final Reference payment;
    private final Date paymentDate;
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
    private final Reference payee;
    @Summary
    @ReferenceTarget(value={"Organization"})
    @Required
    private final Reference recipient;
    @Summary
    @Required
    private final Money amount;
    @Binding(bindingName="PaymentStatus", strength=BindingStrength.Value.EXAMPLE, description="The payment conveyance status codes.", valueSet="http://hl7.org/fhir/ValueSet/payment-status")
    private final CodeableConcept paymentStatus;

    private PaymentNotice(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.request = builder.request;
        this.response = builder.response;
        this.created = builder.created;
        this.provider = builder.provider;
        this.payment = builder.payment;
        this.paymentDate = builder.paymentDate;
        this.payee = builder.payee;
        this.recipient = builder.recipient;
        this.amount = builder.amount;
        this.paymentStatus = builder.paymentStatus;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public PaymentNoticeStatus getStatus() {
        return this.status;
    }

    public Reference getRequest() {
        return this.request;
    }

    public Reference getResponse() {
        return this.response;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public Reference getProvider() {
        return this.provider;
    }

    public Reference getPayment() {
        return this.payment;
    }

    public Date getPaymentDate() {
        return this.paymentDate;
    }

    public Reference getPayee() {
        return this.payee;
    }

    public Reference getRecipient() {
        return this.recipient;
    }

    public Money getAmount() {
        return this.amount;
    }

    public CodeableConcept getPaymentStatus() {
        return this.paymentStatus;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.request != null || this.response != null || this.created != null || this.provider != null || this.payment != null || this.paymentDate != null || this.payee != null || this.recipient != null || this.amount != null || this.paymentStatus != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.request, "request", visitor);
                this.accept(this.response, "response", visitor);
                this.accept(this.created, "created", visitor);
                this.accept(this.provider, "provider", visitor);
                this.accept(this.payment, "payment", visitor);
                this.accept(this.paymentDate, "paymentDate", visitor);
                this.accept(this.payee, "payee", visitor);
                this.accept(this.recipient, "recipient", visitor);
                this.accept(this.amount, "amount", visitor);
                this.accept(this.paymentStatus, "paymentStatus", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaymentNotice other = (PaymentNotice)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.request, other.request) && Objects.equals(this.response, other.response) && Objects.equals(this.created, other.created) && Objects.equals(this.provider, other.provider) && Objects.equals(this.payment, other.payment) && Objects.equals(this.paymentDate, other.paymentDate) && Objects.equals(this.payee, other.payee) && Objects.equals(this.recipient, other.recipient) && Objects.equals(this.amount, other.amount) && Objects.equals(this.paymentStatus, other.paymentStatus);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.request, this.response, this.created, this.provider, this.payment, this.paymentDate, this.payee, this.recipient, this.amount, this.paymentStatus);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private PaymentNoticeStatus status;
        private Reference request;
        private Reference response;
        private DateTime created;
        private Reference provider;
        private Reference payment;
        private Date paymentDate;
        private Reference payee;
        private Reference recipient;
        private Money amount;
        private CodeableConcept paymentStatus;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(PaymentNoticeStatus status) {
            this.status = status;
            return this;
        }

        public Builder request(Reference request) {
            this.request = request;
            return this;
        }

        public Builder response(Reference response) {
            this.response = response;
            return this;
        }

        public Builder created(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder provider(Reference provider) {
            this.provider = provider;
            return this;
        }

        public Builder payment(Reference payment) {
            this.payment = payment;
            return this;
        }

        public Builder paymentDate(LocalDate paymentDate) {
            this.paymentDate = paymentDate == null ? null : Date.of(paymentDate);
            return this;
        }

        public Builder paymentDate(Date paymentDate) {
            this.paymentDate = paymentDate;
            return this;
        }

        public Builder payee(Reference payee) {
            this.payee = payee;
            return this;
        }

        public Builder recipient(Reference recipient) {
            this.recipient = recipient;
            return this;
        }

        public Builder amount(Money amount) {
            this.amount = amount;
            return this;
        }

        public Builder paymentStatus(CodeableConcept paymentStatus) {
            this.paymentStatus = paymentStatus;
            return this;
        }

        @Override
        public PaymentNotice build() {
            PaymentNotice paymentNotice = new PaymentNotice(this);
            if (this.validating) {
                this.validate(paymentNotice);
            }
            return paymentNotice;
        }

        protected void validate(PaymentNotice paymentNotice) {
            super.validate(paymentNotice);
            ValidationSupport.checkList(paymentNotice.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(paymentNotice.status, "status");
            ValidationSupport.requireNonNull(paymentNotice.created, "created");
            ValidationSupport.requireNonNull(paymentNotice.payment, "payment");
            ValidationSupport.requireNonNull(paymentNotice.recipient, "recipient");
            ValidationSupport.requireNonNull(paymentNotice.amount, "amount");
            ValidationSupport.checkReferenceType(paymentNotice.provider, "provider", "Practitioner", "PractitionerRole", "Organization");
            ValidationSupport.checkReferenceType(paymentNotice.payment, "payment", "PaymentReconciliation");
            ValidationSupport.checkReferenceType(paymentNotice.payee, "payee", "Practitioner", "PractitionerRole", "Organization");
            ValidationSupport.checkReferenceType(paymentNotice.recipient, "recipient", "Organization");
        }

        protected Builder from(PaymentNotice paymentNotice) {
            super.from(paymentNotice);
            this.identifier.addAll(paymentNotice.identifier);
            this.status = paymentNotice.status;
            this.request = paymentNotice.request;
            this.response = paymentNotice.response;
            this.created = paymentNotice.created;
            this.provider = paymentNotice.provider;
            this.payment = paymentNotice.payment;
            this.paymentDate = paymentNotice.paymentDate;
            this.payee = paymentNotice.payee;
            this.recipient = paymentNotice.recipient;
            this.amount = paymentNotice.amount;
            this.paymentStatus = paymentNotice.paymentStatus;
            return this;
        }
    }
}

