/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Address;
import org.linuxforhealth.fhir.model.type.Attachment;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.ContactPoint;
import org.linuxforhealth.fhir.model.type.Date;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.HumanName;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.AdministrativeGender;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.IdentityAssuranceLevel;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
public class Person
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    private final List<HumanName> name;
    @Summary
    private final List<ContactPoint> telecom;
    @Summary
    @Binding(bindingName="AdministrativeGender", strength=BindingStrength.Value.REQUIRED, description="The gender of a person used for administrative purposes.", valueSet="http://hl7.org/fhir/ValueSet/administrative-gender|4.3.0")
    private final AdministrativeGender gender;
    @Summary
    private final Date birthDate;
    private final List<Address> address;
    private final Attachment photo;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference managingOrganization;
    @Summary
    private final Boolean active;
    private final List<Link> link;

    private Person(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.name = Collections.unmodifiableList(builder.name);
        this.telecom = Collections.unmodifiableList(builder.telecom);
        this.gender = builder.gender;
        this.birthDate = builder.birthDate;
        this.address = Collections.unmodifiableList(builder.address);
        this.photo = builder.photo;
        this.managingOrganization = builder.managingOrganization;
        this.active = builder.active;
        this.link = Collections.unmodifiableList(builder.link);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<HumanName> getName() {
        return this.name;
    }

    public List<ContactPoint> getTelecom() {
        return this.telecom;
    }

    public AdministrativeGender getGender() {
        return this.gender;
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    public List<Address> getAddress() {
        return this.address;
    }

    public Attachment getPhoto() {
        return this.photo;
    }

    public Reference getManagingOrganization() {
        return this.managingOrganization;
    }

    public Boolean getActive() {
        return this.active;
    }

    public List<Link> getLink() {
        return this.link;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.name.isEmpty() || !this.telecom.isEmpty() || this.gender != null || this.birthDate != null || !this.address.isEmpty() || this.photo != null || this.managingOrganization != null || this.active != null || !this.link.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.name, "name", visitor, HumanName.class);
                this.accept(this.telecom, "telecom", visitor, ContactPoint.class);
                this.accept(this.gender, "gender", visitor);
                this.accept(this.birthDate, "birthDate", visitor);
                this.accept(this.address, "address", visitor, Address.class);
                this.accept(this.photo, "photo", visitor);
                this.accept(this.managingOrganization, "managingOrganization", visitor);
                this.accept(this.active, "active", visitor);
                this.accept(this.link, "link", visitor, Link.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Person other = (Person)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.name, other.name) && Objects.equals(this.telecom, other.telecom) && Objects.equals(this.gender, other.gender) && Objects.equals(this.birthDate, other.birthDate) && Objects.equals(this.address, other.address) && Objects.equals(this.photo, other.photo) && Objects.equals(this.managingOrganization, other.managingOrganization) && Objects.equals(this.active, other.active) && Objects.equals(this.link, other.link);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.name, this.telecom, this.gender, this.birthDate, this.address, this.photo, this.managingOrganization, this.active, this.link);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Link
    extends BackboneElement {
        @ReferenceTarget(value={"Patient", "Practitioner", "RelatedPerson", "Person"})
        @Required
        private final Reference target;
        @Binding(bindingName="IdentityAssuranceLevel", strength=BindingStrength.Value.REQUIRED, description="The level of confidence that this link represents the same actual person, based on NIST Authentication Levels.", valueSet="http://hl7.org/fhir/ValueSet/identity-assuranceLevel|4.3.0")
        private final IdentityAssuranceLevel assurance;

        private Link(Builder builder) {
            super(builder);
            this.target = builder.target;
            this.assurance = builder.assurance;
        }

        public Reference getTarget() {
            return this.target;
        }

        public IdentityAssuranceLevel getAssurance() {
            return this.assurance;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.target != null || this.assurance != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.target, "target", visitor);
                    this.accept(this.assurance, "assurance", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Link other = (Link)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.target, other.target) && Objects.equals(this.assurance, other.assurance);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.target, this.assurance);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Reference target;
            private IdentityAssuranceLevel assurance;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder target(Reference target) {
                this.target = target;
                return this;
            }

            public Builder assurance(IdentityAssuranceLevel assurance) {
                this.assurance = assurance;
                return this;
            }

            @Override
            public Link build() {
                Link link = new Link(this);
                if (this.validating) {
                    this.validate(link);
                }
                return link;
            }

            protected void validate(Link link) {
                super.validate(link);
                ValidationSupport.requireNonNull(link.target, "target");
                ValidationSupport.checkReferenceType(link.target, "target", "Patient", "Practitioner", "RelatedPerson", "Person");
                ValidationSupport.requireValueOrChildren(link);
            }

            protected Builder from(Link link) {
                super.from(link);
                this.target = link.target;
                this.assurance = link.assurance;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<HumanName> name = new ArrayList<HumanName>();
        private List<ContactPoint> telecom = new ArrayList<ContactPoint>();
        private AdministrativeGender gender;
        private Date birthDate;
        private List<Address> address = new ArrayList<Address>();
        private Attachment photo;
        private Reference managingOrganization;
        private Boolean active;
        private List<Link> link = new ArrayList<Link>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder name(HumanName ... name) {
            for (HumanName value : name) {
                this.name.add(value);
            }
            return this;
        }

        public Builder name(Collection<HumanName> name) {
            this.name = new ArrayList<HumanName>(name);
            return this;
        }

        public Builder telecom(ContactPoint ... telecom) {
            for (ContactPoint value : telecom) {
                this.telecom.add(value);
            }
            return this;
        }

        public Builder telecom(Collection<ContactPoint> telecom) {
            this.telecom = new ArrayList<ContactPoint>(telecom);
            return this;
        }

        public Builder gender(AdministrativeGender gender) {
            this.gender = gender;
            return this;
        }

        public Builder birthDate(LocalDate birthDate) {
            this.birthDate = birthDate == null ? null : Date.of(birthDate);
            return this;
        }

        public Builder birthDate(Date birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        public Builder address(Address ... address) {
            for (Address value : address) {
                this.address.add(value);
            }
            return this;
        }

        public Builder address(Collection<Address> address) {
            this.address = new ArrayList<Address>(address);
            return this;
        }

        public Builder photo(Attachment photo) {
            this.photo = photo;
            return this;
        }

        public Builder managingOrganization(Reference managingOrganization) {
            this.managingOrganization = managingOrganization;
            return this;
        }

        public Builder active(java.lang.Boolean active) {
            this.active = active == null ? null : Boolean.of(active);
            return this;
        }

        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder link(Link ... link) {
            for (Link value : link) {
                this.link.add(value);
            }
            return this;
        }

        public Builder link(Collection<Link> link) {
            this.link = new ArrayList<Link>(link);
            return this;
        }

        @Override
        public Person build() {
            Person person = new Person(this);
            if (this.validating) {
                this.validate(person);
            }
            return person;
        }

        protected void validate(Person person) {
            super.validate(person);
            ValidationSupport.checkList(person.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(person.name, "name", HumanName.class);
            ValidationSupport.checkList(person.telecom, "telecom", ContactPoint.class);
            ValidationSupport.checkList(person.address, "address", Address.class);
            ValidationSupport.checkList(person.link, "link", Link.class);
            ValidationSupport.checkReferenceType(person.managingOrganization, "managingOrganization", "Organization");
        }

        protected Builder from(Person person) {
            super.from(person);
            this.identifier.addAll(person.identifier);
            this.name.addAll(person.name);
            this.telecom.addAll(person.telecom);
            this.gender = person.gender;
            this.birthDate = person.birthDate;
            this.address.addAll(person.address);
            this.photo = person.photo;
            this.managingOrganization = person.managingOrganization;
            this.active = person.active;
            this.link.addAll(person.link);
            return this;
        }
    }
}

