/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.ContactPoint;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Time;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.DaysOfWeek;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraint(id="practitionerRole-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/c80-practice-codes", expression="specialty.exists() implies (specialty.all(memberOf('http://hl7.org/fhir/ValueSet/c80-practice-codes', 'preferred')))", source="http://hl7.org/fhir/StructureDefinition/PractitionerRole", generated=true)
public class PractitionerRole
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final Boolean active;
    @Summary
    private final Period period;
    @Summary
    @ReferenceTarget(value={"Practitioner"})
    private final Reference practitioner;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference organization;
    @Summary
    @Binding(bindingName="PractitionerRole", strength=BindingStrength.Value.EXAMPLE, description="The role a person plays representing an organization.", valueSet="http://hl7.org/fhir/ValueSet/practitioner-role")
    private final List<CodeableConcept> code;
    @Summary
    @Binding(bindingName="PractitionerSpecialty", strength=BindingStrength.Value.PREFERRED, description="Specific specialty associated with the agency.", valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
    private final List<CodeableConcept> specialty;
    @Summary
    @ReferenceTarget(value={"Location"})
    private final List<Reference> location;
    @ReferenceTarget(value={"HealthcareService"})
    private final List<Reference> healthcareService;
    @Summary
    private final List<ContactPoint> telecom;
    private final List<AvailableTime> availableTime;
    private final List<NotAvailable> notAvailable;
    private final String availabilityExceptions;
    @ReferenceTarget(value={"Endpoint"})
    private final List<Reference> endpoint;

    private PractitionerRole(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.active = builder.active;
        this.period = builder.period;
        this.practitioner = builder.practitioner;
        this.organization = builder.organization;
        this.code = Collections.unmodifiableList(builder.code);
        this.specialty = Collections.unmodifiableList(builder.specialty);
        this.location = Collections.unmodifiableList(builder.location);
        this.healthcareService = Collections.unmodifiableList(builder.healthcareService);
        this.telecom = Collections.unmodifiableList(builder.telecom);
        this.availableTime = Collections.unmodifiableList(builder.availableTime);
        this.notAvailable = Collections.unmodifiableList(builder.notAvailable);
        this.availabilityExceptions = builder.availabilityExceptions;
        this.endpoint = Collections.unmodifiableList(builder.endpoint);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Reference getPractitioner() {
        return this.practitioner;
    }

    public Reference getOrganization() {
        return this.organization;
    }

    public List<CodeableConcept> getCode() {
        return this.code;
    }

    public List<CodeableConcept> getSpecialty() {
        return this.specialty;
    }

    public List<Reference> getLocation() {
        return this.location;
    }

    public List<Reference> getHealthcareService() {
        return this.healthcareService;
    }

    public List<ContactPoint> getTelecom() {
        return this.telecom;
    }

    public List<AvailableTime> getAvailableTime() {
        return this.availableTime;
    }

    public List<NotAvailable> getNotAvailable() {
        return this.notAvailable;
    }

    public String getAvailabilityExceptions() {
        return this.availabilityExceptions;
    }

    public List<Reference> getEndpoint() {
        return this.endpoint;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.active != null || this.period != null || this.practitioner != null || this.organization != null || !this.code.isEmpty() || !this.specialty.isEmpty() || !this.location.isEmpty() || !this.healthcareService.isEmpty() || !this.telecom.isEmpty() || !this.availableTime.isEmpty() || !this.notAvailable.isEmpty() || this.availabilityExceptions != null || !this.endpoint.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.active, "active", visitor);
                this.accept(this.period, "period", visitor);
                this.accept(this.practitioner, "practitioner", visitor);
                this.accept(this.organization, "organization", visitor);
                this.accept(this.code, "code", visitor, CodeableConcept.class);
                this.accept(this.specialty, "specialty", visitor, CodeableConcept.class);
                this.accept(this.location, "location", visitor, Reference.class);
                this.accept(this.healthcareService, "healthcareService", visitor, Reference.class);
                this.accept(this.telecom, "telecom", visitor, ContactPoint.class);
                this.accept(this.availableTime, "availableTime", visitor, AvailableTime.class);
                this.accept(this.notAvailable, "notAvailable", visitor, NotAvailable.class);
                this.accept(this.availabilityExceptions, "availabilityExceptions", visitor);
                this.accept(this.endpoint, "endpoint", visitor, Reference.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PractitionerRole other = (PractitionerRole)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.active, other.active) && Objects.equals(this.period, other.period) && Objects.equals(this.practitioner, other.practitioner) && Objects.equals(this.organization, other.organization) && Objects.equals(this.code, other.code) && Objects.equals(this.specialty, other.specialty) && Objects.equals(this.location, other.location) && Objects.equals(this.healthcareService, other.healthcareService) && Objects.equals(this.telecom, other.telecom) && Objects.equals(this.availableTime, other.availableTime) && Objects.equals(this.notAvailable, other.notAvailable) && Objects.equals(this.availabilityExceptions, other.availabilityExceptions) && Objects.equals(this.endpoint, other.endpoint);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.active, this.period, this.practitioner, this.organization, this.code, this.specialty, this.location, this.healthcareService, this.telecom, this.availableTime, this.notAvailable, this.availabilityExceptions, this.endpoint);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class NotAvailable
    extends BackboneElement {
        @Required
        private final String description;
        private final Period during;

        private NotAvailable(Builder builder) {
            super(builder);
            this.description = builder.description;
            this.during = builder.during;
        }

        public String getDescription() {
            return this.description;
        }

        public Period getDuring() {
            return this.during;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || this.during != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.during, "during", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NotAvailable other = (NotAvailable)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.during, other.during);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.during);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String description;
            private Period during;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(java.lang.String description) {
                this.description = description == null ? null : String.of(description);
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder during(Period during) {
                this.during = during;
                return this;
            }

            @Override
            public NotAvailable build() {
                NotAvailable notAvailable = new NotAvailable(this);
                if (this.validating) {
                    this.validate(notAvailable);
                }
                return notAvailable;
            }

            protected void validate(NotAvailable notAvailable) {
                super.validate(notAvailable);
                ValidationSupport.requireNonNull(notAvailable.description, "description");
                ValidationSupport.requireValueOrChildren(notAvailable);
            }

            protected Builder from(NotAvailable notAvailable) {
                super.from(notAvailable);
                this.description = notAvailable.description;
                this.during = notAvailable.during;
                return this;
            }
        }
    }

    public static class AvailableTime
    extends BackboneElement {
        @Binding(bindingName="DaysOfWeek", strength=BindingStrength.Value.REQUIRED, description="The days of the week.", valueSet="http://hl7.org/fhir/ValueSet/days-of-week|4.3.0")
        private final List<DaysOfWeek> daysOfWeek;
        private final Boolean allDay;
        private final Time availableStartTime;
        private final Time availableEndTime;

        private AvailableTime(Builder builder) {
            super(builder);
            this.daysOfWeek = Collections.unmodifiableList(builder.daysOfWeek);
            this.allDay = builder.allDay;
            this.availableStartTime = builder.availableStartTime;
            this.availableEndTime = builder.availableEndTime;
        }

        public List<DaysOfWeek> getDaysOfWeek() {
            return this.daysOfWeek;
        }

        public Boolean getAllDay() {
            return this.allDay;
        }

        public Time getAvailableStartTime() {
            return this.availableStartTime;
        }

        public Time getAvailableEndTime() {
            return this.availableEndTime;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.daysOfWeek.isEmpty() || this.allDay != null || this.availableStartTime != null || this.availableEndTime != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.daysOfWeek, "daysOfWeek", visitor, DaysOfWeek.class);
                    this.accept(this.allDay, "allDay", visitor);
                    this.accept(this.availableStartTime, "availableStartTime", visitor);
                    this.accept(this.availableEndTime, "availableEndTime", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AvailableTime other = (AvailableTime)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.daysOfWeek, other.daysOfWeek) && Objects.equals(this.allDay, other.allDay) && Objects.equals(this.availableStartTime, other.availableStartTime) && Objects.equals(this.availableEndTime, other.availableEndTime);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.daysOfWeek, this.allDay, this.availableStartTime, this.availableEndTime);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<DaysOfWeek> daysOfWeek = new ArrayList<DaysOfWeek>();
            private Boolean allDay;
            private Time availableStartTime;
            private Time availableEndTime;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder daysOfWeek(DaysOfWeek ... daysOfWeek) {
                for (DaysOfWeek value : daysOfWeek) {
                    this.daysOfWeek.add(value);
                }
                return this;
            }

            public Builder daysOfWeek(Collection<DaysOfWeek> daysOfWeek) {
                this.daysOfWeek = new ArrayList<DaysOfWeek>(daysOfWeek);
                return this;
            }

            public Builder allDay(java.lang.Boolean allDay) {
                this.allDay = allDay == null ? null : Boolean.of(allDay);
                return this;
            }

            public Builder allDay(Boolean allDay) {
                this.allDay = allDay;
                return this;
            }

            public Builder availableStartTime(LocalTime availableStartTime) {
                this.availableStartTime = availableStartTime == null ? null : Time.of(availableStartTime);
                return this;
            }

            public Builder availableStartTime(Time availableStartTime) {
                this.availableStartTime = availableStartTime;
                return this;
            }

            public Builder availableEndTime(LocalTime availableEndTime) {
                this.availableEndTime = availableEndTime == null ? null : Time.of(availableEndTime);
                return this;
            }

            public Builder availableEndTime(Time availableEndTime) {
                this.availableEndTime = availableEndTime;
                return this;
            }

            @Override
            public AvailableTime build() {
                AvailableTime availableTime = new AvailableTime(this);
                if (this.validating) {
                    this.validate(availableTime);
                }
                return availableTime;
            }

            protected void validate(AvailableTime availableTime) {
                super.validate(availableTime);
                ValidationSupport.checkList(availableTime.daysOfWeek, "daysOfWeek", DaysOfWeek.class);
                ValidationSupport.requireValueOrChildren(availableTime);
            }

            protected Builder from(AvailableTime availableTime) {
                super.from(availableTime);
                this.daysOfWeek.addAll(availableTime.daysOfWeek);
                this.allDay = availableTime.allDay;
                this.availableStartTime = availableTime.availableStartTime;
                this.availableEndTime = availableTime.availableEndTime;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Boolean active;
        private Period period;
        private Reference practitioner;
        private Reference organization;
        private List<CodeableConcept> code = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> specialty = new ArrayList<CodeableConcept>();
        private List<Reference> location = new ArrayList<Reference>();
        private List<Reference> healthcareService = new ArrayList<Reference>();
        private List<ContactPoint> telecom = new ArrayList<ContactPoint>();
        private List<AvailableTime> availableTime = new ArrayList<AvailableTime>();
        private List<NotAvailable> notAvailable = new ArrayList<NotAvailable>();
        private String availabilityExceptions;
        private List<Reference> endpoint = new ArrayList<Reference>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder active(java.lang.Boolean active) {
            this.active = active == null ? null : Boolean.of(active);
            return this;
        }

        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder practitioner(Reference practitioner) {
            this.practitioner = practitioner;
            return this;
        }

        public Builder organization(Reference organization) {
            this.organization = organization;
            return this;
        }

        public Builder code(CodeableConcept ... code) {
            for (CodeableConcept value : code) {
                this.code.add(value);
            }
            return this;
        }

        public Builder code(Collection<CodeableConcept> code) {
            this.code = new ArrayList<CodeableConcept>(code);
            return this;
        }

        public Builder specialty(CodeableConcept ... specialty) {
            for (CodeableConcept value : specialty) {
                this.specialty.add(value);
            }
            return this;
        }

        public Builder specialty(Collection<CodeableConcept> specialty) {
            this.specialty = new ArrayList<CodeableConcept>(specialty);
            return this;
        }

        public Builder location(Reference ... location) {
            for (Reference value : location) {
                this.location.add(value);
            }
            return this;
        }

        public Builder location(Collection<Reference> location) {
            this.location = new ArrayList<Reference>(location);
            return this;
        }

        public Builder healthcareService(Reference ... healthcareService) {
            for (Reference value : healthcareService) {
                this.healthcareService.add(value);
            }
            return this;
        }

        public Builder healthcareService(Collection<Reference> healthcareService) {
            this.healthcareService = new ArrayList<Reference>(healthcareService);
            return this;
        }

        public Builder telecom(ContactPoint ... telecom) {
            for (ContactPoint value : telecom) {
                this.telecom.add(value);
            }
            return this;
        }

        public Builder telecom(Collection<ContactPoint> telecom) {
            this.telecom = new ArrayList<ContactPoint>(telecom);
            return this;
        }

        public Builder availableTime(AvailableTime ... availableTime) {
            for (AvailableTime value : availableTime) {
                this.availableTime.add(value);
            }
            return this;
        }

        public Builder availableTime(Collection<AvailableTime> availableTime) {
            this.availableTime = new ArrayList<AvailableTime>(availableTime);
            return this;
        }

        public Builder notAvailable(NotAvailable ... notAvailable) {
            for (NotAvailable value : notAvailable) {
                this.notAvailable.add(value);
            }
            return this;
        }

        public Builder notAvailable(Collection<NotAvailable> notAvailable) {
            this.notAvailable = new ArrayList<NotAvailable>(notAvailable);
            return this;
        }

        public Builder availabilityExceptions(java.lang.String availabilityExceptions) {
            this.availabilityExceptions = availabilityExceptions == null ? null : String.of(availabilityExceptions);
            return this;
        }

        public Builder availabilityExceptions(String availabilityExceptions) {
            this.availabilityExceptions = availabilityExceptions;
            return this;
        }

        public Builder endpoint(Reference ... endpoint) {
            for (Reference value : endpoint) {
                this.endpoint.add(value);
            }
            return this;
        }

        public Builder endpoint(Collection<Reference> endpoint) {
            this.endpoint = new ArrayList<Reference>(endpoint);
            return this;
        }

        @Override
        public PractitionerRole build() {
            PractitionerRole practitionerRole = new PractitionerRole(this);
            if (this.validating) {
                this.validate(practitionerRole);
            }
            return practitionerRole;
        }

        protected void validate(PractitionerRole practitionerRole) {
            super.validate(practitionerRole);
            ValidationSupport.checkList(practitionerRole.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(practitionerRole.code, "code", CodeableConcept.class);
            ValidationSupport.checkList(practitionerRole.specialty, "specialty", CodeableConcept.class);
            ValidationSupport.checkList(practitionerRole.location, "location", Reference.class);
            ValidationSupport.checkList(practitionerRole.healthcareService, "healthcareService", Reference.class);
            ValidationSupport.checkList(practitionerRole.telecom, "telecom", ContactPoint.class);
            ValidationSupport.checkList(practitionerRole.availableTime, "availableTime", AvailableTime.class);
            ValidationSupport.checkList(practitionerRole.notAvailable, "notAvailable", NotAvailable.class);
            ValidationSupport.checkList(practitionerRole.endpoint, "endpoint", Reference.class);
            ValidationSupport.checkReferenceType(practitionerRole.practitioner, "practitioner", "Practitioner");
            ValidationSupport.checkReferenceType(practitionerRole.organization, "organization", "Organization");
            ValidationSupport.checkReferenceType(practitionerRole.location, "location", "Location");
            ValidationSupport.checkReferenceType(practitionerRole.healthcareService, "healthcareService", "HealthcareService");
            ValidationSupport.checkReferenceType(practitionerRole.endpoint, "endpoint", "Endpoint");
        }

        protected Builder from(PractitionerRole practitionerRole) {
            super.from(practitionerRole);
            this.identifier.addAll(practitionerRole.identifier);
            this.active = practitionerRole.active;
            this.period = practitionerRole.period;
            this.practitioner = practitionerRole.practitioner;
            this.organization = practitionerRole.organization;
            this.code.addAll(practitionerRole.code);
            this.specialty.addAll(practitionerRole.specialty);
            this.location.addAll(practitionerRole.location);
            this.healthcareService.addAll(practitionerRole.healthcareService);
            this.telecom.addAll(practitionerRole.telecom);
            this.availableTime.addAll(practitionerRole.availableTime);
            this.notAvailable.addAll(practitionerRole.notAvailable);
            this.availabilityExceptions = practitionerRole.availabilityExceptions;
            this.endpoint.addAll(practitionerRole.endpoint);
            return this;
        }
    }
}

