/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.CodeableReference;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="regulatedAuthorization-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/publication-status", expression="status.exists() implies (status.memberOf('http://hl7.org/fhir/ValueSet/publication-status', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/RegulatedAuthorization", generated=true), @Constraint(id="regulatedAuthorization-1", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/product-intended-use", expression="intendedUse.exists() implies (intendedUse.memberOf('http://hl7.org/fhir/ValueSet/product-intended-use', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/RegulatedAuthorization", generated=true), @Constraint(id="regulatedAuthorization-2", level="Warning", location="case.status", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/publication-status", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/publication-status', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/RegulatedAuthorization", generated=true)})
public class RegulatedAuthorization
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @ReferenceTarget(value={"MedicinalProductDefinition", "BiologicallyDerivedProduct", "NutritionProduct", "PackagedProductDefinition", "SubstanceDefinition", "DeviceDefinition", "ResearchStudy", "ActivityDefinition", "PlanDefinition", "ObservationDefinition", "Practitioner", "Organization", "Location"})
    private final List<Reference> subject;
    @Summary
    @Binding(bindingName="RegulatedAuthorizationType", strength=BindingStrength.Value.EXAMPLE, description="Overall type of this authorization.", valueSet="http://hl7.org/fhir/ValueSet/regulated-authorization-type")
    private final CodeableConcept type;
    @Summary
    private final Markdown description;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXAMPLE, description="Jurisdiction codes", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> region;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.PREFERRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    private final CodeableConcept status;
    @Summary
    private final DateTime statusDate;
    @Summary
    private final Period validityPeriod;
    @Summary
    private final CodeableReference indication;
    @Summary
    @Binding(bindingName="ProductIntendedUse", strength=BindingStrength.Value.PREFERRED, description="The overall intended use of a product.", valueSet="http://hl7.org/fhir/ValueSet/product-intended-use")
    private final CodeableConcept intendedUse;
    @Summary
    @Binding(bindingName="RegulatedAuthorizationBasis", strength=BindingStrength.Value.EXAMPLE, description="A legal or regulatory framework against which an authorization is granted, or other reasons for it.", valueSet="http://hl7.org/fhir/ValueSet/regulated-authorization-basis")
    private final List<CodeableConcept> basis;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference holder;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference regulator;
    @Summary
    private final Case _case;

    private RegulatedAuthorization(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.subject = Collections.unmodifiableList(builder.subject);
        this.type = builder.type;
        this.description = builder.description;
        this.region = Collections.unmodifiableList(builder.region);
        this.status = builder.status;
        this.statusDate = builder.statusDate;
        this.validityPeriod = builder.validityPeriod;
        this.indication = builder.indication;
        this.intendedUse = builder.intendedUse;
        this.basis = Collections.unmodifiableList(builder.basis);
        this.holder = builder.holder;
        this.regulator = builder.regulator;
        this._case = builder._case;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Reference> getSubject() {
        return this.subject;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<CodeableConcept> getRegion() {
        return this.region;
    }

    public CodeableConcept getStatus() {
        return this.status;
    }

    public DateTime getStatusDate() {
        return this.statusDate;
    }

    public Period getValidityPeriod() {
        return this.validityPeriod;
    }

    public CodeableReference getIndication() {
        return this.indication;
    }

    public CodeableConcept getIntendedUse() {
        return this.intendedUse;
    }

    public List<CodeableConcept> getBasis() {
        return this.basis;
    }

    public Reference getHolder() {
        return this.holder;
    }

    public Reference getRegulator() {
        return this.regulator;
    }

    public Case getCase() {
        return this._case;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.subject.isEmpty() || this.type != null || this.description != null || !this.region.isEmpty() || this.status != null || this.statusDate != null || this.validityPeriod != null || this.indication != null || this.intendedUse != null || !this.basis.isEmpty() || this.holder != null || this.regulator != null || this._case != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.subject, "subject", visitor, Reference.class);
                this.accept(this.type, "type", visitor);
                this.accept(this.description, "description", visitor);
                this.accept(this.region, "region", visitor, CodeableConcept.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.statusDate, "statusDate", visitor);
                this.accept(this.validityPeriod, "validityPeriod", visitor);
                this.accept(this.indication, "indication", visitor);
                this.accept(this.intendedUse, "intendedUse", visitor);
                this.accept(this.basis, "basis", visitor, CodeableConcept.class);
                this.accept(this.holder, "holder", visitor);
                this.accept(this.regulator, "regulator", visitor);
                this.accept(this._case, "case", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegulatedAuthorization other = (RegulatedAuthorization)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.subject, other.subject) && Objects.equals(this.type, other.type) && Objects.equals(this.description, other.description) && Objects.equals(this.region, other.region) && Objects.equals(this.status, other.status) && Objects.equals(this.statusDate, other.statusDate) && Objects.equals(this.validityPeriod, other.validityPeriod) && Objects.equals(this.indication, other.indication) && Objects.equals(this.intendedUse, other.intendedUse) && Objects.equals(this.basis, other.basis) && Objects.equals(this.holder, other.holder) && Objects.equals(this.regulator, other.regulator) && Objects.equals(this._case, other._case);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.subject, this.type, this.description, this.region, this.status, this.statusDate, this.validityPeriod, this.indication, this.intendedUse, this.basis, this.holder, this.regulator, this._case);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Case
    extends BackboneElement {
        @Summary
        private final Identifier identifier;
        @Summary
        @Binding(bindingName="RegulatedAuthorizationCaseType", strength=BindingStrength.Value.EXAMPLE, description="The type of a case involved in an application.", valueSet="http://hl7.org/fhir/ValueSet/regulated-authorization-case-type")
        private final CodeableConcept type;
        @Summary
        @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.PREFERRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status")
        private final CodeableConcept status;
        @Summary
        @Choice(value={Period.class, DateTime.class})
        private final Element date;
        @Summary
        private final List<Case> application;

        private Case(Builder builder) {
            super(builder);
            this.identifier = builder.identifier;
            this.type = builder.type;
            this.status = builder.status;
            this.date = builder.date;
            this.application = Collections.unmodifiableList(builder.application);
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public CodeableConcept getStatus() {
            return this.status;
        }

        public Element getDate() {
            return this.date;
        }

        public List<Case> getApplication() {
            return this.application;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.identifier != null || this.type != null || this.status != null || this.date != null || !this.application.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.identifier, "identifier", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.status, "status", visitor);
                    this.accept(this.date, "date", visitor);
                    this.accept(this.application, "application", visitor, Case.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Case other = (Case)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.type, other.type) && Objects.equals(this.status, other.status) && Objects.equals(this.date, other.date) && Objects.equals(this.application, other.application);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.type, this.status, this.date, this.application);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Identifier identifier;
            private CodeableConcept type;
            private CodeableConcept status;
            private Element date;
            private List<Case> application = new ArrayList<Case>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder identifier(Identifier identifier) {
                this.identifier = identifier;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder status(CodeableConcept status) {
                this.status = status;
                return this;
            }

            public Builder date(Element date) {
                this.date = date;
                return this;
            }

            public Builder application(Case ... application) {
                for (Case value : application) {
                    this.application.add(value);
                }
                return this;
            }

            public Builder application(Collection<Case> application) {
                this.application = new ArrayList<Case>(application);
                return this;
            }

            @Override
            public Case build() {
                Case _case = new Case(this);
                if (this.validating) {
                    this.validate(_case);
                }
                return _case;
            }

            protected void validate(Case _case) {
                super.validate(_case);
                ValidationSupport.choiceElement(_case.date, "date", Period.class, DateTime.class);
                ValidationSupport.checkList(_case.application, "application", Case.class);
                ValidationSupport.requireValueOrChildren(_case);
            }

            protected Builder from(Case _case) {
                super.from(_case);
                this.identifier = _case.identifier;
                this.type = _case.type;
                this.status = _case.status;
                this.date = _case.date;
                this.application.addAll(_case.application);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Reference> subject = new ArrayList<Reference>();
        private CodeableConcept type;
        private Markdown description;
        private List<CodeableConcept> region = new ArrayList<CodeableConcept>();
        private CodeableConcept status;
        private DateTime statusDate;
        private Period validityPeriod;
        private CodeableReference indication;
        private CodeableConcept intendedUse;
        private List<CodeableConcept> basis = new ArrayList<CodeableConcept>();
        private Reference holder;
        private Reference regulator;
        private Case _case;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder subject(Reference ... subject) {
            for (Reference value : subject) {
                this.subject.add(value);
            }
            return this;
        }

        public Builder subject(Collection<Reference> subject) {
            this.subject = new ArrayList<Reference>(subject);
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder region(CodeableConcept ... region) {
            for (CodeableConcept value : region) {
                this.region.add(value);
            }
            return this;
        }

        public Builder region(Collection<CodeableConcept> region) {
            this.region = new ArrayList<CodeableConcept>(region);
            return this;
        }

        public Builder status(CodeableConcept status) {
            this.status = status;
            return this;
        }

        public Builder statusDate(DateTime statusDate) {
            this.statusDate = statusDate;
            return this;
        }

        public Builder validityPeriod(Period validityPeriod) {
            this.validityPeriod = validityPeriod;
            return this;
        }

        public Builder indication(CodeableReference indication) {
            this.indication = indication;
            return this;
        }

        public Builder intendedUse(CodeableConcept intendedUse) {
            this.intendedUse = intendedUse;
            return this;
        }

        public Builder basis(CodeableConcept ... basis) {
            for (CodeableConcept value : basis) {
                this.basis.add(value);
            }
            return this;
        }

        public Builder basis(Collection<CodeableConcept> basis) {
            this.basis = new ArrayList<CodeableConcept>(basis);
            return this;
        }

        public Builder holder(Reference holder) {
            this.holder = holder;
            return this;
        }

        public Builder regulator(Reference regulator) {
            this.regulator = regulator;
            return this;
        }

        public Builder _case(Case _case) {
            this._case = _case;
            return this;
        }

        @Override
        public RegulatedAuthorization build() {
            RegulatedAuthorization regulatedAuthorization = new RegulatedAuthorization(this);
            if (this.validating) {
                this.validate(regulatedAuthorization);
            }
            return regulatedAuthorization;
        }

        protected void validate(RegulatedAuthorization regulatedAuthorization) {
            super.validate(regulatedAuthorization);
            ValidationSupport.checkList(regulatedAuthorization.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(regulatedAuthorization.subject, "subject", Reference.class);
            ValidationSupport.checkList(regulatedAuthorization.region, "region", CodeableConcept.class);
            ValidationSupport.checkList(regulatedAuthorization.basis, "basis", CodeableConcept.class);
            ValidationSupport.checkReferenceType(regulatedAuthorization.subject, "subject", "MedicinalProductDefinition", "BiologicallyDerivedProduct", "NutritionProduct", "PackagedProductDefinition", "SubstanceDefinition", "DeviceDefinition", "ResearchStudy", "ActivityDefinition", "PlanDefinition", "ObservationDefinition", "Practitioner", "Organization", "Location");
            ValidationSupport.checkReferenceType(regulatedAuthorization.holder, "holder", "Organization");
            ValidationSupport.checkReferenceType(regulatedAuthorization.regulator, "regulator", "Organization");
        }

        protected Builder from(RegulatedAuthorization regulatedAuthorization) {
            super.from(regulatedAuthorization);
            this.identifier.addAll(regulatedAuthorization.identifier);
            this.subject.addAll(regulatedAuthorization.subject);
            this.type = regulatedAuthorization.type;
            this.description = regulatedAuthorization.description;
            this.region.addAll(regulatedAuthorization.region);
            this.status = regulatedAuthorization.status;
            this.statusDate = regulatedAuthorization.statusDate;
            this.validityPeriod = regulatedAuthorization.validityPeriod;
            this.indication = regulatedAuthorization.indication;
            this.intendedUse = regulatedAuthorization.intendedUse;
            this.basis.addAll(regulatedAuthorization.basis);
            this.holder = regulatedAuthorization.holder;
            this.regulator = regulatedAuthorization.regulator;
            this._case = regulatedAuthorization._case;
            return this;
        }
    }
}

