/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Address;
import org.linuxforhealth.fhir.model.type.Attachment;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.ContactPoint;
import org.linuxforhealth.fhir.model.type.Date;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.HumanName;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.AdministrativeGender;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="relatedPerson-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/relatedperson-relationshiptype", expression="relationship.exists() implies (relationship.all(memberOf('http://hl7.org/fhir/ValueSet/relatedperson-relationshiptype', 'preferred')))", source="http://hl7.org/fhir/StructureDefinition/RelatedPerson", generated=true), @Constraint(id="relatedPerson-1", level="Warning", location="communication.language", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/languages", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/languages', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/RelatedPerson", generated=true)})
public class RelatedPerson
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final Boolean active;
    @Summary
    @ReferenceTarget(value={"Patient"})
    @Required
    private final Reference patient;
    @Summary
    @Binding(bindingName="PatientRelationshipType", strength=BindingStrength.Value.PREFERRED, description="The nature of the relationship between a patient and the related person.", valueSet="http://hl7.org/fhir/ValueSet/relatedperson-relationshiptype")
    private final List<CodeableConcept> relationship;
    @Summary
    private final List<HumanName> name;
    @Summary
    private final List<ContactPoint> telecom;
    @Summary
    @Binding(bindingName="AdministrativeGender", strength=BindingStrength.Value.REQUIRED, description="The gender of a person used for administrative purposes.", valueSet="http://hl7.org/fhir/ValueSet/administrative-gender|4.3.0")
    private final AdministrativeGender gender;
    @Summary
    private final Date birthDate;
    @Summary
    private final List<Address> address;
    private final List<Attachment> photo;
    private final Period period;
    private final List<Communication> communication;

    private RelatedPerson(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.active = builder.active;
        this.patient = builder.patient;
        this.relationship = Collections.unmodifiableList(builder.relationship);
        this.name = Collections.unmodifiableList(builder.name);
        this.telecom = Collections.unmodifiableList(builder.telecom);
        this.gender = builder.gender;
        this.birthDate = builder.birthDate;
        this.address = Collections.unmodifiableList(builder.address);
        this.photo = Collections.unmodifiableList(builder.photo);
        this.period = builder.period;
        this.communication = Collections.unmodifiableList(builder.communication);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public List<CodeableConcept> getRelationship() {
        return this.relationship;
    }

    public List<HumanName> getName() {
        return this.name;
    }

    public List<ContactPoint> getTelecom() {
        return this.telecom;
    }

    public AdministrativeGender getGender() {
        return this.gender;
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    public List<Address> getAddress() {
        return this.address;
    }

    public List<Attachment> getPhoto() {
        return this.photo;
    }

    public Period getPeriod() {
        return this.period;
    }

    public List<Communication> getCommunication() {
        return this.communication;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.active != null || this.patient != null || !this.relationship.isEmpty() || !this.name.isEmpty() || !this.telecom.isEmpty() || this.gender != null || this.birthDate != null || !this.address.isEmpty() || !this.photo.isEmpty() || this.period != null || !this.communication.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.active, "active", visitor);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.relationship, "relationship", visitor, CodeableConcept.class);
                this.accept(this.name, "name", visitor, HumanName.class);
                this.accept(this.telecom, "telecom", visitor, ContactPoint.class);
                this.accept(this.gender, "gender", visitor);
                this.accept(this.birthDate, "birthDate", visitor);
                this.accept(this.address, "address", visitor, Address.class);
                this.accept(this.photo, "photo", visitor, Attachment.class);
                this.accept(this.period, "period", visitor);
                this.accept(this.communication, "communication", visitor, Communication.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelatedPerson other = (RelatedPerson)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.active, other.active) && Objects.equals(this.patient, other.patient) && Objects.equals(this.relationship, other.relationship) && Objects.equals(this.name, other.name) && Objects.equals(this.telecom, other.telecom) && Objects.equals(this.gender, other.gender) && Objects.equals(this.birthDate, other.birthDate) && Objects.equals(this.address, other.address) && Objects.equals(this.photo, other.photo) && Objects.equals(this.period, other.period) && Objects.equals(this.communication, other.communication);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.active, this.patient, this.relationship, this.name, this.telecom, this.gender, this.birthDate, this.address, this.photo, this.period, this.communication);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Communication
    extends BackboneElement {
        @Binding(bindingName="Language", strength=BindingStrength.Value.PREFERRED, description="IETF language tag", valueSet="http://hl7.org/fhir/ValueSet/languages", maxValueSet="http://hl7.org/fhir/ValueSet/all-languages")
        @Required
        private final CodeableConcept language;
        private final Boolean preferred;

        private Communication(Builder builder) {
            super(builder);
            this.language = builder.language;
            this.preferred = builder.preferred;
        }

        public CodeableConcept getLanguage() {
            return this.language;
        }

        public Boolean getPreferred() {
            return this.preferred;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.language != null || this.preferred != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.language, "language", visitor);
                    this.accept(this.preferred, "preferred", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Communication other = (Communication)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.language, other.language) && Objects.equals(this.preferred, other.preferred);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.language, this.preferred);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept language;
            private Boolean preferred;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder language(CodeableConcept language) {
                this.language = language;
                return this;
            }

            public Builder preferred(java.lang.Boolean preferred) {
                this.preferred = preferred == null ? null : Boolean.of(preferred);
                return this;
            }

            public Builder preferred(Boolean preferred) {
                this.preferred = preferred;
                return this;
            }

            @Override
            public Communication build() {
                Communication communication = new Communication(this);
                if (this.validating) {
                    this.validate(communication);
                }
                return communication;
            }

            protected void validate(Communication communication) {
                super.validate(communication);
                ValidationSupport.requireNonNull(communication.language, "language");
                ValidationSupport.checkValueSetBinding(communication.language, "language", "http://hl7.org/fhir/ValueSet/all-languages", "urn:ietf:bcp:47", new String[0]);
                ValidationSupport.requireValueOrChildren(communication);
            }

            protected Builder from(Communication communication) {
                super.from(communication);
                this.language = communication.language;
                this.preferred = communication.preferred;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Boolean active;
        private Reference patient;
        private List<CodeableConcept> relationship = new ArrayList<CodeableConcept>();
        private List<HumanName> name = new ArrayList<HumanName>();
        private List<ContactPoint> telecom = new ArrayList<ContactPoint>();
        private AdministrativeGender gender;
        private Date birthDate;
        private List<Address> address = new ArrayList<Address>();
        private List<Attachment> photo = new ArrayList<Attachment>();
        private Period period;
        private List<Communication> communication = new ArrayList<Communication>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder active(java.lang.Boolean active) {
            this.active = active == null ? null : Boolean.of(active);
            return this;
        }

        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder relationship(CodeableConcept ... relationship) {
            for (CodeableConcept value : relationship) {
                this.relationship.add(value);
            }
            return this;
        }

        public Builder relationship(Collection<CodeableConcept> relationship) {
            this.relationship = new ArrayList<CodeableConcept>(relationship);
            return this;
        }

        public Builder name(HumanName ... name) {
            for (HumanName value : name) {
                this.name.add(value);
            }
            return this;
        }

        public Builder name(Collection<HumanName> name) {
            this.name = new ArrayList<HumanName>(name);
            return this;
        }

        public Builder telecom(ContactPoint ... telecom) {
            for (ContactPoint value : telecom) {
                this.telecom.add(value);
            }
            return this;
        }

        public Builder telecom(Collection<ContactPoint> telecom) {
            this.telecom = new ArrayList<ContactPoint>(telecom);
            return this;
        }

        public Builder gender(AdministrativeGender gender) {
            this.gender = gender;
            return this;
        }

        public Builder birthDate(LocalDate birthDate) {
            this.birthDate = birthDate == null ? null : Date.of(birthDate);
            return this;
        }

        public Builder birthDate(Date birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        public Builder address(Address ... address) {
            for (Address value : address) {
                this.address.add(value);
            }
            return this;
        }

        public Builder address(Collection<Address> address) {
            this.address = new ArrayList<Address>(address);
            return this;
        }

        public Builder photo(Attachment ... photo) {
            for (Attachment value : photo) {
                this.photo.add(value);
            }
            return this;
        }

        public Builder photo(Collection<Attachment> photo) {
            this.photo = new ArrayList<Attachment>(photo);
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder communication(Communication ... communication) {
            for (Communication value : communication) {
                this.communication.add(value);
            }
            return this;
        }

        public Builder communication(Collection<Communication> communication) {
            this.communication = new ArrayList<Communication>(communication);
            return this;
        }

        @Override
        public RelatedPerson build() {
            RelatedPerson relatedPerson = new RelatedPerson(this);
            if (this.validating) {
                this.validate(relatedPerson);
            }
            return relatedPerson;
        }

        protected void validate(RelatedPerson relatedPerson) {
            super.validate(relatedPerson);
            ValidationSupport.checkList(relatedPerson.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(relatedPerson.patient, "patient");
            ValidationSupport.checkList(relatedPerson.relationship, "relationship", CodeableConcept.class);
            ValidationSupport.checkList(relatedPerson.name, "name", HumanName.class);
            ValidationSupport.checkList(relatedPerson.telecom, "telecom", ContactPoint.class);
            ValidationSupport.checkList(relatedPerson.address, "address", Address.class);
            ValidationSupport.checkList(relatedPerson.photo, "photo", Attachment.class);
            ValidationSupport.checkList(relatedPerson.communication, "communication", Communication.class);
            ValidationSupport.checkReferenceType(relatedPerson.patient, "patient", "Patient");
        }

        protected Builder from(RelatedPerson relatedPerson) {
            super.from(relatedPerson);
            this.identifier.addAll(relatedPerson.identifier);
            this.active = relatedPerson.active;
            this.patient = relatedPerson.patient;
            this.relationship.addAll(relatedPerson.relationship);
            this.name.addAll(relatedPerson.name);
            this.telecom.addAll(relatedPerson.telecom);
            this.gender = relatedPerson.gender;
            this.birthDate = relatedPerson.birthDate;
            this.address.addAll(relatedPerson.address);
            this.photo.addAll(relatedPerson.photo);
            this.period = relatedPerson.period;
            this.communication.addAll(relatedPerson.communication);
            return this;
        }
    }
}

