/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Age;
import org.linuxforhealth.fhir.model.type.Annotation;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Canonical;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Duration;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Expression;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Id;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Range;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.RelatedArtifact;
import org.linuxforhealth.fhir.model.type.Timing;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.ActionCardinalityBehavior;
import org.linuxforhealth.fhir.model.type.code.ActionConditionKind;
import org.linuxforhealth.fhir.model.type.code.ActionGroupingBehavior;
import org.linuxforhealth.fhir.model.type.code.ActionPrecheckBehavior;
import org.linuxforhealth.fhir.model.type.code.ActionRelationshipType;
import org.linuxforhealth.fhir.model.type.code.ActionRequiredBehavior;
import org.linuxforhealth.fhir.model.type.code.ActionSelectionBehavior;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.RequestIntent;
import org.linuxforhealth.fhir.model.type.code.RequestPriority;
import org.linuxforhealth.fhir.model.type.code.RequestStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="rqg-1", level="Rule", location="RequestGroup.action", description="Must have resource or action but not both", expression="resource.exists() != action.exists()", source="http://hl7.org/fhir/StructureDefinition/RequestGroup"), @Constraint(id="requestGroup-2", level="Warning", location="action.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/action-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/action-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/RequestGroup", generated=true)})
public class RequestGroup
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final List<Canonical> instantiatesCanonical;
    @Summary
    private final List<Uri> instantiatesUri;
    private final List<Reference> basedOn;
    private final List<Reference> replaces;
    @Summary
    private final Identifier groupIdentifier;
    @Summary
    @Binding(bindingName="RequestStatus", strength=BindingStrength.Value.REQUIRED, description="Codes identifying the lifecycle stage of a request.", valueSet="http://hl7.org/fhir/ValueSet/request-status|4.3.0")
    @Required
    private final RequestStatus status;
    @Summary
    @Binding(bindingName="RequestIntent", strength=BindingStrength.Value.REQUIRED, description="Codes indicating the degree of authority/intentionality associated with a request.", valueSet="http://hl7.org/fhir/ValueSet/request-intent|4.3.0")
    @Required
    private final RequestIntent intent;
    @Summary
    @Binding(bindingName="RequestPriority", strength=BindingStrength.Value.REQUIRED, description="Identifies the level of importance to be assigned to actioning the request.", valueSet="http://hl7.org/fhir/ValueSet/request-priority|4.3.0")
    private final RequestPriority priority;
    @Summary
    private final CodeableConcept code;
    @ReferenceTarget(value={"Patient", "Group"})
    private final Reference subject;
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    private final DateTime authoredOn;
    @ReferenceTarget(value={"Device", "Practitioner", "PractitionerRole"})
    private final Reference author;
    private final List<CodeableConcept> reasonCode;
    @ReferenceTarget(value={"Condition", "Observation", "DiagnosticReport", "DocumentReference"})
    private final List<Reference> reasonReference;
    private final List<Annotation> note;
    private final List<Action> action;

    private RequestGroup(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.instantiatesCanonical = Collections.unmodifiableList(builder.instantiatesCanonical);
        this.instantiatesUri = Collections.unmodifiableList(builder.instantiatesUri);
        this.basedOn = Collections.unmodifiableList(builder.basedOn);
        this.replaces = Collections.unmodifiableList(builder.replaces);
        this.groupIdentifier = builder.groupIdentifier;
        this.status = builder.status;
        this.intent = builder.intent;
        this.priority = builder.priority;
        this.code = builder.code;
        this.subject = builder.subject;
        this.encounter = builder.encounter;
        this.authoredOn = builder.authoredOn;
        this.author = builder.author;
        this.reasonCode = Collections.unmodifiableList(builder.reasonCode);
        this.reasonReference = Collections.unmodifiableList(builder.reasonReference);
        this.note = Collections.unmodifiableList(builder.note);
        this.action = Collections.unmodifiableList(builder.action);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Canonical> getInstantiatesCanonical() {
        return this.instantiatesCanonical;
    }

    public List<Uri> getInstantiatesUri() {
        return this.instantiatesUri;
    }

    public List<Reference> getBasedOn() {
        return this.basedOn;
    }

    public List<Reference> getReplaces() {
        return this.replaces;
    }

    public Identifier getGroupIdentifier() {
        return this.groupIdentifier;
    }

    public RequestStatus getStatus() {
        return this.status;
    }

    public RequestIntent getIntent() {
        return this.intent;
    }

    public RequestPriority getPriority() {
        return this.priority;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public DateTime getAuthoredOn() {
        return this.authoredOn;
    }

    public Reference getAuthor() {
        return this.author;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        return this.reasonReference;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<Action> getAction() {
        return this.action;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.instantiatesCanonical.isEmpty() || !this.instantiatesUri.isEmpty() || !this.basedOn.isEmpty() || !this.replaces.isEmpty() || this.groupIdentifier != null || this.status != null || this.intent != null || this.priority != null || this.code != null || this.subject != null || this.encounter != null || this.authoredOn != null || this.author != null || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || !this.note.isEmpty() || !this.action.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.instantiatesCanonical, "instantiatesCanonical", visitor, Canonical.class);
                this.accept(this.instantiatesUri, "instantiatesUri", visitor, Uri.class);
                this.accept(this.basedOn, "basedOn", visitor, Reference.class);
                this.accept(this.replaces, "replaces", visitor, Reference.class);
                this.accept(this.groupIdentifier, "groupIdentifier", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.intent, "intent", visitor);
                this.accept(this.priority, "priority", visitor);
                this.accept(this.code, "code", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.authoredOn, "authoredOn", visitor);
                this.accept(this.author, "author", visitor);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.action, "action", visitor, Action.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestGroup other = (RequestGroup)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.instantiatesCanonical, other.instantiatesCanonical) && Objects.equals(this.instantiatesUri, other.instantiatesUri) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.replaces, other.replaces) && Objects.equals(this.groupIdentifier, other.groupIdentifier) && Objects.equals(this.status, other.status) && Objects.equals(this.intent, other.intent) && Objects.equals(this.priority, other.priority) && Objects.equals(this.code, other.code) && Objects.equals(this.subject, other.subject) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.authoredOn, other.authoredOn) && Objects.equals(this.author, other.author) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.note, other.note) && Objects.equals(this.action, other.action);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.basedOn, this.replaces, this.groupIdentifier, this.status, this.intent, this.priority, this.code, this.subject, this.encounter, this.authoredOn, this.author, this.reasonCode, this.reasonReference, this.note, this.action);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Action
    extends BackboneElement {
        private final org.linuxforhealth.fhir.model.type.String prefix;
        private final org.linuxforhealth.fhir.model.type.String title;
        @Summary
        private final org.linuxforhealth.fhir.model.type.String description;
        @Summary
        private final org.linuxforhealth.fhir.model.type.String textEquivalent;
        @Binding(bindingName="RequestPriority", strength=BindingStrength.Value.REQUIRED, description="Identifies the level of importance to be assigned to actioning the request.", valueSet="http://hl7.org/fhir/ValueSet/request-priority|4.3.0")
        private final RequestPriority priority;
        private final List<CodeableConcept> code;
        private final List<RelatedArtifact> documentation;
        private final List<Condition> condition;
        private final List<RelatedAction> relatedAction;
        @Choice(value={DateTime.class, Age.class, Period.class, Duration.class, Range.class, Timing.class})
        private final Element timing;
        @ReferenceTarget(value={"Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "Device"})
        private final List<Reference> participant;
        @Binding(bindingName="ActionType", strength=BindingStrength.Value.EXTENSIBLE, description="The type of action to be performed.", valueSet="http://hl7.org/fhir/ValueSet/action-type")
        private final CodeableConcept type;
        @Binding(bindingName="ActionGroupingBehavior", strength=BindingStrength.Value.REQUIRED, description="Defines organization behavior of a group.", valueSet="http://hl7.org/fhir/ValueSet/action-grouping-behavior|4.3.0")
        private final ActionGroupingBehavior groupingBehavior;
        @Binding(bindingName="ActionSelectionBehavior", strength=BindingStrength.Value.REQUIRED, description="Defines selection behavior of a group.", valueSet="http://hl7.org/fhir/ValueSet/action-selection-behavior|4.3.0")
        private final ActionSelectionBehavior selectionBehavior;
        @Binding(bindingName="ActionRequiredBehavior", strength=BindingStrength.Value.REQUIRED, description="Defines expectations around whether an action or action group is required.", valueSet="http://hl7.org/fhir/ValueSet/action-required-behavior|4.3.0")
        private final ActionRequiredBehavior requiredBehavior;
        @Binding(bindingName="ActionPrecheckBehavior", strength=BindingStrength.Value.REQUIRED, description="Defines selection frequency behavior for an action or group.", valueSet="http://hl7.org/fhir/ValueSet/action-precheck-behavior|4.3.0")
        private final ActionPrecheckBehavior precheckBehavior;
        @Binding(bindingName="ActionCardinalityBehavior", strength=BindingStrength.Value.REQUIRED, description="Defines behavior for an action or a group for how many times that item may be repeated.", valueSet="http://hl7.org/fhir/ValueSet/action-cardinality-behavior|4.3.0")
        private final ActionCardinalityBehavior cardinalityBehavior;
        private final Reference resource;
        private final List<Action> action;

        private Action(Builder builder) {
            super(builder);
            this.prefix = builder.prefix;
            this.title = builder.title;
            this.description = builder.description;
            this.textEquivalent = builder.textEquivalent;
            this.priority = builder.priority;
            this.code = Collections.unmodifiableList(builder.code);
            this.documentation = Collections.unmodifiableList(builder.documentation);
            this.condition = Collections.unmodifiableList(builder.condition);
            this.relatedAction = Collections.unmodifiableList(builder.relatedAction);
            this.timing = builder.timing;
            this.participant = Collections.unmodifiableList(builder.participant);
            this.type = builder.type;
            this.groupingBehavior = builder.groupingBehavior;
            this.selectionBehavior = builder.selectionBehavior;
            this.requiredBehavior = builder.requiredBehavior;
            this.precheckBehavior = builder.precheckBehavior;
            this.cardinalityBehavior = builder.cardinalityBehavior;
            this.resource = builder.resource;
            this.action = Collections.unmodifiableList(builder.action);
        }

        public org.linuxforhealth.fhir.model.type.String getPrefix() {
            return this.prefix;
        }

        public org.linuxforhealth.fhir.model.type.String getTitle() {
            return this.title;
        }

        public org.linuxforhealth.fhir.model.type.String getDescription() {
            return this.description;
        }

        public org.linuxforhealth.fhir.model.type.String getTextEquivalent() {
            return this.textEquivalent;
        }

        public RequestPriority getPriority() {
            return this.priority;
        }

        public List<CodeableConcept> getCode() {
            return this.code;
        }

        public List<RelatedArtifact> getDocumentation() {
            return this.documentation;
        }

        public List<Condition> getCondition() {
            return this.condition;
        }

        public List<RelatedAction> getRelatedAction() {
            return this.relatedAction;
        }

        public Element getTiming() {
            return this.timing;
        }

        public List<Reference> getParticipant() {
            return this.participant;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public ActionGroupingBehavior getGroupingBehavior() {
            return this.groupingBehavior;
        }

        public ActionSelectionBehavior getSelectionBehavior() {
            return this.selectionBehavior;
        }

        public ActionRequiredBehavior getRequiredBehavior() {
            return this.requiredBehavior;
        }

        public ActionPrecheckBehavior getPrecheckBehavior() {
            return this.precheckBehavior;
        }

        public ActionCardinalityBehavior getCardinalityBehavior() {
            return this.cardinalityBehavior;
        }

        public Reference getResource() {
            return this.resource;
        }

        public List<Action> getAction() {
            return this.action;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.prefix != null || this.title != null || this.description != null || this.textEquivalent != null || this.priority != null || !this.code.isEmpty() || !this.documentation.isEmpty() || !this.condition.isEmpty() || !this.relatedAction.isEmpty() || this.timing != null || !this.participant.isEmpty() || this.type != null || this.groupingBehavior != null || this.selectionBehavior != null || this.requiredBehavior != null || this.precheckBehavior != null || this.cardinalityBehavior != null || this.resource != null || !this.action.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.prefix, "prefix", visitor);
                    this.accept(this.title, "title", visitor);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.textEquivalent, "textEquivalent", visitor);
                    this.accept(this.priority, "priority", visitor);
                    this.accept(this.code, "code", visitor, CodeableConcept.class);
                    this.accept(this.documentation, "documentation", visitor, RelatedArtifact.class);
                    this.accept(this.condition, "condition", visitor, Condition.class);
                    this.accept(this.relatedAction, "relatedAction", visitor, RelatedAction.class);
                    this.accept(this.timing, "timing", visitor);
                    this.accept(this.participant, "participant", visitor, Reference.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.groupingBehavior, "groupingBehavior", visitor);
                    this.accept(this.selectionBehavior, "selectionBehavior", visitor);
                    this.accept(this.requiredBehavior, "requiredBehavior", visitor);
                    this.accept(this.precheckBehavior, "precheckBehavior", visitor);
                    this.accept(this.cardinalityBehavior, "cardinalityBehavior", visitor);
                    this.accept(this.resource, "resource", visitor);
                    this.accept(this.action, "action", visitor, Action.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Action other = (Action)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.title, other.title) && Objects.equals(this.description, other.description) && Objects.equals(this.textEquivalent, other.textEquivalent) && Objects.equals(this.priority, other.priority) && Objects.equals(this.code, other.code) && Objects.equals(this.documentation, other.documentation) && Objects.equals(this.condition, other.condition) && Objects.equals(this.relatedAction, other.relatedAction) && Objects.equals(this.timing, other.timing) && Objects.equals(this.participant, other.participant) && Objects.equals(this.type, other.type) && Objects.equals(this.groupingBehavior, other.groupingBehavior) && Objects.equals(this.selectionBehavior, other.selectionBehavior) && Objects.equals(this.requiredBehavior, other.requiredBehavior) && Objects.equals(this.precheckBehavior, other.precheckBehavior) && Objects.equals(this.cardinalityBehavior, other.cardinalityBehavior) && Objects.equals(this.resource, other.resource) && Objects.equals(this.action, other.action);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.prefix, this.title, this.description, this.textEquivalent, this.priority, this.code, this.documentation, this.condition, this.relatedAction, this.timing, this.participant, this.type, this.groupingBehavior, this.selectionBehavior, this.requiredBehavior, this.precheckBehavior, this.cardinalityBehavior, this.resource, this.action);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class RelatedAction
        extends BackboneElement {
            @Required
            private final Id actionId;
            @Binding(bindingName="ActionRelationshipType", strength=BindingStrength.Value.REQUIRED, description="Defines the types of relationships between actions.", valueSet="http://hl7.org/fhir/ValueSet/action-relationship-type|4.3.0")
            @Required
            private final ActionRelationshipType relationship;
            @Choice(value={Duration.class, Range.class})
            private final Element offset;

            private RelatedAction(Builder builder) {
                super(builder);
                this.actionId = builder.actionId;
                this.relationship = builder.relationship;
                this.offset = builder.offset;
            }

            public Id getActionId() {
                return this.actionId;
            }

            public ActionRelationshipType getRelationship() {
                return this.relationship;
            }

            public Element getOffset() {
                return this.offset;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.actionId != null || this.relationship != null || this.offset != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.actionId, "actionId", visitor);
                        this.accept(this.relationship, "relationship", visitor);
                        this.accept(this.offset, "offset", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                RelatedAction other = (RelatedAction)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.actionId, other.actionId) && Objects.equals(this.relationship, other.relationship) && Objects.equals(this.offset, other.offset);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.actionId, this.relationship, this.offset);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Id actionId;
                private ActionRelationshipType relationship;
                private Element offset;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder actionId(Id actionId) {
                    this.actionId = actionId;
                    return this;
                }

                public Builder relationship(ActionRelationshipType relationship) {
                    this.relationship = relationship;
                    return this;
                }

                public Builder offset(Element offset) {
                    this.offset = offset;
                    return this;
                }

                @Override
                public RelatedAction build() {
                    RelatedAction relatedAction = new RelatedAction(this);
                    if (this.validating) {
                        this.validate(relatedAction);
                    }
                    return relatedAction;
                }

                protected void validate(RelatedAction relatedAction) {
                    super.validate(relatedAction);
                    ValidationSupport.requireNonNull(relatedAction.actionId, "actionId");
                    ValidationSupport.requireNonNull(relatedAction.relationship, "relationship");
                    ValidationSupport.choiceElement(relatedAction.offset, "offset", Duration.class, Range.class);
                    ValidationSupport.requireValueOrChildren(relatedAction);
                }

                protected Builder from(RelatedAction relatedAction) {
                    super.from(relatedAction);
                    this.actionId = relatedAction.actionId;
                    this.relationship = relatedAction.relationship;
                    this.offset = relatedAction.offset;
                    return this;
                }
            }
        }

        public static class Condition
        extends BackboneElement {
            @Binding(bindingName="ActionConditionKind", strength=BindingStrength.Value.REQUIRED, description="The kind of condition for the action.", valueSet="http://hl7.org/fhir/ValueSet/action-condition-kind|4.3.0")
            @Required
            private final ActionConditionKind kind;
            private final Expression expression;

            private Condition(Builder builder) {
                super(builder);
                this.kind = builder.kind;
                this.expression = builder.expression;
            }

            public ActionConditionKind getKind() {
                return this.kind;
            }

            public Expression getExpression() {
                return this.expression;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.kind != null || this.expression != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.kind, "kind", visitor);
                        this.accept(this.expression, "expression", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Condition other = (Condition)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.kind, other.kind) && Objects.equals(this.expression, other.expression);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.kind, this.expression);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private ActionConditionKind kind;
                private Expression expression;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder kind(ActionConditionKind kind) {
                    this.kind = kind;
                    return this;
                }

                public Builder expression(Expression expression) {
                    this.expression = expression;
                    return this;
                }

                @Override
                public Condition build() {
                    Condition condition = new Condition(this);
                    if (this.validating) {
                        this.validate(condition);
                    }
                    return condition;
                }

                protected void validate(Condition condition) {
                    super.validate(condition);
                    ValidationSupport.requireNonNull(condition.kind, "kind");
                    ValidationSupport.requireValueOrChildren(condition);
                }

                protected Builder from(Condition condition) {
                    super.from(condition);
                    this.kind = condition.kind;
                    this.expression = condition.expression;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private org.linuxforhealth.fhir.model.type.String prefix;
            private org.linuxforhealth.fhir.model.type.String title;
            private org.linuxforhealth.fhir.model.type.String description;
            private org.linuxforhealth.fhir.model.type.String textEquivalent;
            private RequestPriority priority;
            private List<CodeableConcept> code = new ArrayList<CodeableConcept>();
            private List<RelatedArtifact> documentation = new ArrayList<RelatedArtifact>();
            private List<Condition> condition = new ArrayList<Condition>();
            private List<RelatedAction> relatedAction = new ArrayList<RelatedAction>();
            private Element timing;
            private List<Reference> participant = new ArrayList<Reference>();
            private CodeableConcept type;
            private ActionGroupingBehavior groupingBehavior;
            private ActionSelectionBehavior selectionBehavior;
            private ActionRequiredBehavior requiredBehavior;
            private ActionPrecheckBehavior precheckBehavior;
            private ActionCardinalityBehavior cardinalityBehavior;
            private Reference resource;
            private List<Action> action = new ArrayList<Action>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix == null ? null : org.linuxforhealth.fhir.model.type.String.of(prefix);
                return this;
            }

            public Builder prefix(org.linuxforhealth.fhir.model.type.String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder title(String title) {
                this.title = title == null ? null : org.linuxforhealth.fhir.model.type.String.of(title);
                return this;
            }

            public Builder title(org.linuxforhealth.fhir.model.type.String title) {
                this.title = title;
                return this;
            }

            public Builder description(String description) {
                this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                return this;
            }

            public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                this.description = description;
                return this;
            }

            public Builder textEquivalent(String textEquivalent) {
                this.textEquivalent = textEquivalent == null ? null : org.linuxforhealth.fhir.model.type.String.of(textEquivalent);
                return this;
            }

            public Builder textEquivalent(org.linuxforhealth.fhir.model.type.String textEquivalent) {
                this.textEquivalent = textEquivalent;
                return this;
            }

            public Builder priority(RequestPriority priority) {
                this.priority = priority;
                return this;
            }

            public Builder code(CodeableConcept ... code) {
                for (CodeableConcept value : code) {
                    this.code.add(value);
                }
                return this;
            }

            public Builder code(Collection<CodeableConcept> code) {
                this.code = new ArrayList<CodeableConcept>(code);
                return this;
            }

            public Builder documentation(RelatedArtifact ... documentation) {
                for (RelatedArtifact value : documentation) {
                    this.documentation.add(value);
                }
                return this;
            }

            public Builder documentation(Collection<RelatedArtifact> documentation) {
                this.documentation = new ArrayList<RelatedArtifact>(documentation);
                return this;
            }

            public Builder condition(Condition ... condition) {
                for (Condition value : condition) {
                    this.condition.add(value);
                }
                return this;
            }

            public Builder condition(Collection<Condition> condition) {
                this.condition = new ArrayList<Condition>(condition);
                return this;
            }

            public Builder relatedAction(RelatedAction ... relatedAction) {
                for (RelatedAction value : relatedAction) {
                    this.relatedAction.add(value);
                }
                return this;
            }

            public Builder relatedAction(Collection<RelatedAction> relatedAction) {
                this.relatedAction = new ArrayList<RelatedAction>(relatedAction);
                return this;
            }

            public Builder timing(Element timing) {
                this.timing = timing;
                return this;
            }

            public Builder participant(Reference ... participant) {
                for (Reference value : participant) {
                    this.participant.add(value);
                }
                return this;
            }

            public Builder participant(Collection<Reference> participant) {
                this.participant = new ArrayList<Reference>(participant);
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder groupingBehavior(ActionGroupingBehavior groupingBehavior) {
                this.groupingBehavior = groupingBehavior;
                return this;
            }

            public Builder selectionBehavior(ActionSelectionBehavior selectionBehavior) {
                this.selectionBehavior = selectionBehavior;
                return this;
            }

            public Builder requiredBehavior(ActionRequiredBehavior requiredBehavior) {
                this.requiredBehavior = requiredBehavior;
                return this;
            }

            public Builder precheckBehavior(ActionPrecheckBehavior precheckBehavior) {
                this.precheckBehavior = precheckBehavior;
                return this;
            }

            public Builder cardinalityBehavior(ActionCardinalityBehavior cardinalityBehavior) {
                this.cardinalityBehavior = cardinalityBehavior;
                return this;
            }

            public Builder resource(Reference resource) {
                this.resource = resource;
                return this;
            }

            public Builder action(Action ... action) {
                for (Action value : action) {
                    this.action.add(value);
                }
                return this;
            }

            public Builder action(Collection<Action> action) {
                this.action = new ArrayList<Action>(action);
                return this;
            }

            @Override
            public Action build() {
                Action action = new Action(this);
                if (this.validating) {
                    this.validate(action);
                }
                return action;
            }

            protected void validate(Action action) {
                super.validate(action);
                ValidationSupport.checkList(action.code, "code", CodeableConcept.class);
                ValidationSupport.checkList(action.documentation, "documentation", RelatedArtifact.class);
                ValidationSupport.checkList(action.condition, "condition", Condition.class);
                ValidationSupport.checkList(action.relatedAction, "relatedAction", RelatedAction.class);
                ValidationSupport.choiceElement(action.timing, "timing", DateTime.class, Age.class, Period.class, Duration.class, Range.class, Timing.class);
                ValidationSupport.checkList(action.participant, "participant", Reference.class);
                ValidationSupport.checkList(action.action, "action", Action.class);
                ValidationSupport.checkReferenceType(action.participant, "participant", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "Device");
                ValidationSupport.requireValueOrChildren(action);
            }

            protected Builder from(Action action) {
                super.from(action);
                this.prefix = action.prefix;
                this.title = action.title;
                this.description = action.description;
                this.textEquivalent = action.textEquivalent;
                this.priority = action.priority;
                this.code.addAll(action.code);
                this.documentation.addAll(action.documentation);
                this.condition.addAll(action.condition);
                this.relatedAction.addAll(action.relatedAction);
                this.timing = action.timing;
                this.participant.addAll(action.participant);
                this.type = action.type;
                this.groupingBehavior = action.groupingBehavior;
                this.selectionBehavior = action.selectionBehavior;
                this.requiredBehavior = action.requiredBehavior;
                this.precheckBehavior = action.precheckBehavior;
                this.cardinalityBehavior = action.cardinalityBehavior;
                this.resource = action.resource;
                this.action.addAll(action.action);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Canonical> instantiatesCanonical = new ArrayList<Canonical>();
        private List<Uri> instantiatesUri = new ArrayList<Uri>();
        private List<Reference> basedOn = new ArrayList<Reference>();
        private List<Reference> replaces = new ArrayList<Reference>();
        private Identifier groupIdentifier;
        private RequestStatus status;
        private RequestIntent intent;
        private RequestPriority priority;
        private CodeableConcept code;
        private Reference subject;
        private Reference encounter;
        private DateTime authoredOn;
        private Reference author;
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private List<Reference> reasonReference = new ArrayList<Reference>();
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<Action> action = new ArrayList<Action>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder instantiatesCanonical(Canonical ... instantiatesCanonical) {
            for (Canonical value : instantiatesCanonical) {
                this.instantiatesCanonical.add(value);
            }
            return this;
        }

        public Builder instantiatesCanonical(Collection<Canonical> instantiatesCanonical) {
            this.instantiatesCanonical = new ArrayList<Canonical>(instantiatesCanonical);
            return this;
        }

        public Builder instantiatesUri(Uri ... instantiatesUri) {
            for (Uri value : instantiatesUri) {
                this.instantiatesUri.add(value);
            }
            return this;
        }

        public Builder instantiatesUri(Collection<Uri> instantiatesUri) {
            this.instantiatesUri = new ArrayList<Uri>(instantiatesUri);
            return this;
        }

        public Builder basedOn(Reference ... basedOn) {
            for (Reference value : basedOn) {
                this.basedOn.add(value);
            }
            return this;
        }

        public Builder basedOn(Collection<Reference> basedOn) {
            this.basedOn = new ArrayList<Reference>(basedOn);
            return this;
        }

        public Builder replaces(Reference ... replaces) {
            for (Reference value : replaces) {
                this.replaces.add(value);
            }
            return this;
        }

        public Builder replaces(Collection<Reference> replaces) {
            this.replaces = new ArrayList<Reference>(replaces);
            return this;
        }

        public Builder groupIdentifier(Identifier groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
            return this;
        }

        public Builder status(RequestStatus status) {
            this.status = status;
            return this;
        }

        public Builder intent(RequestIntent intent) {
            this.intent = intent;
            return this;
        }

        public Builder priority(RequestPriority priority) {
            this.priority = priority;
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder authoredOn(DateTime authoredOn) {
            this.authoredOn = authoredOn;
            return this;
        }

        public Builder author(Reference author) {
            this.author = author;
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder reasonReference(Reference ... reasonReference) {
            for (Reference value : reasonReference) {
                this.reasonReference.add(value);
            }
            return this;
        }

        public Builder reasonReference(Collection<Reference> reasonReference) {
            this.reasonReference = new ArrayList<Reference>(reasonReference);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder action(Action ... action) {
            for (Action value : action) {
                this.action.add(value);
            }
            return this;
        }

        public Builder action(Collection<Action> action) {
            this.action = new ArrayList<Action>(action);
            return this;
        }

        @Override
        public RequestGroup build() {
            RequestGroup requestGroup = new RequestGroup(this);
            if (this.validating) {
                this.validate(requestGroup);
            }
            return requestGroup;
        }

        protected void validate(RequestGroup requestGroup) {
            super.validate(requestGroup);
            ValidationSupport.checkList(requestGroup.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(requestGroup.instantiatesCanonical, "instantiatesCanonical", Canonical.class);
            ValidationSupport.checkList(requestGroup.instantiatesUri, "instantiatesUri", Uri.class);
            ValidationSupport.checkList(requestGroup.basedOn, "basedOn", Reference.class);
            ValidationSupport.checkList(requestGroup.replaces, "replaces", Reference.class);
            ValidationSupport.requireNonNull(requestGroup.status, "status");
            ValidationSupport.requireNonNull(requestGroup.intent, "intent");
            ValidationSupport.checkList(requestGroup.reasonCode, "reasonCode", CodeableConcept.class);
            ValidationSupport.checkList(requestGroup.reasonReference, "reasonReference", Reference.class);
            ValidationSupport.checkList(requestGroup.note, "note", Annotation.class);
            ValidationSupport.checkList(requestGroup.action, "action", Action.class);
            ValidationSupport.checkReferenceType(requestGroup.subject, "subject", "Patient", "Group");
            ValidationSupport.checkReferenceType(requestGroup.encounter, "encounter", "Encounter");
            ValidationSupport.checkReferenceType(requestGroup.author, "author", "Device", "Practitioner", "PractitionerRole");
            ValidationSupport.checkReferenceType(requestGroup.reasonReference, "reasonReference", "Condition", "Observation", "DiagnosticReport", "DocumentReference");
        }

        protected Builder from(RequestGroup requestGroup) {
            super.from(requestGroup);
            this.identifier.addAll(requestGroup.identifier);
            this.instantiatesCanonical.addAll(requestGroup.instantiatesCanonical);
            this.instantiatesUri.addAll(requestGroup.instantiatesUri);
            this.basedOn.addAll(requestGroup.basedOn);
            this.replaces.addAll(requestGroup.replaces);
            this.groupIdentifier = requestGroup.groupIdentifier;
            this.status = requestGroup.status;
            this.intent = requestGroup.intent;
            this.priority = requestGroup.priority;
            this.code = requestGroup.code;
            this.subject = requestGroup.subject;
            this.encounter = requestGroup.encounter;
            this.authoredOn = requestGroup.authoredOn;
            this.author = requestGroup.author;
            this.reasonCode.addAll(requestGroup.reasonCode);
            this.reasonReference.addAll(requestGroup.reasonReference);
            this.note.addAll(requestGroup.note);
            this.action.addAll(requestGroup.action);
            return this;
        }
    }
}

