/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.builder.AbstractBuilder;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.AbstractVisitable;

@Maturity(level=5, status=StandardsStatus.Value.NORMATIVE)
@Constraint(id="resource-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/languages", expression="language.exists() implies (language.memberOf('http://hl7.org/fhir/ValueSet/languages', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/Resource", generated=true)
public abstract class Resource
extends AbstractVisitable {
    @Summary
    protected final String id;
    @Summary
    protected final Meta meta;
    @Summary
    protected final Uri implicitRules;
    @Binding(bindingName="Language", strength=BindingStrength.Value.PREFERRED, description="IETF language tag", valueSet="http://hl7.org/fhir/ValueSet/languages", maxValueSet="http://hl7.org/fhir/ValueSet/all-languages")
    protected final Code language;
    protected volatile int hashCode;

    protected Resource(Builder builder) {
        this.id = builder.id;
        this.meta = builder.meta;
        this.implicitRules = builder.implicitRules;
        this.language = builder.language;
    }

    public String getId() {
        return this.id;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public Uri getImplicitRules() {
        return this.implicitRules;
    }

    public Code getLanguage() {
        return this.language;
    }

    public <T extends Resource> boolean is(Class<T> resourceType) {
        return resourceType.isInstance(this);
    }

    public <T extends Resource> T as(Class<T> resourceType) {
        return (T)((Resource)resourceType.cast(this));
    }

    public boolean hasChildren() {
        return this.id != null || this.meta != null || this.implicitRules != null || this.language != null;
    }

    public abstract Builder toBuilder();

    public static abstract class Builder
    extends AbstractBuilder<Resource> {
        protected String id;
        protected Meta meta;
        protected Uri implicitRules;
        protected Code language;

        protected Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder meta(Meta meta) {
            this.meta = meta;
            return this;
        }

        public Builder implicitRules(Uri implicitRules) {
            this.implicitRules = implicitRules;
            return this;
        }

        public Builder language(Code language) {
            this.language = language;
            return this;
        }

        @Override
        public abstract Resource build();

        protected void validate(Resource resource) {
            ValidationSupport.checkId(resource.id);
            ValidationSupport.checkValueSetBinding(resource.language, "language", "http://hl7.org/fhir/ValueSet/all-languages", "urn:ietf:bcp:47", new String[0]);
        }

        protected Builder from(Resource resource) {
            this.id = resource.id;
            this.meta = resource.meta;
            this.implicitRules = resource.implicitRules;
            this.language = resource.language;
            return this;
        }
    }
}

