/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Annotation;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Decimal;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Range;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.RiskAssessmentStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="ras-1", level="Rule", location="RiskAssessment.prediction.probability", description="low and high must be percentages, if present", expression="(low.empty() or ((low.code = '%') and (low.system = %ucum))) and (high.empty() or ((high.code = '%') and (high.system = %ucum)))", source="http://hl7.org/fhir/StructureDefinition/RiskAssessment"), @Constraint(id="ras-2", level="Rule", location="RiskAssessment.prediction", description="Must be <= 100", expression="probability.exists($this is decimal) implies (probability as decimal) <= 100", source="http://hl7.org/fhir/StructureDefinition/RiskAssessment")})
public class RiskAssessment
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    private final Reference basedOn;
    private final Reference parent;
    @Summary
    @Binding(bindingName="RiskAssessmentStatus", strength=BindingStrength.Value.REQUIRED, description="The status of the risk assessment; e.g. preliminary, final, amended, etc.", valueSet="http://hl7.org/fhir/ValueSet/observation-status|4.3.0")
    @Required
    private final RiskAssessmentStatus status;
    @Summary
    @Binding(bindingName="RiskAssessmentMethod", strength=BindingStrength.Value.EXAMPLE, description="The mechanism or algorithm used to make the assessment; e.g. TIMI, PRISM, Cardiff Type 2 diabetes, etc.")
    private final CodeableConcept method;
    @Summary
    private final CodeableConcept code;
    @Summary
    @ReferenceTarget(value={"Patient", "Group"})
    @Required
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    @Choice(value={DateTime.class, Period.class})
    private final Element occurrence;
    @Summary
    @ReferenceTarget(value={"Condition"})
    private final Reference condition;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Device"})
    private final Reference performer;
    private final List<CodeableConcept> reasonCode;
    @ReferenceTarget(value={"Condition", "Observation", "DiagnosticReport", "DocumentReference"})
    private final List<Reference> reasonReference;
    private final List<Reference> basis;
    private final List<Prediction> prediction;
    private final String mitigation;
    private final List<Annotation> note;

    private RiskAssessment(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.basedOn = builder.basedOn;
        this.parent = builder.parent;
        this.status = builder.status;
        this.method = builder.method;
        this.code = builder.code;
        this.subject = builder.subject;
        this.encounter = builder.encounter;
        this.occurrence = builder.occurrence;
        this.condition = builder.condition;
        this.performer = builder.performer;
        this.reasonCode = Collections.unmodifiableList(builder.reasonCode);
        this.reasonReference = Collections.unmodifiableList(builder.reasonReference);
        this.basis = Collections.unmodifiableList(builder.basis);
        this.prediction = Collections.unmodifiableList(builder.prediction);
        this.mitigation = builder.mitigation;
        this.note = Collections.unmodifiableList(builder.note);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Reference getBasedOn() {
        return this.basedOn;
    }

    public Reference getParent() {
        return this.parent;
    }

    public RiskAssessmentStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getMethod() {
        return this.method;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public Element getOccurrence() {
        return this.occurrence;
    }

    public Reference getCondition() {
        return this.condition;
    }

    public Reference getPerformer() {
        return this.performer;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        return this.reasonReference;
    }

    public List<Reference> getBasis() {
        return this.basis;
    }

    public List<Prediction> getPrediction() {
        return this.prediction;
    }

    public String getMitigation() {
        return this.mitigation;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.basedOn != null || this.parent != null || this.status != null || this.method != null || this.code != null || this.subject != null || this.encounter != null || this.occurrence != null || this.condition != null || this.performer != null || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || !this.basis.isEmpty() || !this.prediction.isEmpty() || this.mitigation != null || !this.note.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.basedOn, "basedOn", visitor);
                this.accept(this.parent, "parent", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.method, "method", visitor);
                this.accept(this.code, "code", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.occurrence, "occurrence", visitor);
                this.accept(this.condition, "condition", visitor);
                this.accept(this.performer, "performer", visitor);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                this.accept(this.basis, "basis", visitor, Reference.class);
                this.accept(this.prediction, "prediction", visitor, Prediction.class);
                this.accept(this.mitigation, "mitigation", visitor);
                this.accept(this.note, "note", visitor, Annotation.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RiskAssessment other = (RiskAssessment)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.parent, other.parent) && Objects.equals(this.status, other.status) && Objects.equals(this.method, other.method) && Objects.equals(this.code, other.code) && Objects.equals(this.subject, other.subject) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.occurrence, other.occurrence) && Objects.equals(this.condition, other.condition) && Objects.equals(this.performer, other.performer) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.basis, other.basis) && Objects.equals(this.prediction, other.prediction) && Objects.equals(this.mitigation, other.mitigation) && Objects.equals(this.note, other.note);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.basedOn, this.parent, this.status, this.method, this.code, this.subject, this.encounter, this.occurrence, this.condition, this.performer, this.reasonCode, this.reasonReference, this.basis, this.prediction, this.mitigation, this.note);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Prediction
    extends BackboneElement {
        @Binding(bindingName="RiskAssessmentOutcome", strength=BindingStrength.Value.EXAMPLE, description="The condition or other outcome; e.g. death, remission, amputation, infection, etc.")
        private final CodeableConcept outcome;
        @Choice(value={Decimal.class, Range.class})
        private final Element probability;
        @Binding(bindingName="RiskAssessmentProbability", strength=BindingStrength.Value.EXAMPLE, description="The likelihood of the occurrence of a specified outcome.", valueSet="http://hl7.org/fhir/ValueSet/risk-probability")
        private final CodeableConcept qualitativeRisk;
        private final Decimal relativeRisk;
        @Choice(value={Period.class, Range.class})
        private final Element when;
        private final String rationale;

        private Prediction(Builder builder) {
            super(builder);
            this.outcome = builder.outcome;
            this.probability = builder.probability;
            this.qualitativeRisk = builder.qualitativeRisk;
            this.relativeRisk = builder.relativeRisk;
            this.when = builder.when;
            this.rationale = builder.rationale;
        }

        public CodeableConcept getOutcome() {
            return this.outcome;
        }

        public Element getProbability() {
            return this.probability;
        }

        public CodeableConcept getQualitativeRisk() {
            return this.qualitativeRisk;
        }

        public Decimal getRelativeRisk() {
            return this.relativeRisk;
        }

        public Element getWhen() {
            return this.when;
        }

        public String getRationale() {
            return this.rationale;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.outcome != null || this.probability != null || this.qualitativeRisk != null || this.relativeRisk != null || this.when != null || this.rationale != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.outcome, "outcome", visitor);
                    this.accept(this.probability, "probability", visitor);
                    this.accept(this.qualitativeRisk, "qualitativeRisk", visitor);
                    this.accept(this.relativeRisk, "relativeRisk", visitor);
                    this.accept(this.when, "when", visitor);
                    this.accept(this.rationale, "rationale", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Prediction other = (Prediction)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.outcome, other.outcome) && Objects.equals(this.probability, other.probability) && Objects.equals(this.qualitativeRisk, other.qualitativeRisk) && Objects.equals(this.relativeRisk, other.relativeRisk) && Objects.equals(this.when, other.when) && Objects.equals(this.rationale, other.rationale);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.outcome, this.probability, this.qualitativeRisk, this.relativeRisk, this.when, this.rationale);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept outcome;
            private Element probability;
            private CodeableConcept qualitativeRisk;
            private Decimal relativeRisk;
            private Element when;
            private String rationale;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder outcome(CodeableConcept outcome) {
                this.outcome = outcome;
                return this;
            }

            public Builder probability(Element probability) {
                this.probability = probability;
                return this;
            }

            public Builder qualitativeRisk(CodeableConcept qualitativeRisk) {
                this.qualitativeRisk = qualitativeRisk;
                return this;
            }

            public Builder relativeRisk(Decimal relativeRisk) {
                this.relativeRisk = relativeRisk;
                return this;
            }

            public Builder when(Element when) {
                this.when = when;
                return this;
            }

            public Builder rationale(java.lang.String rationale) {
                this.rationale = rationale == null ? null : String.of(rationale);
                return this;
            }

            public Builder rationale(String rationale) {
                this.rationale = rationale;
                return this;
            }

            @Override
            public Prediction build() {
                Prediction prediction = new Prediction(this);
                if (this.validating) {
                    this.validate(prediction);
                }
                return prediction;
            }

            protected void validate(Prediction prediction) {
                super.validate(prediction);
                ValidationSupport.choiceElement(prediction.probability, "probability", Decimal.class, Range.class);
                ValidationSupport.choiceElement(prediction.when, "when", Period.class, Range.class);
                ValidationSupport.requireValueOrChildren(prediction);
            }

            protected Builder from(Prediction prediction) {
                super.from(prediction);
                this.outcome = prediction.outcome;
                this.probability = prediction.probability;
                this.qualitativeRisk = prediction.qualitativeRisk;
                this.relativeRisk = prediction.relativeRisk;
                this.when = prediction.when;
                this.rationale = prediction.rationale;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Reference basedOn;
        private Reference parent;
        private RiskAssessmentStatus status;
        private CodeableConcept method;
        private CodeableConcept code;
        private Reference subject;
        private Reference encounter;
        private Element occurrence;
        private Reference condition;
        private Reference performer;
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private List<Reference> reasonReference = new ArrayList<Reference>();
        private List<Reference> basis = new ArrayList<Reference>();
        private List<Prediction> prediction = new ArrayList<Prediction>();
        private String mitigation;
        private List<Annotation> note = new ArrayList<Annotation>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder basedOn(Reference basedOn) {
            this.basedOn = basedOn;
            return this;
        }

        public Builder parent(Reference parent) {
            this.parent = parent;
            return this;
        }

        public Builder status(RiskAssessmentStatus status) {
            this.status = status;
            return this;
        }

        public Builder method(CodeableConcept method) {
            this.method = method;
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder occurrence(Element occurrence) {
            this.occurrence = occurrence;
            return this;
        }

        public Builder condition(Reference condition) {
            this.condition = condition;
            return this;
        }

        public Builder performer(Reference performer) {
            this.performer = performer;
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder reasonReference(Reference ... reasonReference) {
            for (Reference value : reasonReference) {
                this.reasonReference.add(value);
            }
            return this;
        }

        public Builder reasonReference(Collection<Reference> reasonReference) {
            this.reasonReference = new ArrayList<Reference>(reasonReference);
            return this;
        }

        public Builder basis(Reference ... basis) {
            for (Reference value : basis) {
                this.basis.add(value);
            }
            return this;
        }

        public Builder basis(Collection<Reference> basis) {
            this.basis = new ArrayList<Reference>(basis);
            return this;
        }

        public Builder prediction(Prediction ... prediction) {
            for (Prediction value : prediction) {
                this.prediction.add(value);
            }
            return this;
        }

        public Builder prediction(Collection<Prediction> prediction) {
            this.prediction = new ArrayList<Prediction>(prediction);
            return this;
        }

        public Builder mitigation(java.lang.String mitigation) {
            this.mitigation = mitigation == null ? null : String.of(mitigation);
            return this;
        }

        public Builder mitigation(String mitigation) {
            this.mitigation = mitigation;
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        @Override
        public RiskAssessment build() {
            RiskAssessment riskAssessment = new RiskAssessment(this);
            if (this.validating) {
                this.validate(riskAssessment);
            }
            return riskAssessment;
        }

        protected void validate(RiskAssessment riskAssessment) {
            super.validate(riskAssessment);
            ValidationSupport.checkList(riskAssessment.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(riskAssessment.status, "status");
            ValidationSupport.requireNonNull(riskAssessment.subject, "subject");
            ValidationSupport.choiceElement(riskAssessment.occurrence, "occurrence", DateTime.class, Period.class);
            ValidationSupport.checkList(riskAssessment.reasonCode, "reasonCode", CodeableConcept.class);
            ValidationSupport.checkList(riskAssessment.reasonReference, "reasonReference", Reference.class);
            ValidationSupport.checkList(riskAssessment.basis, "basis", Reference.class);
            ValidationSupport.checkList(riskAssessment.prediction, "prediction", Prediction.class);
            ValidationSupport.checkList(riskAssessment.note, "note", Annotation.class);
            ValidationSupport.checkReferenceType(riskAssessment.subject, "subject", "Patient", "Group");
            ValidationSupport.checkReferenceType(riskAssessment.encounter, "encounter", "Encounter");
            ValidationSupport.checkReferenceType(riskAssessment.condition, "condition", "Condition");
            ValidationSupport.checkReferenceType(riskAssessment.performer, "performer", "Practitioner", "PractitionerRole", "Device");
            ValidationSupport.checkReferenceType(riskAssessment.reasonReference, "reasonReference", "Condition", "Observation", "DiagnosticReport", "DocumentReference");
        }

        protected Builder from(RiskAssessment riskAssessment) {
            super.from(riskAssessment);
            this.identifier.addAll(riskAssessment.identifier);
            this.basedOn = riskAssessment.basedOn;
            this.parent = riskAssessment.parent;
            this.status = riskAssessment.status;
            this.method = riskAssessment.method;
            this.code = riskAssessment.code;
            this.subject = riskAssessment.subject;
            this.encounter = riskAssessment.encounter;
            this.occurrence = riskAssessment.occurrence;
            this.condition = riskAssessment.condition;
            this.performer = riskAssessment.performer;
            this.reasonCode.addAll(riskAssessment.reasonCode);
            this.reasonReference.addAll(riskAssessment.reasonReference);
            this.basis.addAll(riskAssessment.basis);
            this.prediction.addAll(riskAssessment.prediction);
            this.mitigation = riskAssessment.mitigation;
            this.note.addAll(riskAssessment.note);
            return this;
        }
    }
}

