/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
@Constraint(id="schedule-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/c80-practice-codes", expression="specialty.exists() implies (specialty.all(memberOf('http://hl7.org/fhir/ValueSet/c80-practice-codes', 'preferred')))", source="http://hl7.org/fhir/StructureDefinition/Schedule", generated=true)
public class Schedule
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final Boolean active;
    @Summary
    @Binding(bindingName="service-category", strength=BindingStrength.Value.EXAMPLE, valueSet="http://hl7.org/fhir/ValueSet/service-category")
    private final List<CodeableConcept> serviceCategory;
    @Summary
    @Binding(bindingName="service-type", strength=BindingStrength.Value.EXAMPLE, valueSet="http://hl7.org/fhir/ValueSet/service-type")
    private final List<CodeableConcept> serviceType;
    @Summary
    @Binding(bindingName="specialty", strength=BindingStrength.Value.PREFERRED, description="Additional details about where the content was created (e.g. clinical specialty).", valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
    private final List<CodeableConcept> specialty;
    @Summary
    @ReferenceTarget(value={"Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "Device", "HealthcareService", "Location"})
    @Required
    private final List<Reference> actor;
    @Summary
    private final Period planningHorizon;
    private final String comment;

    private Schedule(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.active = builder.active;
        this.serviceCategory = Collections.unmodifiableList(builder.serviceCategory);
        this.serviceType = Collections.unmodifiableList(builder.serviceType);
        this.specialty = Collections.unmodifiableList(builder.specialty);
        this.actor = Collections.unmodifiableList(builder.actor);
        this.planningHorizon = builder.planningHorizon;
        this.comment = builder.comment;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Boolean getActive() {
        return this.active;
    }

    public List<CodeableConcept> getServiceCategory() {
        return this.serviceCategory;
    }

    public List<CodeableConcept> getServiceType() {
        return this.serviceType;
    }

    public List<CodeableConcept> getSpecialty() {
        return this.specialty;
    }

    public List<Reference> getActor() {
        return this.actor;
    }

    public Period getPlanningHorizon() {
        return this.planningHorizon;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.active != null || !this.serviceCategory.isEmpty() || !this.serviceType.isEmpty() || !this.specialty.isEmpty() || !this.actor.isEmpty() || this.planningHorizon != null || this.comment != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.active, "active", visitor);
                this.accept(this.serviceCategory, "serviceCategory", visitor, CodeableConcept.class);
                this.accept(this.serviceType, "serviceType", visitor, CodeableConcept.class);
                this.accept(this.specialty, "specialty", visitor, CodeableConcept.class);
                this.accept(this.actor, "actor", visitor, Reference.class);
                this.accept(this.planningHorizon, "planningHorizon", visitor);
                this.accept(this.comment, "comment", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Schedule other = (Schedule)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.active, other.active) && Objects.equals(this.serviceCategory, other.serviceCategory) && Objects.equals(this.serviceType, other.serviceType) && Objects.equals(this.specialty, other.specialty) && Objects.equals(this.actor, other.actor) && Objects.equals(this.planningHorizon, other.planningHorizon) && Objects.equals(this.comment, other.comment);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.active, this.serviceCategory, this.serviceType, this.specialty, this.actor, this.planningHorizon, this.comment);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Boolean active;
        private List<CodeableConcept> serviceCategory = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> serviceType = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> specialty = new ArrayList<CodeableConcept>();
        private List<Reference> actor = new ArrayList<Reference>();
        private Period planningHorizon;
        private String comment;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder active(java.lang.Boolean active) {
            this.active = active == null ? null : Boolean.of(active);
            return this;
        }

        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder serviceCategory(CodeableConcept ... serviceCategory) {
            for (CodeableConcept value : serviceCategory) {
                this.serviceCategory.add(value);
            }
            return this;
        }

        public Builder serviceCategory(Collection<CodeableConcept> serviceCategory) {
            this.serviceCategory = new ArrayList<CodeableConcept>(serviceCategory);
            return this;
        }

        public Builder serviceType(CodeableConcept ... serviceType) {
            for (CodeableConcept value : serviceType) {
                this.serviceType.add(value);
            }
            return this;
        }

        public Builder serviceType(Collection<CodeableConcept> serviceType) {
            this.serviceType = new ArrayList<CodeableConcept>(serviceType);
            return this;
        }

        public Builder specialty(CodeableConcept ... specialty) {
            for (CodeableConcept value : specialty) {
                this.specialty.add(value);
            }
            return this;
        }

        public Builder specialty(Collection<CodeableConcept> specialty) {
            this.specialty = new ArrayList<CodeableConcept>(specialty);
            return this;
        }

        public Builder actor(Reference ... actor) {
            for (Reference value : actor) {
                this.actor.add(value);
            }
            return this;
        }

        public Builder actor(Collection<Reference> actor) {
            this.actor = new ArrayList<Reference>(actor);
            return this;
        }

        public Builder planningHorizon(Period planningHorizon) {
            this.planningHorizon = planningHorizon;
            return this;
        }

        public Builder comment(java.lang.String comment) {
            this.comment = comment == null ? null : String.of(comment);
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Schedule build() {
            Schedule schedule = new Schedule(this);
            if (this.validating) {
                this.validate(schedule);
            }
            return schedule;
        }

        protected void validate(Schedule schedule) {
            super.validate(schedule);
            ValidationSupport.checkList(schedule.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(schedule.serviceCategory, "serviceCategory", CodeableConcept.class);
            ValidationSupport.checkList(schedule.serviceType, "serviceType", CodeableConcept.class);
            ValidationSupport.checkList(schedule.specialty, "specialty", CodeableConcept.class);
            ValidationSupport.checkNonEmptyList(schedule.actor, "actor", Reference.class);
            ValidationSupport.checkReferenceType(schedule.actor, "actor", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "Device", "HealthcareService", "Location");
        }

        protected Builder from(Schedule schedule) {
            super.from(schedule);
            this.identifier.addAll(schedule.identifier);
            this.active = schedule.active;
            this.serviceCategory.addAll(schedule.serviceCategory);
            this.serviceType.addAll(schedule.serviceType);
            this.specialty.addAll(schedule.specialty);
            this.actor.addAll(schedule.actor);
            this.planningHorizon = schedule.planningHorizon;
            this.comment = schedule.comment;
            return this;
        }
    }
}

