/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Annotation;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Duration;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.SimpleQuantity;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.SpecimenStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="specimen-0", level="Warning", location="collection.fastingStatus", description="SHALL, if possible, contain a code from value set http://terminology.hl7.org/ValueSet/v2-0916", expression="$this.as(CodeableConcept).memberOf('http://terminology.hl7.org/ValueSet/v2-0916', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Specimen", generated=true), @Constraint(id="specimen-1", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://terminology.hl7.org/ValueSet/v2-0493", expression="condition.exists() implies (condition.all(memberOf('http://terminology.hl7.org/ValueSet/v2-0493', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/Specimen", generated=true)})
public class Specimen
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final Identifier accessionIdentifier;
    @Summary
    @Binding(bindingName="SpecimenStatus", strength=BindingStrength.Value.REQUIRED, description="Codes providing the status/availability of a specimen.", valueSet="http://hl7.org/fhir/ValueSet/specimen-status|4.3.0")
    private final SpecimenStatus status;
    @Summary
    @Binding(bindingName="SpecimenType", strength=BindingStrength.Value.EXAMPLE, description="The type of the specimen.", valueSet="http://terminology.hl7.org/ValueSet/v2-0487")
    private final CodeableConcept type;
    @Summary
    @ReferenceTarget(value={"Patient", "Group", "Device", "Substance", "Location"})
    private final Reference subject;
    @Summary
    private final DateTime receivedTime;
    @ReferenceTarget(value={"Specimen"})
    private final List<Reference> parent;
    @ReferenceTarget(value={"ServiceRequest"})
    private final List<Reference> request;
    private final Collection collection;
    private final List<Processing> processing;
    private final List<Container> container;
    @Summary
    @Binding(bindingName="SpecimenCondition", strength=BindingStrength.Value.EXTENSIBLE, description="Codes describing the state of the specimen.", valueSet="http://terminology.hl7.org/ValueSet/v2-0493")
    private final List<CodeableConcept> condition;
    private final List<Annotation> note;

    private Specimen(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.accessionIdentifier = builder.accessionIdentifier;
        this.status = builder.status;
        this.type = builder.type;
        this.subject = builder.subject;
        this.receivedTime = builder.receivedTime;
        this.parent = Collections.unmodifiableList(builder.parent);
        this.request = Collections.unmodifiableList(builder.request);
        this.collection = builder.collection;
        this.processing = Collections.unmodifiableList(builder.processing);
        this.container = Collections.unmodifiableList(builder.container);
        this.condition = Collections.unmodifiableList(builder.condition);
        this.note = Collections.unmodifiableList(builder.note);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier getAccessionIdentifier() {
        return this.accessionIdentifier;
    }

    public SpecimenStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public DateTime getReceivedTime() {
        return this.receivedTime;
    }

    public List<Reference> getParent() {
        return this.parent;
    }

    public List<Reference> getRequest() {
        return this.request;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public List<Processing> getProcessing() {
        return this.processing;
    }

    public List<Container> getContainer() {
        return this.container;
    }

    public List<CodeableConcept> getCondition() {
        return this.condition;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.accessionIdentifier != null || this.status != null || this.type != null || this.subject != null || this.receivedTime != null || !this.parent.isEmpty() || !this.request.isEmpty() || this.collection != null || !this.processing.isEmpty() || !this.container.isEmpty() || !this.condition.isEmpty() || !this.note.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.accessionIdentifier, "accessionIdentifier", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.receivedTime, "receivedTime", visitor);
                this.accept(this.parent, "parent", visitor, Reference.class);
                this.accept(this.request, "request", visitor, Reference.class);
                this.accept(this.collection, "collection", visitor);
                this.accept(this.processing, "processing", visitor, Processing.class);
                this.accept(this.container, "container", visitor, Container.class);
                this.accept(this.condition, "condition", visitor, CodeableConcept.class);
                this.accept(this.note, "note", visitor, Annotation.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Specimen other = (Specimen)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.accessionIdentifier, other.accessionIdentifier) && Objects.equals(this.status, other.status) && Objects.equals(this.type, other.type) && Objects.equals(this.subject, other.subject) && Objects.equals(this.receivedTime, other.receivedTime) && Objects.equals(this.parent, other.parent) && Objects.equals(this.request, other.request) && Objects.equals(this.collection, other.collection) && Objects.equals(this.processing, other.processing) && Objects.equals(this.container, other.container) && Objects.equals(this.condition, other.condition) && Objects.equals(this.note, other.note);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.accessionIdentifier, this.status, this.type, this.subject, this.receivedTime, this.parent, this.request, this.collection, this.processing, this.container, this.condition, this.note);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Container
    extends BackboneElement {
        @Summary
        private final List<Identifier> identifier;
        private final String description;
        @Binding(bindingName="SpecimenContainerType", strength=BindingStrength.Value.EXAMPLE, description="Type of specimen container.", valueSet="http://hl7.org/fhir/ValueSet/specimen-container-type")
        private final CodeableConcept type;
        private final SimpleQuantity capacity;
        private final SimpleQuantity specimenQuantity;
        @ReferenceTarget(value={"Substance"})
        @Choice(value={CodeableConcept.class, Reference.class})
        @Binding(bindingName="SpecimenContainerAdditive", strength=BindingStrength.Value.EXAMPLE, description="Substance added to specimen container.", valueSet="http://terminology.hl7.org/ValueSet/v2-0371")
        private final Element additive;

        private Container(Builder builder) {
            super(builder);
            this.identifier = Collections.unmodifiableList(builder.identifier);
            this.description = builder.description;
            this.type = builder.type;
            this.capacity = builder.capacity;
            this.specimenQuantity = builder.specimenQuantity;
            this.additive = builder.additive;
        }

        public List<Identifier> getIdentifier() {
            return this.identifier;
        }

        public String getDescription() {
            return this.description;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public SimpleQuantity getCapacity() {
            return this.capacity;
        }

        public SimpleQuantity getSpecimenQuantity() {
            return this.specimenQuantity;
        }

        public Element getAdditive() {
            return this.additive;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.identifier.isEmpty() || this.description != null || this.type != null || this.capacity != null || this.specimenQuantity != null || this.additive != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.identifier, "identifier", visitor, Identifier.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.capacity, "capacity", visitor);
                    this.accept(this.specimenQuantity, "specimenQuantity", visitor);
                    this.accept(this.additive, "additive", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Container other = (Container)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.description, other.description) && Objects.equals(this.type, other.type) && Objects.equals(this.capacity, other.capacity) && Objects.equals(this.specimenQuantity, other.specimenQuantity) && Objects.equals(this.additive, other.additive);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.description, this.type, this.capacity, this.specimenQuantity, this.additive);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Identifier> identifier = new ArrayList<Identifier>();
            private String description;
            private CodeableConcept type;
            private SimpleQuantity capacity;
            private SimpleQuantity specimenQuantity;
            private Element additive;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(java.util.Collection<Extension> extension) {
                return (Builder)super.extension((java.util.Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(java.util.Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder identifier(Identifier ... identifier) {
                for (Identifier value : identifier) {
                    this.identifier.add(value);
                }
                return this;
            }

            public Builder identifier(java.util.Collection<Identifier> identifier) {
                this.identifier = new ArrayList<Identifier>(identifier);
                return this;
            }

            public Builder description(java.lang.String description) {
                this.description = description == null ? null : String.of(description);
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder capacity(SimpleQuantity capacity) {
                this.capacity = capacity;
                return this;
            }

            public Builder specimenQuantity(SimpleQuantity specimenQuantity) {
                this.specimenQuantity = specimenQuantity;
                return this;
            }

            public Builder additive(Element additive) {
                this.additive = additive;
                return this;
            }

            @Override
            public Container build() {
                Container container = new Container(this);
                if (this.validating) {
                    this.validate(container);
                }
                return container;
            }

            protected void validate(Container container) {
                super.validate(container);
                ValidationSupport.checkList(container.identifier, "identifier", Identifier.class);
                ValidationSupport.choiceElement(container.additive, "additive", CodeableConcept.class, Reference.class);
                ValidationSupport.checkReferenceType(container.additive, "additive", "Substance");
                ValidationSupport.requireValueOrChildren(container);
            }

            protected Builder from(Container container) {
                super.from(container);
                this.identifier.addAll(container.identifier);
                this.description = container.description;
                this.type = container.type;
                this.capacity = container.capacity;
                this.specimenQuantity = container.specimenQuantity;
                this.additive = container.additive;
                return this;
            }
        }
    }

    public static class Processing
    extends BackboneElement {
        private final String description;
        @Binding(bindingName="SpecimenProcessingProcedure", strength=BindingStrength.Value.EXAMPLE, description="Type indicating the technique used to process the specimen.", valueSet="http://hl7.org/fhir/ValueSet/specimen-processing-procedure")
        private final CodeableConcept procedure;
        @ReferenceTarget(value={"Substance"})
        private final List<Reference> additive;
        @Choice(value={DateTime.class, Period.class})
        private final Element time;

        private Processing(Builder builder) {
            super(builder);
            this.description = builder.description;
            this.procedure = builder.procedure;
            this.additive = Collections.unmodifiableList(builder.additive);
            this.time = builder.time;
        }

        public String getDescription() {
            return this.description;
        }

        public CodeableConcept getProcedure() {
            return this.procedure;
        }

        public List<Reference> getAdditive() {
            return this.additive;
        }

        public Element getTime() {
            return this.time;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || this.procedure != null || !this.additive.isEmpty() || this.time != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.procedure, "procedure", visitor);
                    this.accept(this.additive, "additive", visitor, Reference.class);
                    this.accept(this.time, "time", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Processing other = (Processing)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.procedure, other.procedure) && Objects.equals(this.additive, other.additive) && Objects.equals(this.time, other.time);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.procedure, this.additive, this.time);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String description;
            private CodeableConcept procedure;
            private List<Reference> additive = new ArrayList<Reference>();
            private Element time;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(java.util.Collection<Extension> extension) {
                return (Builder)super.extension((java.util.Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(java.util.Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(java.lang.String description) {
                this.description = description == null ? null : String.of(description);
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder procedure(CodeableConcept procedure) {
                this.procedure = procedure;
                return this;
            }

            public Builder additive(Reference ... additive) {
                for (Reference value : additive) {
                    this.additive.add(value);
                }
                return this;
            }

            public Builder additive(java.util.Collection<Reference> additive) {
                this.additive = new ArrayList<Reference>(additive);
                return this;
            }

            public Builder time(Element time) {
                this.time = time;
                return this;
            }

            @Override
            public Processing build() {
                Processing processing = new Processing(this);
                if (this.validating) {
                    this.validate(processing);
                }
                return processing;
            }

            protected void validate(Processing processing) {
                super.validate(processing);
                ValidationSupport.checkList(processing.additive, "additive", Reference.class);
                ValidationSupport.choiceElement(processing.time, "time", DateTime.class, Period.class);
                ValidationSupport.checkReferenceType(processing.additive, "additive", "Substance");
                ValidationSupport.requireValueOrChildren(processing);
            }

            protected Builder from(Processing processing) {
                super.from(processing);
                this.description = processing.description;
                this.procedure = processing.procedure;
                this.additive.addAll(processing.additive);
                this.time = processing.time;
                return this;
            }
        }
    }

    public static class Collection
    extends BackboneElement {
        @Summary
        @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
        private final Reference collector;
        @Summary
        @Choice(value={DateTime.class, Period.class})
        private final Element collected;
        @Summary
        private final Duration duration;
        private final SimpleQuantity quantity;
        @Binding(bindingName="SpecimenCollectionMethod", strength=BindingStrength.Value.EXAMPLE, description="The  technique that is used to perform the procedure.", valueSet="http://hl7.org/fhir/ValueSet/specimen-collection-method")
        private final CodeableConcept method;
        @Binding(bindingName="BodySite", strength=BindingStrength.Value.EXAMPLE, description="SNOMED CT Body site concepts", valueSet="http://hl7.org/fhir/ValueSet/body-site")
        private final CodeableConcept bodySite;
        @Summary
        @Choice(value={CodeableConcept.class, Duration.class})
        @Binding(bindingName="FastingStatus", strength=BindingStrength.Value.EXTENSIBLE, description="Codes describing the fasting status of the patient.", valueSet="http://terminology.hl7.org/ValueSet/v2-0916")
        private final Element fastingStatus;

        private Collection(Builder builder) {
            super(builder);
            this.collector = builder.collector;
            this.collected = builder.collected;
            this.duration = builder.duration;
            this.quantity = builder.quantity;
            this.method = builder.method;
            this.bodySite = builder.bodySite;
            this.fastingStatus = builder.fastingStatus;
        }

        public Reference getCollector() {
            return this.collector;
        }

        public Element getCollected() {
            return this.collected;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public SimpleQuantity getQuantity() {
            return this.quantity;
        }

        public CodeableConcept getMethod() {
            return this.method;
        }

        public CodeableConcept getBodySite() {
            return this.bodySite;
        }

        public Element getFastingStatus() {
            return this.fastingStatus;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.collector != null || this.collected != null || this.duration != null || this.quantity != null || this.method != null || this.bodySite != null || this.fastingStatus != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.collector, "collector", visitor);
                    this.accept(this.collected, "collected", visitor);
                    this.accept(this.duration, "duration", visitor);
                    this.accept(this.quantity, "quantity", visitor);
                    this.accept(this.method, "method", visitor);
                    this.accept(this.bodySite, "bodySite", visitor);
                    this.accept(this.fastingStatus, "fastingStatus", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Collection other = (Collection)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.collector, other.collector) && Objects.equals(this.collected, other.collected) && Objects.equals(this.duration, other.duration) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.method, other.method) && Objects.equals(this.bodySite, other.bodySite) && Objects.equals(this.fastingStatus, other.fastingStatus);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.collector, this.collected, this.duration, this.quantity, this.method, this.bodySite, this.fastingStatus);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Reference collector;
            private Element collected;
            private Duration duration;
            private SimpleQuantity quantity;
            private CodeableConcept method;
            private CodeableConcept bodySite;
            private Element fastingStatus;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(java.util.Collection<Extension> extension) {
                return (Builder)super.extension((java.util.Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(java.util.Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder collector(Reference collector) {
                this.collector = collector;
                return this;
            }

            public Builder collected(Element collected) {
                this.collected = collected;
                return this;
            }

            public Builder duration(Duration duration) {
                this.duration = duration;
                return this;
            }

            public Builder quantity(SimpleQuantity quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder method(CodeableConcept method) {
                this.method = method;
                return this;
            }

            public Builder bodySite(CodeableConcept bodySite) {
                this.bodySite = bodySite;
                return this;
            }

            public Builder fastingStatus(Element fastingStatus) {
                this.fastingStatus = fastingStatus;
                return this;
            }

            @Override
            public Collection build() {
                Collection collection = new Collection(this);
                if (this.validating) {
                    this.validate(collection);
                }
                return collection;
            }

            protected void validate(Collection collection) {
                super.validate(collection);
                ValidationSupport.choiceElement(collection.collected, "collected", DateTime.class, Period.class);
                ValidationSupport.choiceElement(collection.fastingStatus, "fastingStatus", CodeableConcept.class, Duration.class);
                ValidationSupport.checkReferenceType(collection.collector, "collector", "Practitioner", "PractitionerRole");
                ValidationSupport.requireValueOrChildren(collection);
            }

            protected Builder from(Collection collection) {
                super.from(collection);
                this.collector = collection.collector;
                this.collected = collection.collected;
                this.duration = collection.duration;
                this.quantity = collection.quantity;
                this.method = collection.method;
                this.bodySite = collection.bodySite;
                this.fastingStatus = collection.fastingStatus;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Identifier accessionIdentifier;
        private SpecimenStatus status;
        private CodeableConcept type;
        private Reference subject;
        private DateTime receivedTime;
        private List<Reference> parent = new ArrayList<Reference>();
        private List<Reference> request = new ArrayList<Reference>();
        private Collection collection;
        private List<Processing> processing = new ArrayList<Processing>();
        private List<Container> container = new ArrayList<Container>();
        private List<CodeableConcept> condition = new ArrayList<CodeableConcept>();
        private List<Annotation> note = new ArrayList<Annotation>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(java.util.Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(java.util.Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(java.util.Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(java.util.Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder accessionIdentifier(Identifier accessionIdentifier) {
            this.accessionIdentifier = accessionIdentifier;
            return this;
        }

        public Builder status(SpecimenStatus status) {
            this.status = status;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder receivedTime(DateTime receivedTime) {
            this.receivedTime = receivedTime;
            return this;
        }

        public Builder parent(Reference ... parent) {
            for (Reference value : parent) {
                this.parent.add(value);
            }
            return this;
        }

        public Builder parent(java.util.Collection<Reference> parent) {
            this.parent = new ArrayList<Reference>(parent);
            return this;
        }

        public Builder request(Reference ... request) {
            for (Reference value : request) {
                this.request.add(value);
            }
            return this;
        }

        public Builder request(java.util.Collection<Reference> request) {
            this.request = new ArrayList<Reference>(request);
            return this;
        }

        public Builder collection(Collection collection) {
            this.collection = collection;
            return this;
        }

        public Builder processing(Processing ... processing) {
            for (Processing value : processing) {
                this.processing.add(value);
            }
            return this;
        }

        public Builder processing(java.util.Collection<Processing> processing) {
            this.processing = new ArrayList<Processing>(processing);
            return this;
        }

        public Builder container(Container ... container) {
            for (Container value : container) {
                this.container.add(value);
            }
            return this;
        }

        public Builder container(java.util.Collection<Container> container) {
            this.container = new ArrayList<Container>(container);
            return this;
        }

        public Builder condition(CodeableConcept ... condition) {
            for (CodeableConcept value : condition) {
                this.condition.add(value);
            }
            return this;
        }

        public Builder condition(java.util.Collection<CodeableConcept> condition) {
            this.condition = new ArrayList<CodeableConcept>(condition);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(java.util.Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        @Override
        public Specimen build() {
            Specimen specimen = new Specimen(this);
            if (this.validating) {
                this.validate(specimen);
            }
            return specimen;
        }

        protected void validate(Specimen specimen) {
            super.validate(specimen);
            ValidationSupport.checkList(specimen.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(specimen.parent, "parent", Reference.class);
            ValidationSupport.checkList(specimen.request, "request", Reference.class);
            ValidationSupport.checkList(specimen.processing, "processing", Processing.class);
            ValidationSupport.checkList(specimen.container, "container", Container.class);
            ValidationSupport.checkList(specimen.condition, "condition", CodeableConcept.class);
            ValidationSupport.checkList(specimen.note, "note", Annotation.class);
            ValidationSupport.checkReferenceType(specimen.subject, "subject", "Patient", "Group", "Device", "Substance", "Location");
            ValidationSupport.checkReferenceType(specimen.parent, "parent", "Specimen");
            ValidationSupport.checkReferenceType(specimen.request, "request", "ServiceRequest");
        }

        protected Builder from(Specimen specimen) {
            super.from(specimen);
            this.identifier.addAll(specimen.identifier);
            this.accessionIdentifier = specimen.accessionIdentifier;
            this.status = specimen.status;
            this.type = specimen.type;
            this.subject = specimen.subject;
            this.receivedTime = specimen.receivedTime;
            this.parent.addAll(specimen.parent);
            this.request.addAll(specimen.request);
            this.collection = specimen.collection;
            this.processing.addAll(specimen.processing);
            this.container.addAll(specimen.container);
            this.condition.addAll(specimen.condition);
            this.note.addAll(specimen.note);
            return this;
        }
    }
}

