/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Duration;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Range;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.SimpleQuantity;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.SpecimenContainedPreference;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
public class SpecimenDefinition
extends DomainResource {
    @Summary
    private final Identifier identifier;
    @Summary
    @Binding(bindingName="CollectedSpecimenType", strength=BindingStrength.Value.EXAMPLE, description="The type of the specimen to be collected.", valueSet="http://terminology.hl7.org/ValueSet/v2-0487")
    private final CodeableConcept typeCollected;
    @Summary
    @Binding(bindingName="PreparePatient", strength=BindingStrength.Value.EXAMPLE, description="SCT descendants of 703763000 |Precondition value (qualifier value)|", valueSet="http://hl7.org/fhir/ValueSet/prepare-patient-prior-specimen-collection")
    private final List<CodeableConcept> patientPreparation;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String timeAspect;
    @Summary
    @Binding(bindingName="SpecimenCollection", strength=BindingStrength.Value.EXAMPLE, description="SCT actions and procedures for specimen collection", valueSet="http://hl7.org/fhir/ValueSet/specimen-collection")
    private final List<CodeableConcept> collection;
    private final List<TypeTested> typeTested;

    private SpecimenDefinition(Builder builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.typeCollected = builder.typeCollected;
        this.patientPreparation = Collections.unmodifiableList(builder.patientPreparation);
        this.timeAspect = builder.timeAspect;
        this.collection = Collections.unmodifiableList(builder.collection);
        this.typeTested = Collections.unmodifiableList(builder.typeTested);
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public CodeableConcept getTypeCollected() {
        return this.typeCollected;
    }

    public List<CodeableConcept> getPatientPreparation() {
        return this.patientPreparation;
    }

    public org.linuxforhealth.fhir.model.type.String getTimeAspect() {
        return this.timeAspect;
    }

    public List<CodeableConcept> getCollection() {
        return this.collection;
    }

    public List<TypeTested> getTypeTested() {
        return this.typeTested;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.identifier != null || this.typeCollected != null || !this.patientPreparation.isEmpty() || this.timeAspect != null || !this.collection.isEmpty() || !this.typeTested.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor);
                this.accept(this.typeCollected, "typeCollected", visitor);
                this.accept(this.patientPreparation, "patientPreparation", visitor, CodeableConcept.class);
                this.accept(this.timeAspect, "timeAspect", visitor);
                this.accept(this.collection, "collection", visitor, CodeableConcept.class);
                this.accept(this.typeTested, "typeTested", visitor, TypeTested.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpecimenDefinition other = (SpecimenDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.typeCollected, other.typeCollected) && Objects.equals(this.patientPreparation, other.patientPreparation) && Objects.equals(this.timeAspect, other.timeAspect) && Objects.equals(this.collection, other.collection) && Objects.equals(this.typeTested, other.typeTested);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.typeCollected, this.patientPreparation, this.timeAspect, this.collection, this.typeTested);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class TypeTested
    extends BackboneElement {
        private final Boolean isDerived;
        @Binding(bindingName="IntendedSpecimenType", strength=BindingStrength.Value.EXAMPLE, description="The type of specimen conditioned in a container for lab testing.", valueSet="http://terminology.hl7.org/ValueSet/v2-0487")
        private final CodeableConcept type;
        @Binding(bindingName="SpecimenContainedPreference", strength=BindingStrength.Value.REQUIRED, description="Degree of preference of a type of conditioned specimen.", valueSet="http://hl7.org/fhir/ValueSet/specimen-contained-preference|4.3.0")
        @Required
        private final SpecimenContainedPreference preference;
        private final Container container;
        private final org.linuxforhealth.fhir.model.type.String requirement;
        private final Duration retentionTime;
        @Binding(bindingName="RejectionCriterion", strength=BindingStrength.Value.EXAMPLE, description="Criterion for rejection of the specimen by laboratory.", valueSet="http://hl7.org/fhir/ValueSet/rejection-criteria")
        private final List<CodeableConcept> rejectionCriterion;
        private final List<Handling> handling;

        private TypeTested(Builder builder) {
            super(builder);
            this.isDerived = builder.isDerived;
            this.type = builder.type;
            this.preference = builder.preference;
            this.container = builder.container;
            this.requirement = builder.requirement;
            this.retentionTime = builder.retentionTime;
            this.rejectionCriterion = Collections.unmodifiableList(builder.rejectionCriterion);
            this.handling = Collections.unmodifiableList(builder.handling);
        }

        public Boolean getIsDerived() {
            return this.isDerived;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public SpecimenContainedPreference getPreference() {
            return this.preference;
        }

        public Container getContainer() {
            return this.container;
        }

        public org.linuxforhealth.fhir.model.type.String getRequirement() {
            return this.requirement;
        }

        public Duration getRetentionTime() {
            return this.retentionTime;
        }

        public List<CodeableConcept> getRejectionCriterion() {
            return this.rejectionCriterion;
        }

        public List<Handling> getHandling() {
            return this.handling;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.isDerived != null || this.type != null || this.preference != null || this.container != null || this.requirement != null || this.retentionTime != null || !this.rejectionCriterion.isEmpty() || !this.handling.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.isDerived, "isDerived", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.preference, "preference", visitor);
                    this.accept(this.container, "container", visitor);
                    this.accept(this.requirement, "requirement", visitor);
                    this.accept(this.retentionTime, "retentionTime", visitor);
                    this.accept(this.rejectionCriterion, "rejectionCriterion", visitor, CodeableConcept.class);
                    this.accept(this.handling, "handling", visitor, Handling.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeTested other = (TypeTested)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.isDerived, other.isDerived) && Objects.equals(this.type, other.type) && Objects.equals(this.preference, other.preference) && Objects.equals(this.container, other.container) && Objects.equals(this.requirement, other.requirement) && Objects.equals(this.retentionTime, other.retentionTime) && Objects.equals(this.rejectionCriterion, other.rejectionCriterion) && Objects.equals(this.handling, other.handling);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.isDerived, this.type, this.preference, this.container, this.requirement, this.retentionTime, this.rejectionCriterion, this.handling);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Handling
        extends BackboneElement {
            @Binding(bindingName="HandlingConditionSet", strength=BindingStrength.Value.EXAMPLE, description="Set of handling instructions prior testing of the specimen.", valueSet="http://hl7.org/fhir/ValueSet/handling-condition")
            private final CodeableConcept temperatureQualifier;
            private final Range temperatureRange;
            private final Duration maxDuration;
            private final org.linuxforhealth.fhir.model.type.String instruction;

            private Handling(Builder builder) {
                super(builder);
                this.temperatureQualifier = builder.temperatureQualifier;
                this.temperatureRange = builder.temperatureRange;
                this.maxDuration = builder.maxDuration;
                this.instruction = builder.instruction;
            }

            public CodeableConcept getTemperatureQualifier() {
                return this.temperatureQualifier;
            }

            public Range getTemperatureRange() {
                return this.temperatureRange;
            }

            public Duration getMaxDuration() {
                return this.maxDuration;
            }

            public org.linuxforhealth.fhir.model.type.String getInstruction() {
                return this.instruction;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.temperatureQualifier != null || this.temperatureRange != null || this.maxDuration != null || this.instruction != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.temperatureQualifier, "temperatureQualifier", visitor);
                        this.accept(this.temperatureRange, "temperatureRange", visitor);
                        this.accept(this.maxDuration, "maxDuration", visitor);
                        this.accept(this.instruction, "instruction", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Handling other = (Handling)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.temperatureQualifier, other.temperatureQualifier) && Objects.equals(this.temperatureRange, other.temperatureRange) && Objects.equals(this.maxDuration, other.maxDuration) && Objects.equals(this.instruction, other.instruction);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.temperatureQualifier, this.temperatureRange, this.maxDuration, this.instruction);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept temperatureQualifier;
                private Range temperatureRange;
                private Duration maxDuration;
                private org.linuxforhealth.fhir.model.type.String instruction;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder temperatureQualifier(CodeableConcept temperatureQualifier) {
                    this.temperatureQualifier = temperatureQualifier;
                    return this;
                }

                public Builder temperatureRange(Range temperatureRange) {
                    this.temperatureRange = temperatureRange;
                    return this;
                }

                public Builder maxDuration(Duration maxDuration) {
                    this.maxDuration = maxDuration;
                    return this;
                }

                public Builder instruction(String instruction) {
                    this.instruction = instruction == null ? null : org.linuxforhealth.fhir.model.type.String.of(instruction);
                    return this;
                }

                public Builder instruction(org.linuxforhealth.fhir.model.type.String instruction) {
                    this.instruction = instruction;
                    return this;
                }

                @Override
                public Handling build() {
                    Handling handling = new Handling(this);
                    if (this.validating) {
                        this.validate(handling);
                    }
                    return handling;
                }

                protected void validate(Handling handling) {
                    super.validate(handling);
                    ValidationSupport.requireValueOrChildren(handling);
                }

                protected Builder from(Handling handling) {
                    super.from(handling);
                    this.temperatureQualifier = handling.temperatureQualifier;
                    this.temperatureRange = handling.temperatureRange;
                    this.maxDuration = handling.maxDuration;
                    this.instruction = handling.instruction;
                    return this;
                }
            }
        }

        public static class Container
        extends BackboneElement {
            @Binding(bindingName="ContainerMaterial", strength=BindingStrength.Value.EXAMPLE, description="SCT 32039001 |Glass|, 61088005 |Plastic|, 425620007 |Metal|", valueSet="http://hl7.org/fhir/ValueSet/container-material")
            private final CodeableConcept material;
            @Binding(bindingName="ContainerType", strength=BindingStrength.Value.EXAMPLE, description="SCT descendants of 706041008 |Device for body fluid and tissue collection/transfer/processing (physical object)|", valueSet="http://hl7.org/fhir/ValueSet/specimen-container-type")
            private final CodeableConcept type;
            @Binding(bindingName="ContainerCap", strength=BindingStrength.Value.EXAMPLE, description="Color of the container cap.", valueSet="http://hl7.org/fhir/ValueSet/container-cap")
            private final CodeableConcept cap;
            private final org.linuxforhealth.fhir.model.type.String description;
            private final SimpleQuantity capacity;
            @Choice(value={SimpleQuantity.class, org.linuxforhealth.fhir.model.type.String.class})
            private final Element minimumVolume;
            private final List<Additive> additive;
            private final org.linuxforhealth.fhir.model.type.String preparation;

            private Container(Builder builder) {
                super(builder);
                this.material = builder.material;
                this.type = builder.type;
                this.cap = builder.cap;
                this.description = builder.description;
                this.capacity = builder.capacity;
                this.minimumVolume = builder.minimumVolume;
                this.additive = Collections.unmodifiableList(builder.additive);
                this.preparation = builder.preparation;
            }

            public CodeableConcept getMaterial() {
                return this.material;
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public CodeableConcept getCap() {
                return this.cap;
            }

            public org.linuxforhealth.fhir.model.type.String getDescription() {
                return this.description;
            }

            public SimpleQuantity getCapacity() {
                return this.capacity;
            }

            public Element getMinimumVolume() {
                return this.minimumVolume;
            }

            public List<Additive> getAdditive() {
                return this.additive;
            }

            public org.linuxforhealth.fhir.model.type.String getPreparation() {
                return this.preparation;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.material != null || this.type != null || this.cap != null || this.description != null || this.capacity != null || this.minimumVolume != null || !this.additive.isEmpty() || this.preparation != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.material, "material", visitor);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.cap, "cap", visitor);
                        this.accept(this.description, "description", visitor);
                        this.accept(this.capacity, "capacity", visitor);
                        this.accept(this.minimumVolume, "minimumVolume", visitor);
                        this.accept(this.additive, "additive", visitor, Additive.class);
                        this.accept(this.preparation, "preparation", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Container other = (Container)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.material, other.material) && Objects.equals(this.type, other.type) && Objects.equals(this.cap, other.cap) && Objects.equals(this.description, other.description) && Objects.equals(this.capacity, other.capacity) && Objects.equals(this.minimumVolume, other.minimumVolume) && Objects.equals(this.additive, other.additive) && Objects.equals(this.preparation, other.preparation);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.material, this.type, this.cap, this.description, this.capacity, this.minimumVolume, this.additive, this.preparation);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Additive
            extends BackboneElement {
                @ReferenceTarget(value={"Substance"})
                @Choice(value={CodeableConcept.class, Reference.class})
                @Binding(bindingName="ContainerAdditive", strength=BindingStrength.Value.EXAMPLE, description="Substance added to specimen container.", valueSet="http://terminology.hl7.org/ValueSet/v2-0371")
                @Required
                private final Element additive;

                private Additive(Builder builder) {
                    super(builder);
                    this.additive = builder.additive;
                }

                public Element getAdditive() {
                    return this.additive;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.additive != null;
                }

                @Override
                public void accept(String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.additive, "additive", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Additive other = (Additive)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.additive, other.additive);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.additive);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private Element additive;

                    private Builder() {
                    }

                    @Override
                    public Builder id(String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder additive(Element additive) {
                        this.additive = additive;
                        return this;
                    }

                    @Override
                    public Additive build() {
                        Additive additive = new Additive(this);
                        if (this.validating) {
                            this.validate(additive);
                        }
                        return additive;
                    }

                    protected void validate(Additive additive) {
                        super.validate(additive);
                        ValidationSupport.requireChoiceElement(additive.additive, "additive", CodeableConcept.class, Reference.class);
                        ValidationSupport.checkReferenceType(additive.additive, "additive", "Substance");
                        ValidationSupport.requireValueOrChildren(additive);
                    }

                    protected Builder from(Additive additive) {
                        super.from(additive);
                        this.additive = additive.additive;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept material;
                private CodeableConcept type;
                private CodeableConcept cap;
                private org.linuxforhealth.fhir.model.type.String description;
                private SimpleQuantity capacity;
                private Element minimumVolume;
                private List<Additive> additive = new ArrayList<Additive>();
                private org.linuxforhealth.fhir.model.type.String preparation;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder material(CodeableConcept material) {
                    this.material = material;
                    return this;
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder cap(CodeableConcept cap) {
                    this.cap = cap;
                    return this;
                }

                public Builder description(String description) {
                    this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                    return this;
                }

                public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                    this.description = description;
                    return this;
                }

                public Builder capacity(SimpleQuantity capacity) {
                    this.capacity = capacity;
                    return this;
                }

                public Builder minimumVolume(String minimumVolume) {
                    this.minimumVolume = minimumVolume == null ? null : org.linuxforhealth.fhir.model.type.String.of(minimumVolume);
                    return this;
                }

                public Builder minimumVolume(Element minimumVolume) {
                    this.minimumVolume = minimumVolume;
                    return this;
                }

                public Builder additive(Additive ... additive) {
                    for (Additive value : additive) {
                        this.additive.add(value);
                    }
                    return this;
                }

                public Builder additive(Collection<Additive> additive) {
                    this.additive = new ArrayList<Additive>(additive);
                    return this;
                }

                public Builder preparation(String preparation) {
                    this.preparation = preparation == null ? null : org.linuxforhealth.fhir.model.type.String.of(preparation);
                    return this;
                }

                public Builder preparation(org.linuxforhealth.fhir.model.type.String preparation) {
                    this.preparation = preparation;
                    return this;
                }

                @Override
                public Container build() {
                    Container container = new Container(this);
                    if (this.validating) {
                        this.validate(container);
                    }
                    return container;
                }

                protected void validate(Container container) {
                    super.validate(container);
                    ValidationSupport.choiceElement(container.minimumVolume, "minimumVolume", SimpleQuantity.class, org.linuxforhealth.fhir.model.type.String.class);
                    ValidationSupport.checkList(container.additive, "additive", Additive.class);
                    ValidationSupport.requireValueOrChildren(container);
                }

                protected Builder from(Container container) {
                    super.from(container);
                    this.material = container.material;
                    this.type = container.type;
                    this.cap = container.cap;
                    this.description = container.description;
                    this.capacity = container.capacity;
                    this.minimumVolume = container.minimumVolume;
                    this.additive.addAll(container.additive);
                    this.preparation = container.preparation;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Boolean isDerived;
            private CodeableConcept type;
            private SpecimenContainedPreference preference;
            private Container container;
            private org.linuxforhealth.fhir.model.type.String requirement;
            private Duration retentionTime;
            private List<CodeableConcept> rejectionCriterion = new ArrayList<CodeableConcept>();
            private List<Handling> handling = new ArrayList<Handling>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder isDerived(java.lang.Boolean isDerived) {
                this.isDerived = isDerived == null ? null : Boolean.of(isDerived);
                return this;
            }

            public Builder isDerived(Boolean isDerived) {
                this.isDerived = isDerived;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder preference(SpecimenContainedPreference preference) {
                this.preference = preference;
                return this;
            }

            public Builder container(Container container) {
                this.container = container;
                return this;
            }

            public Builder requirement(String requirement) {
                this.requirement = requirement == null ? null : org.linuxforhealth.fhir.model.type.String.of(requirement);
                return this;
            }

            public Builder requirement(org.linuxforhealth.fhir.model.type.String requirement) {
                this.requirement = requirement;
                return this;
            }

            public Builder retentionTime(Duration retentionTime) {
                this.retentionTime = retentionTime;
                return this;
            }

            public Builder rejectionCriterion(CodeableConcept ... rejectionCriterion) {
                for (CodeableConcept value : rejectionCriterion) {
                    this.rejectionCriterion.add(value);
                }
                return this;
            }

            public Builder rejectionCriterion(Collection<CodeableConcept> rejectionCriterion) {
                this.rejectionCriterion = new ArrayList<CodeableConcept>(rejectionCriterion);
                return this;
            }

            public Builder handling(Handling ... handling) {
                for (Handling value : handling) {
                    this.handling.add(value);
                }
                return this;
            }

            public Builder handling(Collection<Handling> handling) {
                this.handling = new ArrayList<Handling>(handling);
                return this;
            }

            @Override
            public TypeTested build() {
                TypeTested typeTested = new TypeTested(this);
                if (this.validating) {
                    this.validate(typeTested);
                }
                return typeTested;
            }

            protected void validate(TypeTested typeTested) {
                super.validate(typeTested);
                ValidationSupport.requireNonNull(typeTested.preference, "preference");
                ValidationSupport.checkList(typeTested.rejectionCriterion, "rejectionCriterion", CodeableConcept.class);
                ValidationSupport.checkList(typeTested.handling, "handling", Handling.class);
                ValidationSupport.requireValueOrChildren(typeTested);
            }

            protected Builder from(TypeTested typeTested) {
                super.from(typeTested);
                this.isDerived = typeTested.isDerived;
                this.type = typeTested.type;
                this.preference = typeTested.preference;
                this.container = typeTested.container;
                this.requirement = typeTested.requirement;
                this.retentionTime = typeTested.retentionTime;
                this.rejectionCriterion.addAll(typeTested.rejectionCriterion);
                this.handling.addAll(typeTested.handling);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Identifier identifier;
        private CodeableConcept typeCollected;
        private List<CodeableConcept> patientPreparation = new ArrayList<CodeableConcept>();
        private org.linuxforhealth.fhir.model.type.String timeAspect;
        private List<CodeableConcept> collection = new ArrayList<CodeableConcept>();
        private List<TypeTested> typeTested = new ArrayList<TypeTested>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder typeCollected(CodeableConcept typeCollected) {
            this.typeCollected = typeCollected;
            return this;
        }

        public Builder patientPreparation(CodeableConcept ... patientPreparation) {
            for (CodeableConcept value : patientPreparation) {
                this.patientPreparation.add(value);
            }
            return this;
        }

        public Builder patientPreparation(Collection<CodeableConcept> patientPreparation) {
            this.patientPreparation = new ArrayList<CodeableConcept>(patientPreparation);
            return this;
        }

        public Builder timeAspect(String timeAspect) {
            this.timeAspect = timeAspect == null ? null : org.linuxforhealth.fhir.model.type.String.of(timeAspect);
            return this;
        }

        public Builder timeAspect(org.linuxforhealth.fhir.model.type.String timeAspect) {
            this.timeAspect = timeAspect;
            return this;
        }

        public Builder collection(CodeableConcept ... collection) {
            for (CodeableConcept value : collection) {
                this.collection.add(value);
            }
            return this;
        }

        public Builder collection(Collection<CodeableConcept> collection) {
            this.collection = new ArrayList<CodeableConcept>(collection);
            return this;
        }

        public Builder typeTested(TypeTested ... typeTested) {
            for (TypeTested value : typeTested) {
                this.typeTested.add(value);
            }
            return this;
        }

        public Builder typeTested(Collection<TypeTested> typeTested) {
            this.typeTested = new ArrayList<TypeTested>(typeTested);
            return this;
        }

        @Override
        public SpecimenDefinition build() {
            SpecimenDefinition specimenDefinition = new SpecimenDefinition(this);
            if (this.validating) {
                this.validate(specimenDefinition);
            }
            return specimenDefinition;
        }

        protected void validate(SpecimenDefinition specimenDefinition) {
            super.validate(specimenDefinition);
            ValidationSupport.checkList(specimenDefinition.patientPreparation, "patientPreparation", CodeableConcept.class);
            ValidationSupport.checkList(specimenDefinition.collection, "collection", CodeableConcept.class);
            ValidationSupport.checkList(specimenDefinition.typeTested, "typeTested", TypeTested.class);
        }

        protected Builder from(SpecimenDefinition specimenDefinition) {
            super.from(specimenDefinition);
            this.identifier = specimenDefinition.identifier;
            this.typeCollected = specimenDefinition.typeCollected;
            this.patientPreparation.addAll(specimenDefinition.patientPreparation);
            this.timeAspect = specimenDefinition.timeAspect;
            this.collection.addAll(specimenDefinition.collection);
            this.typeTested.addAll(specimenDefinition.typeTested);
            return this;
        }
    }
}

