/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.ContactPoint;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Instant;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.Url;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.type.code.SubscriptionChannelType;
import org.linuxforhealth.fhir.model.type.code.SubscriptionStatusCode;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
public class Subscription
extends DomainResource {
    @Summary
    @Binding(bindingName="SubscriptionStatus", strength=BindingStrength.Value.REQUIRED, description="The status of a subscription.", valueSet="http://hl7.org/fhir/ValueSet/subscription-status|4.3.0")
    @Required
    private final SubscriptionStatusCode status;
    @Summary
    private final List<ContactPoint> contact;
    @Summary
    private final Instant end;
    @Summary
    @Required
    private final String reason;
    @Summary
    @Required
    private final String criteria;
    @Summary
    private final String error;
    @Summary
    @Required
    private final Channel channel;

    private Subscription(Builder builder) {
        super(builder);
        this.status = builder.status;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.end = builder.end;
        this.reason = builder.reason;
        this.criteria = builder.criteria;
        this.error = builder.error;
        this.channel = builder.channel;
    }

    public SubscriptionStatusCode getStatus() {
        return this.status;
    }

    public List<ContactPoint> getContact() {
        return this.contact;
    }

    public Instant getEnd() {
        return this.end;
    }

    public String getReason() {
        return this.reason;
    }

    public String getCriteria() {
        return this.criteria;
    }

    public String getError() {
        return this.error;
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.status != null || !this.contact.isEmpty() || this.end != null || this.reason != null || this.criteria != null || this.error != null || this.channel != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.contact, "contact", visitor, ContactPoint.class);
                this.accept(this.end, "end", visitor);
                this.accept(this.reason, "reason", visitor);
                this.accept(this.criteria, "criteria", visitor);
                this.accept(this.error, "error", visitor);
                this.accept(this.channel, "channel", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Subscription other = (Subscription)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.status, other.status) && Objects.equals(this.contact, other.contact) && Objects.equals(this.end, other.end) && Objects.equals(this.reason, other.reason) && Objects.equals(this.criteria, other.criteria) && Objects.equals(this.error, other.error) && Objects.equals(this.channel, other.channel);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.status, this.contact, this.end, this.reason, this.criteria, this.error, this.channel);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Channel
    extends BackboneElement {
        @Summary
        @Binding(bindingName="SubscriptionChannelType", strength=BindingStrength.Value.REQUIRED, description="The type of method used to execute a subscription.", valueSet="http://hl7.org/fhir/ValueSet/subscription-channel-type|4.3.0")
        @Required
        private final SubscriptionChannelType type;
        @Summary
        private final Url endpoint;
        @Summary
        @Binding(bindingName="MimeType", strength=BindingStrength.Value.REQUIRED, description="BCP 13 (RFCs 2045, 2046, 2047, 4288, 4289 and 2049)", valueSet="http://hl7.org/fhir/ValueSet/mimetypes|4.3.0")
        private final Code payload;
        @Summary
        private final List<String> header;

        private Channel(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.endpoint = builder.endpoint;
            this.payload = builder.payload;
            this.header = Collections.unmodifiableList(builder.header);
        }

        public SubscriptionChannelType getType() {
            return this.type;
        }

        public Url getEndpoint() {
            return this.endpoint;
        }

        public Code getPayload() {
            return this.payload;
        }

        public List<String> getHeader() {
            return this.header;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.endpoint != null || this.payload != null || !this.header.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.endpoint, "endpoint", visitor);
                    this.accept(this.payload, "payload", visitor);
                    this.accept(this.header, "header", visitor, String.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Channel other = (Channel)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.endpoint, other.endpoint) && Objects.equals(this.payload, other.payload) && Objects.equals(this.header, other.header);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.endpoint, this.payload, this.header);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private SubscriptionChannelType type;
            private Url endpoint;
            private Code payload;
            private List<String> header = new ArrayList<String>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(SubscriptionChannelType type) {
                this.type = type;
                return this;
            }

            public Builder endpoint(Url endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public Builder payload(Code payload) {
                this.payload = payload;
                return this;
            }

            public Builder header(java.lang.String ... header) {
                for (java.lang.String value : header) {
                    this.header.add(value == null ? null : String.of(value));
                }
                return this;
            }

            public Builder header(String ... header) {
                for (String value : header) {
                    this.header.add(value);
                }
                return this;
            }

            public Builder header(Collection<String> header) {
                this.header = new ArrayList<String>(header);
                return this;
            }

            @Override
            public Channel build() {
                Channel channel = new Channel(this);
                if (this.validating) {
                    this.validate(channel);
                }
                return channel;
            }

            protected void validate(Channel channel) {
                super.validate(channel);
                ValidationSupport.requireNonNull(channel.type, "type");
                ValidationSupport.checkList(channel.header, "header", String.class);
                ValidationSupport.requireValueOrChildren(channel);
            }

            protected Builder from(Channel channel) {
                super.from(channel);
                this.type = channel.type;
                this.endpoint = channel.endpoint;
                this.payload = channel.payload;
                this.header.addAll(channel.header);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private SubscriptionStatusCode status;
        private List<ContactPoint> contact = new ArrayList<ContactPoint>();
        private Instant end;
        private String reason;
        private String criteria;
        private String error;
        private Channel channel;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder status(SubscriptionStatusCode status) {
            this.status = status;
            return this;
        }

        public Builder contact(ContactPoint ... contact) {
            for (ContactPoint value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactPoint> contact) {
            this.contact = new ArrayList<ContactPoint>(contact);
            return this;
        }

        public Builder end(ZonedDateTime end) {
            this.end = end == null ? null : Instant.of(end);
            return this;
        }

        public Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public Builder reason(java.lang.String reason) {
            this.reason = reason == null ? null : String.of(reason);
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder criteria(java.lang.String criteria) {
            this.criteria = criteria == null ? null : String.of(criteria);
            return this;
        }

        public Builder criteria(String criteria) {
            this.criteria = criteria;
            return this;
        }

        public Builder error(java.lang.String error) {
            this.error = error == null ? null : String.of(error);
            return this;
        }

        public Builder error(String error) {
            this.error = error;
            return this;
        }

        public Builder channel(Channel channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public Subscription build() {
            Subscription subscription = new Subscription(this);
            if (this.validating) {
                this.validate(subscription);
            }
            return subscription;
        }

        protected void validate(Subscription subscription) {
            super.validate(subscription);
            ValidationSupport.requireNonNull(subscription.status, "status");
            ValidationSupport.checkList(subscription.contact, "contact", ContactPoint.class);
            ValidationSupport.requireNonNull(subscription.reason, "reason");
            ValidationSupport.requireNonNull(subscription.criteria, "criteria");
            ValidationSupport.requireNonNull(subscription.channel, "channel");
        }

        protected Builder from(Subscription subscription) {
            super.from(subscription);
            this.status = subscription.status;
            this.contact.addAll(subscription.contact);
            this.end = subscription.end;
            this.reason = subscription.reason;
            this.criteria = subscription.criteria;
            this.error = subscription.error;
            this.channel = subscription.channel;
            return this;
        }
    }
}

