/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Canonical;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Instant;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.type.code.SubscriptionNotificationType;
import org.linuxforhealth.fhir.model.type.code.SubscriptionStatusCode;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=0, status=StandardsStatus.Value.DRAFT)
@Constraint(id="sst-1", level="Rule", location="(base)", description="events listed in event notifications", expression="type = 'event-notification' implies (notificationEvent.exists() and notificationEvent.first().exists())", source="http://hl7.org/fhir/StructureDefinition/SubscriptionStatus")
public class SubscriptionStatus
extends DomainResource {
    @Summary
    @Binding(bindingName="SubscriptionStatus", strength=BindingStrength.Value.REQUIRED, description="The status of a subscription at the time this notification was generated.", valueSet="http://hl7.org/fhir/ValueSet/subscription-status|4.3.0")
    private final SubscriptionStatusCode status;
    @Summary
    @Binding(bindingName="SubscriptionNotificationType", strength=BindingStrength.Value.REQUIRED, description="The type of notification represented by the status message.", valueSet="http://hl7.org/fhir/ValueSet/subscription-notification-type|4.3.0")
    @Required
    private final SubscriptionNotificationType type;
    @Summary
    private final String eventsSinceSubscriptionStart;
    private final List<NotificationEvent> notificationEvent;
    @Summary
    @ReferenceTarget(value={"Subscription"})
    @Required
    private final Reference subscription;
    @Summary
    private final Canonical topic;
    @Summary
    @Binding(bindingName="SubscriptionError", strength=BindingStrength.Value.EXAMPLE, description="Codes to represent subscription error details.", valueSet="http://hl7.org/fhir/ValueSet/subscription-error")
    private final List<CodeableConcept> error;

    private SubscriptionStatus(Builder builder) {
        super(builder);
        this.status = builder.status;
        this.type = builder.type;
        this.eventsSinceSubscriptionStart = builder.eventsSinceSubscriptionStart;
        this.notificationEvent = Collections.unmodifiableList(builder.notificationEvent);
        this.subscription = builder.subscription;
        this.topic = builder.topic;
        this.error = Collections.unmodifiableList(builder.error);
    }

    public SubscriptionStatusCode getStatus() {
        return this.status;
    }

    public SubscriptionNotificationType getType() {
        return this.type;
    }

    public String getEventsSinceSubscriptionStart() {
        return this.eventsSinceSubscriptionStart;
    }

    public List<NotificationEvent> getNotificationEvent() {
        return this.notificationEvent;
    }

    public Reference getSubscription() {
        return this.subscription;
    }

    public Canonical getTopic() {
        return this.topic;
    }

    public List<CodeableConcept> getError() {
        return this.error;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.status != null || this.type != null || this.eventsSinceSubscriptionStart != null || !this.notificationEvent.isEmpty() || this.subscription != null || this.topic != null || !this.error.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.eventsSinceSubscriptionStart, "eventsSinceSubscriptionStart", visitor);
                this.accept(this.notificationEvent, "notificationEvent", visitor, NotificationEvent.class);
                this.accept(this.subscription, "subscription", visitor);
                this.accept(this.topic, "topic", visitor);
                this.accept(this.error, "error", visitor, CodeableConcept.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriptionStatus other = (SubscriptionStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.status, other.status) && Objects.equals(this.type, other.type) && Objects.equals(this.eventsSinceSubscriptionStart, other.eventsSinceSubscriptionStart) && Objects.equals(this.notificationEvent, other.notificationEvent) && Objects.equals(this.subscription, other.subscription) && Objects.equals(this.topic, other.topic) && Objects.equals(this.error, other.error);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.status, this.type, this.eventsSinceSubscriptionStart, this.notificationEvent, this.subscription, this.topic, this.error);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class NotificationEvent
    extends BackboneElement {
        @Required
        private final String eventNumber;
        private final Instant timestamp;
        private final Reference focus;
        private final List<Reference> additionalContext;

        private NotificationEvent(Builder builder) {
            super(builder);
            this.eventNumber = builder.eventNumber;
            this.timestamp = builder.timestamp;
            this.focus = builder.focus;
            this.additionalContext = Collections.unmodifiableList(builder.additionalContext);
        }

        public String getEventNumber() {
            return this.eventNumber;
        }

        public Instant getTimestamp() {
            return this.timestamp;
        }

        public Reference getFocus() {
            return this.focus;
        }

        public List<Reference> getAdditionalContext() {
            return this.additionalContext;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.eventNumber != null || this.timestamp != null || this.focus != null || !this.additionalContext.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.eventNumber, "eventNumber", visitor);
                    this.accept(this.timestamp, "timestamp", visitor);
                    this.accept(this.focus, "focus", visitor);
                    this.accept(this.additionalContext, "additionalContext", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NotificationEvent other = (NotificationEvent)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.eventNumber, other.eventNumber) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.focus, other.focus) && Objects.equals(this.additionalContext, other.additionalContext);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.eventNumber, this.timestamp, this.focus, this.additionalContext);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String eventNumber;
            private Instant timestamp;
            private Reference focus;
            private List<Reference> additionalContext = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder eventNumber(java.lang.String eventNumber) {
                this.eventNumber = eventNumber == null ? null : String.of(eventNumber);
                return this;
            }

            public Builder eventNumber(String eventNumber) {
                this.eventNumber = eventNumber;
                return this;
            }

            public Builder timestamp(ZonedDateTime timestamp) {
                this.timestamp = timestamp == null ? null : Instant.of(timestamp);
                return this;
            }

            public Builder timestamp(Instant timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public Builder focus(Reference focus) {
                this.focus = focus;
                return this;
            }

            public Builder additionalContext(Reference ... additionalContext) {
                for (Reference value : additionalContext) {
                    this.additionalContext.add(value);
                }
                return this;
            }

            public Builder additionalContext(Collection<Reference> additionalContext) {
                this.additionalContext = new ArrayList<Reference>(additionalContext);
                return this;
            }

            @Override
            public NotificationEvent build() {
                NotificationEvent notificationEvent = new NotificationEvent(this);
                if (this.validating) {
                    this.validate(notificationEvent);
                }
                return notificationEvent;
            }

            protected void validate(NotificationEvent notificationEvent) {
                super.validate(notificationEvent);
                ValidationSupport.requireNonNull(notificationEvent.eventNumber, "eventNumber");
                ValidationSupport.checkList(notificationEvent.additionalContext, "additionalContext", Reference.class);
                ValidationSupport.requireValueOrChildren(notificationEvent);
            }

            protected Builder from(NotificationEvent notificationEvent) {
                super.from(notificationEvent);
                this.eventNumber = notificationEvent.eventNumber;
                this.timestamp = notificationEvent.timestamp;
                this.focus = notificationEvent.focus;
                this.additionalContext.addAll(notificationEvent.additionalContext);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private SubscriptionStatusCode status;
        private SubscriptionNotificationType type;
        private String eventsSinceSubscriptionStart;
        private List<NotificationEvent> notificationEvent = new ArrayList<NotificationEvent>();
        private Reference subscription;
        private Canonical topic;
        private List<CodeableConcept> error = new ArrayList<CodeableConcept>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder status(SubscriptionStatusCode status) {
            this.status = status;
            return this;
        }

        public Builder type(SubscriptionNotificationType type) {
            this.type = type;
            return this;
        }

        public Builder eventsSinceSubscriptionStart(java.lang.String eventsSinceSubscriptionStart) {
            this.eventsSinceSubscriptionStart = eventsSinceSubscriptionStart == null ? null : String.of(eventsSinceSubscriptionStart);
            return this;
        }

        public Builder eventsSinceSubscriptionStart(String eventsSinceSubscriptionStart) {
            this.eventsSinceSubscriptionStart = eventsSinceSubscriptionStart;
            return this;
        }

        public Builder notificationEvent(NotificationEvent ... notificationEvent) {
            for (NotificationEvent value : notificationEvent) {
                this.notificationEvent.add(value);
            }
            return this;
        }

        public Builder notificationEvent(Collection<NotificationEvent> notificationEvent) {
            this.notificationEvent = new ArrayList<NotificationEvent>(notificationEvent);
            return this;
        }

        public Builder subscription(Reference subscription) {
            this.subscription = subscription;
            return this;
        }

        public Builder topic(Canonical topic) {
            this.topic = topic;
            return this;
        }

        public Builder error(CodeableConcept ... error) {
            for (CodeableConcept value : error) {
                this.error.add(value);
            }
            return this;
        }

        public Builder error(Collection<CodeableConcept> error) {
            this.error = new ArrayList<CodeableConcept>(error);
            return this;
        }

        @Override
        public SubscriptionStatus build() {
            SubscriptionStatus subscriptionStatus = new SubscriptionStatus(this);
            if (this.validating) {
                this.validate(subscriptionStatus);
            }
            return subscriptionStatus;
        }

        protected void validate(SubscriptionStatus subscriptionStatus) {
            super.validate(subscriptionStatus);
            ValidationSupport.requireNonNull(subscriptionStatus.type, "type");
            ValidationSupport.checkList(subscriptionStatus.notificationEvent, "notificationEvent", NotificationEvent.class);
            ValidationSupport.requireNonNull(subscriptionStatus.subscription, "subscription");
            ValidationSupport.checkList(subscriptionStatus.error, "error", CodeableConcept.class);
            ValidationSupport.checkReferenceType(subscriptionStatus.subscription, "subscription", "Subscription");
        }

        protected Builder from(SubscriptionStatus subscriptionStatus) {
            super.from(subscriptionStatus);
            this.status = subscriptionStatus.status;
            this.type = subscriptionStatus.type;
            this.eventsSinceSubscriptionStart = subscriptionStatus.eventsSinceSubscriptionStart;
            this.notificationEvent.addAll(subscriptionStatus.notificationEvent);
            this.subscription = subscriptionStatus.subscription;
            this.topic = subscriptionStatus.topic;
            this.error.addAll(subscriptionStatus.error);
            return this;
        }
    }
}

