/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Canonical;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.ContactDetail;
import org.linuxforhealth.fhir.model.type.Date;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.UsageContext;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.CriteriaNotExistsBehavior;
import org.linuxforhealth.fhir.model.type.code.MethodCode;
import org.linuxforhealth.fhir.model.type.code.PublicationStatus;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.type.code.SubscriptionTopicFilterBySearchModifier;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=0, status=StandardsStatus.Value.DRAFT)
@Constraints(value={@Constraint(id="subscriptionTopic-0", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/SubscriptionTopic", generated=true), @Constraint(id="subscriptionTopic-1", level="Warning", location="resourceTrigger.resource", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/defined-types", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/defined-types', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/SubscriptionTopic", generated=true), @Constraint(id="subscriptionTopic-2", level="Warning", location="eventTrigger.resource", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/defined-types", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/defined-types', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/SubscriptionTopic", generated=true), @Constraint(id="subscriptionTopic-3", level="Warning", location="canFilterBy.resource", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/defined-types", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/defined-types', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/SubscriptionTopic", generated=true), @Constraint(id="subscriptionTopic-4", level="Warning", location="notificationShape.resource", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/defined-types", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/defined-types', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/SubscriptionTopic", generated=true)})
public class SubscriptionTopic
extends DomainResource {
    @Summary
    @Required
    private final Uri url;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String version;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String title;
    @Summary
    private final List<Canonical> derivedFrom;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.3.0")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @Summary
    private final DateTime date;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String publisher;
    @Summary
    private final List<ContactDetail> contact;
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    private final Markdown copyright;
    private final Date approvalDate;
    private final Date lastReviewDate;
    @Summary
    private final Period effectivePeriod;
    @Summary
    private final List<ResourceTrigger> resourceTrigger;
    @Summary
    private final List<EventTrigger> eventTrigger;
    @Summary
    private final List<CanFilterBy> canFilterBy;
    @Summary
    private final List<NotificationShape> notificationShape;

    private SubscriptionTopic(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.version = builder.version;
        this.title = builder.title;
        this.derivedFrom = Collections.unmodifiableList(builder.derivedFrom);
        this.status = builder.status;
        this.experimental = builder.experimental;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.purpose = builder.purpose;
        this.copyright = builder.copyright;
        this.approvalDate = builder.approvalDate;
        this.lastReviewDate = builder.lastReviewDate;
        this.effectivePeriod = builder.effectivePeriod;
        this.resourceTrigger = Collections.unmodifiableList(builder.resourceTrigger);
        this.eventTrigger = Collections.unmodifiableList(builder.eventTrigger);
        this.canFilterBy = Collections.unmodifiableList(builder.canFilterBy);
        this.notificationShape = Collections.unmodifiableList(builder.notificationShape);
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public org.linuxforhealth.fhir.model.type.String getVersion() {
        return this.version;
    }

    public org.linuxforhealth.fhir.model.type.String getTitle() {
        return this.title;
    }

    public List<Canonical> getDerivedFrom() {
        return this.derivedFrom;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public DateTime getDate() {
        return this.date;
    }

    public org.linuxforhealth.fhir.model.type.String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate;
    }

    public Period getEffectivePeriod() {
        return this.effectivePeriod;
    }

    public List<ResourceTrigger> getResourceTrigger() {
        return this.resourceTrigger;
    }

    public List<EventTrigger> getEventTrigger() {
        return this.eventTrigger;
    }

    public List<CanFilterBy> getCanFilterBy() {
        return this.canFilterBy;
    }

    public List<NotificationShape> getNotificationShape() {
        return this.notificationShape;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.title != null || !this.derivedFrom.isEmpty() || this.status != null || this.experimental != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.copyright != null || this.approvalDate != null || this.lastReviewDate != null || this.effectivePeriod != null || !this.resourceTrigger.isEmpty() || !this.eventTrigger.isEmpty() || !this.canFilterBy.isEmpty() || !this.notificationShape.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.derivedFrom, "derivedFrom", visitor, Canonical.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.approvalDate, "approvalDate", visitor);
                this.accept(this.lastReviewDate, "lastReviewDate", visitor);
                this.accept(this.effectivePeriod, "effectivePeriod", visitor);
                this.accept(this.resourceTrigger, "resourceTrigger", visitor, ResourceTrigger.class);
                this.accept(this.eventTrigger, "eventTrigger", visitor, EventTrigger.class);
                this.accept(this.canFilterBy, "canFilterBy", visitor, CanFilterBy.class);
                this.accept(this.notificationShape, "notificationShape", visitor, NotificationShape.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriptionTopic other = (SubscriptionTopic)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.title, other.title) && Objects.equals(this.derivedFrom, other.derivedFrom) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.approvalDate, other.approvalDate) && Objects.equals(this.lastReviewDate, other.lastReviewDate) && Objects.equals(this.effectivePeriod, other.effectivePeriod) && Objects.equals(this.resourceTrigger, other.resourceTrigger) && Objects.equals(this.eventTrigger, other.eventTrigger) && Objects.equals(this.canFilterBy, other.canFilterBy) && Objects.equals(this.notificationShape, other.notificationShape);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.title, this.derivedFrom, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.resourceTrigger, this.eventTrigger, this.canFilterBy, this.notificationShape);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class NotificationShape
    extends BackboneElement {
        @Summary
        @Binding(bindingName="FHIRDefinedTypeExt", strength=BindingStrength.Value.EXTENSIBLE, description="Either a resource or a data type, including logical model types.", valueSet="http://hl7.org/fhir/ValueSet/defined-types")
        @Required
        private final Uri resource;
        @Summary
        private final List<org.linuxforhealth.fhir.model.type.String> include;
        @Summary
        private final List<org.linuxforhealth.fhir.model.type.String> revInclude;

        private NotificationShape(Builder builder) {
            super(builder);
            this.resource = builder.resource;
            this.include = Collections.unmodifiableList(builder.include);
            this.revInclude = Collections.unmodifiableList(builder.revInclude);
        }

        public Uri getResource() {
            return this.resource;
        }

        public List<org.linuxforhealth.fhir.model.type.String> getInclude() {
            return this.include;
        }

        public List<org.linuxforhealth.fhir.model.type.String> getRevInclude() {
            return this.revInclude;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.resource != null || !this.include.isEmpty() || !this.revInclude.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.resource, "resource", visitor);
                    this.accept(this.include, "include", visitor, org.linuxforhealth.fhir.model.type.String.class);
                    this.accept(this.revInclude, "revInclude", visitor, org.linuxforhealth.fhir.model.type.String.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NotificationShape other = (NotificationShape)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.resource, other.resource) && Objects.equals(this.include, other.include) && Objects.equals(this.revInclude, other.revInclude);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.resource, this.include, this.revInclude);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Uri resource;
            private List<org.linuxforhealth.fhir.model.type.String> include = new ArrayList<org.linuxforhealth.fhir.model.type.String>();
            private List<org.linuxforhealth.fhir.model.type.String> revInclude = new ArrayList<org.linuxforhealth.fhir.model.type.String>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder resource(Uri resource) {
                this.resource = resource;
                return this;
            }

            public Builder include(String ... include) {
                for (String value : include) {
                    this.include.add(value == null ? null : org.linuxforhealth.fhir.model.type.String.of(value));
                }
                return this;
            }

            public Builder include(org.linuxforhealth.fhir.model.type.String ... include) {
                for (org.linuxforhealth.fhir.model.type.String value : include) {
                    this.include.add(value);
                }
                return this;
            }

            public Builder include(Collection<org.linuxforhealth.fhir.model.type.String> include) {
                this.include = new ArrayList<org.linuxforhealth.fhir.model.type.String>(include);
                return this;
            }

            public Builder revInclude(String ... revInclude) {
                for (String value : revInclude) {
                    this.revInclude.add(value == null ? null : org.linuxforhealth.fhir.model.type.String.of(value));
                }
                return this;
            }

            public Builder revInclude(org.linuxforhealth.fhir.model.type.String ... revInclude) {
                for (org.linuxforhealth.fhir.model.type.String value : revInclude) {
                    this.revInclude.add(value);
                }
                return this;
            }

            public Builder revInclude(Collection<org.linuxforhealth.fhir.model.type.String> revInclude) {
                this.revInclude = new ArrayList<org.linuxforhealth.fhir.model.type.String>(revInclude);
                return this;
            }

            @Override
            public NotificationShape build() {
                NotificationShape notificationShape = new NotificationShape(this);
                if (this.validating) {
                    this.validate(notificationShape);
                }
                return notificationShape;
            }

            protected void validate(NotificationShape notificationShape) {
                super.validate(notificationShape);
                ValidationSupport.requireNonNull(notificationShape.resource, "resource");
                ValidationSupport.checkList(notificationShape.include, "include", org.linuxforhealth.fhir.model.type.String.class);
                ValidationSupport.checkList(notificationShape.revInclude, "revInclude", org.linuxforhealth.fhir.model.type.String.class);
                ValidationSupport.requireValueOrChildren(notificationShape);
            }

            protected Builder from(NotificationShape notificationShape) {
                super.from(notificationShape);
                this.resource = notificationShape.resource;
                this.include.addAll(notificationShape.include);
                this.revInclude.addAll(notificationShape.revInclude);
                return this;
            }
        }
    }

    public static class CanFilterBy
    extends BackboneElement {
        @Summary
        private final Markdown description;
        @Summary
        @Binding(bindingName="FHIRDefinedTypeExt", strength=BindingStrength.Value.EXTENSIBLE, description="Either a resource or a data type, including logical model types.", valueSet="http://hl7.org/fhir/ValueSet/defined-types")
        private final Uri resource;
        @Summary
        @Required
        private final org.linuxforhealth.fhir.model.type.String filterParameter;
        @Summary
        private final Uri filterDefinition;
        @Summary
        @Binding(bindingName="SubscriptionTopicFilterBySearchModifier", strength=BindingStrength.Value.REQUIRED, description="Operator to apply to filter label.", valueSet="http://hl7.org/fhir/ValueSet/subscription-search-modifier|4.3.0")
        private final List<SubscriptionTopicFilterBySearchModifier> modifier;

        private CanFilterBy(Builder builder) {
            super(builder);
            this.description = builder.description;
            this.resource = builder.resource;
            this.filterParameter = builder.filterParameter;
            this.filterDefinition = builder.filterDefinition;
            this.modifier = Collections.unmodifiableList(builder.modifier);
        }

        public Markdown getDescription() {
            return this.description;
        }

        public Uri getResource() {
            return this.resource;
        }

        public org.linuxforhealth.fhir.model.type.String getFilterParameter() {
            return this.filterParameter;
        }

        public Uri getFilterDefinition() {
            return this.filterDefinition;
        }

        public List<SubscriptionTopicFilterBySearchModifier> getModifier() {
            return this.modifier;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || this.resource != null || this.filterParameter != null || this.filterDefinition != null || !this.modifier.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.resource, "resource", visitor);
                    this.accept(this.filterParameter, "filterParameter", visitor);
                    this.accept(this.filterDefinition, "filterDefinition", visitor);
                    this.accept(this.modifier, "modifier", visitor, SubscriptionTopicFilterBySearchModifier.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CanFilterBy other = (CanFilterBy)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.resource, other.resource) && Objects.equals(this.filterParameter, other.filterParameter) && Objects.equals(this.filterDefinition, other.filterDefinition) && Objects.equals(this.modifier, other.modifier);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.resource, this.filterParameter, this.filterDefinition, this.modifier);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Markdown description;
            private Uri resource;
            private org.linuxforhealth.fhir.model.type.String filterParameter;
            private Uri filterDefinition;
            private List<SubscriptionTopicFilterBySearchModifier> modifier = new ArrayList<SubscriptionTopicFilterBySearchModifier>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(Markdown description) {
                this.description = description;
                return this;
            }

            public Builder resource(Uri resource) {
                this.resource = resource;
                return this;
            }

            public Builder filterParameter(String filterParameter) {
                this.filterParameter = filterParameter == null ? null : org.linuxforhealth.fhir.model.type.String.of(filterParameter);
                return this;
            }

            public Builder filterParameter(org.linuxforhealth.fhir.model.type.String filterParameter) {
                this.filterParameter = filterParameter;
                return this;
            }

            public Builder filterDefinition(Uri filterDefinition) {
                this.filterDefinition = filterDefinition;
                return this;
            }

            public Builder modifier(SubscriptionTopicFilterBySearchModifier ... modifier) {
                for (SubscriptionTopicFilterBySearchModifier value : modifier) {
                    this.modifier.add(value);
                }
                return this;
            }

            public Builder modifier(Collection<SubscriptionTopicFilterBySearchModifier> modifier) {
                this.modifier = new ArrayList<SubscriptionTopicFilterBySearchModifier>(modifier);
                return this;
            }

            @Override
            public CanFilterBy build() {
                CanFilterBy canFilterBy = new CanFilterBy(this);
                if (this.validating) {
                    this.validate(canFilterBy);
                }
                return canFilterBy;
            }

            protected void validate(CanFilterBy canFilterBy) {
                super.validate(canFilterBy);
                ValidationSupport.requireNonNull(canFilterBy.filterParameter, "filterParameter");
                ValidationSupport.checkList(canFilterBy.modifier, "modifier", SubscriptionTopicFilterBySearchModifier.class);
                ValidationSupport.requireValueOrChildren(canFilterBy);
            }

            protected Builder from(CanFilterBy canFilterBy) {
                super.from(canFilterBy);
                this.description = canFilterBy.description;
                this.resource = canFilterBy.resource;
                this.filterParameter = canFilterBy.filterParameter;
                this.filterDefinition = canFilterBy.filterDefinition;
                this.modifier.addAll(canFilterBy.modifier);
                return this;
            }
        }
    }

    public static class EventTrigger
    extends BackboneElement {
        @Summary
        private final Markdown description;
        @Summary
        @Binding(bindingName="SubscriptionTopicEventTrigger", strength=BindingStrength.Value.EXAMPLE, description="FHIR Value set/code system definition for HL7 v2 table 0003 (EVENT TYPE CODE).", valueSet="http://terminology.hl7.org/ValueSet/v2-0003")
        @Required
        private final CodeableConcept event;
        @Summary
        @Binding(bindingName="FHIRDefinedTypeExt", strength=BindingStrength.Value.EXTENSIBLE, description="Either a resource or a data type, including logical model types.", valueSet="http://hl7.org/fhir/ValueSet/defined-types")
        @Required
        private final Uri resource;

        private EventTrigger(Builder builder) {
            super(builder);
            this.description = builder.description;
            this.event = builder.event;
            this.resource = builder.resource;
        }

        public Markdown getDescription() {
            return this.description;
        }

        public CodeableConcept getEvent() {
            return this.event;
        }

        public Uri getResource() {
            return this.resource;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || this.event != null || this.resource != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.event, "event", visitor);
                    this.accept(this.resource, "resource", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventTrigger other = (EventTrigger)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.event, other.event) && Objects.equals(this.resource, other.resource);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.event, this.resource);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Markdown description;
            private CodeableConcept event;
            private Uri resource;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(Markdown description) {
                this.description = description;
                return this;
            }

            public Builder event(CodeableConcept event) {
                this.event = event;
                return this;
            }

            public Builder resource(Uri resource) {
                this.resource = resource;
                return this;
            }

            @Override
            public EventTrigger build() {
                EventTrigger eventTrigger = new EventTrigger(this);
                if (this.validating) {
                    this.validate(eventTrigger);
                }
                return eventTrigger;
            }

            protected void validate(EventTrigger eventTrigger) {
                super.validate(eventTrigger);
                ValidationSupport.requireNonNull(eventTrigger.event, "event");
                ValidationSupport.requireNonNull(eventTrigger.resource, "resource");
                ValidationSupport.requireValueOrChildren(eventTrigger);
            }

            protected Builder from(EventTrigger eventTrigger) {
                super.from(eventTrigger);
                this.description = eventTrigger.description;
                this.event = eventTrigger.event;
                this.resource = eventTrigger.resource;
                return this;
            }
        }
    }

    public static class ResourceTrigger
    extends BackboneElement {
        @Summary
        private final Markdown description;
        @Summary
        @Binding(bindingName="FHIRDefinedTypeExt", strength=BindingStrength.Value.EXTENSIBLE, description="Either a resource or a data type, including logical model types.", valueSet="http://hl7.org/fhir/ValueSet/defined-types")
        @Required
        private final Uri resource;
        @Summary
        @Binding(bindingName="MethodCode", strength=BindingStrength.Value.REQUIRED, description="FHIR RESTful interaction used to filter a resource-based SubscriptionTopic trigger.", valueSet="http://hl7.org/fhir/ValueSet/interaction-trigger|4.3.0")
        private final List<MethodCode> supportedInteraction;
        @Summary
        private final QueryCriteria queryCriteria;
        @Summary
        private final org.linuxforhealth.fhir.model.type.String fhirPathCriteria;

        private ResourceTrigger(Builder builder) {
            super(builder);
            this.description = builder.description;
            this.resource = builder.resource;
            this.supportedInteraction = Collections.unmodifiableList(builder.supportedInteraction);
            this.queryCriteria = builder.queryCriteria;
            this.fhirPathCriteria = builder.fhirPathCriteria;
        }

        public Markdown getDescription() {
            return this.description;
        }

        public Uri getResource() {
            return this.resource;
        }

        public List<MethodCode> getSupportedInteraction() {
            return this.supportedInteraction;
        }

        public QueryCriteria getQueryCriteria() {
            return this.queryCriteria;
        }

        public org.linuxforhealth.fhir.model.type.String getFhirPathCriteria() {
            return this.fhirPathCriteria;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || this.resource != null || !this.supportedInteraction.isEmpty() || this.queryCriteria != null || this.fhirPathCriteria != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.resource, "resource", visitor);
                    this.accept(this.supportedInteraction, "supportedInteraction", visitor, MethodCode.class);
                    this.accept(this.queryCriteria, "queryCriteria", visitor);
                    this.accept(this.fhirPathCriteria, "fhirPathCriteria", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceTrigger other = (ResourceTrigger)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.resource, other.resource) && Objects.equals(this.supportedInteraction, other.supportedInteraction) && Objects.equals(this.queryCriteria, other.queryCriteria) && Objects.equals(this.fhirPathCriteria, other.fhirPathCriteria);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.resource, this.supportedInteraction, this.queryCriteria, this.fhirPathCriteria);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class QueryCriteria
        extends BackboneElement {
            @Summary
            private final org.linuxforhealth.fhir.model.type.String previous;
            @Summary
            @Binding(bindingName="CriteriaNotExistsBehavior", strength=BindingStrength.Value.REQUIRED, description="Behavior a server can exhibit when a criteria state does not exist (e.g., state prior to a create or after a delete).", valueSet="http://hl7.org/fhir/ValueSet/subscriptiontopic-cr-behavior|4.3.0")
            private final CriteriaNotExistsBehavior resultForCreate;
            @Summary
            private final org.linuxforhealth.fhir.model.type.String current;
            @Summary
            @Binding(bindingName="CriteriaNotExistsBehavior", strength=BindingStrength.Value.REQUIRED, description="Behavior a server can exhibit when a criteria state does not exist (e.g., state prior to a create or after a delete).", valueSet="http://hl7.org/fhir/ValueSet/subscriptiontopic-cr-behavior|4.3.0")
            private final CriteriaNotExistsBehavior resultForDelete;
            @Summary
            private final Boolean requireBoth;

            private QueryCriteria(Builder builder) {
                super(builder);
                this.previous = builder.previous;
                this.resultForCreate = builder.resultForCreate;
                this.current = builder.current;
                this.resultForDelete = builder.resultForDelete;
                this.requireBoth = builder.requireBoth;
            }

            public org.linuxforhealth.fhir.model.type.String getPrevious() {
                return this.previous;
            }

            public CriteriaNotExistsBehavior getResultForCreate() {
                return this.resultForCreate;
            }

            public org.linuxforhealth.fhir.model.type.String getCurrent() {
                return this.current;
            }

            public CriteriaNotExistsBehavior getResultForDelete() {
                return this.resultForDelete;
            }

            public Boolean getRequireBoth() {
                return this.requireBoth;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.previous != null || this.resultForCreate != null || this.current != null || this.resultForDelete != null || this.requireBoth != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.previous, "previous", visitor);
                        this.accept(this.resultForCreate, "resultForCreate", visitor);
                        this.accept(this.current, "current", visitor);
                        this.accept(this.resultForDelete, "resultForDelete", visitor);
                        this.accept(this.requireBoth, "requireBoth", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                QueryCriteria other = (QueryCriteria)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.previous, other.previous) && Objects.equals(this.resultForCreate, other.resultForCreate) && Objects.equals(this.current, other.current) && Objects.equals(this.resultForDelete, other.resultForDelete) && Objects.equals(this.requireBoth, other.requireBoth);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.previous, this.resultForCreate, this.current, this.resultForDelete, this.requireBoth);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private org.linuxforhealth.fhir.model.type.String previous;
                private CriteriaNotExistsBehavior resultForCreate;
                private org.linuxforhealth.fhir.model.type.String current;
                private CriteriaNotExistsBehavior resultForDelete;
                private Boolean requireBoth;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder previous(String previous) {
                    this.previous = previous == null ? null : org.linuxforhealth.fhir.model.type.String.of(previous);
                    return this;
                }

                public Builder previous(org.linuxforhealth.fhir.model.type.String previous) {
                    this.previous = previous;
                    return this;
                }

                public Builder resultForCreate(CriteriaNotExistsBehavior resultForCreate) {
                    this.resultForCreate = resultForCreate;
                    return this;
                }

                public Builder current(String current) {
                    this.current = current == null ? null : org.linuxforhealth.fhir.model.type.String.of(current);
                    return this;
                }

                public Builder current(org.linuxforhealth.fhir.model.type.String current) {
                    this.current = current;
                    return this;
                }

                public Builder resultForDelete(CriteriaNotExistsBehavior resultForDelete) {
                    this.resultForDelete = resultForDelete;
                    return this;
                }

                public Builder requireBoth(java.lang.Boolean requireBoth) {
                    this.requireBoth = requireBoth == null ? null : Boolean.of(requireBoth);
                    return this;
                }

                public Builder requireBoth(Boolean requireBoth) {
                    this.requireBoth = requireBoth;
                    return this;
                }

                @Override
                public QueryCriteria build() {
                    QueryCriteria queryCriteria = new QueryCriteria(this);
                    if (this.validating) {
                        this.validate(queryCriteria);
                    }
                    return queryCriteria;
                }

                protected void validate(QueryCriteria queryCriteria) {
                    super.validate(queryCriteria);
                    ValidationSupport.requireValueOrChildren(queryCriteria);
                }

                protected Builder from(QueryCriteria queryCriteria) {
                    super.from(queryCriteria);
                    this.previous = queryCriteria.previous;
                    this.resultForCreate = queryCriteria.resultForCreate;
                    this.current = queryCriteria.current;
                    this.resultForDelete = queryCriteria.resultForDelete;
                    this.requireBoth = queryCriteria.requireBoth;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Markdown description;
            private Uri resource;
            private List<MethodCode> supportedInteraction = new ArrayList<MethodCode>();
            private QueryCriteria queryCriteria;
            private org.linuxforhealth.fhir.model.type.String fhirPathCriteria;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(Markdown description) {
                this.description = description;
                return this;
            }

            public Builder resource(Uri resource) {
                this.resource = resource;
                return this;
            }

            public Builder supportedInteraction(MethodCode ... supportedInteraction) {
                for (MethodCode value : supportedInteraction) {
                    this.supportedInteraction.add(value);
                }
                return this;
            }

            public Builder supportedInteraction(Collection<MethodCode> supportedInteraction) {
                this.supportedInteraction = new ArrayList<MethodCode>(supportedInteraction);
                return this;
            }

            public Builder queryCriteria(QueryCriteria queryCriteria) {
                this.queryCriteria = queryCriteria;
                return this;
            }

            public Builder fhirPathCriteria(String fhirPathCriteria) {
                this.fhirPathCriteria = fhirPathCriteria == null ? null : org.linuxforhealth.fhir.model.type.String.of(fhirPathCriteria);
                return this;
            }

            public Builder fhirPathCriteria(org.linuxforhealth.fhir.model.type.String fhirPathCriteria) {
                this.fhirPathCriteria = fhirPathCriteria;
                return this;
            }

            @Override
            public ResourceTrigger build() {
                ResourceTrigger resourceTrigger = new ResourceTrigger(this);
                if (this.validating) {
                    this.validate(resourceTrigger);
                }
                return resourceTrigger;
            }

            protected void validate(ResourceTrigger resourceTrigger) {
                super.validate(resourceTrigger);
                ValidationSupport.requireNonNull(resourceTrigger.resource, "resource");
                ValidationSupport.checkList(resourceTrigger.supportedInteraction, "supportedInteraction", MethodCode.class);
                ValidationSupport.requireValueOrChildren(resourceTrigger);
            }

            protected Builder from(ResourceTrigger resourceTrigger) {
                super.from(resourceTrigger);
                this.description = resourceTrigger.description;
                this.resource = resourceTrigger.resource;
                this.supportedInteraction.addAll(resourceTrigger.supportedInteraction);
                this.queryCriteria = resourceTrigger.queryCriteria;
                this.fhirPathCriteria = resourceTrigger.fhirPathCriteria;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private org.linuxforhealth.fhir.model.type.String version;
        private org.linuxforhealth.fhir.model.type.String title;
        private List<Canonical> derivedFrom = new ArrayList<Canonical>();
        private PublicationStatus status;
        private Boolean experimental;
        private DateTime date;
        private org.linuxforhealth.fhir.model.type.String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private Markdown copyright;
        private Date approvalDate;
        private Date lastReviewDate;
        private Period effectivePeriod;
        private List<ResourceTrigger> resourceTrigger = new ArrayList<ResourceTrigger>();
        private List<EventTrigger> eventTrigger = new ArrayList<EventTrigger>();
        private List<CanFilterBy> canFilterBy = new ArrayList<CanFilterBy>();
        private List<NotificationShape> notificationShape = new ArrayList<NotificationShape>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(String version) {
            this.version = version == null ? null : org.linuxforhealth.fhir.model.type.String.of(version);
            return this;
        }

        public Builder version(org.linuxforhealth.fhir.model.type.String version) {
            this.version = version;
            return this;
        }

        public Builder title(String title) {
            this.title = title == null ? null : org.linuxforhealth.fhir.model.type.String.of(title);
            return this;
        }

        public Builder title(org.linuxforhealth.fhir.model.type.String title) {
            this.title = title;
            return this;
        }

        public Builder derivedFrom(Canonical ... derivedFrom) {
            for (Canonical value : derivedFrom) {
                this.derivedFrom.add(value);
            }
            return this;
        }

        public Builder derivedFrom(Collection<Canonical> derivedFrom) {
            this.derivedFrom = new ArrayList<Canonical>(derivedFrom);
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(java.lang.Boolean experimental) {
            this.experimental = experimental == null ? null : Boolean.of(experimental);
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher == null ? null : org.linuxforhealth.fhir.model.type.String.of(publisher);
            return this;
        }

        public Builder publisher(org.linuxforhealth.fhir.model.type.String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder approvalDate(LocalDate approvalDate) {
            this.approvalDate = approvalDate == null ? null : Date.of(approvalDate);
            return this;
        }

        public Builder approvalDate(Date approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public Builder lastReviewDate(LocalDate lastReviewDate) {
            this.lastReviewDate = lastReviewDate == null ? null : Date.of(lastReviewDate);
            return this;
        }

        public Builder lastReviewDate(Date lastReviewDate) {
            this.lastReviewDate = lastReviewDate;
            return this;
        }

        public Builder effectivePeriod(Period effectivePeriod) {
            this.effectivePeriod = effectivePeriod;
            return this;
        }

        public Builder resourceTrigger(ResourceTrigger ... resourceTrigger) {
            for (ResourceTrigger value : resourceTrigger) {
                this.resourceTrigger.add(value);
            }
            return this;
        }

        public Builder resourceTrigger(Collection<ResourceTrigger> resourceTrigger) {
            this.resourceTrigger = new ArrayList<ResourceTrigger>(resourceTrigger);
            return this;
        }

        public Builder eventTrigger(EventTrigger ... eventTrigger) {
            for (EventTrigger value : eventTrigger) {
                this.eventTrigger.add(value);
            }
            return this;
        }

        public Builder eventTrigger(Collection<EventTrigger> eventTrigger) {
            this.eventTrigger = new ArrayList<EventTrigger>(eventTrigger);
            return this;
        }

        public Builder canFilterBy(CanFilterBy ... canFilterBy) {
            for (CanFilterBy value : canFilterBy) {
                this.canFilterBy.add(value);
            }
            return this;
        }

        public Builder canFilterBy(Collection<CanFilterBy> canFilterBy) {
            this.canFilterBy = new ArrayList<CanFilterBy>(canFilterBy);
            return this;
        }

        public Builder notificationShape(NotificationShape ... notificationShape) {
            for (NotificationShape value : notificationShape) {
                this.notificationShape.add(value);
            }
            return this;
        }

        public Builder notificationShape(Collection<NotificationShape> notificationShape) {
            this.notificationShape = new ArrayList<NotificationShape>(notificationShape);
            return this;
        }

        @Override
        public SubscriptionTopic build() {
            SubscriptionTopic subscriptionTopic = new SubscriptionTopic(this);
            if (this.validating) {
                this.validate(subscriptionTopic);
            }
            return subscriptionTopic;
        }

        protected void validate(SubscriptionTopic subscriptionTopic) {
            super.validate(subscriptionTopic);
            ValidationSupport.requireNonNull(subscriptionTopic.url, "url");
            ValidationSupport.checkList(subscriptionTopic.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(subscriptionTopic.derivedFrom, "derivedFrom", Canonical.class);
            ValidationSupport.requireNonNull(subscriptionTopic.status, "status");
            ValidationSupport.checkList(subscriptionTopic.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(subscriptionTopic.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(subscriptionTopic.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.checkList(subscriptionTopic.resourceTrigger, "resourceTrigger", ResourceTrigger.class);
            ValidationSupport.checkList(subscriptionTopic.eventTrigger, "eventTrigger", EventTrigger.class);
            ValidationSupport.checkList(subscriptionTopic.canFilterBy, "canFilterBy", CanFilterBy.class);
            ValidationSupport.checkList(subscriptionTopic.notificationShape, "notificationShape", NotificationShape.class);
        }

        protected Builder from(SubscriptionTopic subscriptionTopic) {
            super.from(subscriptionTopic);
            this.url = subscriptionTopic.url;
            this.identifier.addAll(subscriptionTopic.identifier);
            this.version = subscriptionTopic.version;
            this.title = subscriptionTopic.title;
            this.derivedFrom.addAll(subscriptionTopic.derivedFrom);
            this.status = subscriptionTopic.status;
            this.experimental = subscriptionTopic.experimental;
            this.date = subscriptionTopic.date;
            this.publisher = subscriptionTopic.publisher;
            this.contact.addAll(subscriptionTopic.contact);
            this.description = subscriptionTopic.description;
            this.useContext.addAll(subscriptionTopic.useContext);
            this.jurisdiction.addAll(subscriptionTopic.jurisdiction);
            this.purpose = subscriptionTopic.purpose;
            this.copyright = subscriptionTopic.copyright;
            this.approvalDate = subscriptionTopic.approvalDate;
            this.lastReviewDate = subscriptionTopic.lastReviewDate;
            this.effectivePeriod = subscriptionTopic.effectivePeriod;
            this.resourceTrigger.addAll(subscriptionTopic.resourceTrigger);
            this.eventTrigger.addAll(subscriptionTopic.eventTrigger);
            this.canFilterBy.addAll(subscriptionTopic.canFilterBy);
            this.notificationShape.addAll(subscriptionTopic.notificationShape);
            return this;
        }
    }
}

