/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Annotation;
import org.linuxforhealth.fhir.model.type.Attachment;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Date;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Quantity;
import org.linuxforhealth.fhir.model.type.Ratio;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="substanceDefinition-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/publication-status", expression="status.exists() implies (status.memberOf('http://hl7.org/fhir/ValueSet/publication-status', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/SubstanceDefinition", generated=true), @Constraint(id="substanceDefinition-1", level="Warning", location="code.status", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/publication-status", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/publication-status', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/SubstanceDefinition", generated=true), @Constraint(id="substanceDefinition-2", level="Warning", location="name.status", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/publication-status", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/publication-status', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/SubstanceDefinition", generated=true), @Constraint(id="substanceDefinition-3", level="Warning", location="name.language", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/languages", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/languages', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/SubstanceDefinition", generated=true), @Constraint(id="substanceDefinition-4", level="Warning", location="name.official.authority", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/substance-name-authority", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/substance-name-authority', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/SubstanceDefinition", generated=true), @Constraint(id="substanceDefinition-5", level="Warning", location="name.official.status", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/publication-status", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/publication-status', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/SubstanceDefinition", generated=true)})
public class SubstanceDefinition
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String version;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.PREFERRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    private final CodeableConcept status;
    @Summary
    private final List<CodeableConcept> classification;
    @Summary
    @Binding(bindingName="MedicinalProductType", strength=BindingStrength.Value.EXAMPLE, description="Applicable domain for this product (e.g. human, veterinary).", valueSet="http://hl7.org/fhir/ValueSet/medicinal-product-domain")
    private final CodeableConcept domain;
    @Summary
    @Binding(bindingName="SubstanceGrade", strength=BindingStrength.Value.EXAMPLE, description="The quality standard, established benchmark, to which a substance complies", valueSet="http://hl7.org/fhir/ValueSet/substance-grade")
    private final List<CodeableConcept> grade;
    @Summary
    private final Markdown description;
    @Summary
    @ReferenceTarget(value={"Citation"})
    private final List<Reference> informationSource;
    @Summary
    private final List<Annotation> note;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final List<Reference> manufacturer;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final List<Reference> supplier;
    @Summary
    private final List<Moiety> moiety;
    @Summary
    private final List<Property> property;
    @Summary
    private final List<MolecularWeight> molecularWeight;
    @Summary
    private final Structure structure;
    @Summary
    private final List<Code> code;
    @Summary
    private final List<Name> name;
    @Summary
    private final List<Relationship> relationship;
    @Summary
    private final SourceMaterial sourceMaterial;

    private SubstanceDefinition(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.version = builder.version;
        this.status = builder.status;
        this.classification = Collections.unmodifiableList(builder.classification);
        this.domain = builder.domain;
        this.grade = Collections.unmodifiableList(builder.grade);
        this.description = builder.description;
        this.informationSource = Collections.unmodifiableList(builder.informationSource);
        this.note = Collections.unmodifiableList(builder.note);
        this.manufacturer = Collections.unmodifiableList(builder.manufacturer);
        this.supplier = Collections.unmodifiableList(builder.supplier);
        this.moiety = Collections.unmodifiableList(builder.moiety);
        this.property = Collections.unmodifiableList(builder.property);
        this.molecularWeight = Collections.unmodifiableList(builder.molecularWeight);
        this.structure = builder.structure;
        this.code = Collections.unmodifiableList(builder.code);
        this.name = Collections.unmodifiableList(builder.name);
        this.relationship = Collections.unmodifiableList(builder.relationship);
        this.sourceMaterial = builder.sourceMaterial;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public org.linuxforhealth.fhir.model.type.String getVersion() {
        return this.version;
    }

    public CodeableConcept getStatus() {
        return this.status;
    }

    public List<CodeableConcept> getClassification() {
        return this.classification;
    }

    public CodeableConcept getDomain() {
        return this.domain;
    }

    public List<CodeableConcept> getGrade() {
        return this.grade;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<Reference> getInformationSource() {
        return this.informationSource;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<Reference> getManufacturer() {
        return this.manufacturer;
    }

    public List<Reference> getSupplier() {
        return this.supplier;
    }

    public List<Moiety> getMoiety() {
        return this.moiety;
    }

    public List<Property> getProperty() {
        return this.property;
    }

    public List<MolecularWeight> getMolecularWeight() {
        return this.molecularWeight;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public List<Code> getCode() {
        return this.code;
    }

    public List<Name> getName() {
        return this.name;
    }

    public List<Relationship> getRelationship() {
        return this.relationship;
    }

    public SourceMaterial getSourceMaterial() {
        return this.sourceMaterial;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.version != null || this.status != null || !this.classification.isEmpty() || this.domain != null || !this.grade.isEmpty() || this.description != null || !this.informationSource.isEmpty() || !this.note.isEmpty() || !this.manufacturer.isEmpty() || !this.supplier.isEmpty() || !this.moiety.isEmpty() || !this.property.isEmpty() || !this.molecularWeight.isEmpty() || this.structure != null || !this.code.isEmpty() || !this.name.isEmpty() || !this.relationship.isEmpty() || this.sourceMaterial != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.classification, "classification", visitor, CodeableConcept.class);
                this.accept(this.domain, "domain", visitor);
                this.accept(this.grade, "grade", visitor, CodeableConcept.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.informationSource, "informationSource", visitor, Reference.class);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.manufacturer, "manufacturer", visitor, Reference.class);
                this.accept(this.supplier, "supplier", visitor, Reference.class);
                this.accept(this.moiety, "moiety", visitor, Moiety.class);
                this.accept(this.property, "property", visitor, Property.class);
                this.accept(this.molecularWeight, "molecularWeight", visitor, MolecularWeight.class);
                this.accept(this.structure, "structure", visitor);
                this.accept(this.code, "code", visitor, Code.class);
                this.accept(this.name, "name", visitor, Name.class);
                this.accept(this.relationship, "relationship", visitor, Relationship.class);
                this.accept(this.sourceMaterial, "sourceMaterial", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubstanceDefinition other = (SubstanceDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.status, other.status) && Objects.equals(this.classification, other.classification) && Objects.equals(this.domain, other.domain) && Objects.equals(this.grade, other.grade) && Objects.equals(this.description, other.description) && Objects.equals(this.informationSource, other.informationSource) && Objects.equals(this.note, other.note) && Objects.equals(this.manufacturer, other.manufacturer) && Objects.equals(this.supplier, other.supplier) && Objects.equals(this.moiety, other.moiety) && Objects.equals(this.property, other.property) && Objects.equals(this.molecularWeight, other.molecularWeight) && Objects.equals(this.structure, other.structure) && Objects.equals(this.code, other.code) && Objects.equals(this.name, other.name) && Objects.equals(this.relationship, other.relationship) && Objects.equals(this.sourceMaterial, other.sourceMaterial);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.version, this.status, this.classification, this.domain, this.grade, this.description, this.informationSource, this.note, this.manufacturer, this.supplier, this.moiety, this.property, this.molecularWeight, this.structure, this.code, this.name, this.relationship, this.sourceMaterial);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class SourceMaterial
    extends BackboneElement {
        @Summary
        @Binding(bindingName="SourceMaterialType", strength=BindingStrength.Value.EXAMPLE, description="A classification that provides the origin of the substance raw material.", valueSet="http://hl7.org/fhir/ValueSet/substance-source-material-type")
        private final CodeableConcept type;
        @Summary
        @Binding(bindingName="SourceMaterialGenus", strength=BindingStrength.Value.EXAMPLE, description="The genus of an organism, typically referring to the Latin epithet of the genus element of the plant/animal scientific name.", valueSet="http://hl7.org/fhir/ValueSet/substance-source-material-genus")
        private final CodeableConcept genus;
        @Summary
        @Binding(bindingName="SourceMaterialSpecies", strength=BindingStrength.Value.EXAMPLE, description="A species of origin a substance raw material.", valueSet="http://hl7.org/fhir/ValueSet/substance-source-material-species")
        private final CodeableConcept species;
        @Summary
        @Binding(bindingName="SourceMaterialPart", strength=BindingStrength.Value.EXAMPLE, description="An anatomical origin of the source material within an organism.", valueSet="http://hl7.org/fhir/ValueSet/substance-source-material-part")
        private final CodeableConcept part;
        @Summary
        @Binding(bindingName="Country", strength=BindingStrength.Value.REQUIRED, description="Jurisdiction codes", valueSet="http://hl7.org/fhir/ValueSet/country|4.3.0")
        private final List<CodeableConcept> countryOfOrigin;

        private SourceMaterial(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.genus = builder.genus;
            this.species = builder.species;
            this.part = builder.part;
            this.countryOfOrigin = Collections.unmodifiableList(builder.countryOfOrigin);
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public CodeableConcept getGenus() {
            return this.genus;
        }

        public CodeableConcept getSpecies() {
            return this.species;
        }

        public CodeableConcept getPart() {
            return this.part;
        }

        public List<CodeableConcept> getCountryOfOrigin() {
            return this.countryOfOrigin;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.genus != null || this.species != null || this.part != null || !this.countryOfOrigin.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.genus, "genus", visitor);
                    this.accept(this.species, "species", visitor);
                    this.accept(this.part, "part", visitor);
                    this.accept(this.countryOfOrigin, "countryOfOrigin", visitor, CodeableConcept.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceMaterial other = (SourceMaterial)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.genus, other.genus) && Objects.equals(this.species, other.species) && Objects.equals(this.part, other.part) && Objects.equals(this.countryOfOrigin, other.countryOfOrigin);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.genus, this.species, this.part, this.countryOfOrigin);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private CodeableConcept genus;
            private CodeableConcept species;
            private CodeableConcept part;
            private List<CodeableConcept> countryOfOrigin = new ArrayList<CodeableConcept>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder genus(CodeableConcept genus) {
                this.genus = genus;
                return this;
            }

            public Builder species(CodeableConcept species) {
                this.species = species;
                return this;
            }

            public Builder part(CodeableConcept part) {
                this.part = part;
                return this;
            }

            public Builder countryOfOrigin(CodeableConcept ... countryOfOrigin) {
                for (CodeableConcept value : countryOfOrigin) {
                    this.countryOfOrigin.add(value);
                }
                return this;
            }

            public Builder countryOfOrigin(Collection<CodeableConcept> countryOfOrigin) {
                this.countryOfOrigin = new ArrayList<CodeableConcept>(countryOfOrigin);
                return this;
            }

            @Override
            public SourceMaterial build() {
                SourceMaterial sourceMaterial = new SourceMaterial(this);
                if (this.validating) {
                    this.validate(sourceMaterial);
                }
                return sourceMaterial;
            }

            protected void validate(SourceMaterial sourceMaterial) {
                super.validate(sourceMaterial);
                ValidationSupport.checkList(sourceMaterial.countryOfOrigin, "countryOfOrigin", CodeableConcept.class);
                ValidationSupport.requireValueOrChildren(sourceMaterial);
            }

            protected Builder from(SourceMaterial sourceMaterial) {
                super.from(sourceMaterial);
                this.type = sourceMaterial.type;
                this.genus = sourceMaterial.genus;
                this.species = sourceMaterial.species;
                this.part = sourceMaterial.part;
                this.countryOfOrigin.addAll(sourceMaterial.countryOfOrigin);
                return this;
            }
        }
    }

    public static class Relationship
    extends BackboneElement {
        @Summary
        @ReferenceTarget(value={"SubstanceDefinition"})
        @Choice(value={Reference.class, CodeableConcept.class})
        private final Element substanceDefinition;
        @Summary
        @Binding(bindingName="SubstanceRelationshipType", strength=BindingStrength.Value.EXAMPLE, description="The relationship between two substance types.", valueSet="http://hl7.org/fhir/ValueSet/substance-relationship-type")
        @Required
        private final CodeableConcept type;
        @Summary
        private final Boolean isDefining;
        @Summary
        @Choice(value={Quantity.class, Ratio.class, org.linuxforhealth.fhir.model.type.String.class})
        private final Element amount;
        @Summary
        private final Ratio ratioHighLimitAmount;
        @Summary
        @Binding(bindingName="SubstanceAmountType", strength=BindingStrength.Value.EXAMPLE, description="The relationship between two substance types.", valueSet="http://hl7.org/fhir/ValueSet/substance-amount-type")
        private final CodeableConcept comparator;
        @Summary
        @ReferenceTarget(value={"DocumentReference"})
        private final List<Reference> source;

        private Relationship(Builder builder) {
            super(builder);
            this.substanceDefinition = builder.substanceDefinition;
            this.type = builder.type;
            this.isDefining = builder.isDefining;
            this.amount = builder.amount;
            this.ratioHighLimitAmount = builder.ratioHighLimitAmount;
            this.comparator = builder.comparator;
            this.source = Collections.unmodifiableList(builder.source);
        }

        public Element getSubstanceDefinition() {
            return this.substanceDefinition;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Boolean getIsDefining() {
            return this.isDefining;
        }

        public Element getAmount() {
            return this.amount;
        }

        public Ratio getRatioHighLimitAmount() {
            return this.ratioHighLimitAmount;
        }

        public CodeableConcept getComparator() {
            return this.comparator;
        }

        public List<Reference> getSource() {
            return this.source;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.substanceDefinition != null || this.type != null || this.isDefining != null || this.amount != null || this.ratioHighLimitAmount != null || this.comparator != null || !this.source.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.substanceDefinition, "substanceDefinition", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.isDefining, "isDefining", visitor);
                    this.accept(this.amount, "amount", visitor);
                    this.accept(this.ratioHighLimitAmount, "ratioHighLimitAmount", visitor);
                    this.accept(this.comparator, "comparator", visitor);
                    this.accept(this.source, "source", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Relationship other = (Relationship)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.substanceDefinition, other.substanceDefinition) && Objects.equals(this.type, other.type) && Objects.equals(this.isDefining, other.isDefining) && Objects.equals(this.amount, other.amount) && Objects.equals(this.ratioHighLimitAmount, other.ratioHighLimitAmount) && Objects.equals(this.comparator, other.comparator) && Objects.equals(this.source, other.source);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.substanceDefinition, this.type, this.isDefining, this.amount, this.ratioHighLimitAmount, this.comparator, this.source);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Element substanceDefinition;
            private CodeableConcept type;
            private Boolean isDefining;
            private Element amount;
            private Ratio ratioHighLimitAmount;
            private CodeableConcept comparator;
            private List<Reference> source = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder substanceDefinition(Element substanceDefinition) {
                this.substanceDefinition = substanceDefinition;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder isDefining(java.lang.Boolean isDefining) {
                this.isDefining = isDefining == null ? null : Boolean.of(isDefining);
                return this;
            }

            public Builder isDefining(Boolean isDefining) {
                this.isDefining = isDefining;
                return this;
            }

            public Builder amount(String amount) {
                this.amount = amount == null ? null : org.linuxforhealth.fhir.model.type.String.of(amount);
                return this;
            }

            public Builder amount(Element amount) {
                this.amount = amount;
                return this;
            }

            public Builder ratioHighLimitAmount(Ratio ratioHighLimitAmount) {
                this.ratioHighLimitAmount = ratioHighLimitAmount;
                return this;
            }

            public Builder comparator(CodeableConcept comparator) {
                this.comparator = comparator;
                return this;
            }

            public Builder source(Reference ... source) {
                for (Reference value : source) {
                    this.source.add(value);
                }
                return this;
            }

            public Builder source(Collection<Reference> source) {
                this.source = new ArrayList<Reference>(source);
                return this;
            }

            @Override
            public Relationship build() {
                Relationship relationship = new Relationship(this);
                if (this.validating) {
                    this.validate(relationship);
                }
                return relationship;
            }

            protected void validate(Relationship relationship) {
                super.validate(relationship);
                ValidationSupport.choiceElement(relationship.substanceDefinition, "substanceDefinition", Reference.class, CodeableConcept.class);
                ValidationSupport.requireNonNull(relationship.type, "type");
                ValidationSupport.choiceElement(relationship.amount, "amount", Quantity.class, Ratio.class, org.linuxforhealth.fhir.model.type.String.class);
                ValidationSupport.checkList(relationship.source, "source", Reference.class);
                ValidationSupport.checkReferenceType(relationship.substanceDefinition, "substanceDefinition", "SubstanceDefinition");
                ValidationSupport.checkReferenceType(relationship.source, "source", "DocumentReference");
                ValidationSupport.requireValueOrChildren(relationship);
            }

            protected Builder from(Relationship relationship) {
                super.from(relationship);
                this.substanceDefinition = relationship.substanceDefinition;
                this.type = relationship.type;
                this.isDefining = relationship.isDefining;
                this.amount = relationship.amount;
                this.ratioHighLimitAmount = relationship.ratioHighLimitAmount;
                this.comparator = relationship.comparator;
                this.source.addAll(relationship.source);
                return this;
            }
        }
    }

    public static class Name
    extends BackboneElement {
        @Summary
        @Required
        private final org.linuxforhealth.fhir.model.type.String name;
        @Summary
        @Binding(bindingName="SubstanceNameType", strength=BindingStrength.Value.EXAMPLE, description="The type of a name given to a substance.", valueSet="http://hl7.org/fhir/ValueSet/substance-name-type")
        private final CodeableConcept type;
        @Summary
        @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.PREFERRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status")
        private final CodeableConcept status;
        @Summary
        private final Boolean preferred;
        @Summary
        @Binding(bindingName="Language", strength=BindingStrength.Value.PREFERRED, description="IETF language tag", valueSet="http://hl7.org/fhir/ValueSet/languages", maxValueSet="http://hl7.org/fhir/ValueSet/all-languages")
        private final List<CodeableConcept> language;
        @Summary
        @Binding(bindingName="SubstanceNameDomain", strength=BindingStrength.Value.EXAMPLE, description="The use context of a substance name for example if there is a different name when used as a drug active ingredient as opposed to a food colour additive.", valueSet="http://hl7.org/fhir/ValueSet/substance-name-domain")
        private final List<CodeableConcept> domain;
        @Summary
        @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXAMPLE, description="Jurisdiction codes", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
        private final List<CodeableConcept> jurisdiction;
        @Summary
        private final List<Name> synonym;
        @Summary
        private final List<Name> translation;
        @Summary
        private final List<Official> official;
        @Summary
        @ReferenceTarget(value={"DocumentReference"})
        private final List<Reference> source;

        private Name(Builder builder) {
            super(builder);
            this.name = builder.name;
            this.type = builder.type;
            this.status = builder.status;
            this.preferred = builder.preferred;
            this.language = Collections.unmodifiableList(builder.language);
            this.domain = Collections.unmodifiableList(builder.domain);
            this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
            this.synonym = Collections.unmodifiableList(builder.synonym);
            this.translation = Collections.unmodifiableList(builder.translation);
            this.official = Collections.unmodifiableList(builder.official);
            this.source = Collections.unmodifiableList(builder.source);
        }

        public org.linuxforhealth.fhir.model.type.String getName() {
            return this.name;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public CodeableConcept getStatus() {
            return this.status;
        }

        public Boolean getPreferred() {
            return this.preferred;
        }

        public List<CodeableConcept> getLanguage() {
            return this.language;
        }

        public List<CodeableConcept> getDomain() {
            return this.domain;
        }

        public List<CodeableConcept> getJurisdiction() {
            return this.jurisdiction;
        }

        public List<Name> getSynonym() {
            return this.synonym;
        }

        public List<Name> getTranslation() {
            return this.translation;
        }

        public List<Official> getOfficial() {
            return this.official;
        }

        public List<Reference> getSource() {
            return this.source;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.name != null || this.type != null || this.status != null || this.preferred != null || !this.language.isEmpty() || !this.domain.isEmpty() || !this.jurisdiction.isEmpty() || !this.synonym.isEmpty() || !this.translation.isEmpty() || !this.official.isEmpty() || !this.source.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.status, "status", visitor);
                    this.accept(this.preferred, "preferred", visitor);
                    this.accept(this.language, "language", visitor, CodeableConcept.class);
                    this.accept(this.domain, "domain", visitor, CodeableConcept.class);
                    this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                    this.accept(this.synonym, "synonym", visitor, Name.class);
                    this.accept(this.translation, "translation", visitor, Name.class);
                    this.accept(this.official, "official", visitor, Official.class);
                    this.accept(this.source, "source", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Name other = (Name)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.status, other.status) && Objects.equals(this.preferred, other.preferred) && Objects.equals(this.language, other.language) && Objects.equals(this.domain, other.domain) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.synonym, other.synonym) && Objects.equals(this.translation, other.translation) && Objects.equals(this.official, other.official) && Objects.equals(this.source, other.source);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.type, this.status, this.preferred, this.language, this.domain, this.jurisdiction, this.synonym, this.translation, this.official, this.source);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Official
        extends BackboneElement {
            @Summary
            @Binding(bindingName="SubstanceNameAuthority", strength=BindingStrength.Value.PREFERRED, description="An authority that officates substance names.", valueSet="http://hl7.org/fhir/ValueSet/substance-name-authority")
            private final CodeableConcept authority;
            @Summary
            @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.PREFERRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status")
            private final CodeableConcept status;
            @Summary
            private final DateTime date;

            private Official(Builder builder) {
                super(builder);
                this.authority = builder.authority;
                this.status = builder.status;
                this.date = builder.date;
            }

            public CodeableConcept getAuthority() {
                return this.authority;
            }

            public CodeableConcept getStatus() {
                return this.status;
            }

            public DateTime getDate() {
                return this.date;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.authority != null || this.status != null || this.date != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.authority, "authority", visitor);
                        this.accept(this.status, "status", visitor);
                        this.accept(this.date, "date", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Official other = (Official)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.authority, other.authority) && Objects.equals(this.status, other.status) && Objects.equals(this.date, other.date);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.authority, this.status, this.date);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept authority;
                private CodeableConcept status;
                private DateTime date;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder authority(CodeableConcept authority) {
                    this.authority = authority;
                    return this;
                }

                public Builder status(CodeableConcept status) {
                    this.status = status;
                    return this;
                }

                public Builder date(DateTime date) {
                    this.date = date;
                    return this;
                }

                @Override
                public Official build() {
                    Official official = new Official(this);
                    if (this.validating) {
                        this.validate(official);
                    }
                    return official;
                }

                protected void validate(Official official) {
                    super.validate(official);
                    ValidationSupport.requireValueOrChildren(official);
                }

                protected Builder from(Official official) {
                    super.from(official);
                    this.authority = official.authority;
                    this.status = official.status;
                    this.date = official.date;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private org.linuxforhealth.fhir.model.type.String name;
            private CodeableConcept type;
            private CodeableConcept status;
            private Boolean preferred;
            private List<CodeableConcept> language = new ArrayList<CodeableConcept>();
            private List<CodeableConcept> domain = new ArrayList<CodeableConcept>();
            private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
            private List<Name> synonym = new ArrayList<Name>();
            private List<Name> translation = new ArrayList<Name>();
            private List<Official> official = new ArrayList<Official>();
            private List<Reference> source = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder name(String name) {
                this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
                return this;
            }

            public Builder name(org.linuxforhealth.fhir.model.type.String name) {
                this.name = name;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder status(CodeableConcept status) {
                this.status = status;
                return this;
            }

            public Builder preferred(java.lang.Boolean preferred) {
                this.preferred = preferred == null ? null : Boolean.of(preferred);
                return this;
            }

            public Builder preferred(Boolean preferred) {
                this.preferred = preferred;
                return this;
            }

            public Builder language(CodeableConcept ... language) {
                for (CodeableConcept value : language) {
                    this.language.add(value);
                }
                return this;
            }

            public Builder language(Collection<CodeableConcept> language) {
                this.language = new ArrayList<CodeableConcept>(language);
                return this;
            }

            public Builder domain(CodeableConcept ... domain) {
                for (CodeableConcept value : domain) {
                    this.domain.add(value);
                }
                return this;
            }

            public Builder domain(Collection<CodeableConcept> domain) {
                this.domain = new ArrayList<CodeableConcept>(domain);
                return this;
            }

            public Builder jurisdiction(CodeableConcept ... jurisdiction) {
                for (CodeableConcept value : jurisdiction) {
                    this.jurisdiction.add(value);
                }
                return this;
            }

            public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
                this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
                return this;
            }

            public Builder synonym(Name ... synonym) {
                for (Name value : synonym) {
                    this.synonym.add(value);
                }
                return this;
            }

            public Builder synonym(Collection<Name> synonym) {
                this.synonym = new ArrayList<Name>(synonym);
                return this;
            }

            public Builder translation(Name ... translation) {
                for (Name value : translation) {
                    this.translation.add(value);
                }
                return this;
            }

            public Builder translation(Collection<Name> translation) {
                this.translation = new ArrayList<Name>(translation);
                return this;
            }

            public Builder official(Official ... official) {
                for (Official value : official) {
                    this.official.add(value);
                }
                return this;
            }

            public Builder official(Collection<Official> official) {
                this.official = new ArrayList<Official>(official);
                return this;
            }

            public Builder source(Reference ... source) {
                for (Reference value : source) {
                    this.source.add(value);
                }
                return this;
            }

            public Builder source(Collection<Reference> source) {
                this.source = new ArrayList<Reference>(source);
                return this;
            }

            @Override
            public Name build() {
                Name name = new Name(this);
                if (this.validating) {
                    this.validate(name);
                }
                return name;
            }

            protected void validate(Name name) {
                super.validate(name);
                ValidationSupport.requireNonNull(name.name, "name");
                ValidationSupport.checkList(name.language, "language", CodeableConcept.class);
                ValidationSupport.checkList(name.domain, "domain", CodeableConcept.class);
                ValidationSupport.checkList(name.jurisdiction, "jurisdiction", CodeableConcept.class);
                ValidationSupport.checkList(name.synonym, "synonym", Name.class);
                ValidationSupport.checkList(name.translation, "translation", Name.class);
                ValidationSupport.checkList(name.official, "official", Official.class);
                ValidationSupport.checkList(name.source, "source", Reference.class);
                ValidationSupport.checkValueSetBinding(name.language, "language", "http://hl7.org/fhir/ValueSet/all-languages", "urn:ietf:bcp:47", new String[0]);
                ValidationSupport.checkReferenceType(name.source, "source", "DocumentReference");
                ValidationSupport.requireValueOrChildren(name);
            }

            protected Builder from(Name name) {
                super.from(name);
                this.name = name.name;
                this.type = name.type;
                this.status = name.status;
                this.preferred = name.preferred;
                this.language.addAll(name.language);
                this.domain.addAll(name.domain);
                this.jurisdiction.addAll(name.jurisdiction);
                this.synonym.addAll(name.synonym);
                this.translation.addAll(name.translation);
                this.official.addAll(name.official);
                this.source.addAll(name.source);
                return this;
            }
        }
    }

    public static class Code
    extends BackboneElement {
        @Summary
        private final CodeableConcept code;
        @Summary
        @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.PREFERRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status")
        private final CodeableConcept status;
        @Summary
        private final DateTime statusDate;
        @Summary
        private final List<Annotation> note;
        @Summary
        @ReferenceTarget(value={"DocumentReference"})
        private final List<Reference> source;

        private Code(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.status = builder.status;
            this.statusDate = builder.statusDate;
            this.note = Collections.unmodifiableList(builder.note);
            this.source = Collections.unmodifiableList(builder.source);
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public CodeableConcept getStatus() {
            return this.status;
        }

        public DateTime getStatusDate() {
            return this.statusDate;
        }

        public List<Annotation> getNote() {
            return this.note;
        }

        public List<Reference> getSource() {
            return this.source;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.status != null || this.statusDate != null || !this.note.isEmpty() || !this.source.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.status, "status", visitor);
                    this.accept(this.statusDate, "statusDate", visitor);
                    this.accept(this.note, "note", visitor, Annotation.class);
                    this.accept(this.source, "source", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Code other = (Code)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.status, other.status) && Objects.equals(this.statusDate, other.statusDate) && Objects.equals(this.note, other.note) && Objects.equals(this.source, other.source);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.status, this.statusDate, this.note, this.source);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;
            private CodeableConcept status;
            private DateTime statusDate;
            private List<Annotation> note = new ArrayList<Annotation>();
            private List<Reference> source = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder status(CodeableConcept status) {
                this.status = status;
                return this;
            }

            public Builder statusDate(DateTime statusDate) {
                this.statusDate = statusDate;
                return this;
            }

            public Builder note(Annotation ... note) {
                for (Annotation value : note) {
                    this.note.add(value);
                }
                return this;
            }

            public Builder note(Collection<Annotation> note) {
                this.note = new ArrayList<Annotation>(note);
                return this;
            }

            public Builder source(Reference ... source) {
                for (Reference value : source) {
                    this.source.add(value);
                }
                return this;
            }

            public Builder source(Collection<Reference> source) {
                this.source = new ArrayList<Reference>(source);
                return this;
            }

            @Override
            public Code build() {
                Code code = new Code(this);
                if (this.validating) {
                    this.validate(code);
                }
                return code;
            }

            protected void validate(Code code) {
                super.validate(code);
                ValidationSupport.checkList(code.note, "note", Annotation.class);
                ValidationSupport.checkList(code.source, "source", Reference.class);
                ValidationSupport.checkReferenceType(code.source, "source", "DocumentReference");
                ValidationSupport.requireValueOrChildren(code);
            }

            protected Builder from(Code code) {
                super.from(code);
                this.code = code.code;
                this.status = code.status;
                this.statusDate = code.statusDate;
                this.note.addAll(code.note);
                this.source.addAll(code.source);
                return this;
            }
        }
    }

    public static class Structure
    extends BackboneElement {
        @Summary
        @Binding(bindingName="SubstanceStereochemistry", strength=BindingStrength.Value.EXAMPLE, description="The optical rotation type of a substance.", valueSet="http://hl7.org/fhir/ValueSet/substance-stereochemistry")
        private final CodeableConcept stereochemistry;
        @Summary
        @Binding(bindingName="SubstanceOpticalActivity", strength=BindingStrength.Value.EXAMPLE, description="The optical rotation type of a substance.", valueSet="http://hl7.org/fhir/ValueSet/substance-optical-activity")
        private final CodeableConcept opticalActivity;
        @Summary
        private final org.linuxforhealth.fhir.model.type.String molecularFormula;
        @Summary
        private final org.linuxforhealth.fhir.model.type.String molecularFormulaByMoiety;
        @Summary
        private final MolecularWeight molecularWeight;
        @Summary
        @Binding(bindingName="SubstanceStructureTechnique", strength=BindingStrength.Value.EXAMPLE, description="The method used to elucidate the structure or characterization of the drug substance.", valueSet="http://hl7.org/fhir/ValueSet/substance-structure-technique")
        private final List<CodeableConcept> technique;
        @Summary
        @ReferenceTarget(value={"DocumentReference"})
        private final List<Reference> sourceDocument;
        @Summary
        private final List<Representation> representation;

        private Structure(Builder builder) {
            super(builder);
            this.stereochemistry = builder.stereochemistry;
            this.opticalActivity = builder.opticalActivity;
            this.molecularFormula = builder.molecularFormula;
            this.molecularFormulaByMoiety = builder.molecularFormulaByMoiety;
            this.molecularWeight = builder.molecularWeight;
            this.technique = Collections.unmodifiableList(builder.technique);
            this.sourceDocument = Collections.unmodifiableList(builder.sourceDocument);
            this.representation = Collections.unmodifiableList(builder.representation);
        }

        public CodeableConcept getStereochemistry() {
            return this.stereochemistry;
        }

        public CodeableConcept getOpticalActivity() {
            return this.opticalActivity;
        }

        public org.linuxforhealth.fhir.model.type.String getMolecularFormula() {
            return this.molecularFormula;
        }

        public org.linuxforhealth.fhir.model.type.String getMolecularFormulaByMoiety() {
            return this.molecularFormulaByMoiety;
        }

        public MolecularWeight getMolecularWeight() {
            return this.molecularWeight;
        }

        public List<CodeableConcept> getTechnique() {
            return this.technique;
        }

        public List<Reference> getSourceDocument() {
            return this.sourceDocument;
        }

        public List<Representation> getRepresentation() {
            return this.representation;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.stereochemistry != null || this.opticalActivity != null || this.molecularFormula != null || this.molecularFormulaByMoiety != null || this.molecularWeight != null || !this.technique.isEmpty() || !this.sourceDocument.isEmpty() || !this.representation.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.stereochemistry, "stereochemistry", visitor);
                    this.accept(this.opticalActivity, "opticalActivity", visitor);
                    this.accept(this.molecularFormula, "molecularFormula", visitor);
                    this.accept(this.molecularFormulaByMoiety, "molecularFormulaByMoiety", visitor);
                    this.accept(this.molecularWeight, "molecularWeight", visitor);
                    this.accept(this.technique, "technique", visitor, CodeableConcept.class);
                    this.accept(this.sourceDocument, "sourceDocument", visitor, Reference.class);
                    this.accept(this.representation, "representation", visitor, Representation.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Structure other = (Structure)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.stereochemistry, other.stereochemistry) && Objects.equals(this.opticalActivity, other.opticalActivity) && Objects.equals(this.molecularFormula, other.molecularFormula) && Objects.equals(this.molecularFormulaByMoiety, other.molecularFormulaByMoiety) && Objects.equals(this.molecularWeight, other.molecularWeight) && Objects.equals(this.technique, other.technique) && Objects.equals(this.sourceDocument, other.sourceDocument) && Objects.equals(this.representation, other.representation);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.stereochemistry, this.opticalActivity, this.molecularFormula, this.molecularFormulaByMoiety, this.molecularWeight, this.technique, this.sourceDocument, this.representation);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Representation
        extends BackboneElement {
            @Summary
            @Binding(bindingName="SubstanceRepresentationType", strength=BindingStrength.Value.EXAMPLE, description="A format of a substance representation.", valueSet="http://hl7.org/fhir/ValueSet/substance-representation-type")
            private final CodeableConcept type;
            @Summary
            private final org.linuxforhealth.fhir.model.type.String representation;
            @Summary
            @Binding(bindingName="SubstanceRepresentationFormat", strength=BindingStrength.Value.EXAMPLE, description="A format of a substance representation.", valueSet="http://hl7.org/fhir/ValueSet/substance-representation-format")
            private final CodeableConcept format;
            @Summary
            @ReferenceTarget(value={"DocumentReference"})
            private final Reference document;

            private Representation(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.representation = builder.representation;
                this.format = builder.format;
                this.document = builder.document;
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public org.linuxforhealth.fhir.model.type.String getRepresentation() {
                return this.representation;
            }

            public CodeableConcept getFormat() {
                return this.format;
            }

            public Reference getDocument() {
                return this.document;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.representation != null || this.format != null || this.document != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.representation, "representation", visitor);
                        this.accept(this.format, "format", visitor);
                        this.accept(this.document, "document", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Representation other = (Representation)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.representation, other.representation) && Objects.equals(this.format, other.format) && Objects.equals(this.document, other.document);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.representation, this.format, this.document);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept type;
                private org.linuxforhealth.fhir.model.type.String representation;
                private CodeableConcept format;
                private Reference document;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder representation(String representation) {
                    this.representation = representation == null ? null : org.linuxforhealth.fhir.model.type.String.of(representation);
                    return this;
                }

                public Builder representation(org.linuxforhealth.fhir.model.type.String representation) {
                    this.representation = representation;
                    return this;
                }

                public Builder format(CodeableConcept format) {
                    this.format = format;
                    return this;
                }

                public Builder document(Reference document) {
                    this.document = document;
                    return this;
                }

                @Override
                public Representation build() {
                    Representation representation = new Representation(this);
                    if (this.validating) {
                        this.validate(representation);
                    }
                    return representation;
                }

                protected void validate(Representation representation) {
                    super.validate(representation);
                    ValidationSupport.checkReferenceType(representation.document, "document", "DocumentReference");
                    ValidationSupport.requireValueOrChildren(representation);
                }

                protected Builder from(Representation representation) {
                    super.from(representation);
                    this.type = representation.type;
                    this.representation = representation.representation;
                    this.format = representation.format;
                    this.document = representation.document;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept stereochemistry;
            private CodeableConcept opticalActivity;
            private org.linuxforhealth.fhir.model.type.String molecularFormula;
            private org.linuxforhealth.fhir.model.type.String molecularFormulaByMoiety;
            private MolecularWeight molecularWeight;
            private List<CodeableConcept> technique = new ArrayList<CodeableConcept>();
            private List<Reference> sourceDocument = new ArrayList<Reference>();
            private List<Representation> representation = new ArrayList<Representation>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder stereochemistry(CodeableConcept stereochemistry) {
                this.stereochemistry = stereochemistry;
                return this;
            }

            public Builder opticalActivity(CodeableConcept opticalActivity) {
                this.opticalActivity = opticalActivity;
                return this;
            }

            public Builder molecularFormula(String molecularFormula) {
                this.molecularFormula = molecularFormula == null ? null : org.linuxforhealth.fhir.model.type.String.of(molecularFormula);
                return this;
            }

            public Builder molecularFormula(org.linuxforhealth.fhir.model.type.String molecularFormula) {
                this.molecularFormula = molecularFormula;
                return this;
            }

            public Builder molecularFormulaByMoiety(String molecularFormulaByMoiety) {
                this.molecularFormulaByMoiety = molecularFormulaByMoiety == null ? null : org.linuxforhealth.fhir.model.type.String.of(molecularFormulaByMoiety);
                return this;
            }

            public Builder molecularFormulaByMoiety(org.linuxforhealth.fhir.model.type.String molecularFormulaByMoiety) {
                this.molecularFormulaByMoiety = molecularFormulaByMoiety;
                return this;
            }

            public Builder molecularWeight(MolecularWeight molecularWeight) {
                this.molecularWeight = molecularWeight;
                return this;
            }

            public Builder technique(CodeableConcept ... technique) {
                for (CodeableConcept value : technique) {
                    this.technique.add(value);
                }
                return this;
            }

            public Builder technique(Collection<CodeableConcept> technique) {
                this.technique = new ArrayList<CodeableConcept>(technique);
                return this;
            }

            public Builder sourceDocument(Reference ... sourceDocument) {
                for (Reference value : sourceDocument) {
                    this.sourceDocument.add(value);
                }
                return this;
            }

            public Builder sourceDocument(Collection<Reference> sourceDocument) {
                this.sourceDocument = new ArrayList<Reference>(sourceDocument);
                return this;
            }

            public Builder representation(Representation ... representation) {
                for (Representation value : representation) {
                    this.representation.add(value);
                }
                return this;
            }

            public Builder representation(Collection<Representation> representation) {
                this.representation = new ArrayList<Representation>(representation);
                return this;
            }

            @Override
            public Structure build() {
                Structure structure = new Structure(this);
                if (this.validating) {
                    this.validate(structure);
                }
                return structure;
            }

            protected void validate(Structure structure) {
                super.validate(structure);
                ValidationSupport.checkList(structure.technique, "technique", CodeableConcept.class);
                ValidationSupport.checkList(structure.sourceDocument, "sourceDocument", Reference.class);
                ValidationSupport.checkList(structure.representation, "representation", Representation.class);
                ValidationSupport.checkReferenceType(structure.sourceDocument, "sourceDocument", "DocumentReference");
                ValidationSupport.requireValueOrChildren(structure);
            }

            protected Builder from(Structure structure) {
                super.from(structure);
                this.stereochemistry = structure.stereochemistry;
                this.opticalActivity = structure.opticalActivity;
                this.molecularFormula = structure.molecularFormula;
                this.molecularFormulaByMoiety = structure.molecularFormulaByMoiety;
                this.molecularWeight = structure.molecularWeight;
                this.technique.addAll(structure.technique);
                this.sourceDocument.addAll(structure.sourceDocument);
                this.representation.addAll(structure.representation);
                return this;
            }
        }
    }

    public static class MolecularWeight
    extends BackboneElement {
        @Summary
        @Binding(bindingName="SubstanceWeightMethod", strength=BindingStrength.Value.EXAMPLE, description="The method by which the substance weight was measured.", valueSet="http://hl7.org/fhir/ValueSet/substance-weight-method")
        private final CodeableConcept method;
        @Summary
        @Binding(bindingName="SubstanceWeightType", strength=BindingStrength.Value.EXAMPLE, description="The type of substance weight measurement.", valueSet="http://hl7.org/fhir/ValueSet/substance-weight-type")
        private final CodeableConcept type;
        @Summary
        @Required
        private final Quantity amount;

        private MolecularWeight(Builder builder) {
            super(builder);
            this.method = builder.method;
            this.type = builder.type;
            this.amount = builder.amount;
        }

        public CodeableConcept getMethod() {
            return this.method;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Quantity getAmount() {
            return this.amount;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.method != null || this.type != null || this.amount != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.method, "method", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.amount, "amount", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MolecularWeight other = (MolecularWeight)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.method, other.method) && Objects.equals(this.type, other.type) && Objects.equals(this.amount, other.amount);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.method, this.type, this.amount);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept method;
            private CodeableConcept type;
            private Quantity amount;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder method(CodeableConcept method) {
                this.method = method;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder amount(Quantity amount) {
                this.amount = amount;
                return this;
            }

            @Override
            public MolecularWeight build() {
                MolecularWeight molecularWeight = new MolecularWeight(this);
                if (this.validating) {
                    this.validate(molecularWeight);
                }
                return molecularWeight;
            }

            protected void validate(MolecularWeight molecularWeight) {
                super.validate(molecularWeight);
                ValidationSupport.requireNonNull(molecularWeight.amount, "amount");
                ValidationSupport.requireValueOrChildren(molecularWeight);
            }

            protected Builder from(MolecularWeight molecularWeight) {
                super.from(molecularWeight);
                this.method = molecularWeight.method;
                this.type = molecularWeight.type;
                this.amount = molecularWeight.amount;
                return this;
            }
        }
    }

    public static class Property
    extends BackboneElement {
        @Summary
        @Binding(bindingName="SNOMEDCTCharacteristicCodes", strength=BindingStrength.Value.EXAMPLE, description="This value set includes all observable entity codes from SNOMED CT - provided as an exemplar value set.", valueSet="http://hl7.org/fhir/ValueSet/product-characteristic-codes")
        @Required
        private final CodeableConcept type;
        @Summary
        @Choice(value={CodeableConcept.class, Quantity.class, Date.class, Boolean.class, Attachment.class})
        private final Element value;

        private Property(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.value = builder.value;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Element getValue() {
            return this.value;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.value != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.value, "value", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Property other = (Property)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.value);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private Element value;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder value(LocalDate value) {
                this.value = value == null ? null : Date.of(value);
                return this;
            }

            public Builder value(java.lang.Boolean value) {
                this.value = value == null ? null : Boolean.of(value);
                return this;
            }

            public Builder value(Element value) {
                this.value = value;
                return this;
            }

            @Override
            public Property build() {
                Property property = new Property(this);
                if (this.validating) {
                    this.validate(property);
                }
                return property;
            }

            protected void validate(Property property) {
                super.validate(property);
                ValidationSupport.requireNonNull(property.type, "type");
                ValidationSupport.choiceElement(property.value, "value", CodeableConcept.class, Quantity.class, Date.class, Boolean.class, Attachment.class);
                ValidationSupport.requireValueOrChildren(property);
            }

            protected Builder from(Property property) {
                super.from(property);
                this.type = property.type;
                this.value = property.value;
                return this;
            }
        }
    }

    public static class Moiety
    extends BackboneElement {
        @Summary
        private final CodeableConcept role;
        @Summary
        private final Identifier identifier;
        @Summary
        private final org.linuxforhealth.fhir.model.type.String name;
        @Summary
        @Binding(bindingName="SubstanceStereochemistry", strength=BindingStrength.Value.EXAMPLE, description="The optical rotation type of a substance.", valueSet="http://hl7.org/fhir/ValueSet/substance-stereochemistry")
        private final CodeableConcept stereochemistry;
        @Summary
        @Binding(bindingName="SubstanceOpticalActivity", strength=BindingStrength.Value.EXAMPLE, description="The optical rotation type of a substance.", valueSet="http://hl7.org/fhir/ValueSet/substance-optical-activity")
        private final CodeableConcept opticalActivity;
        @Summary
        private final org.linuxforhealth.fhir.model.type.String molecularFormula;
        @Summary
        @Choice(value={Quantity.class, org.linuxforhealth.fhir.model.type.String.class})
        private final Element amount;
        @Summary
        @Binding(bindingName="SubstanceAmountType", strength=BindingStrength.Value.EXAMPLE, description="The relationship between two substance types.", valueSet="http://hl7.org/fhir/ValueSet/substance-amount-type")
        private final CodeableConcept measurementType;

        private Moiety(Builder builder) {
            super(builder);
            this.role = builder.role;
            this.identifier = builder.identifier;
            this.name = builder.name;
            this.stereochemistry = builder.stereochemistry;
            this.opticalActivity = builder.opticalActivity;
            this.molecularFormula = builder.molecularFormula;
            this.amount = builder.amount;
            this.measurementType = builder.measurementType;
        }

        public CodeableConcept getRole() {
            return this.role;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public org.linuxforhealth.fhir.model.type.String getName() {
            return this.name;
        }

        public CodeableConcept getStereochemistry() {
            return this.stereochemistry;
        }

        public CodeableConcept getOpticalActivity() {
            return this.opticalActivity;
        }

        public org.linuxforhealth.fhir.model.type.String getMolecularFormula() {
            return this.molecularFormula;
        }

        public Element getAmount() {
            return this.amount;
        }

        public CodeableConcept getMeasurementType() {
            return this.measurementType;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.role != null || this.identifier != null || this.name != null || this.stereochemistry != null || this.opticalActivity != null || this.molecularFormula != null || this.amount != null || this.measurementType != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.role, "role", visitor);
                    this.accept(this.identifier, "identifier", visitor);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.stereochemistry, "stereochemistry", visitor);
                    this.accept(this.opticalActivity, "opticalActivity", visitor);
                    this.accept(this.molecularFormula, "molecularFormula", visitor);
                    this.accept(this.amount, "amount", visitor);
                    this.accept(this.measurementType, "measurementType", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Moiety other = (Moiety)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.role, other.role) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.name, other.name) && Objects.equals(this.stereochemistry, other.stereochemistry) && Objects.equals(this.opticalActivity, other.opticalActivity) && Objects.equals(this.molecularFormula, other.molecularFormula) && Objects.equals(this.amount, other.amount) && Objects.equals(this.measurementType, other.measurementType);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.role, this.identifier, this.name, this.stereochemistry, this.opticalActivity, this.molecularFormula, this.amount, this.measurementType);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept role;
            private Identifier identifier;
            private org.linuxforhealth.fhir.model.type.String name;
            private CodeableConcept stereochemistry;
            private CodeableConcept opticalActivity;
            private org.linuxforhealth.fhir.model.type.String molecularFormula;
            private Element amount;
            private CodeableConcept measurementType;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder role(CodeableConcept role) {
                this.role = role;
                return this;
            }

            public Builder identifier(Identifier identifier) {
                this.identifier = identifier;
                return this;
            }

            public Builder name(String name) {
                this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
                return this;
            }

            public Builder name(org.linuxforhealth.fhir.model.type.String name) {
                this.name = name;
                return this;
            }

            public Builder stereochemistry(CodeableConcept stereochemistry) {
                this.stereochemistry = stereochemistry;
                return this;
            }

            public Builder opticalActivity(CodeableConcept opticalActivity) {
                this.opticalActivity = opticalActivity;
                return this;
            }

            public Builder molecularFormula(String molecularFormula) {
                this.molecularFormula = molecularFormula == null ? null : org.linuxforhealth.fhir.model.type.String.of(molecularFormula);
                return this;
            }

            public Builder molecularFormula(org.linuxforhealth.fhir.model.type.String molecularFormula) {
                this.molecularFormula = molecularFormula;
                return this;
            }

            public Builder amount(String amount) {
                this.amount = amount == null ? null : org.linuxforhealth.fhir.model.type.String.of(amount);
                return this;
            }

            public Builder amount(Element amount) {
                this.amount = amount;
                return this;
            }

            public Builder measurementType(CodeableConcept measurementType) {
                this.measurementType = measurementType;
                return this;
            }

            @Override
            public Moiety build() {
                Moiety moiety = new Moiety(this);
                if (this.validating) {
                    this.validate(moiety);
                }
                return moiety;
            }

            protected void validate(Moiety moiety) {
                super.validate(moiety);
                ValidationSupport.choiceElement(moiety.amount, "amount", Quantity.class, org.linuxforhealth.fhir.model.type.String.class);
                ValidationSupport.requireValueOrChildren(moiety);
            }

            protected Builder from(Moiety moiety) {
                super.from(moiety);
                this.role = moiety.role;
                this.identifier = moiety.identifier;
                this.name = moiety.name;
                this.stereochemistry = moiety.stereochemistry;
                this.opticalActivity = moiety.opticalActivity;
                this.molecularFormula = moiety.molecularFormula;
                this.amount = moiety.amount;
                this.measurementType = moiety.measurementType;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private org.linuxforhealth.fhir.model.type.String version;
        private CodeableConcept status;
        private List<CodeableConcept> classification = new ArrayList<CodeableConcept>();
        private CodeableConcept domain;
        private List<CodeableConcept> grade = new ArrayList<CodeableConcept>();
        private Markdown description;
        private List<Reference> informationSource = new ArrayList<Reference>();
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<Reference> manufacturer = new ArrayList<Reference>();
        private List<Reference> supplier = new ArrayList<Reference>();
        private List<Moiety> moiety = new ArrayList<Moiety>();
        private List<Property> property = new ArrayList<Property>();
        private List<MolecularWeight> molecularWeight = new ArrayList<MolecularWeight>();
        private Structure structure;
        private List<Code> code = new ArrayList<Code>();
        private List<Name> name = new ArrayList<Name>();
        private List<Relationship> relationship = new ArrayList<Relationship>();
        private SourceMaterial sourceMaterial;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(org.linuxforhealth.fhir.model.type.Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(String version) {
            this.version = version == null ? null : org.linuxforhealth.fhir.model.type.String.of(version);
            return this;
        }

        public Builder version(org.linuxforhealth.fhir.model.type.String version) {
            this.version = version;
            return this;
        }

        public Builder status(CodeableConcept status) {
            this.status = status;
            return this;
        }

        public Builder classification(CodeableConcept ... classification) {
            for (CodeableConcept value : classification) {
                this.classification.add(value);
            }
            return this;
        }

        public Builder classification(Collection<CodeableConcept> classification) {
            this.classification = new ArrayList<CodeableConcept>(classification);
            return this;
        }

        public Builder domain(CodeableConcept domain) {
            this.domain = domain;
            return this;
        }

        public Builder grade(CodeableConcept ... grade) {
            for (CodeableConcept value : grade) {
                this.grade.add(value);
            }
            return this;
        }

        public Builder grade(Collection<CodeableConcept> grade) {
            this.grade = new ArrayList<CodeableConcept>(grade);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder informationSource(Reference ... informationSource) {
            for (Reference value : informationSource) {
                this.informationSource.add(value);
            }
            return this;
        }

        public Builder informationSource(Collection<Reference> informationSource) {
            this.informationSource = new ArrayList<Reference>(informationSource);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder manufacturer(Reference ... manufacturer) {
            for (Reference value : manufacturer) {
                this.manufacturer.add(value);
            }
            return this;
        }

        public Builder manufacturer(Collection<Reference> manufacturer) {
            this.manufacturer = new ArrayList<Reference>(manufacturer);
            return this;
        }

        public Builder supplier(Reference ... supplier) {
            for (Reference value : supplier) {
                this.supplier.add(value);
            }
            return this;
        }

        public Builder supplier(Collection<Reference> supplier) {
            this.supplier = new ArrayList<Reference>(supplier);
            return this;
        }

        public Builder moiety(Moiety ... moiety) {
            for (Moiety value : moiety) {
                this.moiety.add(value);
            }
            return this;
        }

        public Builder moiety(Collection<Moiety> moiety) {
            this.moiety = new ArrayList<Moiety>(moiety);
            return this;
        }

        public Builder property(Property ... property) {
            for (Property value : property) {
                this.property.add(value);
            }
            return this;
        }

        public Builder property(Collection<Property> property) {
            this.property = new ArrayList<Property>(property);
            return this;
        }

        public Builder molecularWeight(MolecularWeight ... molecularWeight) {
            for (MolecularWeight value : molecularWeight) {
                this.molecularWeight.add(value);
            }
            return this;
        }

        public Builder molecularWeight(Collection<MolecularWeight> molecularWeight) {
            this.molecularWeight = new ArrayList<MolecularWeight>(molecularWeight);
            return this;
        }

        public Builder structure(Structure structure) {
            this.structure = structure;
            return this;
        }

        public Builder code(Code ... code) {
            for (Code value : code) {
                this.code.add(value);
            }
            return this;
        }

        public Builder code(Collection<Code> code) {
            this.code = new ArrayList<Code>(code);
            return this;
        }

        public Builder name(Name ... name) {
            for (Name value : name) {
                this.name.add(value);
            }
            return this;
        }

        public Builder name(Collection<Name> name) {
            this.name = new ArrayList<Name>(name);
            return this;
        }

        public Builder relationship(Relationship ... relationship) {
            for (Relationship value : relationship) {
                this.relationship.add(value);
            }
            return this;
        }

        public Builder relationship(Collection<Relationship> relationship) {
            this.relationship = new ArrayList<Relationship>(relationship);
            return this;
        }

        public Builder sourceMaterial(SourceMaterial sourceMaterial) {
            this.sourceMaterial = sourceMaterial;
            return this;
        }

        @Override
        public SubstanceDefinition build() {
            SubstanceDefinition substanceDefinition = new SubstanceDefinition(this);
            if (this.validating) {
                this.validate(substanceDefinition);
            }
            return substanceDefinition;
        }

        protected void validate(SubstanceDefinition substanceDefinition) {
            super.validate(substanceDefinition);
            ValidationSupport.checkList(substanceDefinition.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(substanceDefinition.classification, "classification", CodeableConcept.class);
            ValidationSupport.checkList(substanceDefinition.grade, "grade", CodeableConcept.class);
            ValidationSupport.checkList(substanceDefinition.informationSource, "informationSource", Reference.class);
            ValidationSupport.checkList(substanceDefinition.note, "note", Annotation.class);
            ValidationSupport.checkList(substanceDefinition.manufacturer, "manufacturer", Reference.class);
            ValidationSupport.checkList(substanceDefinition.supplier, "supplier", Reference.class);
            ValidationSupport.checkList(substanceDefinition.moiety, "moiety", Moiety.class);
            ValidationSupport.checkList(substanceDefinition.property, "property", Property.class);
            ValidationSupport.checkList(substanceDefinition.molecularWeight, "molecularWeight", MolecularWeight.class);
            ValidationSupport.checkList(substanceDefinition.code, "code", Code.class);
            ValidationSupport.checkList(substanceDefinition.name, "name", Name.class);
            ValidationSupport.checkList(substanceDefinition.relationship, "relationship", Relationship.class);
            ValidationSupport.checkReferenceType(substanceDefinition.informationSource, "informationSource", "Citation");
            ValidationSupport.checkReferenceType(substanceDefinition.manufacturer, "manufacturer", "Organization");
            ValidationSupport.checkReferenceType(substanceDefinition.supplier, "supplier", "Organization");
        }

        protected Builder from(SubstanceDefinition substanceDefinition) {
            super.from(substanceDefinition);
            this.identifier.addAll(substanceDefinition.identifier);
            this.version = substanceDefinition.version;
            this.status = substanceDefinition.status;
            this.classification.addAll(substanceDefinition.classification);
            this.domain = substanceDefinition.domain;
            this.grade.addAll(substanceDefinition.grade);
            this.description = substanceDefinition.description;
            this.informationSource.addAll(substanceDefinition.informationSource);
            this.note.addAll(substanceDefinition.note);
            this.manufacturer.addAll(substanceDefinition.manufacturer);
            this.supplier.addAll(substanceDefinition.supplier);
            this.moiety.addAll(substanceDefinition.moiety);
            this.property.addAll(substanceDefinition.property);
            this.molecularWeight.addAll(substanceDefinition.molecularWeight);
            this.structure = substanceDefinition.structure;
            this.code.addAll(substanceDefinition.code);
            this.name.addAll(substanceDefinition.name);
            this.relationship.addAll(substanceDefinition.relationship);
            this.sourceMaterial = substanceDefinition.sourceMaterial;
            return this;
        }
    }
}

