/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Quantity;
import org.linuxforhealth.fhir.model.type.Range;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Timing;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.RequestPriority;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.type.code.SupplyRequestStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
public class SupplyRequest
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="SupplyRequestStatus", strength=BindingStrength.Value.REQUIRED, description="Status of the supply request.", valueSet="http://hl7.org/fhir/ValueSet/supplyrequest-status|4.3.0")
    private final SupplyRequestStatus status;
    @Summary
    @Binding(bindingName="SupplyRequestKind", strength=BindingStrength.Value.EXAMPLE, description="Category of supply request.", valueSet="http://hl7.org/fhir/ValueSet/supplyrequest-kind")
    private final CodeableConcept category;
    @Summary
    @Binding(bindingName="RequestPriority", strength=BindingStrength.Value.REQUIRED, description="Identifies the level of importance to be assigned to actioning the request.", valueSet="http://hl7.org/fhir/ValueSet/request-priority|4.3.0")
    private final RequestPriority priority;
    @Summary
    @ReferenceTarget(value={"Medication", "Substance", "Device"})
    @Choice(value={CodeableConcept.class, Reference.class})
    @Binding(bindingName="SupplyRequestItem", strength=BindingStrength.Value.EXAMPLE, description="The item that was requested.", valueSet="http://hl7.org/fhir/ValueSet/supply-item")
    @Required
    private final Element item;
    @Summary
    @Required
    private final Quantity quantity;
    private final List<Parameter> parameter;
    @Summary
    @Choice(value={DateTime.class, Period.class, Timing.class})
    private final Element occurrence;
    @Summary
    private final DateTime authoredOn;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "Patient", "RelatedPerson", "Device"})
    private final Reference requester;
    @Summary
    @ReferenceTarget(value={"Organization", "HealthcareService"})
    private final List<Reference> supplier;
    @Binding(bindingName="SupplyRequestReason", strength=BindingStrength.Value.EXAMPLE, description="The reason why the supply item was requested.", valueSet="http://hl7.org/fhir/ValueSet/supplyrequest-reason")
    private final List<CodeableConcept> reasonCode;
    @ReferenceTarget(value={"Condition", "Observation", "DiagnosticReport", "DocumentReference"})
    private final List<Reference> reasonReference;
    @ReferenceTarget(value={"Organization", "Location"})
    private final Reference deliverFrom;
    @ReferenceTarget(value={"Organization", "Location", "Patient"})
    private final Reference deliverTo;

    private SupplyRequest(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.category = builder.category;
        this.priority = builder.priority;
        this.item = builder.item;
        this.quantity = builder.quantity;
        this.parameter = Collections.unmodifiableList(builder.parameter);
        this.occurrence = builder.occurrence;
        this.authoredOn = builder.authoredOn;
        this.requester = builder.requester;
        this.supplier = Collections.unmodifiableList(builder.supplier);
        this.reasonCode = Collections.unmodifiableList(builder.reasonCode);
        this.reasonReference = Collections.unmodifiableList(builder.reasonReference);
        this.deliverFrom = builder.deliverFrom;
        this.deliverTo = builder.deliverTo;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public SupplyRequestStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getCategory() {
        return this.category;
    }

    public RequestPriority getPriority() {
        return this.priority;
    }

    public Element getItem() {
        return this.item;
    }

    public Quantity getQuantity() {
        return this.quantity;
    }

    public List<Parameter> getParameter() {
        return this.parameter;
    }

    public Element getOccurrence() {
        return this.occurrence;
    }

    public DateTime getAuthoredOn() {
        return this.authoredOn;
    }

    public Reference getRequester() {
        return this.requester;
    }

    public List<Reference> getSupplier() {
        return this.supplier;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        return this.reasonReference;
    }

    public Reference getDeliverFrom() {
        return this.deliverFrom;
    }

    public Reference getDeliverTo() {
        return this.deliverTo;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.category != null || this.priority != null || this.item != null || this.quantity != null || !this.parameter.isEmpty() || this.occurrence != null || this.authoredOn != null || this.requester != null || !this.supplier.isEmpty() || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || this.deliverFrom != null || this.deliverTo != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.category, "category", visitor);
                this.accept(this.priority, "priority", visitor);
                this.accept(this.item, "item", visitor);
                this.accept(this.quantity, "quantity", visitor);
                this.accept(this.parameter, "parameter", visitor, Parameter.class);
                this.accept(this.occurrence, "occurrence", visitor);
                this.accept(this.authoredOn, "authoredOn", visitor);
                this.accept(this.requester, "requester", visitor);
                this.accept(this.supplier, "supplier", visitor, Reference.class);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                this.accept(this.deliverFrom, "deliverFrom", visitor);
                this.accept(this.deliverTo, "deliverTo", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SupplyRequest other = (SupplyRequest)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.category, other.category) && Objects.equals(this.priority, other.priority) && Objects.equals(this.item, other.item) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.parameter, other.parameter) && Objects.equals(this.occurrence, other.occurrence) && Objects.equals(this.authoredOn, other.authoredOn) && Objects.equals(this.requester, other.requester) && Objects.equals(this.supplier, other.supplier) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.deliverFrom, other.deliverFrom) && Objects.equals(this.deliverTo, other.deliverTo);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.category, this.priority, this.item, this.quantity, this.parameter, this.occurrence, this.authoredOn, this.requester, this.supplier, this.reasonCode, this.reasonReference, this.deliverFrom, this.deliverTo);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Parameter
    extends BackboneElement {
        @Binding(bindingName="ParameterCode", strength=BindingStrength.Value.EXAMPLE, description="A code that identifies the device detail.")
        private final CodeableConcept code;
        @Choice(value={CodeableConcept.class, Quantity.class, Range.class, Boolean.class})
        private final Element value;

        private Parameter(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.value = builder.value;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public Element getValue() {
            return this.value;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.value != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.value, "value", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Parameter other = (Parameter)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.value);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;
            private Element value;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder value(java.lang.Boolean value) {
                this.value = value == null ? null : Boolean.of(value);
                return this;
            }

            public Builder value(Element value) {
                this.value = value;
                return this;
            }

            @Override
            public Parameter build() {
                Parameter parameter = new Parameter(this);
                if (this.validating) {
                    this.validate(parameter);
                }
                return parameter;
            }

            protected void validate(Parameter parameter) {
                super.validate(parameter);
                ValidationSupport.choiceElement(parameter.value, "value", CodeableConcept.class, Quantity.class, Range.class, Boolean.class);
                ValidationSupport.requireValueOrChildren(parameter);
            }

            protected Builder from(Parameter parameter) {
                super.from(parameter);
                this.code = parameter.code;
                this.value = parameter.value;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private SupplyRequestStatus status;
        private CodeableConcept category;
        private RequestPriority priority;
        private Element item;
        private Quantity quantity;
        private List<Parameter> parameter = new ArrayList<Parameter>();
        private Element occurrence;
        private DateTime authoredOn;
        private Reference requester;
        private List<Reference> supplier = new ArrayList<Reference>();
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private List<Reference> reasonReference = new ArrayList<Reference>();
        private Reference deliverFrom;
        private Reference deliverTo;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(SupplyRequestStatus status) {
            this.status = status;
            return this;
        }

        public Builder category(CodeableConcept category) {
            this.category = category;
            return this;
        }

        public Builder priority(RequestPriority priority) {
            this.priority = priority;
            return this;
        }

        public Builder item(Element item) {
            this.item = item;
            return this;
        }

        public Builder quantity(Quantity quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder parameter(Parameter ... parameter) {
            for (Parameter value : parameter) {
                this.parameter.add(value);
            }
            return this;
        }

        public Builder parameter(Collection<Parameter> parameter) {
            this.parameter = new ArrayList<Parameter>(parameter);
            return this;
        }

        public Builder occurrence(Element occurrence) {
            this.occurrence = occurrence;
            return this;
        }

        public Builder authoredOn(DateTime authoredOn) {
            this.authoredOn = authoredOn;
            return this;
        }

        public Builder requester(Reference requester) {
            this.requester = requester;
            return this;
        }

        public Builder supplier(Reference ... supplier) {
            for (Reference value : supplier) {
                this.supplier.add(value);
            }
            return this;
        }

        public Builder supplier(Collection<Reference> supplier) {
            this.supplier = new ArrayList<Reference>(supplier);
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder reasonReference(Reference ... reasonReference) {
            for (Reference value : reasonReference) {
                this.reasonReference.add(value);
            }
            return this;
        }

        public Builder reasonReference(Collection<Reference> reasonReference) {
            this.reasonReference = new ArrayList<Reference>(reasonReference);
            return this;
        }

        public Builder deliverFrom(Reference deliverFrom) {
            this.deliverFrom = deliverFrom;
            return this;
        }

        public Builder deliverTo(Reference deliverTo) {
            this.deliverTo = deliverTo;
            return this;
        }

        @Override
        public SupplyRequest build() {
            SupplyRequest supplyRequest = new SupplyRequest(this);
            if (this.validating) {
                this.validate(supplyRequest);
            }
            return supplyRequest;
        }

        protected void validate(SupplyRequest supplyRequest) {
            super.validate(supplyRequest);
            ValidationSupport.checkList(supplyRequest.identifier, "identifier", Identifier.class);
            ValidationSupport.requireChoiceElement(supplyRequest.item, "item", CodeableConcept.class, Reference.class);
            ValidationSupport.requireNonNull(supplyRequest.quantity, "quantity");
            ValidationSupport.checkList(supplyRequest.parameter, "parameter", Parameter.class);
            ValidationSupport.choiceElement(supplyRequest.occurrence, "occurrence", DateTime.class, Period.class, Timing.class);
            ValidationSupport.checkList(supplyRequest.supplier, "supplier", Reference.class);
            ValidationSupport.checkList(supplyRequest.reasonCode, "reasonCode", CodeableConcept.class);
            ValidationSupport.checkList(supplyRequest.reasonReference, "reasonReference", Reference.class);
            ValidationSupport.checkReferenceType(supplyRequest.item, "item", "Medication", "Substance", "Device");
            ValidationSupport.checkReferenceType(supplyRequest.requester, "requester", "Practitioner", "PractitionerRole", "Organization", "Patient", "RelatedPerson", "Device");
            ValidationSupport.checkReferenceType(supplyRequest.supplier, "supplier", "Organization", "HealthcareService");
            ValidationSupport.checkReferenceType(supplyRequest.reasonReference, "reasonReference", "Condition", "Observation", "DiagnosticReport", "DocumentReference");
            ValidationSupport.checkReferenceType(supplyRequest.deliverFrom, "deliverFrom", "Organization", "Location");
            ValidationSupport.checkReferenceType(supplyRequest.deliverTo, "deliverTo", "Organization", "Location", "Patient");
        }

        protected Builder from(SupplyRequest supplyRequest) {
            super.from(supplyRequest);
            this.identifier.addAll(supplyRequest.identifier);
            this.status = supplyRequest.status;
            this.category = supplyRequest.category;
            this.priority = supplyRequest.priority;
            this.item = supplyRequest.item;
            this.quantity = supplyRequest.quantity;
            this.parameter.addAll(supplyRequest.parameter);
            this.occurrence = supplyRequest.occurrence;
            this.authoredOn = supplyRequest.authoredOn;
            this.requester = supplyRequest.requester;
            this.supplier.addAll(supplyRequest.supplier);
            this.reasonCode.addAll(supplyRequest.reasonCode);
            this.reasonReference.addAll(supplyRequest.reasonReference);
            this.deliverFrom = supplyRequest.deliverFrom;
            this.deliverTo = supplyRequest.deliverTo;
            return this;
        }
    }
}

