/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Decimal;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.type.code.TestReportActionResult;
import org.linuxforhealth.fhir.model.type.code.TestReportParticipantType;
import org.linuxforhealth.fhir.model.type.code.TestReportResult;
import org.linuxforhealth.fhir.model.type.code.TestReportStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="inv-1", level="Rule", location="TestReport.setup.action", description="Setup action SHALL contain either an operation or assert but not both.", expression="operation.exists() xor assert.exists()", source="http://hl7.org/fhir/StructureDefinition/TestReport"), @Constraint(id="inv-2", level="Rule", location="TestReport.test.action", description="Test action SHALL contain either an operation or assert but not both.", expression="operation.exists() xor assert.exists()", source="http://hl7.org/fhir/StructureDefinition/TestReport")})
public class TestReport
extends DomainResource {
    @Summary
    private final Identifier identifier;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String name;
    @Summary
    @Binding(bindingName="TestReportStatus", strength=BindingStrength.Value.REQUIRED, description="The current status of the test script execution.", valueSet="http://hl7.org/fhir/ValueSet/report-status-codes|4.3.0")
    @Required
    private final TestReportStatus status;
    @Summary
    @ReferenceTarget(value={"TestScript"})
    @Required
    private final Reference testScript;
    @Summary
    @Binding(bindingName="TestReportResult", strength=BindingStrength.Value.REQUIRED, description="The overall execution result of the TestScript.", valueSet="http://hl7.org/fhir/ValueSet/report-result-codes|4.3.0")
    @Required
    private final TestReportResult result;
    @Summary
    private final Decimal score;
    @Summary
    private final org.linuxforhealth.fhir.model.type.String tester;
    @Summary
    private final DateTime issued;
    private final List<Participant> participant;
    private final Setup setup;
    private final List<Test> test;
    private final Teardown teardown;

    private TestReport(Builder builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.status = builder.status;
        this.testScript = builder.testScript;
        this.result = builder.result;
        this.score = builder.score;
        this.tester = builder.tester;
        this.issued = builder.issued;
        this.participant = Collections.unmodifiableList(builder.participant);
        this.setup = builder.setup;
        this.test = Collections.unmodifiableList(builder.test);
        this.teardown = builder.teardown;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public org.linuxforhealth.fhir.model.type.String getName() {
        return this.name;
    }

    public TestReportStatus getStatus() {
        return this.status;
    }

    public Reference getTestScript() {
        return this.testScript;
    }

    public TestReportResult getResult() {
        return this.result;
    }

    public Decimal getScore() {
        return this.score;
    }

    public org.linuxforhealth.fhir.model.type.String getTester() {
        return this.tester;
    }

    public DateTime getIssued() {
        return this.issued;
    }

    public List<Participant> getParticipant() {
        return this.participant;
    }

    public Setup getSetup() {
        return this.setup;
    }

    public List<Test> getTest() {
        return this.test;
    }

    public Teardown getTeardown() {
        return this.teardown;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.identifier != null || this.name != null || this.status != null || this.testScript != null || this.result != null || this.score != null || this.tester != null || this.issued != null || !this.participant.isEmpty() || this.setup != null || !this.test.isEmpty() || this.teardown != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.testScript, "testScript", visitor);
                this.accept(this.result, "result", visitor);
                this.accept(this.score, "score", visitor);
                this.accept(this.tester, "tester", visitor);
                this.accept(this.issued, "issued", visitor);
                this.accept(this.participant, "participant", visitor, Participant.class);
                this.accept(this.setup, "setup", visitor);
                this.accept(this.test, "test", visitor, Test.class);
                this.accept(this.teardown, "teardown", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestReport other = (TestReport)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.name, other.name) && Objects.equals(this.status, other.status) && Objects.equals(this.testScript, other.testScript) && Objects.equals(this.result, other.result) && Objects.equals(this.score, other.score) && Objects.equals(this.tester, other.tester) && Objects.equals(this.issued, other.issued) && Objects.equals(this.participant, other.participant) && Objects.equals(this.setup, other.setup) && Objects.equals(this.test, other.test) && Objects.equals(this.teardown, other.teardown);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.name, this.status, this.testScript, this.result, this.score, this.tester, this.issued, this.participant, this.setup, this.test, this.teardown);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Teardown
    extends BackboneElement {
        @Required
        private final List<Action> action;

        private Teardown(Builder builder) {
            super(builder);
            this.action = Collections.unmodifiableList(builder.action);
        }

        public List<Action> getAction() {
            return this.action;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.action.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.action, "action", visitor, Action.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Teardown other = (Teardown)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.action, other.action);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.action);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Action
        extends BackboneElement {
            @Required
            private final Setup.Action.Operation operation;

            private Action(Builder builder) {
                super(builder);
                this.operation = builder.operation;
            }

            public Setup.Action.Operation getOperation() {
                return this.operation;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.operation != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.operation, "operation", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Action other = (Action)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.operation, other.operation);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.operation);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Setup.Action.Operation operation;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder operation(Setup.Action.Operation operation) {
                    this.operation = operation;
                    return this;
                }

                @Override
                public Action build() {
                    Action action = new Action(this);
                    if (this.validating) {
                        this.validate(action);
                    }
                    return action;
                }

                protected void validate(Action action) {
                    super.validate(action);
                    ValidationSupport.requireNonNull(action.operation, "operation");
                    ValidationSupport.requireValueOrChildren(action);
                }

                protected Builder from(Action action) {
                    super.from(action);
                    this.operation = action.operation;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Action> action = new ArrayList<Action>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder action(Action ... action) {
                for (Action value : action) {
                    this.action.add(value);
                }
                return this;
            }

            public Builder action(Collection<Action> action) {
                this.action = new ArrayList<Action>(action);
                return this;
            }

            @Override
            public Teardown build() {
                Teardown teardown = new Teardown(this);
                if (this.validating) {
                    this.validate(teardown);
                }
                return teardown;
            }

            protected void validate(Teardown teardown) {
                super.validate(teardown);
                ValidationSupport.checkNonEmptyList(teardown.action, "action", Action.class);
                ValidationSupport.requireValueOrChildren(teardown);
            }

            protected Builder from(Teardown teardown) {
                super.from(teardown);
                this.action.addAll(teardown.action);
                return this;
            }
        }
    }

    public static class Test
    extends BackboneElement {
        private final org.linuxforhealth.fhir.model.type.String name;
        private final org.linuxforhealth.fhir.model.type.String description;
        @Required
        private final List<Action> action;

        private Test(Builder builder) {
            super(builder);
            this.name = builder.name;
            this.description = builder.description;
            this.action = Collections.unmodifiableList(builder.action);
        }

        public org.linuxforhealth.fhir.model.type.String getName() {
            return this.name;
        }

        public org.linuxforhealth.fhir.model.type.String getDescription() {
            return this.description;
        }

        public List<Action> getAction() {
            return this.action;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.name != null || this.description != null || !this.action.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.action, "action", visitor, Action.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Test other = (Test)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.action, other.action);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.description, this.action);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Action
        extends BackboneElement {
            private final Setup.Action.Operation operation;
            private final Setup.Action.Assert _assert;

            private Action(Builder builder) {
                super(builder);
                this.operation = builder.operation;
                this._assert = builder._assert;
            }

            public Setup.Action.Operation getOperation() {
                return this.operation;
            }

            public Setup.Action.Assert getAssert() {
                return this._assert;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.operation != null || this._assert != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.operation, "operation", visitor);
                        this.accept(this._assert, "assert", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Action other = (Action)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.operation, other.operation) && Objects.equals(this._assert, other._assert);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.operation, this._assert);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Setup.Action.Operation operation;
                private Setup.Action.Assert _assert;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder operation(Setup.Action.Operation operation) {
                    this.operation = operation;
                    return this;
                }

                public Builder _assert(Setup.Action.Assert _assert) {
                    this._assert = _assert;
                    return this;
                }

                @Override
                public Action build() {
                    Action action = new Action(this);
                    if (this.validating) {
                        this.validate(action);
                    }
                    return action;
                }

                protected void validate(Action action) {
                    super.validate(action);
                    ValidationSupport.requireValueOrChildren(action);
                }

                protected Builder from(Action action) {
                    super.from(action);
                    this.operation = action.operation;
                    this._assert = action._assert;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private org.linuxforhealth.fhir.model.type.String name;
            private org.linuxforhealth.fhir.model.type.String description;
            private List<Action> action = new ArrayList<Action>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder name(String name) {
                this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
                return this;
            }

            public Builder name(org.linuxforhealth.fhir.model.type.String name) {
                this.name = name;
                return this;
            }

            public Builder description(String description) {
                this.description = description == null ? null : org.linuxforhealth.fhir.model.type.String.of(description);
                return this;
            }

            public Builder description(org.linuxforhealth.fhir.model.type.String description) {
                this.description = description;
                return this;
            }

            public Builder action(Action ... action) {
                for (Action value : action) {
                    this.action.add(value);
                }
                return this;
            }

            public Builder action(Collection<Action> action) {
                this.action = new ArrayList<Action>(action);
                return this;
            }

            @Override
            public Test build() {
                Test test = new Test(this);
                if (this.validating) {
                    this.validate(test);
                }
                return test;
            }

            protected void validate(Test test) {
                super.validate(test);
                ValidationSupport.checkNonEmptyList(test.action, "action", Action.class);
                ValidationSupport.requireValueOrChildren(test);
            }

            protected Builder from(Test test) {
                super.from(test);
                this.name = test.name;
                this.description = test.description;
                this.action.addAll(test.action);
                return this;
            }
        }
    }

    public static class Setup
    extends BackboneElement {
        @Required
        private final List<Action> action;

        private Setup(Builder builder) {
            super(builder);
            this.action = Collections.unmodifiableList(builder.action);
        }

        public List<Action> getAction() {
            return this.action;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.action.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.action, "action", visitor, Action.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Setup other = (Setup)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.action, other.action);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.action);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Action
        extends BackboneElement {
            private final Operation operation;
            private final Assert _assert;

            private Action(Builder builder) {
                super(builder);
                this.operation = builder.operation;
                this._assert = builder._assert;
            }

            public Operation getOperation() {
                return this.operation;
            }

            public Assert getAssert() {
                return this._assert;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.operation != null || this._assert != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.operation, "operation", visitor);
                        this.accept(this._assert, "assert", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Action other = (Action)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.operation, other.operation) && Objects.equals(this._assert, other._assert);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.operation, this._assert);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Assert
            extends BackboneElement {
                @Binding(bindingName="TestReportActionResult", strength=BindingStrength.Value.REQUIRED, description="The result of the execution of an individual action.", valueSet="http://hl7.org/fhir/ValueSet/report-action-result-codes|4.3.0")
                @Required
                private final TestReportActionResult result;
                private final Markdown message;
                private final org.linuxforhealth.fhir.model.type.String detail;

                private Assert(Builder builder) {
                    super(builder);
                    this.result = builder.result;
                    this.message = builder.message;
                    this.detail = builder.detail;
                }

                public TestReportActionResult getResult() {
                    return this.result;
                }

                public Markdown getMessage() {
                    return this.message;
                }

                public org.linuxforhealth.fhir.model.type.String getDetail() {
                    return this.detail;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.result != null || this.message != null || this.detail != null;
                }

                @Override
                public void accept(String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.result, "result", visitor);
                            this.accept(this.message, "message", visitor);
                            this.accept(this.detail, "detail", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Assert other = (Assert)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.result, other.result) && Objects.equals(this.message, other.message) && Objects.equals(this.detail, other.detail);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.result, this.message, this.detail);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private TestReportActionResult result;
                    private Markdown message;
                    private org.linuxforhealth.fhir.model.type.String detail;

                    private Builder() {
                    }

                    @Override
                    public Builder id(String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder result(TestReportActionResult result) {
                        this.result = result;
                        return this;
                    }

                    public Builder message(Markdown message) {
                        this.message = message;
                        return this;
                    }

                    public Builder detail(String detail) {
                        this.detail = detail == null ? null : org.linuxforhealth.fhir.model.type.String.of(detail);
                        return this;
                    }

                    public Builder detail(org.linuxforhealth.fhir.model.type.String detail) {
                        this.detail = detail;
                        return this;
                    }

                    @Override
                    public Assert build() {
                        Assert _assert = new Assert(this);
                        if (this.validating) {
                            this.validate(_assert);
                        }
                        return _assert;
                    }

                    protected void validate(Assert _assert) {
                        super.validate(_assert);
                        ValidationSupport.requireNonNull(_assert.result, "result");
                        ValidationSupport.requireValueOrChildren(_assert);
                    }

                    protected Builder from(Assert _assert) {
                        super.from(_assert);
                        this.result = _assert.result;
                        this.message = _assert.message;
                        this.detail = _assert.detail;
                        return this;
                    }
                }
            }

            public static class Operation
            extends BackboneElement {
                @Binding(bindingName="TestReportActionResult", strength=BindingStrength.Value.REQUIRED, description="The result of the execution of an individual action.", valueSet="http://hl7.org/fhir/ValueSet/report-action-result-codes|4.3.0")
                @Required
                private final TestReportActionResult result;
                private final Markdown message;
                private final Uri detail;

                private Operation(Builder builder) {
                    super(builder);
                    this.result = builder.result;
                    this.message = builder.message;
                    this.detail = builder.detail;
                }

                public TestReportActionResult getResult() {
                    return this.result;
                }

                public Markdown getMessage() {
                    return this.message;
                }

                public Uri getDetail() {
                    return this.detail;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.result != null || this.message != null || this.detail != null;
                }

                @Override
                public void accept(String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.result, "result", visitor);
                            this.accept(this.message, "message", visitor);
                            this.accept(this.detail, "detail", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Operation other = (Operation)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.result, other.result) && Objects.equals(this.message, other.message) && Objects.equals(this.detail, other.detail);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.result, this.message, this.detail);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private TestReportActionResult result;
                    private Markdown message;
                    private Uri detail;

                    private Builder() {
                    }

                    @Override
                    public Builder id(String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder result(TestReportActionResult result) {
                        this.result = result;
                        return this;
                    }

                    public Builder message(Markdown message) {
                        this.message = message;
                        return this;
                    }

                    public Builder detail(Uri detail) {
                        this.detail = detail;
                        return this;
                    }

                    @Override
                    public Operation build() {
                        Operation operation = new Operation(this);
                        if (this.validating) {
                            this.validate(operation);
                        }
                        return operation;
                    }

                    protected void validate(Operation operation) {
                        super.validate(operation);
                        ValidationSupport.requireNonNull(operation.result, "result");
                        ValidationSupport.requireValueOrChildren(operation);
                    }

                    protected Builder from(Operation operation) {
                        super.from(operation);
                        this.result = operation.result;
                        this.message = operation.message;
                        this.detail = operation.detail;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Operation operation;
                private Assert _assert;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder operation(Operation operation) {
                    this.operation = operation;
                    return this;
                }

                public Builder _assert(Assert _assert) {
                    this._assert = _assert;
                    return this;
                }

                @Override
                public Action build() {
                    Action action = new Action(this);
                    if (this.validating) {
                        this.validate(action);
                    }
                    return action;
                }

                protected void validate(Action action) {
                    super.validate(action);
                    ValidationSupport.requireValueOrChildren(action);
                }

                protected Builder from(Action action) {
                    super.from(action);
                    this.operation = action.operation;
                    this._assert = action._assert;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Action> action = new ArrayList<Action>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder action(Action ... action) {
                for (Action value : action) {
                    this.action.add(value);
                }
                return this;
            }

            public Builder action(Collection<Action> action) {
                this.action = new ArrayList<Action>(action);
                return this;
            }

            @Override
            public Setup build() {
                Setup setup = new Setup(this);
                if (this.validating) {
                    this.validate(setup);
                }
                return setup;
            }

            protected void validate(Setup setup) {
                super.validate(setup);
                ValidationSupport.checkNonEmptyList(setup.action, "action", Action.class);
                ValidationSupport.requireValueOrChildren(setup);
            }

            protected Builder from(Setup setup) {
                super.from(setup);
                this.action.addAll(setup.action);
                return this;
            }
        }
    }

    public static class Participant
    extends BackboneElement {
        @Binding(bindingName="TestReportParticipantType", strength=BindingStrength.Value.REQUIRED, description="The type of participant.", valueSet="http://hl7.org/fhir/ValueSet/report-participant-type|4.3.0")
        @Required
        private final TestReportParticipantType type;
        @Required
        private final Uri uri;
        private final org.linuxforhealth.fhir.model.type.String display;

        private Participant(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.uri = builder.uri;
            this.display = builder.display;
        }

        public TestReportParticipantType getType() {
            return this.type;
        }

        public Uri getUri() {
            return this.uri;
        }

        public org.linuxforhealth.fhir.model.type.String getDisplay() {
            return this.display;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.uri != null || this.display != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.uri, "uri", visitor);
                    this.accept(this.display, "display", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Participant other = (Participant)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.uri, other.uri) && Objects.equals(this.display, other.display);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.uri, this.display);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private TestReportParticipantType type;
            private Uri uri;
            private org.linuxforhealth.fhir.model.type.String display;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(TestReportParticipantType type) {
                this.type = type;
                return this;
            }

            public Builder uri(Uri uri) {
                this.uri = uri;
                return this;
            }

            public Builder display(String display) {
                this.display = display == null ? null : org.linuxforhealth.fhir.model.type.String.of(display);
                return this;
            }

            public Builder display(org.linuxforhealth.fhir.model.type.String display) {
                this.display = display;
                return this;
            }

            @Override
            public Participant build() {
                Participant participant = new Participant(this);
                if (this.validating) {
                    this.validate(participant);
                }
                return participant;
            }

            protected void validate(Participant participant) {
                super.validate(participant);
                ValidationSupport.requireNonNull(participant.type, "type");
                ValidationSupport.requireNonNull(participant.uri, "uri");
                ValidationSupport.requireValueOrChildren(participant);
            }

            protected Builder from(Participant participant) {
                super.from(participant);
                this.type = participant.type;
                this.uri = participant.uri;
                this.display = participant.display;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Identifier identifier;
        private org.linuxforhealth.fhir.model.type.String name;
        private TestReportStatus status;
        private Reference testScript;
        private TestReportResult result;
        private Decimal score;
        private org.linuxforhealth.fhir.model.type.String tester;
        private DateTime issued;
        private List<Participant> participant = new ArrayList<Participant>();
        private Setup setup;
        private List<Test> test = new ArrayList<Test>();
        private Teardown teardown;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder name(String name) {
            this.name = name == null ? null : org.linuxforhealth.fhir.model.type.String.of(name);
            return this;
        }

        public Builder name(org.linuxforhealth.fhir.model.type.String name) {
            this.name = name;
            return this;
        }

        public Builder status(TestReportStatus status) {
            this.status = status;
            return this;
        }

        public Builder testScript(Reference testScript) {
            this.testScript = testScript;
            return this;
        }

        public Builder result(TestReportResult result) {
            this.result = result;
            return this;
        }

        public Builder score(Decimal score) {
            this.score = score;
            return this;
        }

        public Builder tester(String tester) {
            this.tester = tester == null ? null : org.linuxforhealth.fhir.model.type.String.of(tester);
            return this;
        }

        public Builder tester(org.linuxforhealth.fhir.model.type.String tester) {
            this.tester = tester;
            return this;
        }

        public Builder issued(DateTime issued) {
            this.issued = issued;
            return this;
        }

        public Builder participant(Participant ... participant) {
            for (Participant value : participant) {
                this.participant.add(value);
            }
            return this;
        }

        public Builder participant(Collection<Participant> participant) {
            this.participant = new ArrayList<Participant>(participant);
            return this;
        }

        public Builder setup(Setup setup) {
            this.setup = setup;
            return this;
        }

        public Builder test(Test ... test) {
            for (Test value : test) {
                this.test.add(value);
            }
            return this;
        }

        public Builder test(Collection<Test> test) {
            this.test = new ArrayList<Test>(test);
            return this;
        }

        public Builder teardown(Teardown teardown) {
            this.teardown = teardown;
            return this;
        }

        @Override
        public TestReport build() {
            TestReport testReport = new TestReport(this);
            if (this.validating) {
                this.validate(testReport);
            }
            return testReport;
        }

        protected void validate(TestReport testReport) {
            super.validate(testReport);
            ValidationSupport.requireNonNull(testReport.status, "status");
            ValidationSupport.requireNonNull(testReport.testScript, "testScript");
            ValidationSupport.requireNonNull(testReport.result, "result");
            ValidationSupport.checkList(testReport.participant, "participant", Participant.class);
            ValidationSupport.checkList(testReport.test, "test", Test.class);
            ValidationSupport.checkReferenceType(testReport.testScript, "testScript", "TestScript");
        }

        protected Builder from(TestReport testReport) {
            super.from(testReport);
            this.identifier = testReport.identifier;
            this.name = testReport.name;
            this.status = testReport.status;
            this.testScript = testReport.testScript;
            this.result = testReport.result;
            this.score = testReport.score;
            this.tester = testReport.tester;
            this.issued = testReport.issued;
            this.participant.addAll(testReport.participant);
            this.setup = testReport.setup;
            this.test.addAll(testReport.test);
            this.teardown = testReport.teardown;
            return this;
        }
    }
}

