/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Maturity;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Annotation;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Decimal;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Integer;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Narrative;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.SimpleQuantity;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.StandardsStatus;
import org.linuxforhealth.fhir.model.type.code.VisionBase;
import org.linuxforhealth.fhir.model.type.code.VisionEyes;
import org.linuxforhealth.fhir.model.type.code.VisionStatus;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
public class VisionPrescription
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="VisionStatus", strength=BindingStrength.Value.REQUIRED, description="A code specifying the state of the resource instance.", valueSet="http://hl7.org/fhir/ValueSet/fm-status|4.3.0")
    @Required
    private final VisionStatus status;
    @Summary
    @Required
    private final DateTime created;
    @Summary
    @ReferenceTarget(value={"Patient"})
    @Required
    private final Reference patient;
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    @Required
    private final DateTime dateWritten;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
    @Required
    private final Reference prescriber;
    @Summary
    @Required
    private final List<LensSpecification> lensSpecification;

    private VisionPrescription(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.created = builder.created;
        this.patient = builder.patient;
        this.encounter = builder.encounter;
        this.dateWritten = builder.dateWritten;
        this.prescriber = builder.prescriber;
        this.lensSpecification = Collections.unmodifiableList(builder.lensSpecification);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public VisionStatus getStatus() {
        return this.status;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public DateTime getDateWritten() {
        return this.dateWritten;
    }

    public Reference getPrescriber() {
        return this.prescriber;
    }

    public List<LensSpecification> getLensSpecification() {
        return this.lensSpecification;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.created != null || this.patient != null || this.encounter != null || this.dateWritten != null || this.prescriber != null || !this.lensSpecification.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.created, "created", visitor);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.dateWritten, "dateWritten", visitor);
                this.accept(this.prescriber, "prescriber", visitor);
                this.accept(this.lensSpecification, "lensSpecification", visitor, LensSpecification.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VisionPrescription other = (VisionPrescription)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.created, other.created) && Objects.equals(this.patient, other.patient) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.dateWritten, other.dateWritten) && Objects.equals(this.prescriber, other.prescriber) && Objects.equals(this.lensSpecification, other.lensSpecification);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.created, this.patient, this.encounter, this.dateWritten, this.prescriber, this.lensSpecification);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class LensSpecification
    extends BackboneElement {
        @Summary
        @Binding(bindingName="VisionProduct", strength=BindingStrength.Value.EXAMPLE, description="A coded concept describing the vision products.", valueSet="http://hl7.org/fhir/ValueSet/vision-product")
        @Required
        private final CodeableConcept product;
        @Summary
        @Binding(bindingName="VisionEyes", strength=BindingStrength.Value.REQUIRED, description="A coded concept listing the eye codes.", valueSet="http://hl7.org/fhir/ValueSet/vision-eye-codes|4.3.0")
        @Required
        private final VisionEyes eye;
        private final Decimal sphere;
        private final Decimal cylinder;
        private final Integer axis;
        private final List<Prism> prism;
        private final Decimal add;
        private final Decimal power;
        private final Decimal backCurve;
        private final Decimal diameter;
        private final SimpleQuantity duration;
        private final String color;
        private final String brand;
        private final List<Annotation> note;

        private LensSpecification(Builder builder) {
            super(builder);
            this.product = builder.product;
            this.eye = builder.eye;
            this.sphere = builder.sphere;
            this.cylinder = builder.cylinder;
            this.axis = builder.axis;
            this.prism = Collections.unmodifiableList(builder.prism);
            this.add = builder.add;
            this.power = builder.power;
            this.backCurve = builder.backCurve;
            this.diameter = builder.diameter;
            this.duration = builder.duration;
            this.color = builder.color;
            this.brand = builder.brand;
            this.note = Collections.unmodifiableList(builder.note);
        }

        public CodeableConcept getProduct() {
            return this.product;
        }

        public VisionEyes getEye() {
            return this.eye;
        }

        public Decimal getSphere() {
            return this.sphere;
        }

        public Decimal getCylinder() {
            return this.cylinder;
        }

        public Integer getAxis() {
            return this.axis;
        }

        public List<Prism> getPrism() {
            return this.prism;
        }

        public Decimal getAdd() {
            return this.add;
        }

        public Decimal getPower() {
            return this.power;
        }

        public Decimal getBackCurve() {
            return this.backCurve;
        }

        public Decimal getDiameter() {
            return this.diameter;
        }

        public SimpleQuantity getDuration() {
            return this.duration;
        }

        public String getColor() {
            return this.color;
        }

        public String getBrand() {
            return this.brand;
        }

        public List<Annotation> getNote() {
            return this.note;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.product != null || this.eye != null || this.sphere != null || this.cylinder != null || this.axis != null || !this.prism.isEmpty() || this.add != null || this.power != null || this.backCurve != null || this.diameter != null || this.duration != null || this.color != null || this.brand != null || !this.note.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.product, "product", visitor);
                    this.accept(this.eye, "eye", visitor);
                    this.accept(this.sphere, "sphere", visitor);
                    this.accept(this.cylinder, "cylinder", visitor);
                    this.accept(this.axis, "axis", visitor);
                    this.accept(this.prism, "prism", visitor, Prism.class);
                    this.accept(this.add, "add", visitor);
                    this.accept(this.power, "power", visitor);
                    this.accept(this.backCurve, "backCurve", visitor);
                    this.accept(this.diameter, "diameter", visitor);
                    this.accept(this.duration, "duration", visitor);
                    this.accept(this.color, "color", visitor);
                    this.accept(this.brand, "brand", visitor);
                    this.accept(this.note, "note", visitor, Annotation.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LensSpecification other = (LensSpecification)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.product, other.product) && Objects.equals(this.eye, other.eye) && Objects.equals(this.sphere, other.sphere) && Objects.equals(this.cylinder, other.cylinder) && Objects.equals(this.axis, other.axis) && Objects.equals(this.prism, other.prism) && Objects.equals(this.add, other.add) && Objects.equals(this.power, other.power) && Objects.equals(this.backCurve, other.backCurve) && Objects.equals(this.diameter, other.diameter) && Objects.equals(this.duration, other.duration) && Objects.equals(this.color, other.color) && Objects.equals(this.brand, other.brand) && Objects.equals(this.note, other.note);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.product, this.eye, this.sphere, this.cylinder, this.axis, this.prism, this.add, this.power, this.backCurve, this.diameter, this.duration, this.color, this.brand, this.note);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Prism
        extends BackboneElement {
            @Required
            private final Decimal amount;
            @Binding(bindingName="VisionBase", strength=BindingStrength.Value.REQUIRED, description="A coded concept listing the base codes.", valueSet="http://hl7.org/fhir/ValueSet/vision-base-codes|4.3.0")
            @Required
            private final VisionBase base;

            private Prism(Builder builder) {
                super(builder);
                this.amount = builder.amount;
                this.base = builder.base;
            }

            public Decimal getAmount() {
                return this.amount;
            }

            public VisionBase getBase() {
                return this.base;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.amount != null || this.base != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.amount, "amount", visitor);
                        this.accept(this.base, "base", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Prism other = (Prism)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.amount, other.amount) && Objects.equals(this.base, other.base);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.amount, this.base);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Decimal amount;
                private VisionBase base;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder amount(Decimal amount) {
                    this.amount = amount;
                    return this;
                }

                public Builder base(VisionBase base) {
                    this.base = base;
                    return this;
                }

                @Override
                public Prism build() {
                    Prism prism = new Prism(this);
                    if (this.validating) {
                        this.validate(prism);
                    }
                    return prism;
                }

                protected void validate(Prism prism) {
                    super.validate(prism);
                    ValidationSupport.requireNonNull(prism.amount, "amount");
                    ValidationSupport.requireNonNull(prism.base, "base");
                    ValidationSupport.requireValueOrChildren(prism);
                }

                protected Builder from(Prism prism) {
                    super.from(prism);
                    this.amount = prism.amount;
                    this.base = prism.base;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept product;
            private VisionEyes eye;
            private Decimal sphere;
            private Decimal cylinder;
            private Integer axis;
            private List<Prism> prism = new ArrayList<Prism>();
            private Decimal add;
            private Decimal power;
            private Decimal backCurve;
            private Decimal diameter;
            private SimpleQuantity duration;
            private String color;
            private String brand;
            private List<Annotation> note = new ArrayList<Annotation>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder product(CodeableConcept product) {
                this.product = product;
                return this;
            }

            public Builder eye(VisionEyes eye) {
                this.eye = eye;
                return this;
            }

            public Builder sphere(Decimal sphere) {
                this.sphere = sphere;
                return this;
            }

            public Builder cylinder(Decimal cylinder) {
                this.cylinder = cylinder;
                return this;
            }

            public Builder axis(java.lang.Integer axis) {
                this.axis = axis == null ? null : Integer.of(axis);
                return this;
            }

            public Builder axis(Integer axis) {
                this.axis = axis;
                return this;
            }

            public Builder prism(Prism ... prism) {
                for (Prism value : prism) {
                    this.prism.add(value);
                }
                return this;
            }

            public Builder prism(Collection<Prism> prism) {
                this.prism = new ArrayList<Prism>(prism);
                return this;
            }

            public Builder add(Decimal add) {
                this.add = add;
                return this;
            }

            public Builder power(Decimal power) {
                this.power = power;
                return this;
            }

            public Builder backCurve(Decimal backCurve) {
                this.backCurve = backCurve;
                return this;
            }

            public Builder diameter(Decimal diameter) {
                this.diameter = diameter;
                return this;
            }

            public Builder duration(SimpleQuantity duration) {
                this.duration = duration;
                return this;
            }

            public Builder color(java.lang.String color) {
                this.color = color == null ? null : String.of(color);
                return this;
            }

            public Builder color(String color) {
                this.color = color;
                return this;
            }

            public Builder brand(java.lang.String brand) {
                this.brand = brand == null ? null : String.of(brand);
                return this;
            }

            public Builder brand(String brand) {
                this.brand = brand;
                return this;
            }

            public Builder note(Annotation ... note) {
                for (Annotation value : note) {
                    this.note.add(value);
                }
                return this;
            }

            public Builder note(Collection<Annotation> note) {
                this.note = new ArrayList<Annotation>(note);
                return this;
            }

            @Override
            public LensSpecification build() {
                LensSpecification lensSpecification = new LensSpecification(this);
                if (this.validating) {
                    this.validate(lensSpecification);
                }
                return lensSpecification;
            }

            protected void validate(LensSpecification lensSpecification) {
                super.validate(lensSpecification);
                ValidationSupport.requireNonNull(lensSpecification.product, "product");
                ValidationSupport.requireNonNull(lensSpecification.eye, "eye");
                ValidationSupport.checkList(lensSpecification.prism, "prism", Prism.class);
                ValidationSupport.checkList(lensSpecification.note, "note", Annotation.class);
                ValidationSupport.requireValueOrChildren(lensSpecification);
            }

            protected Builder from(LensSpecification lensSpecification) {
                super.from(lensSpecification);
                this.product = lensSpecification.product;
                this.eye = lensSpecification.eye;
                this.sphere = lensSpecification.sphere;
                this.cylinder = lensSpecification.cylinder;
                this.axis = lensSpecification.axis;
                this.prism.addAll(lensSpecification.prism);
                this.add = lensSpecification.add;
                this.power = lensSpecification.power;
                this.backCurve = lensSpecification.backCurve;
                this.diameter = lensSpecification.diameter;
                this.duration = lensSpecification.duration;
                this.color = lensSpecification.color;
                this.brand = lensSpecification.brand;
                this.note.addAll(lensSpecification.note);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private VisionStatus status;
        private DateTime created;
        private Reference patient;
        private Reference encounter;
        private DateTime dateWritten;
        private Reference prescriber;
        private List<LensSpecification> lensSpecification = new ArrayList<LensSpecification>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(VisionStatus status) {
            this.status = status;
            return this;
        }

        public Builder created(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder dateWritten(DateTime dateWritten) {
            this.dateWritten = dateWritten;
            return this;
        }

        public Builder prescriber(Reference prescriber) {
            this.prescriber = prescriber;
            return this;
        }

        public Builder lensSpecification(LensSpecification ... lensSpecification) {
            for (LensSpecification value : lensSpecification) {
                this.lensSpecification.add(value);
            }
            return this;
        }

        public Builder lensSpecification(Collection<LensSpecification> lensSpecification) {
            this.lensSpecification = new ArrayList<LensSpecification>(lensSpecification);
            return this;
        }

        @Override
        public VisionPrescription build() {
            VisionPrescription visionPrescription = new VisionPrescription(this);
            if (this.validating) {
                this.validate(visionPrescription);
            }
            return visionPrescription;
        }

        protected void validate(VisionPrescription visionPrescription) {
            super.validate(visionPrescription);
            ValidationSupport.checkList(visionPrescription.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(visionPrescription.status, "status");
            ValidationSupport.requireNonNull(visionPrescription.created, "created");
            ValidationSupport.requireNonNull(visionPrescription.patient, "patient");
            ValidationSupport.requireNonNull(visionPrescription.dateWritten, "dateWritten");
            ValidationSupport.requireNonNull(visionPrescription.prescriber, "prescriber");
            ValidationSupport.checkNonEmptyList(visionPrescription.lensSpecification, "lensSpecification", LensSpecification.class);
            ValidationSupport.checkReferenceType(visionPrescription.patient, "patient", "Patient");
            ValidationSupport.checkReferenceType(visionPrescription.encounter, "encounter", "Encounter");
            ValidationSupport.checkReferenceType(visionPrescription.prescriber, "prescriber", "Practitioner", "PractitionerRole");
        }

        protected Builder from(VisionPrescription visionPrescription) {
            super.from(visionPrescription);
            this.identifier.addAll(visionPrescription.identifier);
            this.status = visionPrescription.status;
            this.created = visionPrescription.created;
            this.patient = visionPrescription.patient;
            this.encounter = visionPrescription.encounter;
            this.dateWritten = visionPrescription.dateWritten;
            this.prescriber = visionPrescription.prescriber;
            this.lensSpecification.addAll(visionPrescription.lensSpecification);
            return this;
        }
    }
}

