/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.string.util;

import org.linuxforhealth.fhir.exception.FHIROperationException;
import org.linuxforhealth.fhir.model.resource.OperationOutcome;
import org.linuxforhealth.fhir.model.string.util.strategy.MaxBytesStringSizeControlStrategy;
import org.linuxforhealth.fhir.model.string.util.strategy.StringSizeControlStrategy;
import org.linuxforhealth.fhir.model.type.code.IssueType;
import org.linuxforhealth.fhir.model.util.FHIRUtil;

public class StringSizeControlStrategyFactory {
    private static final StringSizeControlStrategyFactory FACTORY = new StringSizeControlStrategyFactory();

    private StringSizeControlStrategyFactory() {
    }

    public static StringSizeControlStrategyFactory factory() {
        return FACTORY;
    }

    public StringSizeControlStrategy getStrategy(Strategy strategyIdentifier) throws FHIROperationException {
        switch (strategyIdentifier) {
            case MAX_BYTES: {
                return new MaxBytesStringSizeControlStrategy();
            }
        }
        String message = "The StringSizeControlStrategy is not found [" + strategyIdentifier + "]";
        OperationOutcome.Issue ooi = FHIRUtil.buildOperationOutcomeIssue(message, IssueType.EXCEPTION);
        throw new FHIROperationException(message, null).withIssue(ooi);
    }

    public static enum Strategy {
        MAX_BYTES("max_bytes");

        public String value;

        private Strategy(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

