/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.code.AddressType;
import org.linuxforhealth.fhir.model.type.code.AddressUse;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

public class Address
extends Element {
    @Summary
    @Binding(bindingName="AddressUse", strength=BindingStrength.Value.REQUIRED, description="The use of an address (home / work / etc.).", valueSet="http://hl7.org/fhir/ValueSet/address-use|4.3.0")
    private final AddressUse use;
    @Summary
    @Binding(bindingName="AddressType", strength=BindingStrength.Value.REQUIRED, description="The type of an address (physical / postal).", valueSet="http://hl7.org/fhir/ValueSet/address-type|4.3.0")
    private final AddressType type;
    @Summary
    private final String text;
    @Summary
    private final List<String> line;
    @Summary
    private final String city;
    @Summary
    private final String district;
    @Summary
    private final String state;
    @Summary
    private final String postalCode;
    @Summary
    private final String country;
    @Summary
    private final Period period;

    private Address(Builder builder) {
        super(builder);
        this.use = builder.use;
        this.type = builder.type;
        this.text = builder.text;
        this.line = Collections.unmodifiableList(builder.line);
        this.city = builder.city;
        this.district = builder.district;
        this.state = builder.state;
        this.postalCode = builder.postalCode;
        this.country = builder.country;
        this.period = builder.period;
    }

    public AddressUse getUse() {
        return this.use;
    }

    public AddressType getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public List<String> getLine() {
        return this.line;
    }

    public String getCity() {
        return this.city;
    }

    public String getDistrict() {
        return this.district;
    }

    public String getState() {
        return this.state;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getCountry() {
        return this.country;
    }

    public Period getPeriod() {
        return this.period;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.use != null || this.type != null || this.text != null || !this.line.isEmpty() || this.city != null || this.district != null || this.state != null || this.postalCode != null || this.country != null || this.period != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.use, "use", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.line, "line", visitor, String.class);
                this.accept(this.city, "city", visitor);
                this.accept(this.district, "district", visitor);
                this.accept(this.state, "state", visitor);
                this.accept(this.postalCode, "postalCode", visitor);
                this.accept(this.country, "country", visitor);
                this.accept(this.period, "period", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Address other = (Address)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.use, other.use) && Objects.equals(this.type, other.type) && Objects.equals(this.text, other.text) && Objects.equals(this.line, other.line) && Objects.equals(this.city, other.city) && Objects.equals(this.district, other.district) && Objects.equals(this.state, other.state) && Objects.equals(this.postalCode, other.postalCode) && Objects.equals(this.country, other.country) && Objects.equals(this.period, other.period);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.use, this.type, this.text, this.line, this.city, this.district, this.state, this.postalCode, this.country, this.period);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private AddressUse use;
        private AddressType type;
        private String text;
        private List<String> line = new ArrayList<String>();
        private String city;
        private String district;
        private String state;
        private String postalCode;
        private String country;
        private Period period;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder use(AddressUse use) {
            this.use = use;
            return this;
        }

        public Builder type(AddressType type) {
            this.type = type;
            return this;
        }

        public Builder text(java.lang.String text) {
            this.text = text == null ? null : String.of(text);
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder line(java.lang.String ... line) {
            for (java.lang.String value : line) {
                this.line.add(value == null ? null : String.of(value));
            }
            return this;
        }

        public Builder line(String ... line) {
            for (String value : line) {
                this.line.add(value);
            }
            return this;
        }

        public Builder line(Collection<String> line) {
            this.line = new ArrayList<String>(line);
            return this;
        }

        public Builder city(java.lang.String city) {
            this.city = city == null ? null : String.of(city);
            return this;
        }

        public Builder city(String city) {
            this.city = city;
            return this;
        }

        public Builder district(java.lang.String district) {
            this.district = district == null ? null : String.of(district);
            return this;
        }

        public Builder district(String district) {
            this.district = district;
            return this;
        }

        public Builder state(java.lang.String state) {
            this.state = state == null ? null : String.of(state);
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder postalCode(java.lang.String postalCode) {
            this.postalCode = postalCode == null ? null : String.of(postalCode);
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public Builder country(java.lang.String country) {
            this.country = country == null ? null : String.of(country);
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        @Override
        public Address build() {
            Address address = new Address(this);
            if (this.validating) {
                this.validate(address);
            }
            return address;
        }

        protected void validate(Address address) {
            super.validate(address);
            ValidationSupport.checkList(address.line, "line", String.class);
            ValidationSupport.requireValueOrChildren(address);
        }

        protected Builder from(Address address) {
            super.from(address);
            this.use = address.use;
            this.type = address.type;
            this.text = address.text;
            this.line.addAll(address.line);
            this.city = address.city;
            this.district = address.district;
            this.state = address.state;
            this.postalCode = address.postalCode;
            this.country = address.country;
            this.period = address.period;
            return this;
        }
    }
}

