/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

public class Annotation
extends Element {
    @Summary
    @ReferenceTarget(value={"Practitioner", "Patient", "RelatedPerson", "Organization"})
    @Choice(value={Reference.class, String.class})
    private final Element author;
    @Summary
    private final DateTime time;
    @Summary
    @Required
    private final Markdown text;

    private Annotation(Builder builder) {
        super(builder);
        this.author = builder.author;
        this.time = builder.time;
        this.text = builder.text;
    }

    public Element getAuthor() {
        return this.author;
    }

    public DateTime getTime() {
        return this.time;
    }

    public Markdown getText() {
        return this.text;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.author != null || this.time != null || this.text != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.author, "author", visitor);
                this.accept(this.time, "time", visitor);
                this.accept(this.text, "text", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Annotation other = (Annotation)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.author, other.author) && Objects.equals(this.time, other.time) && Objects.equals(this.text, other.text);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.author, this.time, this.text);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private Element author;
        private DateTime time;
        private Markdown text;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder author(java.lang.String author) {
            this.author = author == null ? null : String.of(author);
            return this;
        }

        public Builder author(Element author) {
            this.author = author;
            return this;
        }

        public Builder time(DateTime time) {
            this.time = time;
            return this;
        }

        public Builder text(Markdown text) {
            this.text = text;
            return this;
        }

        @Override
        public Annotation build() {
            Annotation annotation = new Annotation(this);
            if (this.validating) {
                this.validate(annotation);
            }
            return annotation;
        }

        protected void validate(Annotation annotation) {
            super.validate(annotation);
            ValidationSupport.choiceElement(annotation.author, "author", Reference.class, String.class);
            ValidationSupport.requireNonNull(annotation.text, "text");
            ValidationSupport.checkReferenceType(annotation.author, "author", "Practitioner", "Patient", "RelatedPerson", "Organization");
            ValidationSupport.requireValueOrChildren(annotation);
        }

        protected Builder from(Annotation annotation) {
            super.from(annotation);
            this.author = annotation.author;
            this.time = annotation.time;
            this.text = annotation.text;
            return this;
        }
    }
}

