/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.type.Base64Binary;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.UnsignedInt;
import org.linuxforhealth.fhir.model.type.Url;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Constraints(value={@Constraint(id="att-1", level="Rule", location="(base)", description="If the Attachment has data, it SHALL have a contentType", expression="data.empty() or contentType.exists()", source="http://hl7.org/fhir/StructureDefinition/Attachment"), @Constraint(id="attachment-2", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/languages", expression="language.exists() implies (language.memberOf('http://hl7.org/fhir/ValueSet/languages', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/Attachment", generated=true)})
public class Attachment
extends Element {
    @Summary
    @Binding(bindingName="MimeType", strength=BindingStrength.Value.REQUIRED, description="BCP 13 (RFCs 2045, 2046, 2047, 4288, 4289 and 2049)", valueSet="http://hl7.org/fhir/ValueSet/mimetypes|4.3.0")
    private final Code contentType;
    @Summary
    @Binding(bindingName="Language", strength=BindingStrength.Value.PREFERRED, description="IETF language tag", valueSet="http://hl7.org/fhir/ValueSet/languages", maxValueSet="http://hl7.org/fhir/ValueSet/all-languages")
    private final Code language;
    private final Base64Binary data;
    @Summary
    private final Url url;
    @Summary
    private final UnsignedInt size;
    @Summary
    private final Base64Binary hash;
    @Summary
    private final String title;
    @Summary
    private final DateTime creation;

    private Attachment(Builder builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.language = builder.language;
        this.data = builder.data;
        this.url = builder.url;
        this.size = builder.size;
        this.hash = builder.hash;
        this.title = builder.title;
        this.creation = builder.creation;
    }

    public Code getContentType() {
        return this.contentType;
    }

    public Code getLanguage() {
        return this.language;
    }

    public Base64Binary getData() {
        return this.data;
    }

    public Url getUrl() {
        return this.url;
    }

    public UnsignedInt getSize() {
        return this.size;
    }

    public Base64Binary getHash() {
        return this.hash;
    }

    public String getTitle() {
        return this.title;
    }

    public DateTime getCreation() {
        return this.creation;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.contentType != null || this.language != null || this.data != null || this.url != null || this.size != null || this.hash != null || this.title != null || this.creation != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.contentType, "contentType", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.data, "data", visitor);
                this.accept(this.url, "url", visitor);
                this.accept(this.size, "size", visitor);
                this.accept(this.hash, "hash", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.creation, "creation", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attachment other = (Attachment)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.language, other.language) && Objects.equals(this.data, other.data) && Objects.equals(this.url, other.url) && Objects.equals(this.size, other.size) && Objects.equals(this.hash, other.hash) && Objects.equals(this.title, other.title) && Objects.equals(this.creation, other.creation);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.contentType, this.language, this.data, this.url, this.size, this.hash, this.title, this.creation);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private Code contentType;
        private Code language;
        private Base64Binary data;
        private Url url;
        private UnsignedInt size;
        private Base64Binary hash;
        private String title;
        private DateTime creation;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder contentType(Code contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder language(Code language) {
            this.language = language;
            return this;
        }

        public Builder data(Base64Binary data) {
            this.data = data;
            return this;
        }

        public Builder url(Url url) {
            this.url = url;
            return this;
        }

        public Builder size(UnsignedInt size) {
            this.size = size;
            return this;
        }

        public Builder hash(Base64Binary hash) {
            this.hash = hash;
            return this;
        }

        public Builder title(java.lang.String title) {
            this.title = title == null ? null : String.of(title);
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder creation(DateTime creation) {
            this.creation = creation;
            return this;
        }

        @Override
        public Attachment build() {
            Attachment attachment = new Attachment(this);
            if (this.validating) {
                this.validate(attachment);
            }
            return attachment;
        }

        protected void validate(Attachment attachment) {
            super.validate(attachment);
            ValidationSupport.checkValueSetBinding(attachment.language, "language", "http://hl7.org/fhir/ValueSet/all-languages", "urn:ietf:bcp:47", new java.lang.String[0]);
            ValidationSupport.requireValueOrChildren(attachment);
        }

        protected Builder from(Attachment attachment) {
            super.from(attachment);
            this.contentType = attachment.contentType;
            this.language = attachment.language;
            this.data = attachment.data;
            this.url = attachment.url;
            this.size = attachment.size;
            this.hash = attachment.hash;
            this.title = attachment.title;
            this.creation = attachment.creation;
            return this;
        }
    }
}

