/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

public class CodeableReference
extends Element {
    @Summary
    private final CodeableConcept concept;
    @Summary
    private final Reference reference;

    private CodeableReference(Builder builder) {
        super(builder);
        this.concept = builder.concept;
        this.reference = builder.reference;
    }

    public CodeableConcept getConcept() {
        return this.concept;
    }

    public Reference getReference() {
        return this.reference;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.concept != null || this.reference != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.concept, "concept", visitor);
                this.accept(this.reference, "reference", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeableReference other = (CodeableReference)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.concept, other.concept) && Objects.equals(this.reference, other.reference);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.concept, this.reference);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private CodeableConcept concept;
        private Reference reference;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder concept(CodeableConcept concept) {
            this.concept = concept;
            return this;
        }

        public Builder reference(Reference reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public CodeableReference build() {
            CodeableReference codeableReference = new CodeableReference(this);
            if (this.validating) {
                this.validate(codeableReference);
            }
            return codeableReference;
        }

        protected void validate(CodeableReference codeableReference) {
            super.validate(codeableReference);
            ValidationSupport.requireValueOrChildren(codeableReference);
        }

        protected Builder from(CodeableReference codeableReference) {
            super.from(codeableReference);
            this.concept = codeableReference.concept;
            this.reference = codeableReference.reference;
            return this;
        }
    }
}

