/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.type.ContactPoint;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

public class ContactDetail
extends Element {
    @Summary
    private final String name;
    @Summary
    private final List<ContactPoint> telecom;

    private ContactDetail(Builder builder) {
        super(builder);
        this.name = builder.name;
        this.telecom = Collections.unmodifiableList(builder.telecom);
    }

    public String getName() {
        return this.name;
    }

    public List<ContactPoint> getTelecom() {
        return this.telecom;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.name != null || !this.telecom.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.name, "name", visitor);
                this.accept(this.telecom, "telecom", visitor, ContactPoint.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContactDetail other = (ContactDetail)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.name, other.name) && Objects.equals(this.telecom, other.telecom);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.name, this.telecom);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private String name;
        private List<ContactPoint> telecom = new ArrayList<ContactPoint>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder name(java.lang.String name) {
            this.name = name == null ? null : String.of(name);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder telecom(ContactPoint ... telecom) {
            for (ContactPoint value : telecom) {
                this.telecom.add(value);
            }
            return this;
        }

        public Builder telecom(Collection<ContactPoint> telecom) {
            this.telecom = new ArrayList<ContactPoint>(telecom);
            return this;
        }

        @Override
        public ContactDetail build() {
            ContactDetail contactDetail = new ContactDetail(this);
            if (this.validating) {
                this.validate(contactDetail);
            }
            return contactDetail;
        }

        protected void validate(ContactDetail contactDetail) {
            super.validate(contactDetail);
            ValidationSupport.checkList(contactDetail.telecom, "telecom", ContactPoint.class);
            ValidationSupport.requireValueOrChildren(contactDetail);
        }

        protected Builder from(ContactDetail contactDetail) {
            super.from(contactDetail);
            this.name = contactDetail.name;
            this.telecom.addAll(contactDetail.telecom);
            return this;
        }
    }
}

