/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.builder.AbstractBuilder;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.AbstractVisitable;

@Constraint(id="ele-1", level="Rule", location="(base)", description="All FHIR elements must have a @value or children unless an empty Parameters resource", expression="hasValue() or (children().count() > id.count()) or $this is Parameters", source="http://hl7.org/fhir/StructureDefinition/Element", modelChecked=true)
public abstract class Element
extends AbstractVisitable {
    protected final String id;
    protected final List<Extension> extension;
    protected volatile int hashCode;

    protected Element(Builder builder) {
        this.id = builder.id;
        this.extension = Collections.unmodifiableList(builder.extension);
    }

    public String getId() {
        return this.id;
    }

    public List<Extension> getExtension() {
        return this.extension;
    }

    public <T extends Element> boolean is(Class<T> elementType) {
        return elementType.isInstance(this);
    }

    public <T extends Element> T as(Class<T> elementType) {
        return (T)((Element)elementType.cast(this));
    }

    public boolean hasValue() {
        return false;
    }

    public boolean hasChildren() {
        return !this.extension.isEmpty();
    }

    public abstract Builder toBuilder();

    public static abstract class Builder
    extends AbstractBuilder<Element> {
        protected String id;
        protected List<Extension> extension = new ArrayList<Extension>();

        protected Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder extension(Extension ... extension) {
            for (Extension value : extension) {
                this.extension.add(value);
            }
            return this;
        }

        public Builder extension(Collection<Extension> extension) {
            this.extension = new ArrayList<Extension>(extension);
            return this;
        }

        @Override
        public abstract Element build();

        protected void validate(Element element) {
            ValidationSupport.checkList(element.extension, "extension", Extension.class);
            ValidationSupport.checkString(element.id);
        }

        protected Builder from(Element element) {
            this.id = element.id;
            this.extension.addAll(element.extension);
            return this;
        }
    }
}

