/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.type.Address;
import org.linuxforhealth.fhir.model.type.Age;
import org.linuxforhealth.fhir.model.type.Annotation;
import org.linuxforhealth.fhir.model.type.Attachment;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.Base64Binary;
import org.linuxforhealth.fhir.model.type.Boolean;
import org.linuxforhealth.fhir.model.type.Canonical;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.CodeableReference;
import org.linuxforhealth.fhir.model.type.Coding;
import org.linuxforhealth.fhir.model.type.ContactDetail;
import org.linuxforhealth.fhir.model.type.ContactPoint;
import org.linuxforhealth.fhir.model.type.Contributor;
import org.linuxforhealth.fhir.model.type.Count;
import org.linuxforhealth.fhir.model.type.DataRequirement;
import org.linuxforhealth.fhir.model.type.Date;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Decimal;
import org.linuxforhealth.fhir.model.type.Distance;
import org.linuxforhealth.fhir.model.type.Dosage;
import org.linuxforhealth.fhir.model.type.Duration;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Expression;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.HumanName;
import org.linuxforhealth.fhir.model.type.Id;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.Instant;
import org.linuxforhealth.fhir.model.type.Integer;
import org.linuxforhealth.fhir.model.type.Markdown;
import org.linuxforhealth.fhir.model.type.Money;
import org.linuxforhealth.fhir.model.type.Oid;
import org.linuxforhealth.fhir.model.type.ParameterDefinition;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.PositiveInt;
import org.linuxforhealth.fhir.model.type.Quantity;
import org.linuxforhealth.fhir.model.type.Range;
import org.linuxforhealth.fhir.model.type.Ratio;
import org.linuxforhealth.fhir.model.type.RatioRange;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.RelatedArtifact;
import org.linuxforhealth.fhir.model.type.SampledData;
import org.linuxforhealth.fhir.model.type.Signature;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Time;
import org.linuxforhealth.fhir.model.type.Timing;
import org.linuxforhealth.fhir.model.type.TriggerDefinition;
import org.linuxforhealth.fhir.model.type.UnsignedInt;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.Url;
import org.linuxforhealth.fhir.model.type.UsageContext;
import org.linuxforhealth.fhir.model.type.Uuid;
import org.linuxforhealth.fhir.model.type.code.AggregationMode;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.ConstraintSeverity;
import org.linuxforhealth.fhir.model.type.code.DiscriminatorType;
import org.linuxforhealth.fhir.model.type.code.PropertyRepresentation;
import org.linuxforhealth.fhir.model.type.code.ReferenceVersionRules;
import org.linuxforhealth.fhir.model.type.code.SlicingRules;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Constraints(value={@org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-1", level="Rule", location="ElementDefinition.slicing", description="If there are no discriminators, there must be a definition", expression="discriminator.exists() or description.exists()", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-2", level="Rule", location="(base)", description="Min <= Max", expression="min.empty() or max.empty() or (max = '*') or iif(max != '*', min <= max.toInteger())", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-3", level="Rule", location="ElementDefinition.max", description="Max SHALL be a number or \"*\"", expression="empty() or ($this = '*') or (toInteger() >= 0)", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-4", level="Rule", location="ElementDefinition.type", description="Aggregation may only be specified if one of the allowed types for the element is a reference", expression="aggregation.empty() or (code = 'Reference') or (code = 'canonical')", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-5", level="Rule", location="(base)", description="if the element definition has a contentReference, it cannot have type, defaultValue, fixed, pattern, example, minValue, maxValue, maxLength, or binding", expression="contentReference.empty() or (type.empty() and defaultValue.empty() and fixed.empty() and pattern.empty() and example.empty() and minValue.empty() and maxValue.empty() and maxLength.empty() and binding.empty())", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-6", level="Rule", location="(base)", description="Fixed value may only be specified if there is one type", expression="fixed.empty() or (type.count()  <= 1)", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-7", level="Rule", location="(base)", description="Pattern may only be specified if there is one type", expression="pattern.empty() or (type.count() <= 1)", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-8", level="Rule", location="(base)", description="Pattern and fixed are mutually exclusive", expression="pattern.empty() or fixed.empty()", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-11", level="Rule", location="(base)", description="Binding can only be present for coded elements, string, and uri", expression="binding.empty() or type.code.empty() or type.select((code = 'code') or (code = 'Coding') or (code='CodeableConcept') or (code = 'Quantity') or (code = 'string') or (code = 'uri') or (code = 'Duration')).exists()", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-12", level="Rule", location="ElementDefinition.binding", description="ValueSet SHALL start with http:// or https:// or urn:", expression="valueSet.exists() implies (valueSet.startsWith('http:') or valueSet.startsWith('https') or valueSet.startsWith('urn:') or valueSet.startsWith('#'))", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-13", level="Rule", location="(base)", description="Types must be unique by code", expression="type.select(code).isDistinct()", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-14", level="Rule", location="(base)", description="Constraints must be unique by key", expression="constraint.select(key).isDistinct()", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-15", level="Rule", location="(base)", description="default value and meaningWhenMissing are mutually exclusive", expression="defaultValue.empty() or meaningWhenMissing.empty()", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-16", level="Rule", location="(base)", description="sliceName must be composed of proper tokens separated by\"/\"", expression="sliceName.empty() or sliceName.matches('^[a-zA-Z0-9\\/\\-_\\[\\]\\@]+$')", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-17", level="Rule", location="ElementDefinition.type", description="targetProfile is only allowed if the type is Reference or canonical", expression="(code='Reference' or code = 'canonical' or code = 'CodeableReference') or targetProfile.empty()", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-18", level="Rule", location="(base)", description="Must have a modifier reason if isModifier = true", expression="(isModifier.exists() and isModifier) implies isModifierReason.exists()", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-19", level="Rule", location="(base)", description="Element names cannot include some special characters", expression="path.matches('^[^\\s\\.,:;\\'\"\\/|?!@#$%&*()\\[\\]{}]{1,64}(\\.[^\\s\\.,:;\\'\"\\/|?!@#$%&*()\\[\\]{}]{1,64}(\\[x\\])?(\\:[^\\s\\.]+)?)*$')", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-20", level="Warning", location="(base)", description="Element names should be simple alphanumerics with a max of 64 characters, or code generation tools may be broken", expression="path.matches('^[A-Za-z][A-Za-z0-9]*(\\.[a-z][A-Za-z0-9]*(\\[x])?)*$')", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-21", level="Warning", location="ElementDefinition.constraint", description="Constraints should have an expression or else validators will not be able to enforce them", expression="expression.exists()", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="eld-22", level="Rule", location="(base)", description="sliceIsConstraining can only appear if slicename is present", expression="sliceIsConstraining.exists() implies sliceName.exists()", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition"), @org.linuxforhealth.fhir.model.annotation.Constraint(id="elementDefinition-23", level="Warning", location="type.code", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/fhir-element-types", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/fhir-element-types', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/ElementDefinition", generated=true)})
public class ElementDefinition
extends BackboneElement {
    @Summary
    @Required
    private final String path;
    @Summary
    @org.linuxforhealth.fhir.model.annotation.Binding(bindingName="PropertyRepresentation", strength=BindingStrength.Value.REQUIRED, valueSet="http://hl7.org/fhir/ValueSet/property-representation|4.3.0")
    private final List<PropertyRepresentation> representation;
    @Summary
    private final String sliceName;
    @Summary
    private final Boolean sliceIsConstraining;
    @Summary
    private final String label;
    @Summary
    @org.linuxforhealth.fhir.model.annotation.Binding(bindingName="ElementDefinitionCode", strength=BindingStrength.Value.EXAMPLE, valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
    private final List<Coding> code;
    @Summary
    private final Slicing slicing;
    @Summary
    private final String _short;
    @Summary
    private final Markdown definition;
    @Summary
    private final Markdown comment;
    @Summary
    private final Markdown requirements;
    @Summary
    private final List<String> alias;
    @Summary
    private final UnsignedInt min;
    @Summary
    private final String max;
    @Summary
    private final Base base;
    @Summary
    private final Uri contentReference;
    @Summary
    private final List<Type> type;
    @Summary
    @Choice(value={Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, CodeableReference.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, RatioRange.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class})
    private final Element defaultValue;
    @Summary
    private final Markdown meaningWhenMissing;
    @Summary
    private final String orderMeaning;
    @Summary
    @Choice(value={Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, CodeableReference.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, RatioRange.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class})
    private final Element fixed;
    @Summary
    @Choice(value={Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, CodeableReference.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, RatioRange.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class})
    private final Element pattern;
    @Summary
    private final List<Example> example;
    @Summary
    @Choice(value={Date.class, DateTime.class, Instant.class, Time.class, Decimal.class, Integer.class, PositiveInt.class, UnsignedInt.class, Quantity.class})
    private final Element minValue;
    @Summary
    @Choice(value={Date.class, DateTime.class, Instant.class, Time.class, Decimal.class, Integer.class, PositiveInt.class, UnsignedInt.class, Quantity.class})
    private final Element maxValue;
    @Summary
    private final Integer maxLength;
    @Summary
    private final List<Id> condition;
    @Summary
    private final List<Constraint> constraint;
    @Summary
    private final Boolean mustSupport;
    @Summary
    private final Boolean isModifier;
    @Summary
    private final String isModifierReason;
    @Summary
    private final Boolean isSummary;
    @Summary
    private final Binding binding;
    @Summary
    private final List<Mapping> mapping;

    private ElementDefinition(Builder builder) {
        super(builder);
        this.path = builder.path;
        this.representation = Collections.unmodifiableList(builder.representation);
        this.sliceName = builder.sliceName;
        this.sliceIsConstraining = builder.sliceIsConstraining;
        this.label = builder.label;
        this.code = Collections.unmodifiableList(builder.code);
        this.slicing = builder.slicing;
        this._short = builder._short;
        this.definition = builder.definition;
        this.comment = builder.comment;
        this.requirements = builder.requirements;
        this.alias = Collections.unmodifiableList(builder.alias);
        this.min = builder.min;
        this.max = builder.max;
        this.base = builder.base;
        this.contentReference = builder.contentReference;
        this.type = Collections.unmodifiableList(builder.type);
        this.defaultValue = builder.defaultValue;
        this.meaningWhenMissing = builder.meaningWhenMissing;
        this.orderMeaning = builder.orderMeaning;
        this.fixed = builder.fixed;
        this.pattern = builder.pattern;
        this.example = Collections.unmodifiableList(builder.example);
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.maxLength = builder.maxLength;
        this.condition = Collections.unmodifiableList(builder.condition);
        this.constraint = Collections.unmodifiableList(builder.constraint);
        this.mustSupport = builder.mustSupport;
        this.isModifier = builder.isModifier;
        this.isModifierReason = builder.isModifierReason;
        this.isSummary = builder.isSummary;
        this.binding = builder.binding;
        this.mapping = Collections.unmodifiableList(builder.mapping);
    }

    public String getPath() {
        return this.path;
    }

    public List<PropertyRepresentation> getRepresentation() {
        return this.representation;
    }

    public String getSliceName() {
        return this.sliceName;
    }

    public Boolean getSliceIsConstraining() {
        return this.sliceIsConstraining;
    }

    public String getLabel() {
        return this.label;
    }

    public List<Coding> getCode() {
        return this.code;
    }

    public Slicing getSlicing() {
        return this.slicing;
    }

    public String getShort() {
        return this._short;
    }

    public Markdown getDefinition() {
        return this.definition;
    }

    public Markdown getComment() {
        return this.comment;
    }

    public Markdown getRequirements() {
        return this.requirements;
    }

    public List<String> getAlias() {
        return this.alias;
    }

    public UnsignedInt getMin() {
        return this.min;
    }

    public String getMax() {
        return this.max;
    }

    public Base getBase() {
        return this.base;
    }

    public Uri getContentReference() {
        return this.contentReference;
    }

    public List<Type> getType() {
        return this.type;
    }

    public Element getDefaultValue() {
        return this.defaultValue;
    }

    public Markdown getMeaningWhenMissing() {
        return this.meaningWhenMissing;
    }

    public String getOrderMeaning() {
        return this.orderMeaning;
    }

    public Element getFixed() {
        return this.fixed;
    }

    public Element getPattern() {
        return this.pattern;
    }

    public List<Example> getExample() {
        return this.example;
    }

    public Element getMinValue() {
        return this.minValue;
    }

    public Element getMaxValue() {
        return this.maxValue;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public List<Id> getCondition() {
        return this.condition;
    }

    public List<Constraint> getConstraint() {
        return this.constraint;
    }

    public Boolean getMustSupport() {
        return this.mustSupport;
    }

    public Boolean getIsModifier() {
        return this.isModifier;
    }

    public String getIsModifierReason() {
        return this.isModifierReason;
    }

    public Boolean getIsSummary() {
        return this.isSummary;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public List<Mapping> getMapping() {
        return this.mapping;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.path != null || !this.representation.isEmpty() || this.sliceName != null || this.sliceIsConstraining != null || this.label != null || !this.code.isEmpty() || this.slicing != null || this._short != null || this.definition != null || this.comment != null || this.requirements != null || !this.alias.isEmpty() || this.min != null || this.max != null || this.base != null || this.contentReference != null || !this.type.isEmpty() || this.defaultValue != null || this.meaningWhenMissing != null || this.orderMeaning != null || this.fixed != null || this.pattern != null || !this.example.isEmpty() || this.minValue != null || this.maxValue != null || this.maxLength != null || !this.condition.isEmpty() || !this.constraint.isEmpty() || this.mustSupport != null || this.isModifier != null || this.isModifierReason != null || this.isSummary != null || this.binding != null || !this.mapping.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.path, "path", visitor);
                this.accept(this.representation, "representation", visitor, PropertyRepresentation.class);
                this.accept(this.sliceName, "sliceName", visitor);
                this.accept(this.sliceIsConstraining, "sliceIsConstraining", visitor);
                this.accept(this.label, "label", visitor);
                this.accept(this.code, "code", visitor, Coding.class);
                this.accept(this.slicing, "slicing", visitor);
                this.accept(this._short, "short", visitor);
                this.accept(this.definition, "definition", visitor);
                this.accept(this.comment, "comment", visitor);
                this.accept(this.requirements, "requirements", visitor);
                this.accept(this.alias, "alias", visitor, String.class);
                this.accept(this.min, "min", visitor);
                this.accept(this.max, "max", visitor);
                this.accept(this.base, "base", visitor);
                this.accept(this.contentReference, "contentReference", visitor);
                this.accept(this.type, "type", visitor, Type.class);
                this.accept(this.defaultValue, "defaultValue", visitor);
                this.accept(this.meaningWhenMissing, "meaningWhenMissing", visitor);
                this.accept(this.orderMeaning, "orderMeaning", visitor);
                this.accept(this.fixed, "fixed", visitor);
                this.accept(this.pattern, "pattern", visitor);
                this.accept(this.example, "example", visitor, Example.class);
                this.accept(this.minValue, "minValue", visitor);
                this.accept(this.maxValue, "maxValue", visitor);
                this.accept(this.maxLength, "maxLength", visitor);
                this.accept(this.condition, "condition", visitor, Id.class);
                this.accept(this.constraint, "constraint", visitor, Constraint.class);
                this.accept(this.mustSupport, "mustSupport", visitor);
                this.accept(this.isModifier, "isModifier", visitor);
                this.accept(this.isModifierReason, "isModifierReason", visitor);
                this.accept(this.isSummary, "isSummary", visitor);
                this.accept(this.binding, "binding", visitor);
                this.accept(this.mapping, "mapping", visitor, Mapping.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElementDefinition other = (ElementDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.path, other.path) && Objects.equals(this.representation, other.representation) && Objects.equals(this.sliceName, other.sliceName) && Objects.equals(this.sliceIsConstraining, other.sliceIsConstraining) && Objects.equals(this.label, other.label) && Objects.equals(this.code, other.code) && Objects.equals(this.slicing, other.slicing) && Objects.equals(this._short, other._short) && Objects.equals(this.definition, other.definition) && Objects.equals(this.comment, other.comment) && Objects.equals(this.requirements, other.requirements) && Objects.equals(this.alias, other.alias) && Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max) && Objects.equals(this.base, other.base) && Objects.equals(this.contentReference, other.contentReference) && Objects.equals(this.type, other.type) && Objects.equals(this.defaultValue, other.defaultValue) && Objects.equals(this.meaningWhenMissing, other.meaningWhenMissing) && Objects.equals(this.orderMeaning, other.orderMeaning) && Objects.equals(this.fixed, other.fixed) && Objects.equals(this.pattern, other.pattern) && Objects.equals(this.example, other.example) && Objects.equals(this.minValue, other.minValue) && Objects.equals(this.maxValue, other.maxValue) && Objects.equals(this.maxLength, other.maxLength) && Objects.equals(this.condition, other.condition) && Objects.equals(this.constraint, other.constraint) && Objects.equals(this.mustSupport, other.mustSupport) && Objects.equals(this.isModifier, other.isModifier) && Objects.equals(this.isModifierReason, other.isModifierReason) && Objects.equals(this.isSummary, other.isSummary) && Objects.equals(this.binding, other.binding) && Objects.equals(this.mapping, other.mapping);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.path, this.representation, this.sliceName, this.sliceIsConstraining, this.label, this.code, this.slicing, this._short, this.definition, this.comment, this.requirements, this.alias, this.min, this.max, this.base, this.contentReference, this.type, this.defaultValue, this.meaningWhenMissing, this.orderMeaning, this.fixed, this.pattern, this.example, this.minValue, this.maxValue, this.maxLength, this.condition, this.constraint, this.mustSupport, this.isModifier, this.isModifierReason, this.isSummary, this.binding, this.mapping);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Mapping
    extends BackboneElement {
        @Summary
        @Required
        private final Id identity;
        @Summary
        @org.linuxforhealth.fhir.model.annotation.Binding(bindingName="MimeType", strength=BindingStrength.Value.REQUIRED, description="BCP 13 (RFCs 2045, 2046, 2047, 4288, 4289 and 2049)", valueSet="http://hl7.org/fhir/ValueSet/mimetypes|4.3.0")
        private final Code language;
        @Summary
        @Required
        private final String map;
        @Summary
        private final String comment;

        private Mapping(Builder builder) {
            super(builder);
            this.identity = builder.identity;
            this.language = builder.language;
            this.map = builder.map;
            this.comment = builder.comment;
        }

        public Id getIdentity() {
            return this.identity;
        }

        public Code getLanguage() {
            return this.language;
        }

        public String getMap() {
            return this.map;
        }

        public String getComment() {
            return this.comment;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.identity != null || this.language != null || this.map != null || this.comment != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.identity, "identity", visitor);
                    this.accept(this.language, "language", visitor);
                    this.accept(this.map, "map", visitor);
                    this.accept(this.comment, "comment", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Mapping other = (Mapping)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identity, other.identity) && Objects.equals(this.language, other.language) && Objects.equals(this.map, other.map) && Objects.equals(this.comment, other.comment);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identity, this.language, this.map, this.comment);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Id identity;
            private Code language;
            private String map;
            private String comment;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder identity(Id identity) {
                this.identity = identity;
                return this;
            }

            public Builder language(Code language) {
                this.language = language;
                return this;
            }

            public Builder map(java.lang.String map) {
                this.map = map == null ? null : String.of(map);
                return this;
            }

            public Builder map(String map) {
                this.map = map;
                return this;
            }

            public Builder comment(java.lang.String comment) {
                this.comment = comment == null ? null : String.of(comment);
                return this;
            }

            public Builder comment(String comment) {
                this.comment = comment;
                return this;
            }

            @Override
            public Mapping build() {
                Mapping mapping = new Mapping(this);
                if (this.validating) {
                    this.validate(mapping);
                }
                return mapping;
            }

            protected void validate(Mapping mapping) {
                super.validate(mapping);
                ValidationSupport.requireNonNull(mapping.identity, "identity");
                ValidationSupport.requireNonNull(mapping.map, "map");
                ValidationSupport.requireValueOrChildren(mapping);
            }

            protected Builder from(Mapping mapping) {
                super.from(mapping);
                this.identity = mapping.identity;
                this.language = mapping.language;
                this.map = mapping.map;
                this.comment = mapping.comment;
                return this;
            }
        }
    }

    public static class Binding
    extends BackboneElement {
        @Summary
        @org.linuxforhealth.fhir.model.annotation.Binding(bindingName="BindingStrength", strength=BindingStrength.Value.REQUIRED, valueSet="http://hl7.org/fhir/ValueSet/binding-strength|4.3.0")
        @Required
        private final BindingStrength strength;
        @Summary
        private final String description;
        @Summary
        private final Canonical valueSet;

        private Binding(Builder builder) {
            super(builder);
            this.strength = builder.strength;
            this.description = builder.description;
            this.valueSet = builder.valueSet;
        }

        public BindingStrength getStrength() {
            return this.strength;
        }

        public String getDescription() {
            return this.description;
        }

        public Canonical getValueSet() {
            return this.valueSet;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.strength != null || this.description != null || this.valueSet != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.strength, "strength", visitor);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.valueSet, "valueSet", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Binding other = (Binding)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.strength, other.strength) && Objects.equals(this.description, other.description) && Objects.equals(this.valueSet, other.valueSet);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.strength, this.description, this.valueSet);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private BindingStrength strength;
            private String description;
            private Canonical valueSet;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder strength(BindingStrength strength) {
                this.strength = strength;
                return this;
            }

            public Builder description(java.lang.String description) {
                this.description = description == null ? null : String.of(description);
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder valueSet(Canonical valueSet) {
                this.valueSet = valueSet;
                return this;
            }

            @Override
            public Binding build() {
                Binding binding = new Binding(this);
                if (this.validating) {
                    this.validate(binding);
                }
                return binding;
            }

            protected void validate(Binding binding) {
                super.validate(binding);
                ValidationSupport.requireNonNull(binding.strength, "strength");
                ValidationSupport.requireValueOrChildren(binding);
            }

            protected Builder from(Binding binding) {
                super.from(binding);
                this.strength = binding.strength;
                this.description = binding.description;
                this.valueSet = binding.valueSet;
                return this;
            }
        }
    }

    public static class Constraint
    extends BackboneElement {
        @Summary
        @Required
        private final Id key;
        @Summary
        private final String requirements;
        @Summary
        @org.linuxforhealth.fhir.model.annotation.Binding(bindingName="ConstraintSeverity", strength=BindingStrength.Value.REQUIRED, valueSet="http://hl7.org/fhir/ValueSet/constraint-severity|4.3.0")
        @Required
        private final ConstraintSeverity severity;
        @Summary
        @Required
        private final String human;
        @Summary
        private final String expression;
        @Summary
        private final String xpath;
        @Summary
        private final Canonical source;

        private Constraint(Builder builder) {
            super(builder);
            this.key = builder.key;
            this.requirements = builder.requirements;
            this.severity = builder.severity;
            this.human = builder.human;
            this.expression = builder.expression;
            this.xpath = builder.xpath;
            this.source = builder.source;
        }

        public Id getKey() {
            return this.key;
        }

        public String getRequirements() {
            return this.requirements;
        }

        public ConstraintSeverity getSeverity() {
            return this.severity;
        }

        public String getHuman() {
            return this.human;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getXpath() {
            return this.xpath;
        }

        public Canonical getSource() {
            return this.source;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.key != null || this.requirements != null || this.severity != null || this.human != null || this.expression != null || this.xpath != null || this.source != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.key, "key", visitor);
                    this.accept(this.requirements, "requirements", visitor);
                    this.accept(this.severity, "severity", visitor);
                    this.accept(this.human, "human", visitor);
                    this.accept(this.expression, "expression", visitor);
                    this.accept(this.xpath, "xpath", visitor);
                    this.accept(this.source, "source", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Constraint other = (Constraint)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.key, other.key) && Objects.equals(this.requirements, other.requirements) && Objects.equals(this.severity, other.severity) && Objects.equals(this.human, other.human) && Objects.equals(this.expression, other.expression) && Objects.equals(this.xpath, other.xpath) && Objects.equals(this.source, other.source);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.key, this.requirements, this.severity, this.human, this.expression, this.xpath, this.source);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Id key;
            private String requirements;
            private ConstraintSeverity severity;
            private String human;
            private String expression;
            private String xpath;
            private Canonical source;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder key(Id key) {
                this.key = key;
                return this;
            }

            public Builder requirements(java.lang.String requirements) {
                this.requirements = requirements == null ? null : String.of(requirements);
                return this;
            }

            public Builder requirements(String requirements) {
                this.requirements = requirements;
                return this;
            }

            public Builder severity(ConstraintSeverity severity) {
                this.severity = severity;
                return this;
            }

            public Builder human(java.lang.String human) {
                this.human = human == null ? null : String.of(human);
                return this;
            }

            public Builder human(String human) {
                this.human = human;
                return this;
            }

            public Builder expression(java.lang.String expression) {
                this.expression = expression == null ? null : String.of(expression);
                return this;
            }

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public Builder xpath(java.lang.String xpath) {
                this.xpath = xpath == null ? null : String.of(xpath);
                return this;
            }

            public Builder xpath(String xpath) {
                this.xpath = xpath;
                return this;
            }

            public Builder source(Canonical source) {
                this.source = source;
                return this;
            }

            @Override
            public Constraint build() {
                Constraint constraint = new Constraint(this);
                if (this.validating) {
                    this.validate(constraint);
                }
                return constraint;
            }

            protected void validate(Constraint constraint) {
                super.validate(constraint);
                ValidationSupport.requireNonNull(constraint.key, "key");
                ValidationSupport.requireNonNull(constraint.severity, "severity");
                ValidationSupport.requireNonNull(constraint.human, "human");
                ValidationSupport.requireValueOrChildren(constraint);
            }

            protected Builder from(Constraint constraint) {
                super.from(constraint);
                this.key = constraint.key;
                this.requirements = constraint.requirements;
                this.severity = constraint.severity;
                this.human = constraint.human;
                this.expression = constraint.expression;
                this.xpath = constraint.xpath;
                this.source = constraint.source;
                return this;
            }
        }
    }

    public static class Example
    extends BackboneElement {
        @Summary
        @Required
        private final String label;
        @Summary
        @Choice(value={Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, CodeableReference.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, RatioRange.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class})
        @Required
        private final Element value;

        private Example(Builder builder) {
            super(builder);
            this.label = builder.label;
            this.value = builder.value;
        }

        public String getLabel() {
            return this.label;
        }

        public Element getValue() {
            return this.value;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.label != null || this.value != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.label, "label", visitor);
                    this.accept(this.value, "value", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Example other = (Example)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.label, other.label) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.label, this.value);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String label;
            private Element value;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder label(java.lang.String label) {
                this.label = label == null ? null : String.of(label);
                return this;
            }

            public Builder label(String label) {
                this.label = label;
                return this;
            }

            public Builder value(java.lang.Boolean value) {
                this.value = value == null ? null : Boolean.of(value);
                return this;
            }

            public Builder value(LocalDate value) {
                this.value = value == null ? null : Date.of(value);
                return this;
            }

            public Builder value(ZonedDateTime value) {
                this.value = value == null ? null : Instant.of(value);
                return this;
            }

            public Builder value(java.lang.Integer value) {
                this.value = value == null ? null : Integer.of(value);
                return this;
            }

            public Builder value(java.lang.String value) {
                this.value = value == null ? null : String.of(value);
                return this;
            }

            public Builder value(LocalTime value) {
                this.value = value == null ? null : Time.of(value);
                return this;
            }

            public Builder value(Element value) {
                this.value = value;
                return this;
            }

            @Override
            public Example build() {
                Example example = new Example(this);
                if (this.validating) {
                    this.validate(example);
                }
                return example;
            }

            protected void validate(Example example) {
                super.validate(example);
                ValidationSupport.requireNonNull(example.label, "label");
                ValidationSupport.requireChoiceElement(example.value, "value", Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, CodeableReference.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, RatioRange.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class);
                ValidationSupport.requireValueOrChildren(example);
            }

            protected Builder from(Example example) {
                super.from(example);
                this.label = example.label;
                this.value = example.value;
                return this;
            }
        }
    }

    public static class Type
    extends BackboneElement {
        @Summary
        @org.linuxforhealth.fhir.model.annotation.Binding(bindingName="FHIRDefinedTypeExt", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/fhir-element-types")
        @Required
        private final Uri code;
        @Summary
        private final List<Canonical> profile;
        @Summary
        private final List<Canonical> targetProfile;
        @Summary
        @org.linuxforhealth.fhir.model.annotation.Binding(bindingName="AggregationMode", strength=BindingStrength.Value.REQUIRED, valueSet="http://hl7.org/fhir/ValueSet/resource-aggregation-mode|4.3.0")
        private final List<AggregationMode> aggregation;
        @Summary
        @org.linuxforhealth.fhir.model.annotation.Binding(bindingName="ReferenceVersionRules", strength=BindingStrength.Value.REQUIRED, valueSet="http://hl7.org/fhir/ValueSet/reference-version-rules|4.3.0")
        private final ReferenceVersionRules versioning;

        private Type(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.profile = Collections.unmodifiableList(builder.profile);
            this.targetProfile = Collections.unmodifiableList(builder.targetProfile);
            this.aggregation = Collections.unmodifiableList(builder.aggregation);
            this.versioning = builder.versioning;
        }

        public Uri getCode() {
            return this.code;
        }

        public List<Canonical> getProfile() {
            return this.profile;
        }

        public List<Canonical> getTargetProfile() {
            return this.targetProfile;
        }

        public List<AggregationMode> getAggregation() {
            return this.aggregation;
        }

        public ReferenceVersionRules getVersioning() {
            return this.versioning;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || !this.profile.isEmpty() || !this.targetProfile.isEmpty() || !this.aggregation.isEmpty() || this.versioning != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.profile, "profile", visitor, Canonical.class);
                    this.accept(this.targetProfile, "targetProfile", visitor, Canonical.class);
                    this.accept(this.aggregation, "aggregation", visitor, AggregationMode.class);
                    this.accept(this.versioning, "versioning", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Type other = (Type)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.profile, other.profile) && Objects.equals(this.targetProfile, other.targetProfile) && Objects.equals(this.aggregation, other.aggregation) && Objects.equals(this.versioning, other.versioning);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.profile, this.targetProfile, this.aggregation, this.versioning);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Uri code;
            private List<Canonical> profile = new ArrayList<Canonical>();
            private List<Canonical> targetProfile = new ArrayList<Canonical>();
            private List<AggregationMode> aggregation = new ArrayList<AggregationMode>();
            private ReferenceVersionRules versioning;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(Uri code) {
                this.code = code;
                return this;
            }

            public Builder profile(Canonical ... profile) {
                for (Canonical value : profile) {
                    this.profile.add(value);
                }
                return this;
            }

            public Builder profile(Collection<Canonical> profile) {
                this.profile = new ArrayList<Canonical>(profile);
                return this;
            }

            public Builder targetProfile(Canonical ... targetProfile) {
                for (Canonical value : targetProfile) {
                    this.targetProfile.add(value);
                }
                return this;
            }

            public Builder targetProfile(Collection<Canonical> targetProfile) {
                this.targetProfile = new ArrayList<Canonical>(targetProfile);
                return this;
            }

            public Builder aggregation(AggregationMode ... aggregation) {
                for (AggregationMode value : aggregation) {
                    this.aggregation.add(value);
                }
                return this;
            }

            public Builder aggregation(Collection<AggregationMode> aggregation) {
                this.aggregation = new ArrayList<AggregationMode>(aggregation);
                return this;
            }

            public Builder versioning(ReferenceVersionRules versioning) {
                this.versioning = versioning;
                return this;
            }

            @Override
            public Type build() {
                Type type = new Type(this);
                if (this.validating) {
                    this.validate(type);
                }
                return type;
            }

            protected void validate(Type type) {
                super.validate(type);
                ValidationSupport.requireNonNull(type.code, "code");
                ValidationSupport.checkList(type.profile, "profile", Canonical.class);
                ValidationSupport.checkList(type.targetProfile, "targetProfile", Canonical.class);
                ValidationSupport.checkList(type.aggregation, "aggregation", AggregationMode.class);
                ValidationSupport.requireValueOrChildren(type);
            }

            protected Builder from(Type type) {
                super.from(type);
                this.code = type.code;
                this.profile.addAll(type.profile);
                this.targetProfile.addAll(type.targetProfile);
                this.aggregation.addAll(type.aggregation);
                this.versioning = type.versioning;
                return this;
            }
        }
    }

    public static class Base
    extends BackboneElement {
        @Summary
        @Required
        private final String path;
        @Summary
        @Required
        private final UnsignedInt min;
        @Summary
        @Required
        private final String max;

        private Base(Builder builder) {
            super(builder);
            this.path = builder.path;
            this.min = builder.min;
            this.max = builder.max;
        }

        public String getPath() {
            return this.path;
        }

        public UnsignedInt getMin() {
            return this.min;
        }

        public String getMax() {
            return this.max;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.path != null || this.min != null || this.max != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.path, "path", visitor);
                    this.accept(this.min, "min", visitor);
                    this.accept(this.max, "max", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Base other = (Base)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.path, other.path) && Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.path, this.min, this.max);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String path;
            private UnsignedInt min;
            private String max;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder path(java.lang.String path) {
                this.path = path == null ? null : String.of(path);
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder min(UnsignedInt min) {
                this.min = min;
                return this;
            }

            public Builder max(java.lang.String max) {
                this.max = max == null ? null : String.of(max);
                return this;
            }

            public Builder max(String max) {
                this.max = max;
                return this;
            }

            @Override
            public Base build() {
                Base base = new Base(this);
                if (this.validating) {
                    this.validate(base);
                }
                return base;
            }

            protected void validate(Base base) {
                super.validate(base);
                ValidationSupport.requireNonNull(base.path, "path");
                ValidationSupport.requireNonNull(base.min, "min");
                ValidationSupport.requireNonNull(base.max, "max");
                ValidationSupport.requireValueOrChildren(base);
            }

            protected Builder from(Base base) {
                super.from(base);
                this.path = base.path;
                this.min = base.min;
                this.max = base.max;
                return this;
            }
        }
    }

    public static class Slicing
    extends BackboneElement {
        @Summary
        private final List<Discriminator> discriminator;
        @Summary
        private final String description;
        @Summary
        private final Boolean ordered;
        @Summary
        @org.linuxforhealth.fhir.model.annotation.Binding(bindingName="SlicingRules", strength=BindingStrength.Value.REQUIRED, valueSet="http://hl7.org/fhir/ValueSet/resource-slicing-rules|4.3.0")
        @Required
        private final SlicingRules rules;

        private Slicing(Builder builder) {
            super(builder);
            this.discriminator = Collections.unmodifiableList(builder.discriminator);
            this.description = builder.description;
            this.ordered = builder.ordered;
            this.rules = builder.rules;
        }

        public List<Discriminator> getDiscriminator() {
            return this.discriminator;
        }

        public String getDescription() {
            return this.description;
        }

        public Boolean getOrdered() {
            return this.ordered;
        }

        public SlicingRules getRules() {
            return this.rules;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.discriminator.isEmpty() || this.description != null || this.ordered != null || this.rules != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.discriminator, "discriminator", visitor, Discriminator.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.ordered, "ordered", visitor);
                    this.accept(this.rules, "rules", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Slicing other = (Slicing)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.discriminator, other.discriminator) && Objects.equals(this.description, other.description) && Objects.equals(this.ordered, other.ordered) && Objects.equals(this.rules, other.rules);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.discriminator, this.description, this.ordered, this.rules);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Discriminator
        extends BackboneElement {
            @Summary
            @org.linuxforhealth.fhir.model.annotation.Binding(bindingName="DiscriminatorType", strength=BindingStrength.Value.REQUIRED, valueSet="http://hl7.org/fhir/ValueSet/discriminator-type|4.3.0")
            @Required
            private final DiscriminatorType type;
            @Summary
            @Required
            private final String path;

            private Discriminator(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.path = builder.path;
            }

            public DiscriminatorType getType() {
                return this.type;
            }

            public String getPath() {
                return this.path;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.path != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.path, "path", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Discriminator other = (Discriminator)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.path, other.path);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.path);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private DiscriminatorType type;
                private String path;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(DiscriminatorType type) {
                    this.type = type;
                    return this;
                }

                public Builder path(java.lang.String path) {
                    this.path = path == null ? null : String.of(path);
                    return this;
                }

                public Builder path(String path) {
                    this.path = path;
                    return this;
                }

                @Override
                public Discriminator build() {
                    Discriminator discriminator = new Discriminator(this);
                    if (this.validating) {
                        this.validate(discriminator);
                    }
                    return discriminator;
                }

                protected void validate(Discriminator discriminator) {
                    super.validate(discriminator);
                    ValidationSupport.requireNonNull(discriminator.type, "type");
                    ValidationSupport.requireNonNull(discriminator.path, "path");
                    ValidationSupport.requireValueOrChildren(discriminator);
                }

                protected Builder from(Discriminator discriminator) {
                    super.from(discriminator);
                    this.type = discriminator.type;
                    this.path = discriminator.path;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Discriminator> discriminator = new ArrayList<Discriminator>();
            private String description;
            private Boolean ordered;
            private SlicingRules rules;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder discriminator(Discriminator ... discriminator) {
                for (Discriminator value : discriminator) {
                    this.discriminator.add(value);
                }
                return this;
            }

            public Builder discriminator(Collection<Discriminator> discriminator) {
                this.discriminator = new ArrayList<Discriminator>(discriminator);
                return this;
            }

            public Builder description(java.lang.String description) {
                this.description = description == null ? null : String.of(description);
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder ordered(java.lang.Boolean ordered) {
                this.ordered = ordered == null ? null : Boolean.of(ordered);
                return this;
            }

            public Builder ordered(Boolean ordered) {
                this.ordered = ordered;
                return this;
            }

            public Builder rules(SlicingRules rules) {
                this.rules = rules;
                return this;
            }

            @Override
            public Slicing build() {
                Slicing slicing = new Slicing(this);
                if (this.validating) {
                    this.validate(slicing);
                }
                return slicing;
            }

            protected void validate(Slicing slicing) {
                super.validate(slicing);
                ValidationSupport.checkList(slicing.discriminator, "discriminator", Discriminator.class);
                ValidationSupport.requireNonNull(slicing.rules, "rules");
                ValidationSupport.requireValueOrChildren(slicing);
            }

            protected Builder from(Slicing slicing) {
                super.from(slicing);
                this.discriminator.addAll(slicing.discriminator);
                this.description = slicing.description;
                this.ordered = slicing.ordered;
                this.rules = slicing.rules;
                return this;
            }
        }
    }

    public static class Builder
    extends BackboneElement.Builder {
        private String path;
        private List<PropertyRepresentation> representation = new ArrayList<PropertyRepresentation>();
        private String sliceName;
        private Boolean sliceIsConstraining;
        private String label;
        private List<Coding> code = new ArrayList<Coding>();
        private Slicing slicing;
        private String _short;
        private Markdown definition;
        private Markdown comment;
        private Markdown requirements;
        private List<String> alias = new ArrayList<String>();
        private UnsignedInt min;
        private String max;
        private Base base;
        private Uri contentReference;
        private List<Type> type = new ArrayList<Type>();
        private Element defaultValue;
        private Markdown meaningWhenMissing;
        private String orderMeaning;
        private Element fixed;
        private Element pattern;
        private List<Example> example = new ArrayList<Example>();
        private Element minValue;
        private Element maxValue;
        private Integer maxLength;
        private List<Id> condition = new ArrayList<Id>();
        private List<Constraint> constraint = new ArrayList<Constraint>();
        private Boolean mustSupport;
        private Boolean isModifier;
        private String isModifierReason;
        private Boolean isSummary;
        private Binding binding;
        private List<Mapping> mapping = new ArrayList<Mapping>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder path(java.lang.String path) {
            this.path = path == null ? null : String.of(path);
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder representation(PropertyRepresentation ... representation) {
            for (PropertyRepresentation value : representation) {
                this.representation.add(value);
            }
            return this;
        }

        public Builder representation(Collection<PropertyRepresentation> representation) {
            this.representation = new ArrayList<PropertyRepresentation>(representation);
            return this;
        }

        public Builder sliceName(java.lang.String sliceName) {
            this.sliceName = sliceName == null ? null : String.of(sliceName);
            return this;
        }

        public Builder sliceName(String sliceName) {
            this.sliceName = sliceName;
            return this;
        }

        public Builder sliceIsConstraining(java.lang.Boolean sliceIsConstraining) {
            this.sliceIsConstraining = sliceIsConstraining == null ? null : Boolean.of(sliceIsConstraining);
            return this;
        }

        public Builder sliceIsConstraining(Boolean sliceIsConstraining) {
            this.sliceIsConstraining = sliceIsConstraining;
            return this;
        }

        public Builder label(java.lang.String label) {
            this.label = label == null ? null : String.of(label);
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder code(Coding ... code) {
            for (Coding value : code) {
                this.code.add(value);
            }
            return this;
        }

        public Builder code(Collection<Coding> code) {
            this.code = new ArrayList<Coding>(code);
            return this;
        }

        public Builder slicing(Slicing slicing) {
            this.slicing = slicing;
            return this;
        }

        public Builder _short(java.lang.String _short) {
            this._short = _short == null ? null : String.of(_short);
            return this;
        }

        public Builder _short(String _short) {
            this._short = _short;
            return this;
        }

        public Builder definition(Markdown definition) {
            this.definition = definition;
            return this;
        }

        public Builder comment(Markdown comment) {
            this.comment = comment;
            return this;
        }

        public Builder requirements(Markdown requirements) {
            this.requirements = requirements;
            return this;
        }

        public Builder alias(java.lang.String ... alias) {
            for (java.lang.String value : alias) {
                this.alias.add(value == null ? null : String.of(value));
            }
            return this;
        }

        public Builder alias(String ... alias) {
            for (String value : alias) {
                this.alias.add(value);
            }
            return this;
        }

        public Builder alias(Collection<String> alias) {
            this.alias = new ArrayList<String>(alias);
            return this;
        }

        public Builder min(UnsignedInt min) {
            this.min = min;
            return this;
        }

        public Builder max(java.lang.String max) {
            this.max = max == null ? null : String.of(max);
            return this;
        }

        public Builder max(String max) {
            this.max = max;
            return this;
        }

        public Builder base(Base base) {
            this.base = base;
            return this;
        }

        public Builder contentReference(Uri contentReference) {
            this.contentReference = contentReference;
            return this;
        }

        public Builder type(Type ... type) {
            for (Type value : type) {
                this.type.add(value);
            }
            return this;
        }

        public Builder type(Collection<Type> type) {
            this.type = new ArrayList<Type>(type);
            return this;
        }

        public Builder defaultValue(java.lang.Boolean defaultValue) {
            this.defaultValue = defaultValue == null ? null : Boolean.of(defaultValue);
            return this;
        }

        public Builder defaultValue(LocalDate defaultValue) {
            this.defaultValue = defaultValue == null ? null : Date.of(defaultValue);
            return this;
        }

        public Builder defaultValue(ZonedDateTime defaultValue) {
            this.defaultValue = defaultValue == null ? null : Instant.of(defaultValue);
            return this;
        }

        public Builder defaultValue(java.lang.Integer defaultValue) {
            this.defaultValue = defaultValue == null ? null : Integer.of(defaultValue);
            return this;
        }

        public Builder defaultValue(java.lang.String defaultValue) {
            this.defaultValue = defaultValue == null ? null : String.of(defaultValue);
            return this;
        }

        public Builder defaultValue(LocalTime defaultValue) {
            this.defaultValue = defaultValue == null ? null : Time.of(defaultValue);
            return this;
        }

        public Builder defaultValue(Element defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder meaningWhenMissing(Markdown meaningWhenMissing) {
            this.meaningWhenMissing = meaningWhenMissing;
            return this;
        }

        public Builder orderMeaning(java.lang.String orderMeaning) {
            this.orderMeaning = orderMeaning == null ? null : String.of(orderMeaning);
            return this;
        }

        public Builder orderMeaning(String orderMeaning) {
            this.orderMeaning = orderMeaning;
            return this;
        }

        public Builder fixed(java.lang.Boolean fixed) {
            this.fixed = fixed == null ? null : Boolean.of(fixed);
            return this;
        }

        public Builder fixed(LocalDate fixed) {
            this.fixed = fixed == null ? null : Date.of(fixed);
            return this;
        }

        public Builder fixed(ZonedDateTime fixed) {
            this.fixed = fixed == null ? null : Instant.of(fixed);
            return this;
        }

        public Builder fixed(java.lang.Integer fixed) {
            this.fixed = fixed == null ? null : Integer.of(fixed);
            return this;
        }

        public Builder fixed(java.lang.String fixed) {
            this.fixed = fixed == null ? null : String.of(fixed);
            return this;
        }

        public Builder fixed(LocalTime fixed) {
            this.fixed = fixed == null ? null : Time.of(fixed);
            return this;
        }

        public Builder fixed(Element fixed) {
            this.fixed = fixed;
            return this;
        }

        public Builder pattern(java.lang.Boolean pattern) {
            this.pattern = pattern == null ? null : Boolean.of(pattern);
            return this;
        }

        public Builder pattern(LocalDate pattern) {
            this.pattern = pattern == null ? null : Date.of(pattern);
            return this;
        }

        public Builder pattern(ZonedDateTime pattern) {
            this.pattern = pattern == null ? null : Instant.of(pattern);
            return this;
        }

        public Builder pattern(java.lang.Integer pattern) {
            this.pattern = pattern == null ? null : Integer.of(pattern);
            return this;
        }

        public Builder pattern(java.lang.String pattern) {
            this.pattern = pattern == null ? null : String.of(pattern);
            return this;
        }

        public Builder pattern(LocalTime pattern) {
            this.pattern = pattern == null ? null : Time.of(pattern);
            return this;
        }

        public Builder pattern(Element pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder example(Example ... example) {
            for (Example value : example) {
                this.example.add(value);
            }
            return this;
        }

        public Builder example(Collection<Example> example) {
            this.example = new ArrayList<Example>(example);
            return this;
        }

        public Builder minValue(LocalDate minValue) {
            this.minValue = minValue == null ? null : Date.of(minValue);
            return this;
        }

        public Builder minValue(ZonedDateTime minValue) {
            this.minValue = minValue == null ? null : Instant.of(minValue);
            return this;
        }

        public Builder minValue(LocalTime minValue) {
            this.minValue = minValue == null ? null : Time.of(minValue);
            return this;
        }

        public Builder minValue(java.lang.Integer minValue) {
            this.minValue = minValue == null ? null : Integer.of(minValue);
            return this;
        }

        public Builder minValue(Element minValue) {
            this.minValue = minValue;
            return this;
        }

        public Builder maxValue(LocalDate maxValue) {
            this.maxValue = maxValue == null ? null : Date.of(maxValue);
            return this;
        }

        public Builder maxValue(ZonedDateTime maxValue) {
            this.maxValue = maxValue == null ? null : Instant.of(maxValue);
            return this;
        }

        public Builder maxValue(LocalTime maxValue) {
            this.maxValue = maxValue == null ? null : Time.of(maxValue);
            return this;
        }

        public Builder maxValue(java.lang.Integer maxValue) {
            this.maxValue = maxValue == null ? null : Integer.of(maxValue);
            return this;
        }

        public Builder maxValue(Element maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public Builder maxLength(java.lang.Integer maxLength) {
            this.maxLength = maxLength == null ? null : Integer.of(maxLength);
            return this;
        }

        public Builder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder condition(Id ... condition) {
            for (Id value : condition) {
                this.condition.add(value);
            }
            return this;
        }

        public Builder condition(Collection<Id> condition) {
            this.condition = new ArrayList<Id>(condition);
            return this;
        }

        public Builder constraint(Constraint ... constraint) {
            for (Constraint value : constraint) {
                this.constraint.add(value);
            }
            return this;
        }

        public Builder constraint(Collection<Constraint> constraint) {
            this.constraint = new ArrayList<Constraint>(constraint);
            return this;
        }

        public Builder mustSupport(java.lang.Boolean mustSupport) {
            this.mustSupport = mustSupport == null ? null : Boolean.of(mustSupport);
            return this;
        }

        public Builder mustSupport(Boolean mustSupport) {
            this.mustSupport = mustSupport;
            return this;
        }

        public Builder isModifier(java.lang.Boolean isModifier) {
            this.isModifier = isModifier == null ? null : Boolean.of(isModifier);
            return this;
        }

        public Builder isModifier(Boolean isModifier) {
            this.isModifier = isModifier;
            return this;
        }

        public Builder isModifierReason(java.lang.String isModifierReason) {
            this.isModifierReason = isModifierReason == null ? null : String.of(isModifierReason);
            return this;
        }

        public Builder isModifierReason(String isModifierReason) {
            this.isModifierReason = isModifierReason;
            return this;
        }

        public Builder isSummary(java.lang.Boolean isSummary) {
            this.isSummary = isSummary == null ? null : Boolean.of(isSummary);
            return this;
        }

        public Builder isSummary(Boolean isSummary) {
            this.isSummary = isSummary;
            return this;
        }

        public Builder binding(Binding binding) {
            this.binding = binding;
            return this;
        }

        public Builder mapping(Mapping ... mapping) {
            for (Mapping value : mapping) {
                this.mapping.add(value);
            }
            return this;
        }

        public Builder mapping(Collection<Mapping> mapping) {
            this.mapping = new ArrayList<Mapping>(mapping);
            return this;
        }

        @Override
        public ElementDefinition build() {
            ElementDefinition elementDefinition = new ElementDefinition(this);
            if (this.validating) {
                this.validate(elementDefinition);
            }
            return elementDefinition;
        }

        protected void validate(ElementDefinition elementDefinition) {
            super.validate(elementDefinition);
            ValidationSupport.requireNonNull(elementDefinition.path, "path");
            ValidationSupport.checkList(elementDefinition.representation, "representation", PropertyRepresentation.class);
            ValidationSupport.checkList(elementDefinition.code, "code", Coding.class);
            ValidationSupport.checkList(elementDefinition.alias, "alias", String.class);
            ValidationSupport.checkList(elementDefinition.type, "type", Type.class);
            ValidationSupport.choiceElement(elementDefinition.defaultValue, "defaultValue", Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, CodeableReference.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, RatioRange.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class);
            ValidationSupport.choiceElement(elementDefinition.fixed, "fixed", Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, CodeableReference.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, RatioRange.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class);
            ValidationSupport.choiceElement(elementDefinition.pattern, "pattern", Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, CodeableReference.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, RatioRange.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class);
            ValidationSupport.checkList(elementDefinition.example, "example", Example.class);
            ValidationSupport.choiceElement(elementDefinition.minValue, "minValue", Date.class, DateTime.class, Instant.class, Time.class, Decimal.class, Integer.class, PositiveInt.class, UnsignedInt.class, Quantity.class);
            ValidationSupport.choiceElement(elementDefinition.maxValue, "maxValue", Date.class, DateTime.class, Instant.class, Time.class, Decimal.class, Integer.class, PositiveInt.class, UnsignedInt.class, Quantity.class);
            ValidationSupport.checkList(elementDefinition.condition, "condition", Id.class);
            ValidationSupport.checkList(elementDefinition.constraint, "constraint", Constraint.class);
            ValidationSupport.checkList(elementDefinition.mapping, "mapping", Mapping.class);
            ValidationSupport.requireValueOrChildren(elementDefinition);
        }

        protected Builder from(ElementDefinition elementDefinition) {
            super.from(elementDefinition);
            this.path = elementDefinition.path;
            this.representation.addAll(elementDefinition.representation);
            this.sliceName = elementDefinition.sliceName;
            this.sliceIsConstraining = elementDefinition.sliceIsConstraining;
            this.label = elementDefinition.label;
            this.code.addAll(elementDefinition.code);
            this.slicing = elementDefinition.slicing;
            this._short = elementDefinition._short;
            this.definition = elementDefinition.definition;
            this.comment = elementDefinition.comment;
            this.requirements = elementDefinition.requirements;
            this.alias.addAll(elementDefinition.alias);
            this.min = elementDefinition.min;
            this.max = elementDefinition.max;
            this.base = elementDefinition.base;
            this.contentReference = elementDefinition.contentReference;
            this.type.addAll(elementDefinition.type);
            this.defaultValue = elementDefinition.defaultValue;
            this.meaningWhenMissing = elementDefinition.meaningWhenMissing;
            this.orderMeaning = elementDefinition.orderMeaning;
            this.fixed = elementDefinition.fixed;
            this.pattern = elementDefinition.pattern;
            this.example.addAll(elementDefinition.example);
            this.minValue = elementDefinition.minValue;
            this.maxValue = elementDefinition.maxValue;
            this.maxLength = elementDefinition.maxLength;
            this.condition.addAll(elementDefinition.condition);
            this.constraint.addAll(elementDefinition.constraint);
            this.mustSupport = elementDefinition.mustSupport;
            this.isModifier = elementDefinition.isModifier;
            this.isModifierReason = elementDefinition.isModifierReason;
            this.isSummary = elementDefinition.isSummary;
            this.binding = elementDefinition.binding;
            this.mapping.addAll(elementDefinition.mapping);
            return this;
        }
    }
}

