/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.IdentifierUse;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Constraint(id="identifier-0", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/identifier-type", expression="type.exists() implies (type.memberOf('http://hl7.org/fhir/ValueSet/identifier-type', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/Identifier", generated=true)
public class Identifier
extends Element {
    @Summary
    @Binding(bindingName="IdentifierUse", strength=BindingStrength.Value.REQUIRED, valueSet="http://hl7.org/fhir/ValueSet/identifier-use|4.3.0")
    private final IdentifierUse use;
    @Summary
    @Binding(bindingName="IdentifierType", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/identifier-type")
    private final CodeableConcept type;
    @Summary
    private final Uri system;
    @Summary
    private final String value;
    @Summary
    private final Period period;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference assigner;

    private Identifier(Builder builder) {
        super(builder);
        this.use = builder.use;
        this.type = builder.type;
        this.system = builder.system;
        this.value = builder.value;
        this.period = builder.period;
        this.assigner = builder.assigner;
    }

    public IdentifierUse getUse() {
        return this.use;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Uri getSystem() {
        return this.system;
    }

    public String getValue() {
        return this.value;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Reference getAssigner() {
        return this.assigner;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.use != null || this.type != null || this.system != null || this.value != null || this.period != null || this.assigner != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.use, "use", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.system, "system", visitor);
                this.accept(this.value, "value", visitor);
                this.accept(this.period, "period", visitor);
                this.accept(this.assigner, "assigner", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Identifier other = (Identifier)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.use, other.use) && Objects.equals(this.type, other.type) && Objects.equals(this.system, other.system) && Objects.equals(this.value, other.value) && Objects.equals(this.period, other.period) && Objects.equals(this.assigner, other.assigner);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.use, this.type, this.system, this.value, this.period, this.assigner);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private IdentifierUse use;
        private CodeableConcept type;
        private Uri system;
        private String value;
        private Period period;
        private Reference assigner;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder use(IdentifierUse use) {
            this.use = use;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder system(Uri system) {
            this.system = system;
            return this;
        }

        public Builder value(java.lang.String value) {
            this.value = value == null ? null : String.of(value);
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder assigner(Reference assigner) {
            this.assigner = assigner;
            return this;
        }

        @Override
        public Identifier build() {
            Identifier identifier = new Identifier(this);
            if (this.validating) {
                this.validate(identifier);
            }
            return identifier;
        }

        protected void validate(Identifier identifier) {
            super.validate(identifier);
            ValidationSupport.checkReferenceType(identifier.assigner, "assigner", "Organization");
            ValidationSupport.requireValueOrChildren(identifier);
        }

        protected Builder from(Identifier identifier) {
            super.from(identifier);
            this.use = identifier.use;
            this.type = identifier.type;
            this.system = identifier.system;
            this.value = identifier.value;
            this.period = identifier.period;
            this.assigner = identifier.assigner;
            return this;
        }
    }
}

