/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

public class Integer
extends Element {
    protected final java.lang.Integer value;

    protected Integer(Builder builder) {
        super(builder);
        this.value = builder.value;
    }

    public java.lang.Integer getValue() {
        return this.value;
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren();
    }

    public static Integer of(java.lang.Integer value) {
        Objects.requireNonNull(value, "value");
        return Integer.builder().value(value).build();
    }

    public static Integer of(String value) {
        Objects.requireNonNull(value, "value");
        return Integer.builder().value(value).build();
    }

    public static Integer integer(String value) {
        Objects.requireNonNull(value, "value");
        return Integer.builder().value(value).build();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.value, "value", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Integer other = (Integer)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        protected java.lang.Integer value;

        protected Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder value(java.lang.Integer value) {
            this.value = value;
            return this;
        }

        public Builder value(String value) {
            this.value = java.lang.Integer.parseInt(value);
            return this;
        }

        @Override
        public Integer build() {
            Integer integer = new Integer(this);
            if (this.validating) {
                this.validate(integer);
            }
            return integer;
        }

        protected void validate(Integer integer) {
            super.validate(integer);
            ValidationSupport.requireValueOrChildren(integer);
        }

        protected Builder from(Integer integer) {
            super.from(integer);
            this.value = integer.value;
            return this;
        }
    }
}

