/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Decimal;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

public class Money
extends Element {
    @Summary
    private final Decimal value;
    @Summary
    @Binding(bindingName="CurrencyCode", strength=BindingStrength.Value.REQUIRED, valueSet="http://hl7.org/fhir/ValueSet/currencies|4.3.0")
    private final Code currency;

    private Money(Builder builder) {
        super(builder);
        this.value = builder.value;
        this.currency = builder.currency;
    }

    public Decimal getValue() {
        return this.value;
    }

    public Code getCurrency() {
        return this.currency;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.value != null || this.currency != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.value, "value", visitor);
                this.accept(this.currency, "currency", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Money other = (Money)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value) && Objects.equals(this.currency, other.currency);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value, this.currency);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private Decimal value;
        private Code currency;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder value(Decimal value) {
            this.value = value;
            return this;
        }

        public Builder currency(Code currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public Money build() {
            Money money = new Money(this);
            if (this.validating) {
                this.validate(money);
            }
            return money;
        }

        protected void validate(Money money) {
            super.validate(money);
            ValidationSupport.requireValueOrChildren(money);
        }

        protected Builder from(Money money) {
            super.from(money);
            this.value = money.value;
            this.currency = money.currency;
            return this;
        }
    }
}

