/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.type.Canonical;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Integer;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.FHIRAllTypes;
import org.linuxforhealth.fhir.model.type.code.ParameterUse;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

public class ParameterDefinition
extends Element {
    @Summary
    private final Code name;
    @Summary
    @Binding(bindingName="ParameterUse", strength=BindingStrength.Value.REQUIRED, valueSet="http://hl7.org/fhir/ValueSet/operation-parameter-use|4.3.0")
    @Required
    private final ParameterUse use;
    @Summary
    private final Integer min;
    @Summary
    private final String max;
    @Summary
    private final String documentation;
    @Summary
    @Binding(bindingName="FHIRAllTypes", strength=BindingStrength.Value.REQUIRED, valueSet="http://hl7.org/fhir/ValueSet/all-types|4.3.0")
    @Required
    private final FHIRAllTypes type;
    @Summary
    private final Canonical profile;

    private ParameterDefinition(Builder builder) {
        super(builder);
        this.name = builder.name;
        this.use = builder.use;
        this.min = builder.min;
        this.max = builder.max;
        this.documentation = builder.documentation;
        this.type = builder.type;
        this.profile = builder.profile;
    }

    public Code getName() {
        return this.name;
    }

    public ParameterUse getUse() {
        return this.use;
    }

    public Integer getMin() {
        return this.min;
    }

    public String getMax() {
        return this.max;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public FHIRAllTypes getType() {
        return this.type;
    }

    public Canonical getProfile() {
        return this.profile;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.name != null || this.use != null || this.min != null || this.max != null || this.documentation != null || this.type != null || this.profile != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.name, "name", visitor);
                this.accept(this.use, "use", visitor);
                this.accept(this.min, "min", visitor);
                this.accept(this.max, "max", visitor);
                this.accept(this.documentation, "documentation", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.profile, "profile", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterDefinition other = (ParameterDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.name, other.name) && Objects.equals(this.use, other.use) && Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max) && Objects.equals(this.documentation, other.documentation) && Objects.equals(this.type, other.type) && Objects.equals(this.profile, other.profile);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.name, this.use, this.min, this.max, this.documentation, this.type, this.profile);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private Code name;
        private ParameterUse use;
        private Integer min;
        private String max;
        private String documentation;
        private FHIRAllTypes type;
        private Canonical profile;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder name(Code name) {
            this.name = name;
            return this;
        }

        public Builder use(ParameterUse use) {
            this.use = use;
            return this;
        }

        public Builder min(java.lang.Integer min) {
            this.min = min == null ? null : Integer.of(min);
            return this;
        }

        public Builder min(Integer min) {
            this.min = min;
            return this;
        }

        public Builder max(java.lang.String max) {
            this.max = max == null ? null : String.of(max);
            return this;
        }

        public Builder max(String max) {
            this.max = max;
            return this;
        }

        public Builder documentation(java.lang.String documentation) {
            this.documentation = documentation == null ? null : String.of(documentation);
            return this;
        }

        public Builder documentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public Builder type(FHIRAllTypes type) {
            this.type = type;
            return this;
        }

        public Builder profile(Canonical profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public ParameterDefinition build() {
            ParameterDefinition parameterDefinition = new ParameterDefinition(this);
            if (this.validating) {
                this.validate(parameterDefinition);
            }
            return parameterDefinition;
        }

        protected void validate(ParameterDefinition parameterDefinition) {
            super.validate(parameterDefinition);
            ValidationSupport.requireNonNull(parameterDefinition.use, "use");
            ValidationSupport.requireNonNull(parameterDefinition.type, "type");
            ValidationSupport.requireValueOrChildren(parameterDefinition);
        }

        protected Builder from(ParameterDefinition parameterDefinition) {
            super.from(parameterDefinition);
            this.name = parameterDefinition.name;
            this.use = parameterDefinition.use;
            this.min = parameterDefinition.min;
            this.max = parameterDefinition.max;
            this.documentation = parameterDefinition.documentation;
            this.type = parameterDefinition.type;
            this.profile = parameterDefinition.profile;
            return this;
        }
    }
}

