/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Constraint(id="per-1", level="Rule", location="(base)", description="If present, start SHALL have a lower value than end", expression="start.hasValue().not() or end.hasValue().not() or (start <= end)", source="http://hl7.org/fhir/StructureDefinition/Period")
public class Period
extends Element {
    @Summary
    private final DateTime start;
    @Summary
    private final DateTime end;

    private Period(Builder builder) {
        super(builder);
        this.start = builder.start;
        this.end = builder.end;
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getEnd() {
        return this.end;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.start != null || this.end != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.start, "start", visitor);
                this.accept(this.end, "end", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Period other = (Period)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.start, this.end);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private DateTime start;
        private DateTime end;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder start(DateTime start) {
            this.start = start;
            return this;
        }

        public Builder end(DateTime end) {
            this.end = end;
            return this;
        }

        @Override
        public Period build() {
            Period period = new Period(this);
            if (this.validating) {
                this.validate(period);
            }
            return period;
        }

        protected void validate(Period period) {
            super.validate(period);
            ValidationSupport.requireValueOrChildren(period);
        }

        protected Builder from(Period period) {
            super.from(period);
            this.start = period.start;
            this.end = period.end;
            return this;
        }
    }
}

