/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.SimpleQuantity;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Constraints(value={@Constraint(id="inv-1", level="Rule", location="(base)", description="One of lowNumerator or highNumerator and denominator SHALL be present, or all are absent. If all are absent, there SHALL be some extension present", expression="((lowNumerator.exists() or highNumerator.exists()) and denominator.exists()) or (lowNumerator.empty() and highNumerator.empty() and denominator.empty() and extension.exists())", source="http://hl7.org/fhir/StructureDefinition/RatioRange"), @Constraint(id="inv-2", level="Rule", location="(base)", description="If present, lowNumerator SHALL have a lower value than highNumerator", expression="lowNumerator.empty() or highNumerator.empty() or (lowNumerator <= highNumerator)", source="http://hl7.org/fhir/StructureDefinition/RatioRange")})
public class RatioRange
extends Element {
    @Summary
    private final SimpleQuantity lowNumerator;
    @Summary
    private final SimpleQuantity highNumerator;
    @Summary
    private final SimpleQuantity denominator;

    private RatioRange(Builder builder) {
        super(builder);
        this.lowNumerator = builder.lowNumerator;
        this.highNumerator = builder.highNumerator;
        this.denominator = builder.denominator;
    }

    public SimpleQuantity getLowNumerator() {
        return this.lowNumerator;
    }

    public SimpleQuantity getHighNumerator() {
        return this.highNumerator;
    }

    public SimpleQuantity getDenominator() {
        return this.denominator;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.lowNumerator != null || this.highNumerator != null || this.denominator != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.lowNumerator, "lowNumerator", visitor);
                this.accept(this.highNumerator, "highNumerator", visitor);
                this.accept(this.denominator, "denominator", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RatioRange other = (RatioRange)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.lowNumerator, other.lowNumerator) && Objects.equals(this.highNumerator, other.highNumerator) && Objects.equals(this.denominator, other.denominator);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.lowNumerator, this.highNumerator, this.denominator);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private SimpleQuantity lowNumerator;
        private SimpleQuantity highNumerator;
        private SimpleQuantity denominator;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder lowNumerator(SimpleQuantity lowNumerator) {
            this.lowNumerator = lowNumerator;
            return this;
        }

        public Builder highNumerator(SimpleQuantity highNumerator) {
            this.highNumerator = highNumerator;
            return this;
        }

        public Builder denominator(SimpleQuantity denominator) {
            this.denominator = denominator;
            return this;
        }

        @Override
        public RatioRange build() {
            RatioRange ratioRange = new RatioRange(this);
            if (this.validating) {
                this.validate(ratioRange);
            }
            return ratioRange;
        }

        protected void validate(RatioRange ratioRange) {
            super.validate(ratioRange);
            ValidationSupport.requireValueOrChildren(ratioRange);
        }

        protected Builder from(RatioRange ratioRange) {
            super.from(ratioRange);
            this.lowNumerator = ratioRange.lowNumerator;
            this.highNumerator = ratioRange.highNumerator;
            this.denominator = ratioRange.denominator;
            return this;
        }
    }
}

