/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Identifier;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Constraints(value={@Constraint(id="ref-1", level="Rule", location="(base)", description="SHALL have a contained resource if a local reference is provided", expression="reference.startsWith('#').not() or (reference.substring(1).trace('url') in %rootResource.contained.id.trace('ids')) or (reference='#' and %rootResource!=%resource)", source="http://hl7.org/fhir/StructureDefinition/Reference"), @Constraint(id="reference-2", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/resource-types", expression="type.exists() implies (type.memberOf('http://hl7.org/fhir/ValueSet/resource-types', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/Reference", generated=true)})
public class Reference
extends Element {
    @Summary
    private final String reference;
    @Summary
    @Binding(bindingName="FHIRResourceTypeExt", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/resource-types")
    private final Uri type;
    @Summary
    private final Identifier identifier;
    @Summary
    private final String display;

    private Reference(Builder builder) {
        super(builder);
        this.reference = builder.reference;
        this.type = builder.type;
        this.identifier = builder.identifier;
        this.display = builder.display;
    }

    public String getReference() {
        return this.reference;
    }

    public Uri getType() {
        return this.type;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public String getDisplay() {
        return this.display;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.reference != null || this.type != null || this.identifier != null || this.display != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.reference, "reference", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.identifier, "identifier", visitor);
                this.accept(this.display, "display", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Reference other = (Reference)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.reference, other.reference) && Objects.equals(this.type, other.type) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.display, other.display);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.reference, this.type, this.identifier, this.display);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private String reference;
        private Uri type;
        private Identifier identifier;
        private String display;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder reference(java.lang.String reference) {
            this.reference = reference == null ? null : String.of(reference);
            return this;
        }

        public Builder reference(String reference) {
            this.reference = reference;
            return this;
        }

        public Builder type(Uri type) {
            this.type = type;
            return this;
        }

        public Builder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder display(java.lang.String display) {
            this.display = display == null ? null : String.of(display);
            return this;
        }

        public Builder display(String display) {
            this.display = display;
            return this;
        }

        @Override
        public Reference build() {
            Reference reference = new Reference(this);
            if (this.validating) {
                this.validate(reference);
            }
            return reference;
        }

        protected void validate(Reference reference) {
            super.validate(reference);
            ValidationSupport.requireValueOrChildren(reference);
        }

        protected Builder from(Reference reference) {
            super.from(reference);
            this.reference = reference.reference;
            this.type = reference.type;
            this.identifier = reference.identifier;
            this.display = reference.display;
            return this;
        }
    }
}

