/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.type.Decimal;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.PositiveInt;
import org.linuxforhealth.fhir.model.type.SimpleQuantity;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

public class SampledData
extends Element {
    @Summary
    @Required
    private final SimpleQuantity origin;
    @Summary
    @Required
    private final Decimal period;
    @Summary
    private final Decimal factor;
    @Summary
    private final Decimal lowerLimit;
    @Summary
    private final Decimal upperLimit;
    @Summary
    @Required
    private final PositiveInt dimensions;
    private final String data;

    private SampledData(Builder builder) {
        super(builder);
        this.origin = builder.origin;
        this.period = builder.period;
        this.factor = builder.factor;
        this.lowerLimit = builder.lowerLimit;
        this.upperLimit = builder.upperLimit;
        this.dimensions = builder.dimensions;
        this.data = builder.data;
    }

    public SimpleQuantity getOrigin() {
        return this.origin;
    }

    public Decimal getPeriod() {
        return this.period;
    }

    public Decimal getFactor() {
        return this.factor;
    }

    public Decimal getLowerLimit() {
        return this.lowerLimit;
    }

    public Decimal getUpperLimit() {
        return this.upperLimit;
    }

    public PositiveInt getDimensions() {
        return this.dimensions;
    }

    public String getData() {
        return this.data;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.origin != null || this.period != null || this.factor != null || this.lowerLimit != null || this.upperLimit != null || this.dimensions != null || this.data != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.origin, "origin", visitor);
                this.accept(this.period, "period", visitor);
                this.accept(this.factor, "factor", visitor);
                this.accept(this.lowerLimit, "lowerLimit", visitor);
                this.accept(this.upperLimit, "upperLimit", visitor);
                this.accept(this.dimensions, "dimensions", visitor);
                this.accept(this.data, "data", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SampledData other = (SampledData)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.origin, other.origin) && Objects.equals(this.period, other.period) && Objects.equals(this.factor, other.factor) && Objects.equals(this.lowerLimit, other.lowerLimit) && Objects.equals(this.upperLimit, other.upperLimit) && Objects.equals(this.dimensions, other.dimensions) && Objects.equals(this.data, other.data);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.origin, this.period, this.factor, this.lowerLimit, this.upperLimit, this.dimensions, this.data);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private SimpleQuantity origin;
        private Decimal period;
        private Decimal factor;
        private Decimal lowerLimit;
        private Decimal upperLimit;
        private PositiveInt dimensions;
        private String data;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder origin(SimpleQuantity origin) {
            this.origin = origin;
            return this;
        }

        public Builder period(Decimal period) {
            this.period = period;
            return this;
        }

        public Builder factor(Decimal factor) {
            this.factor = factor;
            return this;
        }

        public Builder lowerLimit(Decimal lowerLimit) {
            this.lowerLimit = lowerLimit;
            return this;
        }

        public Builder upperLimit(Decimal upperLimit) {
            this.upperLimit = upperLimit;
            return this;
        }

        public Builder dimensions(PositiveInt dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder data(java.lang.String data) {
            this.data = data == null ? null : String.of(data);
            return this;
        }

        public Builder data(String data) {
            this.data = data;
            return this;
        }

        @Override
        public SampledData build() {
            SampledData sampledData = new SampledData(this);
            if (this.validating) {
                this.validate(sampledData);
            }
            return sampledData;
        }

        protected void validate(SampledData sampledData) {
            super.validate(sampledData);
            ValidationSupport.requireNonNull(sampledData.origin, "origin");
            ValidationSupport.requireNonNull(sampledData.period, "period");
            ValidationSupport.requireNonNull(sampledData.dimensions, "dimensions");
            ValidationSupport.requireValueOrChildren(sampledData);
        }

        protected Builder from(SampledData sampledData) {
            super.from(sampledData);
            this.origin = sampledData.origin;
            this.period = sampledData.period;
            this.factor = sampledData.factor;
            this.lowerLimit = sampledData.lowerLimit;
            this.upperLimit = sampledData.upperLimit;
            this.dimensions = sampledData.dimensions;
            this.data = sampledData.data;
            return this;
        }
    }
}

