/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.Constraints;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.type.BackboneElement;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.DateTime;
import org.linuxforhealth.fhir.model.type.Decimal;
import org.linuxforhealth.fhir.model.type.Duration;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Period;
import org.linuxforhealth.fhir.model.type.PositiveInt;
import org.linuxforhealth.fhir.model.type.Range;
import org.linuxforhealth.fhir.model.type.Time;
import org.linuxforhealth.fhir.model.type.UnsignedInt;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.type.code.DayOfWeek;
import org.linuxforhealth.fhir.model.type.code.EventTiming;
import org.linuxforhealth.fhir.model.type.code.UnitsOfTime;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Constraints(value={@Constraint(id="tim-1", level="Rule", location="Timing.repeat", description="if there's a duration, there needs to be duration units", expression="duration.empty() or durationUnit.exists()", source="http://hl7.org/fhir/StructureDefinition/Timing"), @Constraint(id="tim-2", level="Rule", location="Timing.repeat", description="if there's a period, there needs to be period units", expression="period.empty() or periodUnit.exists()", source="http://hl7.org/fhir/StructureDefinition/Timing"), @Constraint(id="tim-4", level="Rule", location="Timing.repeat", description="duration SHALL be a non-negative value", expression="duration.exists() implies duration >= 0", source="http://hl7.org/fhir/StructureDefinition/Timing"), @Constraint(id="tim-5", level="Rule", location="Timing.repeat", description="period SHALL be a non-negative value", expression="period.exists() implies period >= 0", source="http://hl7.org/fhir/StructureDefinition/Timing"), @Constraint(id="tim-6", level="Rule", location="Timing.repeat", description="If there's a periodMax, there must be a period", expression="periodMax.empty() or period.exists()", source="http://hl7.org/fhir/StructureDefinition/Timing"), @Constraint(id="tim-7", level="Rule", location="Timing.repeat", description="If there's a durationMax, there must be a duration", expression="durationMax.empty() or duration.exists()", source="http://hl7.org/fhir/StructureDefinition/Timing"), @Constraint(id="tim-8", level="Rule", location="Timing.repeat", description="If there's a countMax, there must be a count", expression="countMax.empty() or count.exists()", source="http://hl7.org/fhir/StructureDefinition/Timing"), @Constraint(id="tim-9", level="Rule", location="Timing.repeat", description="If there's an offset, there must be a when (and not C, CM, CD, CV)", expression="offset.empty() or (when.exists() and ((when in ('C' | 'CM' | 'CD' | 'CV')).not()))", source="http://hl7.org/fhir/StructureDefinition/Timing"), @Constraint(id="tim-10", level="Rule", location="Timing.repeat", description="If there's a timeOfDay, there cannot be a when, or vice versa", expression="timeOfDay.empty() or when.empty()", source="http://hl7.org/fhir/StructureDefinition/Timing"), @Constraint(id="timing-11", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/timing-abbreviation", expression="code.exists() implies (code.memberOf('http://hl7.org/fhir/ValueSet/timing-abbreviation', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/Timing", generated=true)})
public class Timing
extends BackboneElement {
    @Summary
    private final List<DateTime> event;
    @Summary
    private final Repeat repeat;
    @Summary
    @Binding(bindingName="TimingAbbreviation", strength=BindingStrength.Value.PREFERRED, valueSet="http://hl7.org/fhir/ValueSet/timing-abbreviation")
    private final CodeableConcept code;

    private Timing(Builder builder) {
        super(builder);
        this.event = Collections.unmodifiableList(builder.event);
        this.repeat = builder.repeat;
        this.code = builder.code;
    }

    public List<DateTime> getEvent() {
        return this.event;
    }

    public Repeat getRepeat() {
        return this.repeat;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.event.isEmpty() || this.repeat != null || this.code != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.event, "event", visitor, DateTime.class);
                this.accept(this.repeat, "repeat", visitor);
                this.accept(this.code, "code", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Timing other = (Timing)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.event, other.event) && Objects.equals(this.repeat, other.repeat) && Objects.equals(this.code, other.code);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.event, this.repeat, this.code);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Repeat
    extends BackboneElement {
        @Summary
        @Choice(value={Duration.class, Range.class, Period.class})
        private final Element bounds;
        @Summary
        private final PositiveInt count;
        @Summary
        private final PositiveInt countMax;
        @Summary
        private final Decimal duration;
        @Summary
        private final Decimal durationMax;
        @Summary
        @Binding(bindingName="UnitsOfTime", strength=BindingStrength.Value.REQUIRED, valueSet="http://hl7.org/fhir/ValueSet/units-of-time|4.3.0")
        private final UnitsOfTime durationUnit;
        @Summary
        private final PositiveInt frequency;
        @Summary
        private final PositiveInt frequencyMax;
        @Summary
        private final Decimal period;
        @Summary
        private final Decimal periodMax;
        @Summary
        @Binding(bindingName="UnitsOfTime", strength=BindingStrength.Value.REQUIRED, valueSet="http://hl7.org/fhir/ValueSet/units-of-time|4.3.0")
        private final UnitsOfTime periodUnit;
        @Summary
        @Binding(bindingName="DayOfWeek", strength=BindingStrength.Value.REQUIRED, valueSet="http://hl7.org/fhir/ValueSet/days-of-week|4.3.0")
        private final List<DayOfWeek> dayOfWeek;
        @Summary
        private final List<Time> timeOfDay;
        @Summary
        @Binding(bindingName="EventTiming", strength=BindingStrength.Value.REQUIRED, valueSet="http://hl7.org/fhir/ValueSet/event-timing|4.3.0")
        private final List<EventTiming> when;
        @Summary
        private final UnsignedInt offset;

        private Repeat(Builder builder) {
            super(builder);
            this.bounds = builder.bounds;
            this.count = builder.count;
            this.countMax = builder.countMax;
            this.duration = builder.duration;
            this.durationMax = builder.durationMax;
            this.durationUnit = builder.durationUnit;
            this.frequency = builder.frequency;
            this.frequencyMax = builder.frequencyMax;
            this.period = builder.period;
            this.periodMax = builder.periodMax;
            this.periodUnit = builder.periodUnit;
            this.dayOfWeek = Collections.unmodifiableList(builder.dayOfWeek);
            this.timeOfDay = Collections.unmodifiableList(builder.timeOfDay);
            this.when = Collections.unmodifiableList(builder.when);
            this.offset = builder.offset;
        }

        public Element getBounds() {
            return this.bounds;
        }

        public PositiveInt getCount() {
            return this.count;
        }

        public PositiveInt getCountMax() {
            return this.countMax;
        }

        public Decimal getDuration() {
            return this.duration;
        }

        public Decimal getDurationMax() {
            return this.durationMax;
        }

        public UnitsOfTime getDurationUnit() {
            return this.durationUnit;
        }

        public PositiveInt getFrequency() {
            return this.frequency;
        }

        public PositiveInt getFrequencyMax() {
            return this.frequencyMax;
        }

        public Decimal getPeriod() {
            return this.period;
        }

        public Decimal getPeriodMax() {
            return this.periodMax;
        }

        public UnitsOfTime getPeriodUnit() {
            return this.periodUnit;
        }

        public List<DayOfWeek> getDayOfWeek() {
            return this.dayOfWeek;
        }

        public List<Time> getTimeOfDay() {
            return this.timeOfDay;
        }

        public List<EventTiming> getWhen() {
            return this.when;
        }

        public UnsignedInt getOffset() {
            return this.offset;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.bounds != null || this.count != null || this.countMax != null || this.duration != null || this.durationMax != null || this.durationUnit != null || this.frequency != null || this.frequencyMax != null || this.period != null || this.periodMax != null || this.periodUnit != null || !this.dayOfWeek.isEmpty() || !this.timeOfDay.isEmpty() || !this.when.isEmpty() || this.offset != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.bounds, "bounds", visitor);
                    this.accept(this.count, "count", visitor);
                    this.accept(this.countMax, "countMax", visitor);
                    this.accept(this.duration, "duration", visitor);
                    this.accept(this.durationMax, "durationMax", visitor);
                    this.accept(this.durationUnit, "durationUnit", visitor);
                    this.accept(this.frequency, "frequency", visitor);
                    this.accept(this.frequencyMax, "frequencyMax", visitor);
                    this.accept(this.period, "period", visitor);
                    this.accept(this.periodMax, "periodMax", visitor);
                    this.accept(this.periodUnit, "periodUnit", visitor);
                    this.accept(this.dayOfWeek, "dayOfWeek", visitor, DayOfWeek.class);
                    this.accept(this.timeOfDay, "timeOfDay", visitor, Time.class);
                    this.accept(this.when, "when", visitor, EventTiming.class);
                    this.accept(this.offset, "offset", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Repeat other = (Repeat)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.bounds, other.bounds) && Objects.equals(this.count, other.count) && Objects.equals(this.countMax, other.countMax) && Objects.equals(this.duration, other.duration) && Objects.equals(this.durationMax, other.durationMax) && Objects.equals(this.durationUnit, other.durationUnit) && Objects.equals(this.frequency, other.frequency) && Objects.equals(this.frequencyMax, other.frequencyMax) && Objects.equals(this.period, other.period) && Objects.equals(this.periodMax, other.periodMax) && Objects.equals(this.periodUnit, other.periodUnit) && Objects.equals(this.dayOfWeek, other.dayOfWeek) && Objects.equals(this.timeOfDay, other.timeOfDay) && Objects.equals(this.when, other.when) && Objects.equals(this.offset, other.offset);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.bounds, this.count, this.countMax, this.duration, this.durationMax, this.durationUnit, this.frequency, this.frequencyMax, this.period, this.periodMax, this.periodUnit, this.dayOfWeek, this.timeOfDay, this.when, this.offset);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Element bounds;
            private PositiveInt count;
            private PositiveInt countMax;
            private Decimal duration;
            private Decimal durationMax;
            private UnitsOfTime durationUnit;
            private PositiveInt frequency;
            private PositiveInt frequencyMax;
            private Decimal period;
            private Decimal periodMax;
            private UnitsOfTime periodUnit;
            private List<DayOfWeek> dayOfWeek = new ArrayList<DayOfWeek>();
            private List<Time> timeOfDay = new ArrayList<Time>();
            private List<EventTiming> when = new ArrayList<EventTiming>();
            private UnsignedInt offset;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder bounds(Element bounds) {
                this.bounds = bounds;
                return this;
            }

            public Builder count(PositiveInt count) {
                this.count = count;
                return this;
            }

            public Builder countMax(PositiveInt countMax) {
                this.countMax = countMax;
                return this;
            }

            public Builder duration(Decimal duration) {
                this.duration = duration;
                return this;
            }

            public Builder durationMax(Decimal durationMax) {
                this.durationMax = durationMax;
                return this;
            }

            public Builder durationUnit(UnitsOfTime durationUnit) {
                this.durationUnit = durationUnit;
                return this;
            }

            public Builder frequency(PositiveInt frequency) {
                this.frequency = frequency;
                return this;
            }

            public Builder frequencyMax(PositiveInt frequencyMax) {
                this.frequencyMax = frequencyMax;
                return this;
            }

            public Builder period(Decimal period) {
                this.period = period;
                return this;
            }

            public Builder periodMax(Decimal periodMax) {
                this.periodMax = periodMax;
                return this;
            }

            public Builder periodUnit(UnitsOfTime periodUnit) {
                this.periodUnit = periodUnit;
                return this;
            }

            public Builder dayOfWeek(DayOfWeek ... dayOfWeek) {
                for (DayOfWeek value : dayOfWeek) {
                    this.dayOfWeek.add(value);
                }
                return this;
            }

            public Builder dayOfWeek(Collection<DayOfWeek> dayOfWeek) {
                this.dayOfWeek = new ArrayList<DayOfWeek>(dayOfWeek);
                return this;
            }

            public Builder timeOfDay(LocalTime ... timeOfDay) {
                for (LocalTime value : timeOfDay) {
                    this.timeOfDay.add(value == null ? null : Time.of(value));
                }
                return this;
            }

            public Builder timeOfDay(Time ... timeOfDay) {
                for (Time value : timeOfDay) {
                    this.timeOfDay.add(value);
                }
                return this;
            }

            public Builder timeOfDay(Collection<Time> timeOfDay) {
                this.timeOfDay = new ArrayList<Time>(timeOfDay);
                return this;
            }

            public Builder when(EventTiming ... when) {
                for (EventTiming value : when) {
                    this.when.add(value);
                }
                return this;
            }

            public Builder when(Collection<EventTiming> when) {
                this.when = new ArrayList<EventTiming>(when);
                return this;
            }

            public Builder offset(UnsignedInt offset) {
                this.offset = offset;
                return this;
            }

            @Override
            public Repeat build() {
                Repeat repeat = new Repeat(this);
                if (this.validating) {
                    this.validate(repeat);
                }
                return repeat;
            }

            protected void validate(Repeat repeat) {
                super.validate(repeat);
                ValidationSupport.choiceElement(repeat.bounds, "bounds", Duration.class, Range.class, Period.class);
                ValidationSupport.checkList(repeat.dayOfWeek, "dayOfWeek", DayOfWeek.class);
                ValidationSupport.checkList(repeat.timeOfDay, "timeOfDay", Time.class);
                ValidationSupport.checkList(repeat.when, "when", EventTiming.class);
                ValidationSupport.requireValueOrChildren(repeat);
            }

            protected Builder from(Repeat repeat) {
                super.from(repeat);
                this.bounds = repeat.bounds;
                this.count = repeat.count;
                this.countMax = repeat.countMax;
                this.duration = repeat.duration;
                this.durationMax = repeat.durationMax;
                this.durationUnit = repeat.durationUnit;
                this.frequency = repeat.frequency;
                this.frequencyMax = repeat.frequencyMax;
                this.period = repeat.period;
                this.periodMax = repeat.periodMax;
                this.periodUnit = repeat.periodUnit;
                this.dayOfWeek.addAll(repeat.dayOfWeek);
                this.timeOfDay.addAll(repeat.timeOfDay);
                this.when.addAll(repeat.when);
                this.offset = repeat.offset;
                return this;
            }
        }
    }

    public static class Builder
    extends BackboneElement.Builder {
        private List<DateTime> event = new ArrayList<DateTime>();
        private Repeat repeat;
        private CodeableConcept code;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder event(DateTime ... event) {
            for (DateTime value : event) {
                this.event.add(value);
            }
            return this;
        }

        public Builder event(Collection<DateTime> event) {
            this.event = new ArrayList<DateTime>(event);
            return this;
        }

        public Builder repeat(Repeat repeat) {
            this.repeat = repeat;
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        @Override
        public Timing build() {
            Timing timing = new Timing(this);
            if (this.validating) {
                this.validate(timing);
            }
            return timing;
        }

        protected void validate(Timing timing) {
            super.validate(timing);
            ValidationSupport.checkList(timing.event, "event", DateTime.class);
            ValidationSupport.requireValueOrChildren(timing);
        }

        protected Builder from(Timing timing) {
            super.from(timing);
            this.event.addAll(timing.event);
            this.repeat = timing.repeat;
            this.code = timing.code;
            return this;
        }
    }
}

