/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.Binding;
import org.linuxforhealth.fhir.model.annotation.Choice;
import org.linuxforhealth.fhir.model.annotation.Constraint;
import org.linuxforhealth.fhir.model.annotation.ReferenceTarget;
import org.linuxforhealth.fhir.model.annotation.Required;
import org.linuxforhealth.fhir.model.annotation.Summary;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Coding;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Quantity;
import org.linuxforhealth.fhir.model.type.Range;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.code.BindingStrength;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

@Constraint(id="usageContext-0", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/usage-context-type", expression="code.exists() and code.memberOf('http://hl7.org/fhir/ValueSet/usage-context-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/UsageContext", generated=true)
public class UsageContext
extends Element {
    @Summary
    @Binding(bindingName="UsageContextType", strength=BindingStrength.Value.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/usage-context-type")
    @Required
    private final Coding code;
    @Summary
    @ReferenceTarget(value={"PlanDefinition", "ResearchStudy", "InsurancePlan", "HealthcareService", "Group", "Location", "Organization"})
    @Choice(value={CodeableConcept.class, Quantity.class, Range.class, Reference.class})
    @Binding(bindingName="UsageContextValue", strength=BindingStrength.Value.EXAMPLE, valueSet="http://hl7.org/fhir/ValueSet/use-context")
    @Required
    private final Element value;

    private UsageContext(Builder builder) {
        super(builder);
        this.code = builder.code;
        this.value = builder.value;
    }

    public Coding getCode() {
        return this.code;
    }

    public Element getValue() {
        return this.value;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.code != null || this.value != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.code, "code", visitor);
                this.accept(this.value, "value", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UsageContext other = (UsageContext)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.code, other.code) && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.code, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private Coding code;
        private Element value;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder code(Coding code) {
            this.code = code;
            return this;
        }

        public Builder value(Element value) {
            this.value = value;
            return this;
        }

        @Override
        public UsageContext build() {
            UsageContext usageContext = new UsageContext(this);
            if (this.validating) {
                this.validate(usageContext);
            }
            return usageContext;
        }

        protected void validate(UsageContext usageContext) {
            super.validate(usageContext);
            ValidationSupport.requireNonNull(usageContext.code, "code");
            ValidationSupport.requireChoiceElement(usageContext.value, "value", CodeableConcept.class, Quantity.class, Range.class, Reference.class);
            ValidationSupport.checkReferenceType(usageContext.value, "value", "PlanDefinition", "ResearchStudy", "InsurancePlan", "HealthcareService", "Group", "Location", "Organization");
            ValidationSupport.requireValueOrChildren(usageContext);
        }

        protected Builder from(UsageContext usageContext) {
            super.from(usageContext);
            this.code = usageContext.code;
            this.value = usageContext.value;
            return this;
        }
    }
}

