/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type;

import java.util.Collection;
import java.util.Objects;
import java.util.regex.Pattern;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.util.ValidationSupport;
import org.linuxforhealth.fhir.model.visitor.Visitor;

public class Uuid
extends Uri {
    private static final Pattern PATTERN = Pattern.compile("urn:uuid:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");

    private Uuid(Builder builder) {
        super(builder);
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    public static Uuid of(String value) {
        Objects.requireNonNull(value, "value");
        return Uuid.builder().value(value).build();
    }

    public static Uri uri(String value) {
        Objects.requireNonNull(value, "value");
        return Uuid.builder().value(value).build();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.value, "value", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Uuid other = (Uuid)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Uri.Builder {
        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(String value) {
            return (Builder)super.value(value);
        }

        @Override
        public Uuid build() {
            Uuid uuid = new Uuid(this);
            if (this.validating) {
                this.validate(uuid);
            }
            return uuid;
        }

        protected void validate(Uuid uuid) {
            super.validate(uuid);
            ValidationSupport.checkValue(uuid.value, PATTERN);
        }

        protected Builder from(Uuid uuid) {
            super.from(uuid);
            return this;
        }
    }
}

