/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/account-status")
public class AccountStatus
extends Code {
    public static final AccountStatus ACTIVE = AccountStatus.builder().value(Value.ACTIVE).build();
    public static final AccountStatus INACTIVE = AccountStatus.builder().value(Value.INACTIVE).build();
    public static final AccountStatus ENTERED_IN_ERROR = AccountStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    public static final AccountStatus ON_HOLD = AccountStatus.builder().value(Value.ON_HOLD).build();
    public static final AccountStatus UNKNOWN = AccountStatus.builder().value(Value.UNKNOWN).build();
    private volatile int hashCode;

    private AccountStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static AccountStatus of(Value value) {
        switch (value) {
            case ACTIVE: {
                return ACTIVE;
            }
            case INACTIVE: {
                return INACTIVE;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case ON_HOLD: {
                return ON_HOLD;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static AccountStatus of(java.lang.String value) {
        return AccountStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return AccountStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return AccountStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccountStatus other = (AccountStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        ACTIVE("active"),
        INACTIVE("inactive"),
        ENTERED_IN_ERROR("entered-in-error"),
        ON_HOLD("on-hold"),
        UNKNOWN("unknown");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "active": {
                    return ACTIVE;
                }
                case "inactive": {
                    return INACTIVE;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
                case "on-hold": {
                    return ON_HOLD;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public AccountStatus build() {
            AccountStatus accountStatus = new AccountStatus(this);
            if (this.validating) {
                this.validate(accountStatus);
            }
            return accountStatus;
        }

        protected void validate(AccountStatus accountStatus) {
            super.validate(accountStatus);
        }

        protected Builder from(AccountStatus accountStatus) {
            super.from(accountStatus);
            return this;
        }
    }
}

