/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/administrative-gender")
public class AdministrativeGender
extends Code {
    public static final AdministrativeGender MALE = AdministrativeGender.builder().value(Value.MALE).build();
    public static final AdministrativeGender FEMALE = AdministrativeGender.builder().value(Value.FEMALE).build();
    public static final AdministrativeGender OTHER = AdministrativeGender.builder().value(Value.OTHER).build();
    public static final AdministrativeGender UNKNOWN = AdministrativeGender.builder().value(Value.UNKNOWN).build();
    private volatile int hashCode;

    private AdministrativeGender(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static AdministrativeGender of(Value value) {
        switch (value) {
            case MALE: {
                return MALE;
            }
            case FEMALE: {
                return FEMALE;
            }
            case OTHER: {
                return OTHER;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static AdministrativeGender of(java.lang.String value) {
        return AdministrativeGender.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return AdministrativeGender.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return AdministrativeGender.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdministrativeGender other = (AdministrativeGender)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        MALE("male"),
        FEMALE("female"),
        OTHER("other"),
        UNKNOWN("unknown");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "male": {
                    return MALE;
                }
                case "female": {
                    return FEMALE;
                }
                case "other": {
                    return OTHER;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public AdministrativeGender build() {
            AdministrativeGender administrativeGender = new AdministrativeGender(this);
            if (this.validating) {
                this.validate(administrativeGender);
            }
            return administrativeGender;
        }

        protected void validate(AdministrativeGender administrativeGender) {
            super.validate(administrativeGender);
        }

        protected Builder from(AdministrativeGender administrativeGender) {
            super.from(administrativeGender);
            return this;
        }
    }
}

