/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/product-category")
public class BiologicallyDerivedProductCategory
extends Code {
    public static final BiologicallyDerivedProductCategory ORGAN = BiologicallyDerivedProductCategory.builder().value(Value.ORGAN).build();
    public static final BiologicallyDerivedProductCategory TISSUE = BiologicallyDerivedProductCategory.builder().value(Value.TISSUE).build();
    public static final BiologicallyDerivedProductCategory FLUID = BiologicallyDerivedProductCategory.builder().value(Value.FLUID).build();
    public static final BiologicallyDerivedProductCategory CELLS = BiologicallyDerivedProductCategory.builder().value(Value.CELLS).build();
    public static final BiologicallyDerivedProductCategory BIOLOGICAL_AGENT = BiologicallyDerivedProductCategory.builder().value(Value.BIOLOGICAL_AGENT).build();
    private volatile int hashCode;

    private BiologicallyDerivedProductCategory(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static BiologicallyDerivedProductCategory of(Value value) {
        switch (value) {
            case ORGAN: {
                return ORGAN;
            }
            case TISSUE: {
                return TISSUE;
            }
            case FLUID: {
                return FLUID;
            }
            case CELLS: {
                return CELLS;
            }
            case BIOLOGICAL_AGENT: {
                return BIOLOGICAL_AGENT;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static BiologicallyDerivedProductCategory of(java.lang.String value) {
        return BiologicallyDerivedProductCategory.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return BiologicallyDerivedProductCategory.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return BiologicallyDerivedProductCategory.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BiologicallyDerivedProductCategory other = (BiologicallyDerivedProductCategory)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        ORGAN("organ"),
        TISSUE("tissue"),
        FLUID("fluid"),
        CELLS("cells"),
        BIOLOGICAL_AGENT("biologicalAgent");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "organ": {
                    return ORGAN;
                }
                case "tissue": {
                    return TISSUE;
                }
                case "fluid": {
                    return FLUID;
                }
                case "cells": {
                    return CELLS;
                }
                case "biologicalAgent": {
                    return BIOLOGICAL_AGENT;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public BiologicallyDerivedProductCategory build() {
            BiologicallyDerivedProductCategory biologicallyDerivedProductCategory = new BiologicallyDerivedProductCategory(this);
            if (this.validating) {
                this.validate(biologicallyDerivedProductCategory);
            }
            return biologicallyDerivedProductCategory;
        }

        protected void validate(BiologicallyDerivedProductCategory biologicallyDerivedProductCategory) {
            super.validate(biologicallyDerivedProductCategory);
        }

        protected Builder from(BiologicallyDerivedProductCategory biologicallyDerivedProductCategory) {
            super.from(biologicallyDerivedProductCategory);
            return this;
        }
    }
}

