/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/resource-types")
public class CarePlanActivityKind
extends Code {
    public static final CarePlanActivityKind APPOINTMENT = CarePlanActivityKind.builder().value(Value.APPOINTMENT).build();
    public static final CarePlanActivityKind COMMUNICATION_REQUEST = CarePlanActivityKind.builder().value(Value.COMMUNICATION_REQUEST).build();
    public static final CarePlanActivityKind DEVICE_REQUEST = CarePlanActivityKind.builder().value(Value.DEVICE_REQUEST).build();
    public static final CarePlanActivityKind MEDICATION_REQUEST = CarePlanActivityKind.builder().value(Value.MEDICATION_REQUEST).build();
    public static final CarePlanActivityKind NUTRITION_ORDER = CarePlanActivityKind.builder().value(Value.NUTRITION_ORDER).build();
    public static final CarePlanActivityKind TASK = CarePlanActivityKind.builder().value(Value.TASK).build();
    public static final CarePlanActivityKind SERVICE_REQUEST = CarePlanActivityKind.builder().value(Value.SERVICE_REQUEST).build();
    public static final CarePlanActivityKind VISION_PRESCRIPTION = CarePlanActivityKind.builder().value(Value.VISION_PRESCRIPTION).build();
    private volatile int hashCode;

    private CarePlanActivityKind(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static CarePlanActivityKind of(Value value) {
        switch (value) {
            case APPOINTMENT: {
                return APPOINTMENT;
            }
            case COMMUNICATION_REQUEST: {
                return COMMUNICATION_REQUEST;
            }
            case DEVICE_REQUEST: {
                return DEVICE_REQUEST;
            }
            case MEDICATION_REQUEST: {
                return MEDICATION_REQUEST;
            }
            case NUTRITION_ORDER: {
                return NUTRITION_ORDER;
            }
            case TASK: {
                return TASK;
            }
            case SERVICE_REQUEST: {
                return SERVICE_REQUEST;
            }
            case VISION_PRESCRIPTION: {
                return VISION_PRESCRIPTION;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static CarePlanActivityKind of(java.lang.String value) {
        return CarePlanActivityKind.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return CarePlanActivityKind.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return CarePlanActivityKind.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CarePlanActivityKind other = (CarePlanActivityKind)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        APPOINTMENT("Appointment"),
        COMMUNICATION_REQUEST("CommunicationRequest"),
        DEVICE_REQUEST("DeviceRequest"),
        MEDICATION_REQUEST("MedicationRequest"),
        NUTRITION_ORDER("NutritionOrder"),
        TASK("Task"),
        SERVICE_REQUEST("ServiceRequest"),
        VISION_PRESCRIPTION("VisionPrescription");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "Appointment": {
                    return APPOINTMENT;
                }
                case "CommunicationRequest": {
                    return COMMUNICATION_REQUEST;
                }
                case "DeviceRequest": {
                    return DEVICE_REQUEST;
                }
                case "MedicationRequest": {
                    return MEDICATION_REQUEST;
                }
                case "NutritionOrder": {
                    return NUTRITION_ORDER;
                }
                case "Task": {
                    return TASK;
                }
                case "ServiceRequest": {
                    return SERVICE_REQUEST;
                }
                case "VisionPrescription": {
                    return VISION_PRESCRIPTION;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public CarePlanActivityKind build() {
            CarePlanActivityKind carePlanActivityKind = new CarePlanActivityKind(this);
            if (this.validating) {
                this.validate(carePlanActivityKind);
            }
            return carePlanActivityKind;
        }

        protected void validate(CarePlanActivityKind carePlanActivityKind) {
            super.validate(carePlanActivityKind);
        }

        protected Builder from(CarePlanActivityKind carePlanActivityKind) {
            super.from(carePlanActivityKind);
            return this;
        }
    }
}

