/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/care-plan-activity-status")
public class CarePlanActivityStatus
extends Code {
    public static final CarePlanActivityStatus NOT_STARTED = CarePlanActivityStatus.builder().value(Value.NOT_STARTED).build();
    public static final CarePlanActivityStatus SCHEDULED = CarePlanActivityStatus.builder().value(Value.SCHEDULED).build();
    public static final CarePlanActivityStatus IN_PROGRESS = CarePlanActivityStatus.builder().value(Value.IN_PROGRESS).build();
    public static final CarePlanActivityStatus ON_HOLD = CarePlanActivityStatus.builder().value(Value.ON_HOLD).build();
    public static final CarePlanActivityStatus COMPLETED = CarePlanActivityStatus.builder().value(Value.COMPLETED).build();
    public static final CarePlanActivityStatus CANCELLED = CarePlanActivityStatus.builder().value(Value.CANCELLED).build();
    public static final CarePlanActivityStatus STOPPED = CarePlanActivityStatus.builder().value(Value.STOPPED).build();
    public static final CarePlanActivityStatus UNKNOWN = CarePlanActivityStatus.builder().value(Value.UNKNOWN).build();
    public static final CarePlanActivityStatus ENTERED_IN_ERROR = CarePlanActivityStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    private volatile int hashCode;

    private CarePlanActivityStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static CarePlanActivityStatus of(Value value) {
        switch (value) {
            case NOT_STARTED: {
                return NOT_STARTED;
            }
            case SCHEDULED: {
                return SCHEDULED;
            }
            case IN_PROGRESS: {
                return IN_PROGRESS;
            }
            case ON_HOLD: {
                return ON_HOLD;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case STOPPED: {
                return STOPPED;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static CarePlanActivityStatus of(java.lang.String value) {
        return CarePlanActivityStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return CarePlanActivityStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return CarePlanActivityStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CarePlanActivityStatus other = (CarePlanActivityStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        NOT_STARTED("not-started"),
        SCHEDULED("scheduled"),
        IN_PROGRESS("in-progress"),
        ON_HOLD("on-hold"),
        COMPLETED("completed"),
        CANCELLED("cancelled"),
        STOPPED("stopped"),
        UNKNOWN("unknown"),
        ENTERED_IN_ERROR("entered-in-error");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "not-started": {
                    return NOT_STARTED;
                }
                case "scheduled": {
                    return SCHEDULED;
                }
                case "in-progress": {
                    return IN_PROGRESS;
                }
                case "on-hold": {
                    return ON_HOLD;
                }
                case "completed": {
                    return COMPLETED;
                }
                case "cancelled": {
                    return CANCELLED;
                }
                case "stopped": {
                    return STOPPED;
                }
                case "unknown": {
                    return UNKNOWN;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public CarePlanActivityStatus build() {
            CarePlanActivityStatus carePlanActivityStatus = new CarePlanActivityStatus(this);
            if (this.validating) {
                this.validate(carePlanActivityStatus);
            }
            return carePlanActivityStatus;
        }

        protected void validate(CarePlanActivityStatus carePlanActivityStatus) {
            super.validate(carePlanActivityStatus);
        }

        protected Builder from(CarePlanActivityStatus carePlanActivityStatus) {
            super.from(carePlanActivityStatus);
            return this;
        }
    }
}

