/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/care-team-status")
public class CareTeamStatus
extends Code {
    public static final CareTeamStatus PROPOSED = CareTeamStatus.builder().value(Value.PROPOSED).build();
    public static final CareTeamStatus ACTIVE = CareTeamStatus.builder().value(Value.ACTIVE).build();
    public static final CareTeamStatus SUSPENDED = CareTeamStatus.builder().value(Value.SUSPENDED).build();
    public static final CareTeamStatus INACTIVE = CareTeamStatus.builder().value(Value.INACTIVE).build();
    public static final CareTeamStatus ENTERED_IN_ERROR = CareTeamStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    private volatile int hashCode;

    private CareTeamStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static CareTeamStatus of(Value value) {
        switch (value) {
            case PROPOSED: {
                return PROPOSED;
            }
            case ACTIVE: {
                return ACTIVE;
            }
            case SUSPENDED: {
                return SUSPENDED;
            }
            case INACTIVE: {
                return INACTIVE;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static CareTeamStatus of(java.lang.String value) {
        return CareTeamStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return CareTeamStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return CareTeamStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CareTeamStatus other = (CareTeamStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        PROPOSED("proposed"),
        ACTIVE("active"),
        SUSPENDED("suspended"),
        INACTIVE("inactive"),
        ENTERED_IN_ERROR("entered-in-error");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "proposed": {
                    return PROPOSED;
                }
                case "active": {
                    return ACTIVE;
                }
                case "suspended": {
                    return SUSPENDED;
                }
                case "inactive": {
                    return INACTIVE;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public CareTeamStatus build() {
            CareTeamStatus careTeamStatus = new CareTeamStatus(this);
            if (this.validating) {
                this.validate(careTeamStatus);
            }
            return careTeamStatus;
        }

        protected void validate(CareTeamStatus careTeamStatus) {
            super.validate(careTeamStatus);
        }

        protected Builder from(CareTeamStatus careTeamStatus) {
            super.from(careTeamStatus);
            return this;
        }
    }
}

