/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/code-search-support")
public class CodeSearchSupport
extends Code {
    public static final CodeSearchSupport EXPLICIT = CodeSearchSupport.builder().value(Value.EXPLICIT).build();
    public static final CodeSearchSupport ALL = CodeSearchSupport.builder().value(Value.ALL).build();
    private volatile int hashCode;

    private CodeSearchSupport(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static CodeSearchSupport of(Value value) {
        switch (value) {
            case EXPLICIT: {
                return EXPLICIT;
            }
            case ALL: {
                return ALL;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static CodeSearchSupport of(java.lang.String value) {
        return CodeSearchSupport.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return CodeSearchSupport.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return CodeSearchSupport.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeSearchSupport other = (CodeSearchSupport)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        EXPLICIT("explicit"),
        ALL("all");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "explicit": {
                    return EXPLICIT;
                }
                case "all": {
                    return ALL;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public CodeSearchSupport build() {
            CodeSearchSupport codeSearchSupport = new CodeSearchSupport(this);
            if (this.validating) {
                this.validate(codeSearchSupport);
            }
            return codeSearchSupport;
        }

        protected void validate(CodeSearchSupport codeSearchSupport) {
            super.validate(codeSearchSupport);
        }

        protected Builder from(CodeSearchSupport codeSearchSupport) {
            super.from(codeSearchSupport);
            return this;
        }
    }
}

