/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/concept-map-equivalence")
public class ConceptMapEquivalence
extends Code {
    public static final ConceptMapEquivalence RELATEDTO = ConceptMapEquivalence.builder().value(Value.RELATEDTO).build();
    public static final ConceptMapEquivalence EQUIVALENT = ConceptMapEquivalence.builder().value(Value.EQUIVALENT).build();
    public static final ConceptMapEquivalence EQUAL = ConceptMapEquivalence.builder().value(Value.EQUAL).build();
    public static final ConceptMapEquivalence WIDER = ConceptMapEquivalence.builder().value(Value.WIDER).build();
    public static final ConceptMapEquivalence SUBSUMES = ConceptMapEquivalence.builder().value(Value.SUBSUMES).build();
    public static final ConceptMapEquivalence NARROWER = ConceptMapEquivalence.builder().value(Value.NARROWER).build();
    public static final ConceptMapEquivalence SPECIALIZES = ConceptMapEquivalence.builder().value(Value.SPECIALIZES).build();
    public static final ConceptMapEquivalence INEXACT = ConceptMapEquivalence.builder().value(Value.INEXACT).build();
    public static final ConceptMapEquivalence UNMATCHED = ConceptMapEquivalence.builder().value(Value.UNMATCHED).build();
    public static final ConceptMapEquivalence DISJOINT = ConceptMapEquivalence.builder().value(Value.DISJOINT).build();
    private volatile int hashCode;

    private ConceptMapEquivalence(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ConceptMapEquivalence of(Value value) {
        switch (value) {
            case RELATEDTO: {
                return RELATEDTO;
            }
            case EQUIVALENT: {
                return EQUIVALENT;
            }
            case EQUAL: {
                return EQUAL;
            }
            case WIDER: {
                return WIDER;
            }
            case SUBSUMES: {
                return SUBSUMES;
            }
            case NARROWER: {
                return NARROWER;
            }
            case SPECIALIZES: {
                return SPECIALIZES;
            }
            case INEXACT: {
                return INEXACT;
            }
            case UNMATCHED: {
                return UNMATCHED;
            }
            case DISJOINT: {
                return DISJOINT;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ConceptMapEquivalence of(java.lang.String value) {
        return ConceptMapEquivalence.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ConceptMapEquivalence.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ConceptMapEquivalence.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConceptMapEquivalence other = (ConceptMapEquivalence)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        RELATEDTO("relatedto"),
        EQUIVALENT("equivalent"),
        EQUAL("equal"),
        WIDER("wider"),
        SUBSUMES("subsumes"),
        NARROWER("narrower"),
        SPECIALIZES("specializes"),
        INEXACT("inexact"),
        UNMATCHED("unmatched"),
        DISJOINT("disjoint");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "relatedto": {
                    return RELATEDTO;
                }
                case "equivalent": {
                    return EQUIVALENT;
                }
                case "equal": {
                    return EQUAL;
                }
                case "wider": {
                    return WIDER;
                }
                case "subsumes": {
                    return SUBSUMES;
                }
                case "narrower": {
                    return NARROWER;
                }
                case "specializes": {
                    return SPECIALIZES;
                }
                case "inexact": {
                    return INEXACT;
                }
                case "unmatched": {
                    return UNMATCHED;
                }
                case "disjoint": {
                    return DISJOINT;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ConceptMapEquivalence build() {
            ConceptMapEquivalence conceptMapEquivalence = new ConceptMapEquivalence(this);
            if (this.validating) {
                this.validate(conceptMapEquivalence);
            }
            return conceptMapEquivalence;
        }

        protected void validate(ConceptMapEquivalence conceptMapEquivalence) {
            super.validate(conceptMapEquivalence);
        }

        protected Builder from(ConceptMapEquivalence conceptMapEquivalence) {
            super.from(conceptMapEquivalence);
            return this;
        }
    }
}

