/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/consent-state-codes")
public class ConsentState
extends Code {
    public static final ConsentState DRAFT = ConsentState.builder().value(Value.DRAFT).build();
    public static final ConsentState PROPOSED = ConsentState.builder().value(Value.PROPOSED).build();
    public static final ConsentState ACTIVE = ConsentState.builder().value(Value.ACTIVE).build();
    public static final ConsentState REJECTED = ConsentState.builder().value(Value.REJECTED).build();
    public static final ConsentState INACTIVE = ConsentState.builder().value(Value.INACTIVE).build();
    public static final ConsentState ENTERED_IN_ERROR = ConsentState.builder().value(Value.ENTERED_IN_ERROR).build();
    private volatile int hashCode;

    private ConsentState(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ConsentState of(Value value) {
        switch (value) {
            case DRAFT: {
                return DRAFT;
            }
            case PROPOSED: {
                return PROPOSED;
            }
            case ACTIVE: {
                return ACTIVE;
            }
            case REJECTED: {
                return REJECTED;
            }
            case INACTIVE: {
                return INACTIVE;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ConsentState of(java.lang.String value) {
        return ConsentState.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ConsentState.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ConsentState.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConsentState other = (ConsentState)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        DRAFT("draft"),
        PROPOSED("proposed"),
        ACTIVE("active"),
        REJECTED("rejected"),
        INACTIVE("inactive"),
        ENTERED_IN_ERROR("entered-in-error");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "draft": {
                    return DRAFT;
                }
                case "proposed": {
                    return PROPOSED;
                }
                case "active": {
                    return ACTIVE;
                }
                case "rejected": {
                    return REJECTED;
                }
                case "inactive": {
                    return INACTIVE;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ConsentState build() {
            ConsentState consentState = new ConsentState(this);
            if (this.validating) {
                this.validate(consentState);
            }
            return consentState;
        }

        protected void validate(ConsentState consentState) {
            super.validate(consentState);
        }

        protected Builder from(ConsentState consentState) {
            super.from(consentState);
            return this;
        }
    }
}

