/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/days-of-week")
public class DaysOfWeek
extends Code {
    public static final DaysOfWeek MON = DaysOfWeek.builder().value(Value.MON).build();
    public static final DaysOfWeek TUE = DaysOfWeek.builder().value(Value.TUE).build();
    public static final DaysOfWeek WED = DaysOfWeek.builder().value(Value.WED).build();
    public static final DaysOfWeek THU = DaysOfWeek.builder().value(Value.THU).build();
    public static final DaysOfWeek FRI = DaysOfWeek.builder().value(Value.FRI).build();
    public static final DaysOfWeek SAT = DaysOfWeek.builder().value(Value.SAT).build();
    public static final DaysOfWeek SUN = DaysOfWeek.builder().value(Value.SUN).build();
    private volatile int hashCode;

    private DaysOfWeek(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static DaysOfWeek of(Value value) {
        switch (value) {
            case MON: {
                return MON;
            }
            case TUE: {
                return TUE;
            }
            case WED: {
                return WED;
            }
            case THU: {
                return THU;
            }
            case FRI: {
                return FRI;
            }
            case SAT: {
                return SAT;
            }
            case SUN: {
                return SUN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static DaysOfWeek of(java.lang.String value) {
        return DaysOfWeek.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return DaysOfWeek.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return DaysOfWeek.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DaysOfWeek other = (DaysOfWeek)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        MON("mon"),
        TUE("tue"),
        WED("wed"),
        THU("thu"),
        FRI("fri"),
        SAT("sat"),
        SUN("sun");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "mon": {
                    return MON;
                }
                case "tue": {
                    return TUE;
                }
                case "wed": {
                    return WED;
                }
                case "thu": {
                    return THU;
                }
                case "fri": {
                    return FRI;
                }
                case "sat": {
                    return SAT;
                }
                case "sun": {
                    return SUN;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public DaysOfWeek build() {
            DaysOfWeek daysOfWeek = new DaysOfWeek(this);
            if (this.validating) {
                this.validate(daysOfWeek);
            }
            return daysOfWeek;
        }

        protected void validate(DaysOfWeek daysOfWeek) {
            super.validate(daysOfWeek);
        }

        protected Builder from(DaysOfWeek daysOfWeek) {
            super.from(daysOfWeek);
            return this;
        }
    }
}

