/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/metric-category")
public class DeviceMetricCategory
extends Code {
    public static final DeviceMetricCategory MEASUREMENT = DeviceMetricCategory.builder().value(Value.MEASUREMENT).build();
    public static final DeviceMetricCategory SETTING = DeviceMetricCategory.builder().value(Value.SETTING).build();
    public static final DeviceMetricCategory CALCULATION = DeviceMetricCategory.builder().value(Value.CALCULATION).build();
    public static final DeviceMetricCategory UNSPECIFIED = DeviceMetricCategory.builder().value(Value.UNSPECIFIED).build();
    private volatile int hashCode;

    private DeviceMetricCategory(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static DeviceMetricCategory of(Value value) {
        switch (value) {
            case MEASUREMENT: {
                return MEASUREMENT;
            }
            case SETTING: {
                return SETTING;
            }
            case CALCULATION: {
                return CALCULATION;
            }
            case UNSPECIFIED: {
                return UNSPECIFIED;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static DeviceMetricCategory of(java.lang.String value) {
        return DeviceMetricCategory.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return DeviceMetricCategory.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return DeviceMetricCategory.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceMetricCategory other = (DeviceMetricCategory)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        MEASUREMENT("measurement"),
        SETTING("setting"),
        CALCULATION("calculation"),
        UNSPECIFIED("unspecified");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "measurement": {
                    return MEASUREMENT;
                }
                case "setting": {
                    return SETTING;
                }
                case "calculation": {
                    return CALCULATION;
                }
                case "unspecified": {
                    return UNSPECIFIED;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public DeviceMetricCategory build() {
            DeviceMetricCategory deviceMetricCategory = new DeviceMetricCategory(this);
            if (this.validating) {
                this.validate(deviceMetricCategory);
            }
            return deviceMetricCategory;
        }

        protected void validate(DeviceMetricCategory deviceMetricCategory) {
            super.validate(deviceMetricCategory);
        }

        protected Builder from(DeviceMetricCategory deviceMetricCategory) {
            super.from(deviceMetricCategory);
            return this;
        }
    }
}

