/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/device-nametype")
public class DeviceNameType
extends Code {
    public static final DeviceNameType UDI_LABEL_NAME = DeviceNameType.builder().value(Value.UDI_LABEL_NAME).build();
    public static final DeviceNameType USER_FRIENDLY_NAME = DeviceNameType.builder().value(Value.USER_FRIENDLY_NAME).build();
    public static final DeviceNameType PATIENT_REPORTED_NAME = DeviceNameType.builder().value(Value.PATIENT_REPORTED_NAME).build();
    public static final DeviceNameType MANUFACTURER_NAME = DeviceNameType.builder().value(Value.MANUFACTURER_NAME).build();
    public static final DeviceNameType MODEL_NAME = DeviceNameType.builder().value(Value.MODEL_NAME).build();
    public static final DeviceNameType OTHER = DeviceNameType.builder().value(Value.OTHER).build();
    private volatile int hashCode;

    private DeviceNameType(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static DeviceNameType of(Value value) {
        switch (value) {
            case UDI_LABEL_NAME: {
                return UDI_LABEL_NAME;
            }
            case USER_FRIENDLY_NAME: {
                return USER_FRIENDLY_NAME;
            }
            case PATIENT_REPORTED_NAME: {
                return PATIENT_REPORTED_NAME;
            }
            case MANUFACTURER_NAME: {
                return MANUFACTURER_NAME;
            }
            case MODEL_NAME: {
                return MODEL_NAME;
            }
            case OTHER: {
                return OTHER;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static DeviceNameType of(java.lang.String value) {
        return DeviceNameType.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return DeviceNameType.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return DeviceNameType.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceNameType other = (DeviceNameType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        UDI_LABEL_NAME("udi-label-name"),
        USER_FRIENDLY_NAME("user-friendly-name"),
        PATIENT_REPORTED_NAME("patient-reported-name"),
        MANUFACTURER_NAME("manufacturer-name"),
        MODEL_NAME("model-name"),
        OTHER("other");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "udi-label-name": {
                    return UDI_LABEL_NAME;
                }
                case "user-friendly-name": {
                    return USER_FRIENDLY_NAME;
                }
                case "patient-reported-name": {
                    return PATIENT_REPORTED_NAME;
                }
                case "manufacturer-name": {
                    return MANUFACTURER_NAME;
                }
                case "model-name": {
                    return MODEL_NAME;
                }
                case "other": {
                    return OTHER;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public DeviceNameType build() {
            DeviceNameType deviceNameType = new DeviceNameType(this);
            if (this.validating) {
                this.validate(deviceNameType);
            }
            return deviceNameType;
        }

        protected void validate(DeviceNameType deviceNameType) {
            super.validate(deviceNameType);
        }

        protected Builder from(DeviceNameType deviceNameType) {
            super.from(deviceNameType);
            return this;
        }
    }
}

